/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter;

import com.sun.source.tree.MethodInvocationTree;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.formatter.FormatterAnnotatedTypeFactory;
import org.checkerframework.checker.formatter.FormatterTreeUtil;
import org.checkerframework.checker.formatter.qual.ConversionCategory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;

public class FormatterVisitor
extends BaseTypeVisitor<FormatterAnnotatedTypeFactory> {
    public FormatterVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        FormatterTreeUtil tu = ((FormatterAnnotatedTypeFactory)this.atypeFactory).treeUtil;
        if (tu.isFormatCall(node, this.atypeFactory)) {
            FormatterTreeUtil formatterTreeUtil = ((FormatterAnnotatedTypeFactory)this.atypeFactory).treeUtil;
            formatterTreeUtil.getClass();
            FormatterTreeUtil.FormatCall fc = formatterTreeUtil.new FormatterTreeUtil.FormatCall(node, this.atypeFactory);
            FormatterTreeUtil.Result<String> sat = fc.isIllegalFormat();
            if (sat.value() != null) {
                tu.failure(sat, "format.string.invalid", sat.value());
            } else {
                FormatterTreeUtil.Result<FormatterTreeUtil.InvocationType> invc = fc.getInvocationType();
                ConversionCategory[] formatCats = fc.getFormatCategories();
                switch (invc.value()) {
                    case VARARG: {
                        FormatterTreeUtil.Result<TypeMirror>[] paramTypes = fc.getParamTypes();
                        int paraml = paramTypes.length;
                        int formatl = formatCats.length;
                        if (paraml < formatl) {
                            tu.failure(invc, "format.missing.arguments", formatl, paraml);
                            break;
                        }
                        if (paraml > formatl) {
                            tu.warning(invc, "format.excess.arguments", formatl, paraml);
                        }
                        block9: for (int i = 0; i < formatl; ++i) {
                            ConversionCategory formatCat = formatCats[i];
                            FormatterTreeUtil.Result<TypeMirror> param = paramTypes[i];
                            TypeMirror paramType = param.value();
                            switch (formatCat) {
                                case UNUSED: {
                                    tu.warning(param, "format.argument.unused", " " + (1 + i));
                                    continue block9;
                                }
                                case NULL: {
                                    tu.failure(param, "format.specifier.null", " " + (1 + i));
                                    continue block9;
                                }
                                case GENERAL: {
                                    continue block9;
                                }
                                default: {
                                    if (fc.isValidParameter(formatCat, paramType)) continue block9;
                                    tu.failure(param, "argument.type.incompatible", new Object[]{paramType, formatCat});
                                }
                            }
                        }
                        break;
                    }
                    case NULLARRAY: 
                    case ARRAY: {
                        for (ConversionCategory cat : formatCats) {
                            if (cat == ConversionCategory.NULL) {
                                tu.failure(invc, "format.specifier.null", "");
                            }
                            if (cat != ConversionCategory.UNUSED) continue;
                            tu.warning(invc, "format.argument.unused", "");
                        }
                        tu.warning(invc, "format.indirect.arguments", new Object[0]);
                    }
                }
            }
        }
        return super.visitMethodInvocation(node, p);
    }
}

