/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.interning;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.typeannotator.ListTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;

public class InterningAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    final AnnotationMirror INTERNED;
    final AnnotationMirror TOP;

    public InterningAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.INTERNED = AnnotationUtils.fromClass(this.elements, Interned.class);
        this.TOP = AnnotationUtils.fromClass(this.elements, UnknownInterned.class);
        this.addAliasedAnnotation(com.sun.istack.internal.Interned.class, this.INTERNED);
        this.postInit();
        this.addTypeNameImplicit(Void.class, this.INTERNED);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new InterningTreeAnnotator(this));
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        return new ListTypeAnnotator(new InterningTypeAnnotator(this), super.createTypeAnnotator());
    }

    @Override
    public void annotateImplicit(Element element, AnnotatedTypeMirror type) {
        if (!type.isAnnotatedInHierarchy(this.INTERNED) && ElementUtils.isCompileTimeConstant(element)) {
            type.addAnnotation(this.INTERNED);
        }
        super.annotateImplicit(element, type);
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedPrimitiveType getUnboxedType(AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        AnnotatedTypeMirror.AnnotatedPrimitiveType primitive = super.getUnboxedType(type);
        primitive.replaceAnnotation(this.INTERNED);
        return primitive;
    }

    private class InterningTypeAnnotator
    extends TypeAnnotator {
        InterningTypeAnnotator(InterningAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType t, Void p) {
            Element elt = t.getUnderlyingType().asElement();
            assert (elt != null);
            if (elt.getKind() == ElementKind.ENUM) {
                t.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            } else if (InterningAnnotatedTypeFactory.this.fromElement(elt).hasAnnotation(InterningAnnotatedTypeFactory.this.INTERNED)) {
                t.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            }
            return (Void)super.visitDeclared(t, p);
        }
    }

    private class InterningTreeAnnotator
    extends TreeAnnotator {
        InterningTreeAnnotator(InterningAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            if (TreeUtils.isCompileTimeString(node)) {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            } else if (TreeUtils.isStringConcatenation(node)) {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.TOP);
            } else if (type.getKind().isPrimitive() || node.getKind() == Tree.Kind.EQUAL_TO || node.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            } else {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.TOP);
            }
            return (Void)super.visitBinary(node, type);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(InterningAnnotatedTypeFactory.this.TOP);
            return (Void)super.visitCompoundAssignment(node, type);
        }
    }
}

