/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.element;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.element.TypeParamElementAnnotationApplier;
import org.checkerframework.javacutil.ErrorReporter;

public class MethodTypeParamApplier
extends TypeParamElementAnnotationApplier {
    private final Symbol.MethodSymbol enclosingMethod;

    public static void apply(AnnotatedTypeMirror.AnnotatedTypeVariable type, Element element, AnnotatedTypeFactory typeFactory) {
        new MethodTypeParamApplier(type, element, typeFactory).extractAndApply();
    }

    public static boolean accepts(AnnotatedTypeMirror type, Element element) {
        return element.getKind() == ElementKind.TYPE_PARAMETER && element.getEnclosingElement() instanceof Symbol.MethodSymbol;
    }

    MethodTypeParamApplier(AnnotatedTypeMirror.AnnotatedTypeVariable type, Element element, AnnotatedTypeFactory typeFactory) {
        super(type, element, typeFactory);
        if (!(element.getEnclosingElement() instanceof Symbol.MethodSymbol)) {
            ErrorReporter.errorAbort("TypeParameter not enclosed by method?  Type( " + type + " ) " + "Element ( " + element + " ) ");
        }
        this.enclosingMethod = (Symbol.MethodSymbol)element.getEnclosingElement();
    }

    @Override
    protected TargetType lowerBoundTarget() {
        return TargetType.METHOD_TYPE_PARAMETER;
    }

    @Override
    protected TargetType upperBoundTarget() {
        return TargetType.METHOD_TYPE_PARAMETER_BOUND;
    }

    @Override
    public int getElementIndex() {
        return ((List)this.enclosingMethod.getTypeParameters()).indexOf(this.element);
    }

    @Override
    protected TargetType[] validTargets() {
        return new TargetType[]{TargetType.METHOD_RETURN, TargetType.METHOD_FORMAL_PARAMETER, TargetType.METHOD_RECEIVER, TargetType.THROWS, TargetType.LOCAL_VARIABLE, TargetType.RESOURCE_VARIABLE, TargetType.EXCEPTION_PARAMETER, TargetType.NEW, TargetType.CAST, TargetType.INSTANCEOF, TargetType.METHOD_INVOCATION_TYPE_ARGUMENT, TargetType.CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT, TargetType.METHOD_REFERENCE, TargetType.CONSTRUCTOR_REFERENCE, TargetType.METHOD_REFERENCE_TYPE_ARGUMENT, TargetType.CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT};
    }

    @Override
    protected Iterable<Attribute.TypeCompound> getRawTypeAttributes() {
        return this.enclosingMethod.getRawTypeAttributes();
    }

    @Override
    protected boolean isAccepted() {
        return MethodTypeParamApplier.accepts(this.type, this.element);
    }
}

