/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeVariableSubstitutor;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;

public class TypeArgInferenceUtil {
    private static final TypeVariableSubstitutor substitutor = new TypeVariableSubstitutor();
    private static final Map<TypeVariable, AnnotatedTypeMirror> substituteMap = new HashMap<TypeVariable, AnnotatedTypeMirror>(5);

    public static List<? extends ExpressionTree> expressionToArgTrees(ExpressionTree expression) {
        List<? extends ExpressionTree> argTrees = expression.getKind() == Tree.Kind.METHOD_INVOCATION ? ((MethodInvocationTree)expression).getArguments() : (expression.getKind() == Tree.Kind.NEW_CLASS ? ((NewClassTree)expression).getArguments() : null);
        if (argTrees == null) {
            throw new IllegalArgumentException("TypeArgumentInference.relationsFromMethodArguments:\ncouldn't determine arguments from tree: " + expression);
        }
        return argTrees;
    }

    public static List<AnnotatedTypeMirror> treesToTypes(List<? extends ExpressionTree> argTrees, AnnotatedTypeFactory typeFactory) {
        ArrayList<AnnotatedTypeMirror> argTypes = new ArrayList<AnnotatedTypeMirror>(argTrees.size());
        for (Tree tree : argTrees) {
            argTypes.add(typeFactory.getAnnotatedType(tree));
        }
        return argTypes;
    }

    public static boolean isATarget(AnnotatedTypeMirror type, Set<TypeVariable> targetTypeVars) {
        return type.getKind() == TypeKind.TYPEVAR && targetTypeVars.contains(type.getUnderlyingType());
    }

    public static Set<TypeVariable> methodTypeToTargets(AnnotatedTypeMirror.AnnotatedExecutableType methodType) {
        List<AnnotatedTypeMirror.AnnotatedTypeVariable> annotatedTypeVars = methodType.getTypeVariables();
        LinkedHashSet<TypeVariable> targets = new LinkedHashSet<TypeVariable>(annotatedTypeVars.size());
        for (AnnotatedTypeMirror.AnnotatedTypeVariable atv : annotatedTypeVars) {
            targets.add(atv.getUnderlyingType());
        }
        return targets;
    }

    public static AnnotatedTypeMirror assignedTo(AnnotatedTypeFactory atypeFactory, TreePath path) {
        Types types = atypeFactory.getProcessingEnv().getTypeUtils();
        Tree assignmentContext = TreeUtils.getAssignmentContext(path);
        if (assignmentContext == null) {
            return null;
        }
        if (assignmentContext instanceof AssignmentTree) {
            ExpressionTree variable = ((AssignmentTree)assignmentContext).getVariable();
            return atypeFactory.getAnnotatedType(variable);
        }
        if (assignmentContext instanceof CompoundAssignmentTree) {
            ExpressionTree variable = ((CompoundAssignmentTree)assignmentContext).getVariable();
            return atypeFactory.getAnnotatedType(variable);
        }
        if (assignmentContext instanceof MethodInvocationTree) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)assignmentContext;
            if (methodInvocation.getMethodSelect() instanceof MemberSelectTree && ((MemberSelectTree)methodInvocation.getMethodSelect()).getExpression() == path.getLeaf()) {
                return null;
            }
            ExecutableElement methodElt = TreeUtils.elementFromUse(methodInvocation);
            AnnotatedTypeMirror receiver = atypeFactory.getReceiverType(methodInvocation);
            AnnotatedTypeMirror.AnnotatedExecutableType method = AnnotatedTypes.asMemberOf(types, atypeFactory, receiver, methodElt);
            int treeIndex = -1;
            for (int i = 0; i < method.getParameterTypes().size(); ++i) {
                if (TreeUtils.skipParens(methodInvocation.getArguments().get(i)) != path.getLeaf()) continue;
                treeIndex = i;
                break;
            }
            if (treeIndex == -1) {
                return null;
            }
            AnnotatedTypeMirror paramType = method.getParameterTypes().get(treeIndex);
            if (paramType == null || TypeArgInferenceUtil.containsUninferredTypeParameter(paramType, method)) {
                return null;
            }
            return paramType;
        }
        if (assignmentContext instanceof NewArrayTree) {
            return null;
        }
        if (assignmentContext instanceof NewClassTree) {
            NewClassTree newClassTree = (NewClassTree)assignmentContext;
            ExecutableElement constructorElt = InternalUtils.constructor(newClassTree);
            AnnotatedTypeMirror receiver = atypeFactory.getAnnotatedType(newClassTree.getIdentifier());
            AnnotatedTypeMirror.AnnotatedExecutableType constructor = AnnotatedTypes.asMemberOf(types, atypeFactory, receiver, constructorElt);
            int treeIndex = -1;
            for (int i = 0; i < constructor.getParameterTypes().size(); ++i) {
                if (TreeUtils.skipParens(newClassTree.getArguments().get(i)) != path.getLeaf()) continue;
                treeIndex = i;
                break;
            }
            assert (treeIndex != -1) : "Could not find path in NewClassTre.treePath=" + path.toString() + "\n" + "methodInvocation=" + newClassTree;
            if (treeIndex == -1) {
                return null;
            }
            return constructor.getParameterTypes().get(treeIndex);
        }
        if (assignmentContext instanceof ReturnTree) {
            MethodTree method = TreeUtils.enclosingMethod(path);
            return atypeFactory.getAnnotatedType(method).getReturnType();
        }
        if (assignmentContext instanceof VariableTree) {
            if (atypeFactory instanceof GenericAnnotatedTypeFactory) {
                GenericAnnotatedTypeFactory gatf = (GenericAnnotatedTypeFactory)atypeFactory;
                boolean oldFlow = gatf.getUseFlow();
                gatf.setUseFlow(false);
                AnnotatedTypeMirror type = gatf.getAnnotatedType(assignmentContext);
                gatf.setUseFlow(oldFlow);
                return type;
            }
            return atypeFactory.getAnnotatedType(assignmentContext);
        }
        ErrorReporter.errorAbort("AnnotatedTypes.assignedTo: shouldn't be here!");
        return null;
    }

    private static boolean containsUninferredTypeParameter(AnnotatedTypeMirror type, AnnotatedTypeMirror.AnnotatedExecutableType methodType) {
        List<AnnotatedTypeMirror.AnnotatedTypeVariable> annotatedTypeVars = methodType.getTypeVariables();
        ArrayList<TypeVariable> typeVars = new ArrayList<TypeVariable>(annotatedTypeVars.size());
        for (AnnotatedTypeMirror.AnnotatedTypeVariable annotatedTypeVar : annotatedTypeVars) {
            typeVars.add(annotatedTypeVar.getUnderlyingType());
        }
        Boolean result = type.accept(new TypeVariableFinder(), typeVars);
        return result != null && result != false;
    }

    public static Map<AnnotationMirror, AnnotationMirror> createHierarchyMap(Set<AnnotationMirror> annos, QualifierHierarchy qualifierHierarchy) {
        Map<AnnotationMirror, AnnotationMirror> result = AnnotationUtils.createAnnotationMap();
        for (AnnotationMirror anno : annos) {
            result.put(qualifierHierarchy.getTopAnnotation(anno), anno);
        }
        return result;
    }

    public static AnnotatedTypeMirror substitute(TypeVariable typeVariable, AnnotatedTypeMirror substitution, AnnotatedTypeMirror toModify) {
        substituteMap.clear();
        substituteMap.put(typeVariable, substitution.deepCopy());
        AnnotatedTypeMirror toModifyCopy = toModify.deepCopy();
        substitutor.substitute(substituteMap, toModifyCopy);
        return toModifyCopy;
    }

    public static AnnotatedTypeMirror substitute(Map<TypeVariable, AnnotatedTypeMirror> substitutions, AnnotatedTypeMirror toModify) {
        AnnotatedTypeMirror substitution = substitutions.get(toModify.getUnderlyingType());
        if (substitution != null) {
            return substitution.deepCopy();
        }
        AnnotatedTypeMirror toModifyCopy = toModify.deepCopy();
        substitutor.substitute(substitutions, toModifyCopy);
        return toModifyCopy;
    }

    public static AnnotatedTypeMirror leastUpperBound(AnnotatedTypeFactory typeFactory, Iterable<AnnotatedTypeMirror> types) {
        Iterator<AnnotatedTypeMirror> typesIter = types.iterator();
        if (!typesIter.hasNext()) {
            ErrorReporter.errorAbort("Calling LUB on empty list!");
        }
        AnnotatedTypeMirror lubType = typesIter.next();
        AnnotatedTypeMirror nextType = null;
        while (typesIter.hasNext()) {
            nextType = typesIter.next();
            if (lubType.getKind().isPrimitive()) {
                if (!nextType.getKind().isPrimitive()) {
                    lubType = typeFactory.getBoxedType((AnnotatedTypeMirror.AnnotatedPrimitiveType)lubType);
                }
            } else if (nextType.getKind().isPrimitive() && !lubType.getKind().isPrimitive()) {
                nextType = typeFactory.getBoxedType((AnnotatedTypeMirror.AnnotatedPrimitiveType)nextType);
            }
            lubType = AnnotatedTypes.leastUpperBound(typeFactory.getProcessingEnv(), typeFactory, lubType, nextType);
        }
        return lubType;
    }

    private static class TypeVariableFinder
    extends AnnotatedTypeScanner<Boolean, List<TypeVariable>> {
        private TypeVariableFinder() {
        }

        @Override
        protected Boolean scan(Iterable<? extends AnnotatedTypeMirror> types, List<TypeVariable> typeVars) {
            if (types == null) {
                return false;
            }
            Boolean result = false;
            Boolean first = true;
            for (AnnotatedTypeMirror annotatedTypeMirror : types) {
                result = first != false ? (Boolean)this.scan(annotatedTypeMirror, typeVars) : this.scanAndReduce(annotatedTypeMirror, typeVars, result);
                first = false;
            }
            return result;
        }

        @Override
        protected Boolean reduce(Boolean r1, Boolean r2) {
            if (r1 == null) {
                return r2 != null && r2 != false;
            }
            if (r2 == null) {
                return r1;
            }
            return r1 != false || r2 != false;
        }

        @Override
        public Boolean visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, List<TypeVariable> typeVars) {
            if (typeVars.contains(type.getUnderlyingType())) {
                return true;
            }
            return (Boolean)super.visitTypeVariable(type, typeVars);
        }
    }
}

