/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.qualframework.base.QualifiedTypeMirror;
import org.checkerframework.qualframework.base.QualifierHierarchy;
import org.checkerframework.qualframework.base.QualifierMapVisitor;
import org.checkerframework.qualframework.base.TypeHierarchy;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.QualifierParameterHierarchy;
import org.checkerframework.qualframework.poly.Wildcard;

class MethodParameterInference<Q> {
    private List<String> qualParams;
    private List<? extends QualifiedTypeMirror<QualParams<Q>>> formals;
    private List<? extends QualifiedTypeMirror<QualParams<Q>>> actuals;
    private QualifierHierarchy<Q> groundHierarchy;
    private QualifierHierarchy<PolyQual<Q>> polyQualHierarchy;
    private QualifierParameterHierarchy<Q> qualParamHierarchy;
    private TypeHierarchy<QualParams<Q>> typeHierarchy;
    private boolean unsatisfiable;
    private List<PolyQual<Q>> upperBounds;
    private List<PolyQual<Q>> lowerBounds;
    private boolean alreadyRan;
    private static final String INFER_TAG = "_INFER";
    private QualifierMapVisitor<QualParams<Q>, QualParams<Q>, Map<String, Wildcard<Q>>> SUBSTITUTE_VISITOR = new QualifierMapVisitor<QualParams<Q>, QualParams<Q>, Map<String, Wildcard<Q>>>(){

        @Override
        public QualParams<Q> process(QualParams<Q> params, Map<String, Wildcard<Q>> substs) {
            return params.substituteAll(substs);
        }
    };

    public MethodParameterInference(List<String> qualParams, List<? extends QualifiedTypeMirror<QualParams<Q>>> formals, List<? extends QualifiedTypeMirror<QualParams<Q>>> actuals, QualifierHierarchy<Q> groundHierarchy, QualifierHierarchy<PolyQual<Q>> polyQualHierarchy, QualifierParameterHierarchy<Q> qualParamHierarchy, TypeHierarchy<QualParams<Q>> typeHierarchy) {
        this.qualParams = qualParams;
        this.formals = formals;
        this.actuals = actuals;
        this.groundHierarchy = groundHierarchy;
        this.polyQualHierarchy = polyQualHierarchy;
        this.qualParamHierarchy = qualParamHierarchy;
        this.typeHierarchy = typeHierarchy;
        this.unsatisfiable = false;
        this.lowerBounds = new ArrayList<PolyQual<Q>>();
        this.upperBounds = new ArrayList<PolyQual<Q>>();
        for (int i = 0; i < qualParams.size(); ++i) {
            this.upperBounds.add(polyQualHierarchy.getTop());
            this.lowerBounds.add(polyQualHierarchy.getBottom());
        }
        this.alreadyRan = false;
    }

    private PolyQual.QualVar<Q> makeInferVar(String name, int i) {
        return new PolyQual.QualVar<Q>(INFER_TAG + i + ":" + name, this.groundHierarchy.getBottom(), this.groundHierarchy.getTop());
    }

    private boolean isInferVar(PolyQual<Q> q) {
        return q instanceof PolyQual.QualVar && ((PolyQual.QualVar)q).getName().startsWith(INFER_TAG);
    }

    private int inferVarIndex(PolyQual<Q> q) {
        PolyQual.QualVar v = (PolyQual.QualVar)q;
        String name = v.getName();
        return Integer.parseInt(name.substring(INFER_TAG.length(), name.indexOf(58)));
    }

    public Map<String, PolyQual<Q>> infer() {
        if (this.alreadyRan) {
            throw new IllegalStateException("already ran infer() on this MethodParameterInference object");
        }
        this.alreadyRan = true;
        List<Pair<Wildcard<Q>, Wildcard<Q>>> constraints = this.findConstraints();
        for (Pair<Wildcard<Q>, Wildcard<Q>> p : constraints) {
            if (p == null) {
                this.unsatisfiable = true;
                continue;
            }
            Wildcard subset = (Wildcard)p.first;
            Wildcard superset = (Wildcard)p.second;
            this.processConstraint(subset, superset);
        }
        return this.getAssignment();
    }

    private List<Pair<Wildcard<Q>, Wildcard<Q>>> findConstraints() {
        ArrayList<PolyQual.QualVar<Q>> inferVars = new ArrayList<PolyQual.QualVar<Q>>();
        HashMap<String, Wildcard<PolyQual>> inferSubst = new HashMap<String, Wildcard<PolyQual>>();
        for (int i = 0; i < this.qualParams.size(); ++i) {
            inferVars.add(this.makeInferVar(this.qualParams.get(i), i));
            inferSubst.put(this.qualParams.get(i), new Wildcard<PolyQual>((PolyQual)inferVars.get(i)));
        }
        ArrayList<Object> substitutedFormals = new ArrayList<Object>();
        for (QualifiedTypeMirror<QualParams<Q>> formal : this.formals) {
            substitutedFormals.add(this.SUBSTITUTE_VISITOR.visit((QualifiedTypeMirror)formal, inferSubst));
        }
        ArrayList constraints = new ArrayList();
        this.qualParamHierarchy.setConstraintTarget(constraints);
        for (int i = 0; i < this.formals.size(); ++i) {
            this.typeHierarchy.isSubtype(this.actuals.get(i), (QualifiedTypeMirror)substitutedFormals.get(i));
        }
        this.qualParamHierarchy.setConstraintTarget(null);
        return constraints;
    }

    private void processConstraint(Wildcard<Q> subset, Wildcard<Q> superset) {
        if (!(this.isInferVar(subset.getLowerBound()) || this.isInferVar(subset.getUpperBound()) || this.isInferVar(superset.getLowerBound()) || this.isInferVar(superset.getUpperBound()))) {
            return;
        }
        this.addSubtypeBound(superset.getLowerBound(), subset.getLowerBound());
        this.addSubtypeBound(subset.getLowerBound(), subset.getUpperBound());
        this.addSubtypeBound(subset.getUpperBound(), superset.getUpperBound());
    }

    private void addSubtypeBound(PolyQual<Q> subtype, PolyQual<Q> supertype) {
        if (this.isInferVar(subtype) && this.isInferVar(supertype)) {
            throw new UnsupportedOperationException();
        }
        if (this.isInferVar(subtype)) {
            int id = this.inferVarIndex(subtype);
            PolyQual<Q> oldUpper = this.upperBounds.get(id);
            this.upperBounds.set(id, this.polyQualHierarchy.greatestLowerBound(oldUpper, supertype));
        } else if (this.isInferVar(supertype)) {
            int id = this.inferVarIndex(supertype);
            PolyQual<Q> oldLower = this.lowerBounds.get(id);
            this.lowerBounds.set(id, this.polyQualHierarchy.leastUpperBound(oldLower, subtype));
        } else if (!this.polyQualHierarchy.isSubtype(subtype, supertype)) {
            this.unsatisfiable = true;
        }
    }

    public Map<String, PolyQual<Q>> getAssignment() {
        if (this.unsatisfiable) {
            return null;
        }
        HashMap<String, PolyQual<Q>> map = new HashMap<String, PolyQual<Q>>();
        for (int i = 0; i < this.qualParams.size(); ++i) {
            map.put(this.qualParams.get(i), this.lowerBounds.get(i));
        }
        return map;
    }
}

