/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.tools.javac.code.Symbol;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ElementUtils {
    private ElementUtils() {
        throw new AssertionError((Object)"Class ElementUtils cannot be instantiated.");
    }

    public static TypeElement enclosingClass(Element elem) {
        Element result = elem;
        while (result != null && !result.getKind().isClass() && !result.getKind().isInterface()) {
            Element encl;
            result = encl = result.getEnclosingElement();
        }
        return (TypeElement)result;
    }

    public static PackageElement enclosingPackage(Element elem) {
        Element result = elem;
        while (result != null && result.getKind() != ElementKind.PACKAGE) {
            Element encl;
            result = encl = result.getEnclosingElement();
        }
        return (PackageElement)result;
    }

    public static PackageElement parentPackage(Elements e, PackageElement elem) {
        String fqnstart = elem.getQualifiedName().toString();
        String fqn = fqnstart;
        if (fqn != null && !fqn.isEmpty() && fqn.contains(".")) {
            fqn = fqn.substring(0, fqn.lastIndexOf(46));
            return e.getPackageElement(fqn);
        }
        return null;
    }

    public static boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static boolean isEffectivelyFinal(Element element) {
        Symbol sym = (Symbol)element;
        if (sym.getEnclosingElement().getKind() == ElementKind.METHOD && (sym.getEnclosingElement().flags() & 0x400L) != 0L) {
            return true;
        }
        return (sym.flags() & 0x20000000010L) != 0L;
    }

    public static TypeMirror getType(Element element) {
        if (element.getKind() == ElementKind.METHOD) {
            return ((ExecutableElement)element).getReturnType();
        }
        if (element.getKind() == ElementKind.CONSTRUCTOR) {
            return ElementUtils.enclosingClass(element).asType();
        }
        return element.asType();
    }

    public static @Nullable Name getQualifiedClassName(Element element) {
        if (element.getKind() == ElementKind.PACKAGE) {
            PackageElement elem = (PackageElement)element;
            return elem.getQualifiedName();
        }
        TypeElement elem = ElementUtils.enclosingClass(element);
        if (elem == null) {
            return null;
        }
        return elem.getQualifiedName();
    }

    public static String getVerboseName(Element elt) {
        if (elt.getKind() == ElementKind.PACKAGE || elt.getKind().isClass() || elt.getKind().isInterface()) {
            return ElementUtils.getQualifiedClassName(elt).toString();
        }
        return ElementUtils.getQualifiedClassName(elt) + "." + elt.toString();
    }

    public static boolean isObject(TypeElement element) {
        return element.getQualifiedName().contentEquals("java.lang.Object");
    }

    public static boolean isCompileTimeConstant(Element elt) {
        return elt != null && elt.getKind() == ElementKind.FIELD && ((VariableElement)elt).getConstantValue() != null;
    }

    public static boolean isElementFromByteCode(Element elt) {
        if (elt == null) {
            return false;
        }
        if (elt instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clss = (Symbol.ClassSymbol)elt;
            if (null != clss.classfile) {
                return clss.classfile.getName().endsWith(".class");
            }
            return false;
        }
        return ElementUtils.isElementFromByteCode(elt.getEnclosingElement(), elt);
    }

    private static boolean isElementFromByteCode(Element elt, Element orig) {
        if (elt == null) {
            return false;
        }
        if (elt instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clss = (Symbol.ClassSymbol)elt;
            if (null != clss.classfile) {
                return clss.classfile.getName().endsWith(".class") || clss.classfile.getName().endsWith(".class)") || clss.classfile.getName().endsWith(".class)]");
            }
            return false;
        }
        return ElementUtils.isElementFromByteCode(elt.getEnclosingElement(), elt);
    }

    public static VariableElement findFieldInType(TypeElement type, String name) {
        for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            if (!field.getSimpleName().toString().equals(name)) continue;
            return field;
        }
        return null;
    }

    public static Set<VariableElement> findFieldsInType(TypeElement type, Collection<String> names) {
        HashSet<VariableElement> results = new HashSet<VariableElement>();
        for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            if (!names.contains(field.getSimpleName().toString())) continue;
            results.add(field);
        }
        return results;
    }

    public static boolean isError(Element element) {
        return element.getClass().getName().equals("com.sun.tools.javac.comp.Resolve$SymbolNotFoundError");
    }

    public static boolean hasReceiver(Element element) {
        return (element.getKind().isField() || element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) && !ElementUtils.isStatic(element);
    }

    public static List<TypeElement> getSuperTypes(TypeElement type) {
        ArrayList<TypeElement> superelems = new ArrayList<TypeElement>();
        if (type == null) {
            return superelems;
        }
        ArrayDeque<TypeElement> stack = new ArrayDeque<TypeElement>();
        stack.push(type);
        while (!stack.isEmpty()) {
            TypeElement supercls;
            TypeElement current = (TypeElement)stack.pop();
            TypeMirror supertypecls = current.getSuperclass();
            if (supertypecls.getKind() != TypeKind.NONE && !superelems.contains(supercls = (TypeElement)((DeclaredType)supertypecls).asElement())) {
                stack.push(supercls);
                superelems.add(supercls);
            }
            for (TypeMirror typeMirror : current.getInterfaces()) {
                TypeElement superitf = (TypeElement)((DeclaredType)typeMirror).asElement();
                if (superelems.contains(superitf)) continue;
                stack.push(superitf);
                superelems.add(superitf);
            }
        }
        return Collections.unmodifiableList(superelems);
    }

    public static List<VariableElement> getAllFieldsIn(TypeElement type) {
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>();
        fields.addAll(ElementFilter.fieldsIn(type.getEnclosedElements()));
        List<TypeElement> alltypes = ElementUtils.getSuperTypes(type);
        for (TypeElement atype : alltypes) {
            fields.addAll(ElementFilter.fieldsIn(atype.getEnclosedElements()));
        }
        return Collections.unmodifiableList(fields);
    }

    public static List<ExecutableElement> getAllMethodsIn(TypeElement type) {
        ArrayList<ExecutableElement> meths = new ArrayList<ExecutableElement>();
        meths.addAll(ElementFilter.methodsIn(type.getEnclosedElements()));
        List<TypeElement> alltypes = ElementUtils.getSuperTypes(type);
        for (TypeElement atype : alltypes) {
            meths.addAll(ElementFilter.methodsIn(atype.getEnclosedElements()));
        }
        return Collections.unmodifiableList(meths);
    }

    public static boolean isTypeDeclaration(Element elt) {
        switch (elt.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case TYPE_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    public static boolean matchesElement(ExecutableElement method, String methodName, Class<?> ... parameters) {
        if (!method.getSimpleName().toString().equals(methodName)) {
            return false;
        }
        if (method.getParameters().size() != parameters.length) {
            return false;
        }
        for (int i = 0; i < method.getParameters().size(); ++i) {
            if (method.getParameters().get(i).asType().toString().equals(parameters[i].getName())) continue;
            return false;
        }
        return true;
    }
}

