/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.i18nformatter;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.i18nformatter.I18nFormatUtil;
import org.checkerframework.checker.i18nformatter.I18nFormatterAnalysis;
import org.checkerframework.checker.i18nformatter.I18nFormatterTransfer;
import org.checkerframework.checker.i18nformatter.I18nFormatterTreeUtil;
import org.checkerframework.checker.i18nformatter.qual.I18nConversionCategory;
import org.checkerframework.checker.i18nformatter.qual.I18nFormat;
import org.checkerframework.checker.i18nformatter.qual.I18nFormatBottom;
import org.checkerframework.checker.i18nformatter.qual.I18nFormatFor;
import org.checkerframework.checker.i18nformatter.qual.I18nInvalidFormat;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;

public class I18nFormatterAnnotatedTypeFactory
extends GenericAnnotatedTypeFactory<CFValue, CFStore, I18nFormatterTransfer, I18nFormatterAnalysis> {
    private final AnnotationMirror I18NFORMAT;
    private final AnnotationMirror I18NINVALIDFORMAT;
    private final AnnotationMirror I18NFORMATBOTTOM;
    private final AnnotationMirror I18NFORMATFOR;
    public final Map<String, String> translations;
    protected final I18nFormatterTreeUtil treeUtil;

    public I18nFormatterAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.I18NFORMAT = AnnotationUtils.fromClass(this.elements, I18nFormat.class);
        this.I18NINVALIDFORMAT = AnnotationUtils.fromClass(this.elements, I18nInvalidFormat.class);
        this.I18NFORMATBOTTOM = AnnotationUtils.fromClass(this.elements, I18nFormatBottom.class);
        this.I18NFORMATFOR = AnnotationUtils.fromClass(this.elements, I18nFormatFor.class);
        this.translations = Collections.unmodifiableMap(this.buildLookup());
        this.treeUtil = new I18nFormatterTreeUtil(checker);
        this.postInit();
    }

    private Map<String, String> buildLookup() {
        String[] namesArr;
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.checker.hasOption("propfiles")) {
            String names = this.checker.getOption("propfiles");
            namesArr = names.split(":");
            if (namesArr == null) {
                System.err.println("Couldn't parse the properties files: <" + names + ">");
            } else {
                for (String name : namesArr) {
                    try {
                        Properties prop = new Properties();
                        InputStream in = null;
                        ClassLoader cl = this.getClass().getClassLoader();
                        if (cl == null) {
                            cl = ClassLoader.getSystemClassLoader();
                        }
                        if ((in = cl.getResourceAsStream(name)) == null) {
                            try {
                                in = new FileInputStream(name);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                // empty catch block
                            }
                        }
                        if (in == null) {
                            System.err.println("Couldn't find the properties file: " + name);
                            continue;
                        }
                        prop.load(in);
                        for (String key : prop.stringPropertyNames()) {
                            result.put(key, prop.getProperty(key));
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Exception in PropertyKeyChecker.keysOfPropertyFile: " + e);
                        e.printStackTrace();
                    }
                }
            }
        }
        if (this.checker.hasOption("bundlenames")) {
            String bundleNames = this.checker.getOption("bundlenames");
            namesArr = bundleNames.split(":");
            if (namesArr == null) {
                System.err.println("Couldn't parse the resource bundles: <" + bundleNames + ">");
            } else {
                for (String bundleName : namesArr) {
                    ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
                    if (bundle == null) {
                        System.err.println("Couldn't find the resource bundle: <" + bundleName + "> for locale <" + Locale.getDefault() + ">");
                        continue;
                    }
                    for (String key : bundle.keySet()) {
                        result.put(key, bundle.getString(key));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new I18nFormatterQualifierHierarchy(factory);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new I18nFormatterTreeAnnotator(this));
    }

    class I18nFormatterQualifierHierarchy
    extends GraphQualifierHierarchy {
        public I18nFormatterQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f, I18nFormatterAnnotatedTypeFactory.this.I18NFORMATBOTTOM);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(rhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT) && AnnotationUtils.areSameIgnoringValues(lhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT)) {
                I18nConversionCategory[] lhsArgTypes;
                I18nConversionCategory[] rhsArgTypes = I18nFormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(rhs);
                if (rhsArgTypes.length > (lhsArgTypes = I18nFormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(lhs)).length) {
                    return false;
                }
                for (int i = 0; i < rhsArgTypes.length; ++i) {
                    if (I18nConversionCategory.isSubsetOf(lhsArgTypes[i], rhsArgTypes[i])) continue;
                    return false;
                }
                return true;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT) && AnnotationUtils.areSameIgnoringValues(rhs, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT)) {
                return AnnotationUtils.getElementValue(rhs, "value", String.class, true).equals(AnnotationUtils.getElementValue(lhs, "value", String.class, true));
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT)) {
                lhs = I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT)) {
                rhs = I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT)) {
                lhs = I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT)) {
                rhs = I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMATFOR)) {
                lhs = I18nFormatterAnnotatedTypeFactory.this.I18NFORMATFOR;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMATFOR)) {
                rhs = I18nFormatterAnnotatedTypeFactory.this.I18NFORMATFOR;
            }
            return super.isSubtype(rhs, lhs);
        }
    }

    private class I18nFormatterTreeAnnotator
    extends TreeAnnotator {
        public I18nFormatterTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (!type.isAnnotatedInHierarchy(I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT)) {
                String format = null;
                if (tree.getKind() == Tree.Kind.STRING_LITERAL) {
                    format = (String)tree.getValue();
                } else if (tree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    format = Character.toString(((Character)tree.getValue()).charValue());
                }
                if (format != null) {
                    AnnotationMirror anno;
                    try {
                        I18nConversionCategory[] cs = I18nFormatUtil.formatParameterCategories(format);
                        anno = I18nFormatterAnnotatedTypeFactory.this.treeUtil.categoriesToFormatAnnotation(cs);
                    }
                    catch (IllegalArgumentException e) {
                        anno = I18nFormatterAnnotatedTypeFactory.this.treeUtil.exceptionToInvalidFormatAnnotation(e);
                    }
                    type.addAnnotation(anno);
                }
            }
            return (Void)super.visitLiteral(tree, type);
        }
    }
}

