/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.javari;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.checker.javari.JavariAnnotatedTypeFactory;
import org.checkerframework.checker.javari.qual.Assignable;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.TreeUtils;

public class JavariVisitor
extends BaseTypeVisitor<JavariAnnotatedTypeFactory> {
    public JavariVisitor(BaseTypeChecker checker) {
        super(checker);
        this.checkForAnnotatedJdk();
    }

    @Override
    public Void visitClass(ClassTree node, Void p) {
        if (((JavariAnnotatedTypeFactory)this.atypeFactory).fromClass(node).hasEffectiveAnnotation(((JavariAnnotatedTypeFactory)this.atypeFactory).POLYREAD)) {
            this.checker.report(Result.failure("polyread.type", new Object[0]), node);
        }
        return super.visitClass(node, p);
    }

    @Override
    protected void checkAssignability(AnnotatedTypeMirror varType, Tree varTree) {
        AnnotatedTypeMirror receiver;
        if (!TreeUtils.isExpressionTree(varTree)) {
            return;
        }
        Element varElt = TreeUtils.elementFromUse((ExpressionTree)varTree);
        if (varElt != null && ((JavariAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(varElt, Assignable.class) != null) {
            return;
        }
        boolean variableLocalField = ((JavariAnnotatedTypeFactory)this.atypeFactory).isMostEnclosingThisDeref((ExpressionTree)varTree) && varElt != null && varElt.getKind().isField();
        boolean inConstructor = this.visitorState.getMethodTree() == null || TreeUtils.isConstructor(this.visitorState.getMethodTree());
        AnnotatedTypeMirror.AnnotatedDeclaredType mReceiver = ((JavariAnnotatedTypeFactory)this.atypeFactory).getSelfType(varTree);
        if (variableLocalField && !inConstructor && !mReceiver.hasEffectiveAnnotation(((JavariAnnotatedTypeFactory)this.atypeFactory).MUTABLE)) {
            this.checker.report(Result.failure("ro.field", new Object[0]), varTree);
        }
        if (varTree.getKind() == Tree.Kind.MEMBER_SELECT && !((JavariAnnotatedTypeFactory)this.atypeFactory).isMostEnclosingThisDeref((ExpressionTree)varTree) && (receiver = ((JavariAnnotatedTypeFactory)this.atypeFactory).getReceiverType((ExpressionTree)varTree)) != null && !receiver.hasEffectiveAnnotation(((JavariAnnotatedTypeFactory)this.atypeFactory).MUTABLE)) {
            this.checker.report(Result.failure("ro.field", new Object[0]), varTree);
        }
        if (varTree.getKind() == Tree.Kind.ARRAY_ACCESS && (receiver = ((JavariAnnotatedTypeFactory)this.atypeFactory).getReceiverType((ExpressionTree)varTree)) != null && !receiver.hasEffectiveAnnotation(((JavariAnnotatedTypeFactory)this.atypeFactory).MUTABLE)) {
            this.checker.report(Result.failure("ro.element", new Object[0]), varTree);
        }
    }

    @Override
    protected Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotations() {
        return Collections.singleton(((JavariAnnotatedTypeFactory)this.atypeFactory).MUTABLE);
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType elemType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        return true;
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedPrimitiveType useType, Tree tree) {
        if (useType.hasAnnotation(((JavariAnnotatedTypeFactory)this.atypeFactory).QREADONLY) || useType.hasAnnotation(((JavariAnnotatedTypeFactory)this.atypeFactory).READONLY) || useType.hasAnnotation(((JavariAnnotatedTypeFactory)this.atypeFactory).POLYREAD)) {
            return false;
        }
        return super.isValidUse(useType, tree);
    }
}

