/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.subtyping;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.qual.SubtypeOf;

public class SubtypingAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public SubtypingAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        String qualNames = this.checker.getOption("quals");
        if (qualNames == null) {
            this.checker.userErrorAbort("SubtypingChecker: missing required option: -Aquals");
            throw new Error("This can't happen");
        }
        HashSet qualSet = new HashSet();
        for (String qualName : qualNames.split(",")) {
            try {
                Class<?> q = Class.forName(qualName);
                qualSet.add(q);
            }
            catch (ClassNotFoundException e) {
                this.checker.userErrorAbort("SubtypingChecker: could not load class for qualifier: " + qualName + "; ensure that your classpath is correct");
            }
        }
        for (Class clazz : qualSet) {
            SubtypeOf subtypeOfAnnotation = clazz.getAnnotation(SubtypeOf.class);
            if (subtypeOfAnnotation == null) continue;
            for (Class<? extends Annotation> superqual : clazz.getAnnotation(SubtypeOf.class).value()) {
                if (qualSet.contains(superqual)) continue;
                this.checker.userErrorAbort("SubtypingChecker: qualifier " + clazz + " was specified via -Aquals but its super-qualifier " + superqual + " was not");
            }
        }
        return Collections.unmodifiableSet(qualSet);
    }
}

