/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test.diagnostics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.checkerframework.framework.test.diagnostics.DiagnosticKind;
import org.checkerframework.framework.test.diagnostics.TestDiagnostic;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticLine;
import org.checkerframework.javacutil.Pair;

public class TestDiagnosticUtils {
    public static final String STUB_PARSER_STRING = "warning: StubParser";
    public static final String STUB_PARSER_COMMENT = "//warning: StubParser";
    public static final String FLOW_POLICY_STRING = "warning: FlowPolicy:";
    public static final String FLOW_POLICY_COMMENT = "//warning: FlowPolicy:";
    public static final String DIAGNOSTIC_IN_JAVA_REGEX = "\\s*(error|fixable-error|warning|other):\\s*(\\(?.*\\)?)\\s*";
    public static final Pattern DIAGNOSTIC_IN_JAVA_PATTERN = Pattern.compile("\\s*(error|fixable-error|warning|other):\\s*(\\(?.*\\)?)\\s*");
    public static final String DIAGNOSTIC_WARNING_IN_JAVA_REGEX = "\\s*warning:\\s*(.*\\s*.*)\\s*";
    public static final Pattern DIAGNOSTIC_WARNING_IN_JAVA_PATTERN = Pattern.compile("\\s*warning:\\s*(.*\\s*.*)\\s*");
    public static final String DIAGNOSTIC_REGEX = ":(\\d+):\\s*(error|fixable-error|warning|other):\\s*(\\(?.*\\)?)\\s*";
    public static final Pattern DIAGNOSTIC_PATTERN = Pattern.compile(":(\\d+):\\s*(error|fixable-error|warning|other):\\s*(\\(?.*\\)?)\\s*");
    public static final String DIAGNOSTIC_WARNING_REGEX = ":(\\d+):\\s*warning:\\s*(.*\\s*.*)\\s*";
    public static final Pattern DIAGNOSTIC_WARNING_PATTERN = Pattern.compile(":(\\d+):\\s*warning:\\s*(.*\\s*.*)\\s*");
    public static final String DIAGNOSTIC_FILE_REGEX = ".+\\.java:(\\d+):\\s*(error|fixable-error|warning|other):\\s*(\\(?.*\\)?)\\s*";
    public static final Pattern DIAGNOSTIC_FILE_PATTERN = Pattern.compile(".+\\.java:(\\d+):\\s*(error|fixable-error|warning|other):\\s*(\\(?.*\\)?)\\s*");
    public static final String DIAGNOSTIC_FILE_WARNING_REGEX = ".+\\.java:(\\d+):\\s*warning:\\s*(.*\\s*.*)\\s*";
    public static final Pattern DIAGNOSTIC_FILE_WARNING_PATTERN = Pattern.compile(".+\\.java:(\\d+):\\s*warning:\\s*(.*\\s*.*)\\s*");
    private static final List<TestDiagnostic> EMPTY = Collections.unmodifiableList(new ArrayList());

    public static TestDiagnostic fromDiagnosticFileString(String stringFromDiagnosticFile) {
        return TestDiagnosticUtils.fromPatternMatching(DIAGNOSTIC_FILE_PATTERN, DIAGNOSTIC_WARNING_IN_JAVA_PATTERN, null, stringFromDiagnosticFile);
    }

    public static TestDiagnostic fromJavaFileComment(long lineNumber, String stringFromjavaFile) {
        return TestDiagnosticUtils.fromPatternMatching(DIAGNOSTIC_IN_JAVA_PATTERN, DIAGNOSTIC_WARNING_IN_JAVA_PATTERN, lineNumber, stringFromjavaFile);
    }

    public static TestDiagnostic fromJavaxToolsDiagnostic(String diagnosticString, boolean noMsgText) {
        String trimmed = TestDiagnosticUtils.formatJavaxToolString(diagnosticString, noMsgText);
        return TestDiagnosticUtils.fromPatternMatching(DIAGNOSTIC_PATTERN, DIAGNOSTIC_WARNING_PATTERN, null, trimmed);
    }

    static Pair<Boolean, String> dropParentheses(String str) {
        if (str.charAt(0) == '(' && str.charAt(str.length() - 1) == ')') {
            return Pair.of(true, str.substring(1, str.length() - 1));
        }
        return Pair.of(false, str);
    }

    protected static TestDiagnostic fromPatternMatching(Pattern diagnosticPattern, Pattern warningPattern, Long lineNumber, String diagnosticString) {
        boolean noParentheses;
        String message;
        boolean isFixable;
        DiagnosticKind kind;
        Matcher diagnosticMatcher;
        long lineNo = -1L;
        int groupOffset = 1;
        if (lineNumber != null) {
            lineNo = lineNumber;
            groupOffset = 0;
        }
        if ((diagnosticMatcher = diagnosticPattern.matcher(diagnosticString)).matches()) {
            Pair<DiagnosticKind, Boolean> categoryToFixable = TestDiagnosticUtils.parseCategoryString(diagnosticMatcher.group(1 + groupOffset));
            kind = (DiagnosticKind)((Object)categoryToFixable.first);
            isFixable = (Boolean)categoryToFixable.second;
            Pair<Boolean, String> dropQuotesToString = TestDiagnosticUtils.dropParentheses(diagnosticMatcher.group(2 + groupOffset).trim());
            message = (String)dropQuotesToString.second;
            boolean bl = noParentheses = (Boolean)dropQuotesToString.first == false;
            if (lineNumber == null) {
                lineNo = Long.parseLong(diagnosticMatcher.group(1));
            }
        } else {
            Matcher warningMatcher = warningPattern.matcher(diagnosticString);
            if (warningMatcher.matches()) {
                kind = DiagnosticKind.Warning;
                isFixable = false;
                message = warningMatcher.group(1 + groupOffset);
                noParentheses = true;
                if (lineNumber == null) {
                    lineNo = Long.parseLong(diagnosticMatcher.group(1));
                }
            } else if (diagnosticString.startsWith("warning:")) {
                kind = DiagnosticKind.Warning;
                isFixable = false;
                message = diagnosticString.substring("warning:".length()).trim();
                noParentheses = true;
                lineNo = lineNumber != null ? lineNumber : 0L;
            } else {
                kind = DiagnosticKind.Other;
                isFixable = false;
                message = diagnosticString;
                noParentheses = true;
                if (lineNumber == null) {
                    lineNo = -1L;
                }
            }
        }
        return new TestDiagnostic(lineNo, kind, message, isFixable, noParentheses);
    }

    public static String formatJavaxToolString(String original, boolean noMsgText) {
        String trimmed = original;
        if (noMsgText && !trimmed.contains("unexpected Throwable")) {
            if (trimmed.contains("\n")) {
                trimmed = trimmed.substring(0, trimmed.indexOf(10));
            }
            if (trimmed.contains(".java:")) {
                trimmed = trimmed.substring(trimmed.indexOf(".java:") + 5).trim();
            }
        }
        return trimmed;
    }

    private static Pair<DiagnosticKind, Boolean> parseCategoryString(String category) {
        String fixable = "fixable-";
        boolean isFixable = category.startsWith("fixable-");
        if (isFixable) {
            category = category.substring("fixable-".length());
        }
        DiagnosticKind categoryEnum = DiagnosticKind.fromParseString(category);
        return Pair.of(categoryEnum, isFixable);
    }

    public static TestDiagnosticLine fromJavaSourceLine(String originalLine, long lineNumber) {
        String trimmedLine = originalLine.trim();
        long errorLine = lineNumber + 1L;
        boolean normalDiagnostic = trimmedLine.startsWith("//::");
        if (normalDiagnostic || trimmedLine.startsWith("//warning:")) {
            String[] diagnosticStrs = normalDiagnostic ? trimmedLine.substring(4).split("::") : new String[]{trimmedLine.substring(2)};
            ArrayList<TestDiagnostic> diagnostics = new ArrayList<TestDiagnostic>(diagnosticStrs.length);
            for (String diagnostic : diagnosticStrs) {
                diagnostics.add(TestDiagnosticUtils.fromJavaFileComment(normalDiagnostic ? errorLine : 0L, diagnostic));
            }
            return new TestDiagnosticLine(errorLine, originalLine, Collections.unmodifiableList(diagnostics));
        }
        return new TestDiagnosticLine(errorLine, originalLine, EMPTY);
    }

    public static TestDiagnosticLine fromDiagnosticFileLine(String diagnosticLine) {
        String trimmedLine = diagnosticLine.trim();
        if (trimmedLine.startsWith("#") || trimmedLine.isEmpty()) {
            return new TestDiagnosticLine(-1L, diagnosticLine, EMPTY);
        }
        TestDiagnostic diagnostic = TestDiagnosticUtils.fromDiagnosticFileString(diagnosticLine);
        return new TestDiagnosticLine(diagnostic.getLineNumber(), diagnosticLine, Arrays.asList(diagnostic));
    }

    public static Set<TestDiagnostic> fromJavaxDiagnosticList(List<Diagnostic<? extends JavaFileObject>> javaxDiagnostics, boolean noMsgText) {
        HashSet<TestDiagnostic> diagnostics = new HashSet<TestDiagnostic>(javaxDiagnostics.size());
        for (Diagnostic<? extends JavaFileObject> diagnostic : javaxDiagnostics) {
            String diagnosticString = diagnostic.toString();
            if (diagnosticString.contains("uses unchecked or unsafe operations.") || diagnosticString.contains("Recompile with -Xlint:unchecked for details.") || diagnosticString.endsWith(" declares unsafe vararg methods.") || diagnosticString.contains("Recompile with -Xlint:varargs for details.")) continue;
            diagnostics.add(TestDiagnosticUtils.fromJavaxToolsDiagnostic(diagnosticString, noMsgText));
        }
        return diagnostics;
    }

    public static List<String> diagnosticsToString(List<TestDiagnostic> diagnostics) {
        ArrayList<String> strings = new ArrayList<String>(diagnostics.size());
        for (TestDiagnostic diagnostic : diagnostics) {
            strings.add(diagnostic.toString());
        }
        return strings;
    }

    public static void removeDiagnosticsOfKind(DiagnosticKind kind, List<TestDiagnostic> expectedDiagnostics) {
        int i = 0;
        while (i < expectedDiagnostics.size()) {
            if (expectedDiagnostics.get(i).getKind() == kind) {
                expectedDiagnostics.remove(i);
                continue;
            }
            ++i;
        }
    }
}

