/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PluginUtil {
    public static final String JAVAC_PATH_OPT = "-javacJar";
    public static final String JDK_PATH_OPT = "-jdkJar";

    public static List<File> toFiles(List<String> fileNames) {
        ArrayList<File> files = new ArrayList<File>(fileNames.size());
        for (String fn : fileNames) {
            files.add(new File(fn));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFofn(File destination, List<File> files) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(destination));){
            for (File file : files) {
                bw.write(PluginUtil.wrapArg(file.getAbsolutePath()));
                bw.newLine();
            }
            bw.flush();
        }
    }

    public static void writeFofn(File destination, File ... files) throws IOException {
        PluginUtil.writeFofn(destination, Arrays.asList(files));
    }

    public static File writeTmpFofn(String prefix, String suffix, boolean deleteOnExit, List<File> files) throws IOException {
        File tmpFile = File.createTempFile(prefix, suffix);
        if (deleteOnExit) {
            tmpFile.deleteOnExit();
        }
        PluginUtil.writeFofn(tmpFile, files);
        return tmpFile;
    }

    public static File writeTmpArgFile(String prefix, String suffix, boolean deleteOnExit, List<String> args) throws IOException {
        File tmpFile = File.createTempFile(prefix, suffix);
        if (deleteOnExit) {
            tmpFile.deleteOnExit();
        }
        PluginUtil.writeArgFile(tmpFile, args);
        return tmpFile;
    }

    public static void writeArgFile(File destination, List<String> args) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(destination));){
            bw.write(PluginUtil.join(" ", args));
            bw.flush();
        }
    }

    public static List<String> readArgFile(File argFile) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(argFile));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        br.close();
        return lines;
    }

    public static <T> String join(String delimiter, T[] objs) {
        boolean notFirst = false;
        StringBuffer sb = new StringBuffer();
        for (T obj : objs) {
            if (notFirst) {
                sb.append(delimiter);
            }
            sb.append(obj.toString());
            notFirst = true;
        }
        return sb.toString();
    }

    public static String join(String delimiter, Iterable<?> values) {
        StringBuilder sb = new StringBuilder();
        boolean isntFirst = false;
        for (Object value : values) {
            if (isntFirst) {
                sb.append(delimiter);
            }
            sb.append(value);
            isntFirst = true;
        }
        return sb.toString();
    }

    public static List<String> getStringProp(Map<CheckerProp, Object> props, CheckerProp prop, String tag, String ... extras) {
        ArrayList<String> out = new ArrayList<String>();
        String strProp = (String)props.get((Object)prop);
        if (strProp != null && !strProp.isEmpty()) {
            out.add(tag + strProp);
            for (String extra : extras) {
                out.add(extra);
            }
        }
        return out;
    }

    public static List<String> getBooleanProp(Map<CheckerProp, Object> props, CheckerProp prop, String tag) {
        Boolean aSkip = (Boolean)props.get((Object)prop);
        if (aSkip != null && aSkip.booleanValue()) {
            return Arrays.asList(tag);
        }
        return new ArrayList<String>();
    }

    private static void addOptions(List<String> cmd, Map<CheckerProp, Object> props) {
        for (CheckerProp cp : CheckerProp.values()) {
            cmd.addAll(cp.getCmdLine(props));
        }
    }

    public static File writeTmpSrcFofn(String prefix, boolean deleteOnExit, List<File> files) throws IOException {
        return PluginUtil.writeTmpFofn(prefix, ".src_files", deleteOnExit, files);
    }

    public static File writeTmpCpFile(String prefix, boolean deleteOnExit, String classpath) throws IOException {
        return PluginUtil.writeTmpArgFile(prefix, ".classpath", deleteOnExit, Arrays.asList("-classpath", PluginUtil.wrapArg(classpath)));
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().contains("win");
    }

    public static String wrapArg(String classpath) {
        if (classpath.contains(" ")) {
            return '\"' + PluginUtil.escapeQuotesAndSlashes(classpath) + '\"';
        }
        return classpath;
    }

    public static String escapeQuotesAndSlashes(String toEscape) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("\\\\", "\\\\\\\\");
        replacements.put("\"", "\\\\\"");
        String replacement = toEscape;
        for (Map.Entry entry : replacements.entrySet()) {
            replacement = replacement.replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        return replacement;
    }

    public static String getJavaCommand(String javaHome, PrintStream out) {
        if (javaHome == null || javaHome.equals("")) {
            return "java";
        }
        File java = new File(javaHome, "bin" + File.separator + "java");
        File javaExe = new File(javaHome, "bin" + File.separator + "java.exe");
        if (java.exists()) {
            return java.getAbsolutePath();
        }
        if (javaExe.exists()) {
            return javaExe.getAbsolutePath();
        }
        if (out != null) {
            out.println("Could not find java executable at: ( " + java.getAbsolutePath() + "," + javaExe.getAbsolutePath() + ")" + "\n  Using \"java\" command.\n");
        }
        return "java";
    }

    public static String fileArgToStr(File fileArg) {
        return "@" + fileArg.getAbsolutePath();
    }

    public static List<String> getCmd(String executable, File javacPath, File jdkPath, File srcFofn, String processors, String checkerHome, String javaHome, File classPathFofn, String bootClassPath, Map<CheckerProp, Object> props, PrintStream out, boolean procOnly, String outputDirectory) {
        ArrayList<String> cmd = new ArrayList<String>();
        String java = executable != null ? executable : PluginUtil.getJavaCommand(javaHome, out);
        cmd.add(java);
        cmd.add("-jar");
        cmd.add(checkerHome);
        if (procOnly) {
            cmd.add("-proc:only");
        } else if (outputDirectory != null) {
            cmd.add("-d");
            cmd.add(outputDirectory);
        }
        if (bootClassPath != null && !bootClassPath.trim().isEmpty()) {
            cmd.add("-Xbootclasspath/p:" + bootClassPath);
        }
        if (javacPath != null) {
            cmd.add(JAVAC_PATH_OPT);
            cmd.add(javacPath.getAbsolutePath());
        }
        if (jdkPath != null) {
            cmd.add(JDK_PATH_OPT);
            cmd.add(jdkPath.getAbsolutePath());
        }
        if (classPathFofn != null) {
            cmd.add(PluginUtil.fileArgToStr(classPathFofn));
        }
        if (processors != null) {
            cmd.add("-processor");
            cmd.add(processors);
        }
        PluginUtil.addOptions(cmd, props);
        cmd.add(PluginUtil.fileArgToStr(srcFofn));
        return cmd;
    }

    public static List<String> toJavaOpts(List<String> opts) {
        ArrayList<String> outOpts = new ArrayList<String>(opts.size());
        for (String opt : opts) {
            outOpts.add("-J" + opt);
        }
        return outOpts;
    }

    public static List<String> getCmdArgsOnly(File srcFofn, String processors, String checkerHome, String javaHome, File classpathFofn, String bootClassPath, Map<CheckerProp, Object> props, PrintStream out, boolean procOnly, String outputDirectory) {
        List<String> cmd = PluginUtil.getCmd(null, null, null, srcFofn, processors, checkerHome, javaHome, classpathFofn, bootClassPath, props, out, procOnly, outputDirectory);
        cmd.remove(0);
        return cmd;
    }

    public static List<String> getCmdArgsOnly(File javacPath, File jdkPath, File srcFofn, String processors, String checkerHome, String javaHome, File classpathFofn, String bootClassPath, Map<CheckerProp, Object> props, PrintStream out, boolean procOnly, String outputDirectory) {
        List<String> cmd = PluginUtil.getCmd(null, javacPath, jdkPath, srcFofn, processors, checkerHome, javaHome, classpathFofn, bootClassPath, props, out, procOnly, outputDirectory);
        cmd.remove(0);
        return cmd;
    }

    public static double getJreVersion() {
        String jreVersionStr;
        Pattern versionPattern = Pattern.compile("^(\\d\\.\\d+)\\..*$");
        Matcher versionMatcher = versionPattern.matcher(jreVersionStr = System.getProperty("java.version"));
        if (!versionMatcher.matches()) {
            throw new RuntimeException("Could not determine version from property java.version=" + jreVersionStr);
        }
        double version = Double.parseDouble(versionMatcher.group(1));
        return version;
    }

    public static String getJdkJarPrefix() {
        String prefix;
        double jreVersion = PluginUtil.getJreVersion();
        if (jreVersion == 1.4 || jreVersion == 1.5 || jreVersion == 1.6) {
            prefix = "jdk6";
        } else if (jreVersion == 1.7) {
            prefix = "jdk7";
        } else if (jreVersion == 1.8) {
            prefix = "jdk8";
        } else if (jreVersion == 1.9) {
            prefix = "jdk9";
        } else {
            throw new AssertionError((Object)("Unsupported JRE version: " + jreVersion));
        }
        return prefix;
    }

    public static String getJdkJarName() {
        String fileName = PluginUtil.getJdkJarPrefix() + ".jar";
        return fileName;
    }

    public static enum CheckerProp {
        IMPLICIT_IMPORTS{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getStringProp(props, this, "-J-Djsr308_imports=", "-implicit:class");
            }
        }
        ,
        MISC_COMPILER{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                List miscOpts = (List)props.get((Object)this);
                if (miscOpts != null && !miscOpts.isEmpty()) {
                    return new ArrayList<String>(miscOpts);
                }
                return new ArrayList<String>();
            }
        }
        ,
        A_SKIP{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getStringProp(props, this, "-AskipUses=", new String[0]);
            }
        }
        ,
        A_LINT{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getStringProp(props, this, "-Alint=", new String[0]);
            }
        }
        ,
        A_WARNS{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getBooleanProp(props, this, "-Awarns");
            }
        }
        ,
        A_NO_MSG_TXT{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getBooleanProp(props, this, "-Anomsgtext");
            }
        }
        ,
        A_SHOW_CHECKS{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getBooleanProp(props, this, "-Ashowchecks");
            }
        }
        ,
        A_FILENAMES{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getBooleanProp(props, this, "-Afilenames");
            }
        }
        ,
        A_DETAILED_MSG{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getBooleanProp(props, this, "-Adetailedmsgtext");
            }
        };


        public abstract List<String> getCmdLine(Map<CheckerProp, Object> var1);
    }
}

