/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.guieffect;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Collections;
import java.util.Set;
import java.util.Stack;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.guieffect.Effect;
import org.checkerframework.checker.guieffect.GuiEffectTypeFactory;
import org.checkerframework.checker.guieffect.qual.AlwaysSafe;
import org.checkerframework.checker.guieffect.qual.PolyUI;
import org.checkerframework.checker.guieffect.qual.PolyUIEffect;
import org.checkerframework.checker.guieffect.qual.SafeEffect;
import org.checkerframework.checker.guieffect.qual.UI;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class GuiEffectVisitor
extends BaseTypeVisitor<GuiEffectTypeFactory> {
    protected final boolean debugSpew;
    protected final Stack<Effect> effStack;
    protected final Stack<MethodTree> currentMethods;

    public GuiEffectVisitor(BaseTypeChecker checker) {
        super(checker);
        this.debugSpew = checker.getLintOption("debugSpew", false);
        if (this.debugSpew) {
            System.err.println("Running GuiEffectVisitor");
        }
        this.effStack = new Stack();
        this.currentMethods = new Stack();
    }

    @Override
    protected GuiEffectTypeFactory createTypeFactory() {
        return new GuiEffectTypeFactory(this.checker, this.debugSpew);
    }

    @Override
    protected void checkMethodInvocability(AnnotatedTypeMirror.AnnotatedExecutableType method, MethodInvocationTree node) {
    }

    @Override
    protected boolean checkOverride(MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, Void p) {
        return true;
    }

    @Override
    protected Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotations() {
        return Collections.singleton(AnnotationUtils.fromClass(this.elements, AlwaysSafe.class));
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        boolean ret;
        boolean bl = ret = useType.hasAnnotation(AlwaysSafe.class) || ((GuiEffectTypeFactory)this.atypeFactory).isPolymorphicType((TypeElement)declarationType.getUnderlyingType().asElement()) || useType.hasAnnotation(UI.class) && declarationType.hasAnnotation(UI.class);
        if (this.debugSpew && !ret) {
            System.err.println("use: " + useType);
            System.err.println("use safe: " + useType.hasAnnotation(AlwaysSafe.class));
            System.err.println("use poly: " + useType.hasAnnotation(PolyUI.class));
            System.err.println("use ui: " + useType.hasAnnotation(UI.class));
            System.err.println("declaration safe: " + declarationType.hasAnnotation(AlwaysSafe.class));
            System.err.println("declaration poly: " + ((GuiEffectTypeFactory)this.atypeFactory).isPolymorphicType((TypeElement)declarationType.getUnderlyingType().asElement()));
            System.err.println("declaration ui: " + declarationType.hasAnnotation(UI.class));
            System.err.println("declaration: " + declarationType);
        }
        return ret;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        Effect targetEffect;
        MethodTree callerTree;
        if (this.debugSpew) {
            System.err.println("For invocation " + node + " in " + this.currentMethods.peek().getName());
        }
        ExecutableElement methodElt = TreeUtils.elementFromUse(node);
        if (this.debugSpew) {
            System.err.println("methodElt found");
        }
        if ((callerTree = TreeUtils.enclosingMethod(this.getCurrentPath())) == null) {
            if (this.debugSpew) {
                System.err.println("No enclosing method: likely static initializer");
            }
            return super.visitMethodInvocation(node, p);
        }
        if (this.debugSpew) {
            System.err.println("callerTree found");
        }
        ExecutableElement callerElt = TreeUtils.elementFromDeclaration(callerTree);
        if (this.debugSpew) {
            System.err.println("callerElt found");
        }
        if ((targetEffect = ((GuiEffectTypeFactory)this.atypeFactory).getDeclaredEffect(methodElt)).isPoly()) {
            AnnotatedTypeMirror srcType = null;
            assert (node.getMethodSelect().getKind() == Tree.Kind.IDENTIFIER || node.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT);
            if (node.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT) {
                ExpressionTree src = ((MemberSelectTree)node.getMethodSelect()).getExpression();
                srcType = ((GuiEffectTypeFactory)this.atypeFactory).fromExpression(src);
            } else {
                srcType = this.visitorState.getMethodReceiver();
            }
            if (srcType.hasAnnotation(AlwaysSafe.class)) {
                targetEffect = new Effect(SafeEffect.class);
            } else if (srcType.hasAnnotation(UI.class)) {
                targetEffect = new Effect(UIEffect.class);
            }
        }
        Effect callerEffect = ((GuiEffectTypeFactory)this.atypeFactory).getDeclaredEffect(callerElt);
        assert (callerEffect.equals(this.effStack.peek()));
        if (!Effect.LE(targetEffect, callerEffect)) {
            this.checker.report(Result.failure("call.invalid.ui", targetEffect, callerEffect), node);
            if (this.debugSpew) {
                System.err.println("Issuing error for node: " + node);
            }
        }
        if (this.debugSpew) {
            System.err.println("Successfully finished main non-recursive checkinv of invocation " + node);
        }
        return super.visitMethodInvocation(node, p);
    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
        ExecutableElement methElt = TreeUtils.elementFromDeclaration(node);
        if (this.debugSpew) {
            System.err.println("\nVisiting method " + methElt);
        }
        assert (methElt != null);
        AnnotationMirror targetUIP = ((GuiEffectTypeFactory)this.atypeFactory).getDeclAnnotation(methElt, UIEffect.class);
        AnnotationMirror targetSafeP = ((GuiEffectTypeFactory)this.atypeFactory).getDeclAnnotation(methElt, SafeEffect.class);
        AnnotationMirror targetPolyP = ((GuiEffectTypeFactory)this.atypeFactory).getDeclAnnotation(methElt, PolyUIEffect.class);
        TypeElement targetClassElt = (TypeElement)methElt.getEnclosingElement();
        if (targetUIP != null && (targetSafeP != null || targetPolyP != null) || targetSafeP != null && targetPolyP != null) {
            this.checker.report(Result.failure("annotations.conflicts", new Object[0]), node);
        }
        if (targetPolyP != null && !((GuiEffectTypeFactory)this.atypeFactory).isPolymorphicType(targetClassElt)) {
            this.checker.report(Result.failure("polymorphism.invalid", new Object[0]), node);
        }
        if (targetUIP != null && ((GuiEffectTypeFactory)this.atypeFactory).isUIType(targetClassElt)) {
            this.checker.report(Result.warning("effects.redundant.uitype", new Object[0]), node);
        }
        Effect.EffectRange range = ((GuiEffectTypeFactory)this.atypeFactory).findInheritedEffectRange((TypeElement)methElt.getEnclosingElement(), methElt, true, node);
        if (targetUIP == null && targetSafeP == null && targetPolyP == null) {
            ((GuiEffectTypeFactory)this.atypeFactory).fromElement(methElt).addAnnotation(((GuiEffectTypeFactory)this.atypeFactory).getDeclaredEffect(methElt).getAnnot());
        }
        this.currentMethods.push(node);
        this.effStack.push(((GuiEffectTypeFactory)this.atypeFactory).getDeclaredEffect(methElt));
        if (this.debugSpew) {
            System.err.println("Pushing " + this.effStack.peek() + " onto the stack when checking " + methElt);
        }
        Void ret = super.visitMethod(node, p);
        this.currentMethods.pop();
        this.effStack.pop();
        return ret;
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        return (Void)super.visitMemberSelect(node, p);
    }

    @Override
    public Void visitClass(ClassTree node, Void p) {
        this.currentMethods.push(null);
        this.effStack.push(new Effect(UIEffect.class));
        Void ret = super.visitClass(node, p);
        this.currentMethods.pop();
        this.effStack.pop();
        return ret;
    }
}

