/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.reflection;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.reflection.qual.ClassBound;
import org.checkerframework.common.reflection.qual.ClassVal;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.ForName;
import org.checkerframework.common.reflection.qual.GetClass;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.framework.qual.TypeQualifiers;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

@TypeQualifiers(value={UnknownClass.class, ClassVal.class, ClassBound.class, ClassValBottom.class})
public class ClassValAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror CLASSVAL_TOP;

    public ClassValAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.CLASSVAL_TOP = AnnotationUtils.fromClass(this.elements, UnknownClass.class);
        if (this.getClass().equals(ClassValAnnotatedTypeFactory.class)) {
            this.postInit();
        }
    }

    private AnnotationMirror createClassVal(List<String> values) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, ClassVal.class.getCanonicalName());
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    private AnnotationMirror createClassBound(List<String> values) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, ClassBound.class.getCanonicalName());
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    public static List<String> getClassNamesFromAnnotation(AnnotationMirror anno) {
        if (AnnotationUtils.areSameByClass(anno, ClassBound.class) || AnnotationUtils.areSameByClass(anno, ClassVal.class)) {
            return AnnotationUtils.getElementValueArray(anno, "value", String.class, true);
        }
        return new ArrayList<String>();
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new ClassValQualifierHierarchy(factory);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new ClassValTreeAnnotator(this), super.createTreeAnnotator());
    }

    protected class ClassValTreeAnnotator
    extends TreeAnnotator {
        protected ClassValTreeAnnotator(ClassValAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
            ExpressionTree etree;
            Type classType;
            String name;
            if (TreeUtils.isClassLiteral(tree) && (name = this.getClassNameFromType(classType = (Type)InternalUtils.typeOf(etree = tree.getExpression()))) != null) {
                AnnotationMirror newQual = ClassValAnnotatedTypeFactory.this.createClassVal(Arrays.asList(name));
                type.replaceAnnotation(newQual);
            }
            return null;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            if (this.isForNameMethodInovaction(tree)) {
                ExpressionTree arg = tree.getArguments().get(0);
                List<String> classNames = this.getStringValues(arg);
                if (classNames != null) {
                    AnnotationMirror newQual = ClassValAnnotatedTypeFactory.this.createClassVal(classNames);
                    type.replaceAnnotation(newQual);
                }
            } else if (this.isGetClassMethodInovaction(tree)) {
                Type clType;
                if (TreeUtils.getReceiverTree(tree) != null) {
                    clType = (Type)InternalUtils.typeOf(TreeUtils.getReceiverTree(tree));
                } else {
                    ClassTree classTree = TreeUtils.enclosingClass(ClassValAnnotatedTypeFactory.this.getPath(tree));
                    clType = (Type)InternalUtils.typeOf(classTree);
                }
                String className = this.getClassNameFromType(clType);
                AnnotationMirror newQual = ClassValAnnotatedTypeFactory.this.createClassBound(Arrays.asList(className));
                type.replaceAnnotation(newQual);
            }
            return null;
        }

        private boolean isForNameMethodInovaction(MethodInvocationTree tree) {
            return ClassValAnnotatedTypeFactory.this.getDeclAnnotation(InternalUtils.symbol(tree), ForName.class) != null;
        }

        private boolean isGetClassMethodInovaction(MethodInvocationTree tree) {
            return ClassValAnnotatedTypeFactory.this.getDeclAnnotation(InternalUtils.symbol(tree), GetClass.class) != null;
        }

        private List<String> getStringValues(ExpressionTree arg) {
            ValueAnnotatedTypeFactory valueATF = (ValueAnnotatedTypeFactory)ClassValAnnotatedTypeFactory.this.getTypeFactoryOfSubchecker(ValueChecker.class);
            AnnotationMirror annotation = valueATF.getAnnotationMirror(arg, StringVal.class);
            if (annotation == null) {
                return null;
            }
            return AnnotationUtils.getElementValueArray(annotation, "value", String.class, true);
        }

        private String getClassNameFromType(Type classType) {
            switch (classType.getKind()) {
                case ARRAY: {
                    String array = "";
                    while (classType.getKind() == TypeKind.ARRAY) {
                        classType = ((Type.ArrayType)classType).getComponentType();
                        array = array + "[]";
                    }
                    return this.getClassNameFromType(classType) + array;
                }
                case DECLARED: {
                    StringBuilder className = new StringBuilder(TypesUtils.getQualifiedName((DeclaredType)((Object)classType)).toString());
                    if (classType.getEnclosingType() != null) {
                        while (classType.getEnclosingType().getKind() != TypeKind.NONE) {
                            classType = classType.getEnclosingType();
                            int last = className.lastIndexOf(".");
                            if (last <= -1) continue;
                            className.replace(last, last + 1, "$");
                        }
                    }
                    return className.toString();
                }
                case INTERSECTION: {
                    return "java.lang.Object";
                }
                case NULL: {
                    return "java.lang.Object";
                }
                case UNION: {
                    classType = ((Type.UnionClassType)classType).getLub();
                    return this.getClassNameFromType(classType);
                }
                case TYPEVAR: 
                case WILDCARD: {
                    classType = classType.getUpperBound();
                    return this.getClassNameFromType(classType);
                }
                case INT: {
                    return Integer.TYPE.getCanonicalName();
                }
                case LONG: {
                    return Long.TYPE.getCanonicalName();
                }
                case SHORT: {
                    return Short.TYPE.getCanonicalName();
                }
                case BYTE: {
                    return Byte.TYPE.getCanonicalName();
                }
                case CHAR: {
                    return Character.TYPE.getCanonicalName();
                }
                case DOUBLE: {
                    return Double.TYPE.getCanonicalName();
                }
                case FLOAT: {
                    return Float.TYPE.getCanonicalName();
                }
                case BOOLEAN: {
                    return Boolean.TYPE.getCanonicalName();
                }
            }
            ClassValAnnotatedTypeFactory.this.checker.errorAbort("ClassValAnnotatedTypeFactory.getClassname: did not expect " + (Object)((Object)classType.getKind()));
            return "java.lang.Object";
        }
    }

    protected class ClassValQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public ClassValQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (!AnnotationUtils.areSameIgnoringValues(this.getTopAnnotation(a1), this.getTopAnnotation(a2))) {
                return null;
            }
            if (this.isSubtype(a1, a2)) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            List<String> a1ClassNames = ClassValAnnotatedTypeFactory.getClassNamesFromAnnotation(a1);
            List<String> a2ClassNames = ClassValAnnotatedTypeFactory.getClassNamesFromAnnotation(a2);
            TreeSet<String> lubClassNames = new TreeSet<String>();
            lubClassNames.addAll(a1ClassNames);
            lubClassNames.addAll(a2ClassNames);
            if (AnnotationUtils.areSameByClass(a1, ClassBound.class) || AnnotationUtils.areSameByClass(a2, ClassBound.class)) {
                return ClassValAnnotatedTypeFactory.this.createClassBound(new ArrayList(lubClassNames));
            }
            return ClassValAnnotatedTypeFactory.this.createClassVal(new ArrayList(lubClassNames));
        }

        @Override
        public boolean isSubtype(AnnotationMirror sub, AnnotationMirror sup) {
            if (AnnotationUtils.areSame(sub, sup) || AnnotationUtils.areSameByClass(sup, UnknownClass.class) || AnnotationUtils.areSameByClass(sub, ClassValBottom.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(sub, UnknownClass.class) || AnnotationUtils.areSameByClass(sup, ClassValBottom.class)) {
                return false;
            }
            if (AnnotationUtils.areSameByClass(sup, ClassVal.class) && AnnotationUtils.areSameByClass(sub, ClassBound.class)) {
                return false;
            }
            List<String> supValues = ClassValAnnotatedTypeFactory.getClassNamesFromAnnotation(sup);
            List<String> subValues = ClassValAnnotatedTypeFactory.getClassNamesFromAnnotation(sub);
            return supValues.containsAll(subValues);
        }
    }
}

