/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.base;

import com.sun.source.tree.CatchTree;
import com.sun.source.tree.Tree;
import javax.lang.model.type.TypeKind;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.qualframework.base.CheckerAdapter;
import org.checkerframework.qualframework.base.QualifiedTypeFactoryAdapter;
import org.checkerframework.qualframework.base.QualifiedTypeMirror;
import org.checkerframework.qualframework.util.QualifierContext;

public class TypecheckVisitorAdapter<Q>
extends BaseTypeVisitor<GenericAnnotatedTypeFactory<?, ?, ?, ?>> {
    protected final QualifierContext<Q> context;

    public TypecheckVisitorAdapter(CheckerAdapter<Q> checker) {
        super(checker);
        this.context = checker.getUnderlying();
    }

    @Override
    protected QualifiedTypeFactoryAdapter<Q> createTypeFactory() {
        return ((CheckerAdapter)this.checker).getTypeFactory();
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        if (tree.getKind() == Tree.Kind.VARIABLE && InternalUtils.symbol(tree).asType().getKind() == TypeKind.TYPEVAR) {
            return true;
        }
        return super.isValidUse(declarationType, useType, tree);
    }

    @Override
    protected void checkExceptionParameter(CatchTree node) {
        QualifiedTypeMirror<Q> exceptionParam = this.context.getTypeFactory().getQualifiedType(node.getParameter());
        Q required = this.getExceptionParameterLowerBoundQualifier();
        Q found = this.context.getTypeFactory().getQualifiedType(node.getParameter()).getQualifier();
        if (!this.context.getTypeFactory().getQualifierHierarchy().isSubtype(required, found)) {
            this.checker.report(Result.failure("exception.parameter.invalid", found, required), node.getParameter());
        }
        if (exceptionParam.getKind() == TypeKind.UNION) {
            QualifiedTypeMirror.QualifiedUnionType aut = (QualifiedTypeMirror.QualifiedUnionType)exceptionParam;
            for (QualifiedTypeMirror alterntive : aut.getAlternatives()) {
                Object foundAltern = alterntive.getQualifier();
                if (this.context.getTypeFactory().getQualifierHierarchy().isSubtype(required, foundAltern)) continue;
                this.checker.report(Result.failure("exception.parameter.invalid", foundAltern, required), node.getParameter());
            }
        }
    }

    protected Q getExceptionParameterLowerBoundQualifier() {
        return this.context.getTypeFactory().getQualifierHierarchy().getTop();
    }
}

