/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.experimental.regex_qual;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.experimental.regex_qual.Regex;
import org.checkerframework.checker.experimental.regex_qual.RegexAnnotationConverter;
import org.checkerframework.checker.experimental.regex_qual.RegexQualifiedTransfer;
import org.checkerframework.checker.experimental.regex_qual.RegexQualifierHierarchy;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.qualframework.base.AnnotationConverter;
import org.checkerframework.qualframework.base.DefaultQualifiedTypeFactory;
import org.checkerframework.qualframework.base.QualifiedTypeMirror;
import org.checkerframework.qualframework.base.QualifierHierarchy;
import org.checkerframework.qualframework.base.SetQualifierVisitor;
import org.checkerframework.qualframework.base.TreeAnnotator;
import org.checkerframework.qualframework.base.dataflow.QualAnalysis;
import org.checkerframework.qualframework.base.dataflow.QualTransfer;
import org.checkerframework.qualframework.base.dataflow.QualValue;
import org.checkerframework.qualframework.util.ExtendedTypeMirror;
import org.checkerframework.qualframework.util.QualifierContext;

public class RegexQualifiedTypeFactory
extends DefaultQualifiedTypeFactory<Regex> {
    private final ExecutableElement patternCompile = TreeUtils.getMethod("java.util.regex.Pattern", "compile", 1, this.getContext().getProcessingEnvironment());
    private final ExecutableElement patternMatcher = TreeUtils.getMethod("java.util.regex.Pattern", "matcher", 1, this.getContext().getProcessingEnvironment());

    public RegexQualifiedTypeFactory(QualifierContext<Regex> checker) {
        super(checker);
    }

    @Override
    protected QualifierHierarchy<Regex> createQualifierHierarchy() {
        return new RegexQualifierHierarchy();
    }

    @Override
    protected AnnotationConverter<Regex> createAnnotationConverter() {
        return new RegexAnnotationConverter();
    }

    @Override
    protected TreeAnnotator<Regex> createTreeAnnotator() {
        return new TreeAnnotator<Regex>(){

            @Override
            public QualifiedTypeMirror<Regex> visitLiteral(LiteralTree tree, ExtendedTypeMirror type) {
                QualifiedTypeMirror<Regex> result = super.visitLiteral(tree, type);
                if (tree.getKind() == Tree.Kind.NULL_LITERAL) {
                    return SetQualifierVisitor.apply(result, Regex.BOTTOM);
                }
                String regexStr = null;
                if (tree.getKind() == Tree.Kind.STRING_LITERAL) {
                    regexStr = (String)tree.getValue();
                } else if (tree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    regexStr = Character.toString(((Character)tree.getValue()).charValue());
                }
                if (regexStr != null) {
                    Regex regexQual;
                    if (RegexQualifiedTypeFactory.isRegex(regexStr)) {
                        int groupCount = RegexQualifiedTypeFactory.getGroupCount(regexStr);
                        regexQual = new Regex.RegexVal(groupCount);
                    } else {
                        regexQual = new Regex.PartialRegex(regexStr);
                    }
                    result = SetQualifierVisitor.apply(result, regexQual);
                }
                return result;
            }

            @Override
            public QualifiedTypeMirror<Regex> visitCompoundAssignment(CompoundAssignmentTree tree, ExtendedTypeMirror type) {
                QualifiedTypeMirror<Regex> result = super.visitCompoundAssignment(tree, type);
                Regex lRegex = RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getQualifiedType(tree.getExpression()));
                Regex rRegex = RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getQualifiedType(tree.getVariable()));
                return this.handleBinaryOperation(tree, lRegex, rRegex, result);
            }

            @Override
            public QualifiedTypeMirror<Regex> visitMethodInvocation(MethodInvocationTree tree, ExtendedTypeMirror type) {
                QualifiedTypeMirror<Regex> result = super.visitMethodInvocation(tree, type);
                if (TreeUtils.isMethodInvocation(tree, RegexQualifiedTypeFactory.this.patternCompile, RegexQualifiedTypeFactory.this.getContext().getProcessingEnvironment())) {
                    ExpressionTree arg0 = tree.getArguments().get(0);
                    Regex qual = RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getQualifiedType(arg0));
                    result = SetQualifierVisitor.apply(result, qual);
                } else if (TreeUtils.isMethodInvocation(tree, RegexQualifiedTypeFactory.this.patternMatcher, RegexQualifiedTypeFactory.this.getContext().getProcessingEnvironment())) {
                    Regex qual = RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getReceiverType(tree));
                    result = SetQualifierVisitor.apply(result, qual);
                }
                return result;
            }

            @Override
            public QualifiedTypeMirror<Regex> visitBinary(BinaryTree tree, ExtendedTypeMirror type) {
                QualifiedTypeMirror<Regex> result = super.visitBinary(tree, type);
                Regex lRegex = RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getQualifiedType(tree.getLeftOperand()));
                Regex rRegex = RegexQualifiedTypeFactory.this.getEffectiveQualifier(RegexQualifiedTypeFactory.this.getQualifiedType(tree.getRightOperand()));
                return this.handleBinaryOperation(tree, lRegex, rRegex, result);
            }

            private QualifiedTypeMirror<Regex> handleBinaryOperation(Tree tree, Regex lRegex, Regex rRegex, QualifiedTypeMirror<Regex> result) {
                if (TreeUtils.isStringConcatenation(tree) || tree instanceof CompoundAssignmentTree && TreeUtils.isStringCompoundConcatenation((CompoundAssignmentTree)tree)) {
                    Regex regex = null;
                    if (lRegex.isRegexVal() && rRegex.isRegexVal()) {
                        int resultCount = ((Regex.RegexVal)lRegex).getCount() + ((Regex.RegexVal)rRegex).getCount();
                        regex = new Regex.RegexVal(resultCount);
                    } else if (lRegex.isPartialRegex() && rRegex.isPartialRegex()) {
                        String concat = ((Regex.PartialRegex)lRegex).getPartialValue() + ((Regex.PartialRegex)rRegex).getPartialValue();
                        if (RegexQualifiedTypeFactory.isRegex(concat)) {
                            int groupCount = RegexQualifiedTypeFactory.getGroupCount(concat);
                            regex = new Regex.RegexVal(groupCount);
                        } else {
                            regex = new Regex.PartialRegex(concat);
                        }
                    } else if (lRegex.isRegexVal() && rRegex.isPartialRegex()) {
                        String concat = "e" + ((Regex.PartialRegex)rRegex).getPartialValue();
                        regex = new Regex.PartialRegex(concat);
                    } else if (rRegex.isRegexVal() && lRegex.isPartialRegex()) {
                        String concat = ((Regex.PartialRegex)lRegex).getPartialValue() + "e";
                        regex = new Regex.PartialRegex(concat);
                    }
                    if (regex != null) {
                        result = SetQualifierVisitor.apply(result, regex);
                    }
                }
                return result;
            }
        };
    }

    public static int getGroupCount(@org.checkerframework.checker.regex.qual.Regex String regex) {
        return Pattern.compile(regex).matcher("").groupCount();
    }

    @Pure
    private static boolean isRegex(String s2) {
        try {
            Pattern.compile(s2);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    @Override
    public QualAnalysis<Regex> createFlowAnalysis(List<Pair<VariableElement, QualValue<Regex>>> fieldValues) {
        return new QualAnalysis<Regex>(this.getContext()){

            @Override
            public QualTransfer<Regex> createTransferFunction() {
                return new RegexQualifiedTransfer(this);
            }
        };
    }

    public Regex getEffectiveQualifier(QualifiedTypeMirror<Regex> mirror) {
        switch (mirror.getKind()) {
            case TYPEVAR: {
                return (Regex)this.getQualifiedTypeParameterBounds(((QualifiedTypeMirror.QualifiedTypeVariable)mirror).getDeclaration().getUnderlyingType()).getUpperBound().getQualifier();
            }
            case WILDCARD: {
                return (Regex)((QualifiedTypeMirror.QualifiedWildcardType)mirror).getExtendsBound().getQualifier();
            }
        }
        return mirror.getQualifier();
    }
}

