/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.SimpleTreeVisitor;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor7;
import javax.lang.model.util.SimpleTypeVisitor7;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.formatter.qual.ConversionCategory;
import org.checkerframework.checker.formatter.qual.Format;
import org.checkerframework.checker.formatter.qual.FormatMethod;
import org.checkerframework.checker.formatter.qual.InvalidFormat;
import org.checkerframework.checker.formatter.qual.ReturnsFormat;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class FormatterTreeUtil {
    public final BaseTypeChecker checker;
    public final ProcessingEnvironment processingEnv;
    private final ExecutableElement formatArgTypesElement;

    public FormatterTreeUtil(BaseTypeChecker checker) {
        this.checker = checker;
        this.processingEnv = checker.getProcessingEnvironment();
        this.formatArgTypesElement = TreeUtils.getMethod(Format.class.getCanonicalName(), "value", 0, this.processingEnv);
    }

    public boolean isAsFormatCall(MethodInvocationNode node, AnnotatedTypeFactory atypeFactory) {
        ExecutableElement method = node.getTarget().getMethod();
        AnnotationMirror anno = atypeFactory.getDeclAnnotation(method, ReturnsFormat.class);
        return anno != null;
    }

    private ConversionCategory[] asFormatCallCategoriesLowLevel(MethodInvocationNode node) {
        Node vararg = node.getArgument(1);
        if (vararg instanceof ArrayCreationNode) {
            List<Node> convs = ((ArrayCreationNode)vararg).getInitializers();
            ConversionCategory[] res = new ConversionCategory[convs.size()];
            for (int i = 0; i < convs.size(); ++i) {
                Class<? extends Object> clazz;
                Node conv = convs.get(i);
                if (!(conv instanceof FieldAccessNode) || (clazz = this.typeMirrorToClass(((FieldAccessNode)conv).getType())) != ConversionCategory.class) {
                    return null;
                }
                res[i] = ConversionCategory.valueOf(((FieldAccessNode)conv).getFieldName());
            }
            return res;
        }
        return null;
    }

    public Result<ConversionCategory[]> asFormatCallCategories(MethodInvocationNode node) {
        return new ResultImpl<ConversionCategory[]>(this.asFormatCallCategoriesLowLevel(node), node.getTree());
    }

    public boolean isFormatCall(MethodInvocationTree node, AnnotatedTypeFactory atypeFactory) {
        ExecutableElement method = TreeUtils.elementFromUse(node);
        AnnotationMirror anno = atypeFactory.getDeclAnnotation(method, FormatMethod.class);
        return anno != null;
    }

    public final <E> void failure(Result<E> res, @CompilerMessageKey String msg, Object ... args) {
        ResultImpl impl = (ResultImpl)res;
        this.checker.report(org.checkerframework.framework.source.Result.failure(msg, args), impl.location);
    }

    public final <E> void warning(Result<E> res, @CompilerMessageKey String msg, Object ... args) {
        ResultImpl impl = (ResultImpl)res;
        this.checker.report(org.checkerframework.framework.source.Result.warning(msg, args), impl.location);
    }

    public AnnotationMirror exceptionToInvalidFormatAnnotation(IllegalFormatException ex) {
        return this.stringToInvalidFormatAnnotation(ex.getMessage());
    }

    AnnotationMirror stringToInvalidFormatAnnotation(String invalidFormatString) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, InvalidFormat.class.getCanonicalName());
        builder.setValue((CharSequence)"value", invalidFormatString);
        return builder.build();
    }

    public String invalidFormatAnnotationToErrorMessage(AnnotationMirror anno) {
        return "\"" + AnnotationUtils.getElementValue(anno, "value", String.class, true) + "\"";
    }

    public AnnotationMirror categoriesToFormatAnnotation(ConversionCategory[] args) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, Format.class.getCanonicalName());
        builder.setValue((CharSequence)"value", args);
        return builder.build();
    }

    public ConversionCategory[] formatAnnotationToCategories(AnnotationMirror anno) {
        List<ConversionCategory> list = AnnotationUtils.getElementValueEnumArray(anno, "value", ConversionCategory.class, false);
        return list.toArray(new ConversionCategory[0]);
    }

    private final Class<? extends Object> typeMirrorToClass(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor7<Class<? extends Object>, Class<Void>>(){

            @Override
            public Class<? extends Object> visitPrimitive(PrimitiveType t, Class<Void> v) {
                switch (t.getKind()) {
                    case BOOLEAN: {
                        return Boolean.class;
                    }
                    case BYTE: {
                        return Byte.class;
                    }
                    case CHAR: {
                        return Character.class;
                    }
                    case SHORT: {
                        return Short.class;
                    }
                    case INT: {
                        return Integer.class;
                    }
                    case LONG: {
                        return Long.class;
                    }
                    case FLOAT: {
                        return Float.class;
                    }
                    case DOUBLE: {
                        return Double.class;
                    }
                }
                return null;
            }

            @Override
            public Class<? extends Object> visitDeclared(DeclaredType dt, Class<Void> v) {
                return dt.asElement().accept(new SimpleElementVisitor7<Class<? extends Object>, Class<Void>>(){

                    @Override
                    public Class<? extends Object> visitType(TypeElement e, Class<Void> v) {
                        try {
                            return Class.forName(e.getQualifiedName().toString());
                        }
                        catch (ClassNotFoundException e1) {
                            return null;
                        }
                    }
                }, Void.TYPE);
            }
        }, Void.TYPE);
    }

    public class FormatCall {
        private final AnnotatedTypeMirror formatAnno;
        private final List<? extends ExpressionTree> args;
        private final MethodInvocationTree node;
        private final ExpressionTree formatArg;
        private final AnnotatedTypeFactory atypeFactory;

        public FormatCall(MethodInvocationTree node, AnnotatedTypeFactory atypeFactory) {
            this.node = node;
            this.atypeFactory = atypeFactory;
            List<? extends ExpressionTree> theargs = node.getArguments();
            if (FormatterTreeUtil.this.typeMirrorToClass(atypeFactory.getAnnotatedType(theargs.get(0)).getUnderlyingType()) == Locale.class) {
                theargs = theargs.subList(1, theargs.size());
            }
            this.formatArg = theargs.get(0);
            this.formatAnno = atypeFactory.getAnnotatedType(this.formatArg);
            this.args = theargs.subList(1, theargs.size());
        }

        public final Result<String> isIllegalFormat() {
            String res = null;
            if (!this.formatAnno.hasAnnotation(Format.class)) {
                res = "(is a @Format annotation missing?)";
                AnnotationMirror inv = this.formatAnno.getAnnotation(InvalidFormat.class);
                if (inv != null) {
                    res = FormatterTreeUtil.this.invalidFormatAnnotationToErrorMessage(inv);
                }
            }
            return new ResultImpl<String>(res, this.formatArg);
        }

        public final Result<InvocationType> getInvocationType() {
            InvocationType type = InvocationType.VARARG;
            if (this.args.size() == 1) {
                final ExpressionTree first = this.args.get(0);
                TypeMirror argType = this.atypeFactory.getAnnotatedType(first).getUnderlyingType();
                type = argType.accept(new SimpleTypeVisitor7<InvocationType, Class<Void>>(){

                    @Override
                    protected InvocationType defaultAction(TypeMirror e, Class<Void> p) {
                        return InvocationType.VARARG;
                    }

                    @Override
                    public InvocationType visitArray(ArrayType t, Class<Void> p) {
                        return first.accept(new SimpleTreeVisitor<InvocationType, Class<Void>>(){

                            @Override
                            protected InvocationType defaultAction(Tree node, Class<Void> p) {
                                return InvocationType.ARRAY;
                            }

                            @Override
                            public InvocationType visitTypeCast(TypeCastTree node, Class<Void> p) {
                                return FormatCall.this.atypeFactory.getAnnotatedType(node.getExpression()).getUnderlyingType().getKind() == TypeKind.NULL ? InvocationType.NULLARRAY : InvocationType.ARRAY;
                            }
                        }, p);
                    }

                    @Override
                    public InvocationType visitNull(NullType t, Class<Void> p) {
                        return InvocationType.NULLARRAY;
                    }
                }, Void.TYPE);
            }
            ExpressionTree loc = this.node.getMethodSelect();
            if (type != InvocationType.VARARG && this.args.size() > 0) {
                loc = this.args.get(0);
            }
            return new ResultImpl<InvocationType>(type, loc);
        }

        public final ConversionCategory[] getFormatCategories() {
            AnnotationMirror anno = this.formatAnno.getAnnotation(Format.class);
            return FormatterTreeUtil.this.formatAnnotationToCategories(anno);
        }

        public final Result<TypeMirror>[] getParamTypes() {
            Result[] res = new Result[this.args.size()];
            for (int i = 0; i < res.length; ++i) {
                ExpressionTree arg = this.args.get(i);
                TypeMirror argType = this.atypeFactory.getAnnotatedType(arg).getUnderlyingType();
                res[i] = new ResultImpl<TypeMirror>(argType, arg);
            }
            return res;
        }

        public final boolean isValidParameter(ConversionCategory formatCat, TypeMirror paramType) {
            Class type = FormatterTreeUtil.this.typeMirrorToClass(paramType);
            if (type == null) {
                return false;
            }
            for (Class<? extends Object> c : formatCat.types) {
                if (!c.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }

        public final boolean isParameterNull(TypeMirror type) {
            return type.accept(new SimpleTypeVisitor7<Boolean, Class<Void>>(){

                @Override
                protected Boolean defaultAction(TypeMirror e, Class<Void> p) {
                    return false;
                }

                @Override
                public Boolean visitNull(NullType t, Class<Void> p) {
                    return true;
                }
            }, Void.TYPE);
        }
    }

    private static class ResultImpl<E>
    implements Result<E> {
        private final E value;
        public final ExpressionTree location;

        public ResultImpl(E value, ExpressionTree location) {
            this.value = value;
            this.location = location;
        }

        @Override
        public E value() {
            return this.value;
        }
    }

    public static interface Result<E> {
        public E value();
    }

    public static enum InvocationType {
        VARARG,
        ARRAY,
        NULLARRAY;

    }
}

