/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.nullness.NullnessAnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.TreeUtils;

public class CollectionToArrayHeuristics {
    private final ProcessingEnvironment processingEnv;
    private final NullnessAnnotatedTypeFactory atypeFactory;
    private final ExecutableElement collectionToArrayObject;
    private final ExecutableElement collectionToArrayE;
    private final ExecutableElement size;
    private final AnnotatedTypeMirror.AnnotatedDeclaredType collectionType;

    public CollectionToArrayHeuristics(ProcessingEnvironment env, NullnessAnnotatedTypeFactory factory) {
        this.processingEnv = env;
        this.atypeFactory = factory;
        this.collectionToArrayObject = TreeUtils.getMethod("java.util.Collection", "toArray", 0, env);
        this.collectionToArrayE = TreeUtils.getMethod("java.util.Collection", "toArray", 1, env);
        this.size = TreeUtils.getMethod("java.util.Collection", "size", 0, env);
        this.collectionType = factory.fromElement(env.getElementUtils().getTypeElement("java.util.Collection"));
    }

    public void handle(MethodInvocationTree tree, AnnotatedTypeMirror.AnnotatedExecutableType method) {
        if (TreeUtils.isMethodInvocation(tree, this.collectionToArrayObject, this.processingEnv)) {
            boolean receiver = this.isNonNullReceiver(tree);
            this.setComponentNullness(receiver, method.getReturnType());
        } else if (TreeUtils.isMethodInvocation(tree, this.collectionToArrayE, this.processingEnv)) {
            assert (!tree.getArguments().isEmpty()) : tree;
            Tree argument = tree.getArguments().get(0);
            boolean isArrayCreation = this.isHandledArrayCreation(argument, this.receiver(tree.getMethodSelect()));
            boolean receiver = this.isNonNullReceiver(tree);
            this.setComponentNullness(receiver && isArrayCreation, method.getReturnType());
            if (!receiver) {
                this.setComponentNullness(false, method.getParameterTypes().get(0));
            }
        }
    }

    private void setComponentNullness(boolean isNonNull, AnnotatedTypeMirror type) {
        assert (type.getKind() == TypeKind.ARRAY);
        AnnotatedTypeMirror compType = ((AnnotatedTypeMirror.AnnotatedArrayType)type).getComponentType();
        compType.replaceAnnotation(isNonNull ? this.atypeFactory.NONNULL : this.atypeFactory.NULLABLE);
    }

    private boolean isHandledArrayCreation(Tree argument, String receiver) {
        if (argument.getKind() != Tree.Kind.NEW_ARRAY) {
            return false;
        }
        NewArrayTree newArr = (NewArrayTree)argument;
        if (newArr.getInitializers() != null) {
            return newArr.getInitializers().isEmpty();
        }
        assert (!newArr.getDimensions().isEmpty());
        Tree dimension = newArr.getDimensions().get(newArr.getDimensions().size() - 1);
        if (dimension.toString().equals("0")) {
            return true;
        }
        if (TreeUtils.isMethodInvocation(dimension, this.size, this.processingEnv)) {
            MethodInvocationTree invok = (MethodInvocationTree)dimension;
            String invokReceiver = this.receiver(invok.getMethodSelect());
            return invokReceiver.equals(receiver);
        }
        return false;
    }

    private boolean isNonNullReceiver(MethodInvocationTree tree) {
        AnnotatedTypeMirror receiver = this.atypeFactory.getReceiverType(tree);
        AnnotatedTypeMirror.AnnotatedDeclaredType collection = AnnotatedTypes.asSuper(this.atypeFactory, receiver, this.collectionType);
        return !collection.getTypeArguments().isEmpty() && collection.getTypeArguments().get(0).hasEffectiveAnnotation(this.atypeFactory.NONNULL);
    }

    private String receiver(Tree tree) {
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)tree).getExpression().toString();
        }
        return "this";
    }
}

