/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.units;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.units.UnitsAnnotatedTypeFormatter;
import org.checkerframework.checker.units.UnitsAnnotationClassLoader;
import org.checkerframework.checker.units.UnitsRelations;
import org.checkerframework.checker.units.UnitsRelationsDefault;
import org.checkerframework.checker.units.UnitsRelationsTools;
import org.checkerframework.checker.units.qual.MixedUnits;
import org.checkerframework.checker.units.qual.Prefix;
import org.checkerframework.checker.units.qual.UnitsBottom;
import org.checkerframework.checker.units.qual.UnitsMultiple;
import org.checkerframework.checker.units.qual.UnknownUnits;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeFormatter;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;

public class UnitsAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private static final Class<org.checkerframework.checker.units.qual.UnitsRelations> unitsRelationsAnnoClass = org.checkerframework.checker.units.qual.UnitsRelations.class;
    protected final AnnotationMirror mixedUnits;
    protected final AnnotationMirror TOP;
    protected final AnnotationMirror BOTTOM;
    private Map<String, UnitsRelations> unitsRel;
    private static final Map<String, Class<? extends Annotation>> externalQualsMap = new HashMap<String, Class<? extends Annotation>>();
    private static final Map<String, AnnotationMirror> aliasMap = new HashMap<String, AnnotationMirror>();

    public UnitsAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker, false);
        this.mixedUnits = AnnotationUtils.fromClass(this.elements, MixedUnits.class);
        this.TOP = AnnotationUtils.fromClass(this.elements, UnknownUnits.class);
        this.BOTTOM = AnnotationUtils.fromClass(this.elements, UnitsBottom.class);
        this.postInit();
    }

    @Override
    protected AnnotatedTypeFormatter createAnnotatedTypeFormatter() {
        return new UnitsAnnotatedTypeFormatter(this.checker);
    }

    @Override
    public AnnotationMirror aliasedAnnotation(AnnotationMirror anno) {
        String aname = anno.getAnnotationType().toString();
        if (aliasMap.containsKey(aname)) {
            return aliasMap.get(aname);
        }
        boolean built = false;
        AnnotationMirror result = null;
        for (AnnotationMirror annotationMirror : anno.getAnnotationType().asElement().getAnnotationMirrors()) {
            if (!this.isUnitsMultiple(annotationMirror)) continue;
            Class<Annotation> baseUnitAnnoClass = AnnotationUtils.getElementValueClass(annotationMirror, "quantity", true).asSubclass(Annotation.class);
            Prefix prefix = AnnotationUtils.getElementValueEnum(annotationMirror, "prefix", Prefix.class, true);
            result = UnitsRelationsTools.buildAnnoMirrorWithSpecificPrefix(this.processingEnv, baseUnitAnnoClass, prefix);
            built = true;
            break;
        }
        if (built) {
            if (UnitsRelationsTools.getPrefix(result) == Prefix.one) {
                result = this.removePrefix(result);
            }
            aliasMap.put(aname, result);
            return result;
        }
        return super.aliasedAnnotation(anno);
    }

    protected Map<String, UnitsRelations> getUnitsRel() {
        if (this.unitsRel == null) {
            this.unitsRel = new HashMap<String, UnitsRelations>();
            this.unitsRel.put(UnitsRelationsDefault.class.getCanonicalName(), new UnitsRelationsDefault().init(this.processingEnv));
        }
        return this.unitsRel;
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        this.loader = new UnitsAnnotationClassLoader(this.checker);
        HashSet<Class<? extends Annotation>> qualSet = new HashSet<Class<? extends Annotation>>();
        qualSet.addAll(this.getBundledTypeQualifiersWithPolyAll(new Class[0]));
        this.loadAllExternalUnits();
        qualSet.addAll(externalQualsMap.values());
        return Collections.unmodifiableSet(qualSet);
    }

    private void loadAllExternalUnits() {
        String qualDirectories;
        String qualNames = this.checker.getOption("units");
        if (qualNames != null) {
            for (String qualName : qualNames.split(",")) {
                this.loadExternalUnit(qualName);
            }
        }
        if ((qualDirectories = this.checker.getOption("unitsDirs")) != null) {
            for (String directoryName : qualDirectories.split(":")) {
                this.loadExternalDirectory(directoryName);
            }
        }
    }

    private void loadExternalUnit(String annoName) {
        Class<? extends Annotation> annoClass = this.loader.loadExternalAnnotationClass(annoName);
        this.addUnitToExternalQualMap(annoClass);
    }

    private void loadExternalDirectory(String directoryName) {
        Set<Class<? extends Annotation>> annoClassSet = this.loader.loadExternalAnnotationClassesFromDirectory(directoryName);
        for (Class<? extends Annotation> annoClass : annoClassSet) {
            this.addUnitToExternalQualMap(annoClass);
        }
    }

    private void addUnitToExternalQualMap(Class<? extends Annotation> annoClass) {
        AnnotationMirror mirror = UnitsRelationsTools.buildAnnoMirrorWithNoPrefix(this.processingEnv, annoClass);
        if (!this.isAliasedAnnotation(mirror)) {
            String unitClassName = annoClass.getCanonicalName();
            if (!externalQualsMap.containsKey(unitClassName)) {
                externalQualsMap.put(unitClassName, annoClass);
            }
        } else {
            Class<? extends Annotation> baseUnitClass = this.getBaseUnitAnnoClass(mirror);
            if (baseUnitClass != null) {
                String baseUnitClassName = baseUnitClass.getCanonicalName();
                if (!externalQualsMap.containsKey(baseUnitClassName)) {
                    this.loadExternalUnit(baseUnitClassName);
                }
                this.aliasedAnnotation(mirror);
            }
        }
        this.addUnitsRelations(annoClass);
    }

    private boolean isAliasedAnnotation(AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : anno.getAnnotationType().asElement().getAnnotationMirrors()) {
            if (!this.isUnitsMultiple(annotationMirror)) continue;
            return true;
        }
        return false;
    }

    private @Nullable Class<? extends Annotation> getBaseUnitAnnoClass(AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : anno.getAnnotationType().asElement().getAnnotationMirrors()) {
            if (!this.isUnitsMultiple(annotationMirror)) continue;
            Class<Annotation> baseUnitAnnoClass = AnnotationUtils.getElementValueClass(annotationMirror, "quantity", true).asSubclass(Annotation.class);
            return baseUnitAnnoClass;
        }
        return null;
    }

    private boolean isUnitsMultiple(AnnotationMirror metaAnno) {
        return AnnotationUtils.areSameByClass(metaAnno, UnitsMultiple.class);
    }

    private void addUnitsRelations(Class<? extends Annotation> qual) {
        AnnotationMirror am = AnnotationUtils.fromClass(this.elements, qual);
        for (AnnotationMirror annotationMirror : am.getAnnotationType().asElement().getAnnotationMirrors()) {
            if (!AnnotationUtils.areSameByClass(annotationMirror, unitsRelationsAnnoClass)) continue;
            Class<UnitsRelations> theclass = AnnotationUtils.getElementValueClass(annotationMirror, "value", true).asSubclass(UnitsRelations.class);
            String classname = theclass.getCanonicalName();
            if (this.getUnitsRel().containsKey(classname)) continue;
            try {
                this.unitsRel.put(classname, theclass.newInstance().init(this.processingEnv));
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        ImplicitsTreeAnnotator implicitsTreeAnnotator = new ImplicitsTreeAnnotator(this);
        implicitsTreeAnnotator.addTreeKind(Tree.Kind.NULL_LITERAL, this.BOTTOM);
        return new ListTreeAnnotator(new UnitsPropagationTreeAnnotator(this), implicitsTreeAnnotator, new UnitsTreeAnnotator(this));
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new UnitsQualifierHierarchy(factory, AnnotationUtils.fromClass(this.elements, UnitsBottom.class));
    }

    private AnnotationMirror removePrefix(AnnotationMirror anno) {
        return UnitsRelationsTools.removePrefix(this.elements, anno);
    }

    protected class UnitsQualifierHierarchy
    extends GraphQualifierHierarchy {
        public UnitsQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory mgf, AnnotationMirror bottom) {
            super(mgf, bottom);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(lhs, rhs)) {
                return AnnotationUtils.areSame(lhs, rhs);
            }
            lhs = UnitsAnnotatedTypeFactory.this.removePrefix(lhs);
            rhs = UnitsAnnotatedTypeFactory.this.removePrefix(rhs);
            return super.isSubtype(rhs, lhs);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            AnnotationMirror result;
            if (UnitsRelationsTools.getPrefix(a1) == Prefix.one) {
                a1 = UnitsAnnotatedTypeFactory.this.removePrefix(a1);
            }
            if (UnitsRelationsTools.getPrefix(a2) == Prefix.one) {
                a2 = UnitsAnnotatedTypeFactory.this.removePrefix(a2);
            }
            if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
                if (AnnotationUtils.areSame(a1, a2)) {
                    result = a1;
                } else {
                    boolean a2Prefixed;
                    boolean a1Prefixed = !UnitsRelationsTools.hasNoPrefix(a1);
                    boolean bl = a2Prefixed = !UnitsRelationsTools.hasNoPrefix(a2);
                    result = a1Prefixed && a2Prefixed ? this.findLub(UnitsAnnotatedTypeFactory.this.removePrefix(a1), a2) : (a1Prefixed && !a2Prefixed ? this.findLub(a2, a1) : this.findLub(a1, a2));
                }
            } else {
                result = super.leastUpperBound(a1, a2);
            }
            return result;
        }
    }

    private class UnitsTreeAnnotator
    extends TreeAnnotator {
        UnitsTreeAnnotator(UnitsAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror lht = UnitsAnnotatedTypeFactory.this.getAnnotatedType(node.getLeftOperand());
            AnnotatedTypeMirror rht = UnitsAnnotatedTypeFactory.this.getAnnotatedType(node.getRightOperand());
            Tree.Kind kind = node.getKind();
            if (UnitsRelationsTools.getPrefix(lht) == Prefix.one) {
                lht = UnitsRelationsTools.removePrefix(UnitsAnnotatedTypeFactory.this.elements, lht);
            }
            if (UnitsRelationsTools.getPrefix(rht) == Prefix.one) {
                rht = UnitsRelationsTools.removePrefix(UnitsAnnotatedTypeFactory.this.elements, rht);
            }
            AnnotationMirror bestres = null;
            for (UnitsRelations ur : UnitsAnnotatedTypeFactory.this.getUnitsRel().values()) {
                AnnotationMirror res = this.useUnitsRelation(kind, ur, lht, rht);
                if (bestres != null && res != null && !bestres.equals(res)) {
                    UnitsAnnotatedTypeFactory.this.checker.message(Diagnostic.Kind.WARNING, "UnitsRelation mismatch, taking neither! Previous: " + bestres + " and current: " + res, new Object[0]);
                    return null;
                }
                if (res == null) continue;
                bestres = res;
            }
            if (bestres != null) {
                type.replaceAnnotation(bestres);
            } else {
                switch (kind) {
                    case MINUS: 
                    case PLUS: {
                        if (lht.getAnnotations().equals(rht.getAnnotations())) {
                            type.replaceAnnotations(lht.getAnnotations());
                            break;
                        }
                        type.replaceAnnotation(UnitsAnnotatedTypeFactory.this.mixedUnits);
                        break;
                    }
                    case DIVIDE: {
                        if (lht.getAnnotations().equals(rht.getAnnotations())) {
                            type.replaceAnnotation(UnitsAnnotatedTypeFactory.this.TOP);
                            break;
                        }
                        if (UnitsRelationsTools.hasNoUnits(rht)) {
                            type.replaceAnnotations(lht.getAnnotations());
                            break;
                        }
                        if (UnitsRelationsTools.hasNoUnits(lht)) {
                            type.replaceAnnotation(UnitsAnnotatedTypeFactory.this.mixedUnits);
                            break;
                        }
                        type.replaceAnnotation(UnitsAnnotatedTypeFactory.this.mixedUnits);
                        break;
                    }
                    case MULTIPLY: {
                        if (UnitsRelationsTools.hasNoUnits(lht)) {
                            type.replaceAnnotations(rht.getAnnotations());
                            break;
                        }
                        if (UnitsRelationsTools.hasNoUnits(rht)) {
                            type.replaceAnnotations(lht.getAnnotations());
                            break;
                        }
                        type.replaceAnnotation(UnitsAnnotatedTypeFactory.this.mixedUnits);
                        break;
                    }
                    case REMAINDER: {
                        type.replaceAnnotations(lht.getAnnotations());
                        break;
                    }
                }
            }
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            ExpressionTree var = node.getVariable();
            AnnotatedTypeMirror varType = UnitsAnnotatedTypeFactory.this.getAnnotatedType(var);
            type.replaceAnnotations(varType.getAnnotations());
            return null;
        }

        private AnnotationMirror useUnitsRelation(Tree.Kind kind, UnitsRelations ur, AnnotatedTypeMirror lht, AnnotatedTypeMirror rht) {
            AnnotationMirror res = null;
            if (ur != null) {
                switch (kind) {
                    case DIVIDE: {
                        res = ur.division(lht, rht);
                        break;
                    }
                    case MULTIPLY: {
                        res = ur.multiplication(lht, rht);
                        break;
                    }
                }
            }
            return res;
        }
    }

    private static class UnitsPropagationTreeAnnotator
    extends PropagationTreeAnnotator {
        public UnitsPropagationTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            return null;
        }
    }
}

