/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.util.report;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeValidator;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.common.util.report.qual.ReportCall;
import org.checkerframework.common.util.report.qual.ReportCreation;
import org.checkerframework.common.util.report.qual.ReportInherit;
import org.checkerframework.common.util.report.qual.ReportOverride;
import org.checkerframework.common.util.report.qual.ReportReadWrite;
import org.checkerframework.common.util.report.qual.ReportUse;
import org.checkerframework.common.util.report.qual.ReportWrite;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;

public class ReportVisitor
extends BaseTypeVisitor<BaseAnnotatedTypeFactory> {
    private final String[] treeKinds;
    private final String[] modifiers;

    public ReportVisitor(BaseTypeChecker checker) {
        super(checker);
        if (checker.hasOption("reportTreeKinds")) {
            String trees = checker.getOption("reportTreeKinds");
            this.treeKinds = trees.split(",");
        } else {
            this.treeKinds = null;
        }
        if (checker.hasOption("reportModifiers")) {
            String mods = checker.getOption("reportModifiers");
            this.modifiers = mods.split(",");
        } else {
            this.modifiers = null;
        }
    }

    @Override
    public Void scan(Tree tree, Void p) {
        if (tree != null && this.treeKinds != null) {
            for (String tk : this.treeKinds) {
                if (!tree.getKind().toString().equals(tk)) continue;
                this.checker.report(Result.failure("Tree.Kind." + tk, new Object[0]), tree);
            }
        }
        return super.scan(tree, p);
    }

    private void checkReportUse(Tree node, Element member) {
        Element loop = member;
        while (loop != null) {
            boolean report;
            boolean bl = report = ((BaseAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(loop, ReportUse.class) != null;
            if (report) {
                this.checker.report(Result.failure("usage", new Object[]{node, ElementUtils.getVerboseName(loop), loop.getKind(), ElementUtils.getVerboseName(member), member.getKind()}), node);
                break;
            }
            if (loop.getKind() == ElementKind.PACKAGE) {
                loop = ElementUtils.parentPackage(this.elements, (PackageElement)loop);
                continue;
            }
            loop = loop.getEnclosingElement();
        }
    }

    @Override
    public Void visitClass(ClassTree node, Void p) {
        TypeElement member = TreeUtils.elementFromDeclaration(node);
        boolean report = false;
        List<TypeElement> suptypes = ElementUtils.getSuperTypes(this.elements, member);
        for (TypeElement sup : suptypes) {
            report = ((BaseAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(sup, ReportInherit.class) != null;
            if (!report) continue;
            this.checker.report(Result.failure("inherit", node, ElementUtils.getVerboseName(sup)), node);
        }
        return super.visitClass(node, p);
    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
        ExecutableElement method = TreeUtils.elementFromDeclaration(node);
        boolean report = false;
        Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods = AnnotatedTypes.overriddenMethods(this.elements, this.atypeFactory, method);
        for (Map.Entry<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> pair : overriddenMethods.entrySet()) {
            ExecutableElement exe = pair.getValue();
            report = ((BaseAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(exe, ReportOverride.class) != null;
            if (!report) continue;
            method = exe;
            break;
        }
        if (report) {
            this.checker.report(Result.failure("override", node, ElementUtils.getVerboseName(method)), node);
        }
        return super.visitMethod(node, p);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        boolean report;
        ExecutableElement method = TreeUtils.elementFromUse(node);
        this.checkReportUse(node, method);
        boolean bl = report = ((BaseAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(method, ReportCall.class) != null;
        if (!report) {
            Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods = AnnotatedTypes.overriddenMethods(this.elements, this.atypeFactory, method);
            for (Map.Entry<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> pair : overriddenMethods.entrySet()) {
                ExecutableElement exe = pair.getValue();
                report = ((BaseAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(exe, ReportCall.class) != null;
                if (!report) continue;
                method = exe;
                break;
            }
        }
        if (report) {
            this.checker.report(Result.failure("methodcall", node, ElementUtils.getVerboseName(method)), node);
        }
        return super.visitMethodInvocation(node, p);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        boolean report;
        Element member = TreeUtils.elementFromUse(node);
        this.checkReportUse(node, member);
        boolean bl = report = ((BaseAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(member, ReportReadWrite.class) != null;
        if (report) {
            this.checker.report(Result.failure("fieldreadwrite", node, ElementUtils.getVerboseName(member)), node);
        }
        return (Void)super.visitMemberSelect(node, p);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        boolean report;
        Element member = TreeUtils.elementFromUse(node);
        boolean bl = report = ((BaseAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(member, ReportReadWrite.class) != null;
        if (report) {
            this.checker.report(Result.failure("fieldreadwrite", node, ElementUtils.getVerboseName(member)), node);
        }
        return super.visitIdentifier(node, p);
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void p) {
        boolean report;
        Element member = TreeUtils.elementFromUse(node.getVariable());
        boolean bl = report = ((BaseAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(member, ReportWrite.class) != null;
        if (report) {
            this.checker.report(Result.failure("fieldwrite", node, ElementUtils.getVerboseName(member)), node);
        }
        return super.visitAssignment(node, p);
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree node, Void p) {
        return super.visitArrayAccess(node, p);
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void p) {
        boolean report;
        Element member = TreeUtils.elementFromUse(node);
        boolean bl = report = ((BaseAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(member, ReportCreation.class) != null;
        if (!report) {
            boolean bl2 = report = ((BaseAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(member = member.getEnclosingElement(), ReportCreation.class) != null;
        }
        if (!report) {
            List<TypeElement> suptypes = ElementUtils.getSuperTypes(this.elements, (TypeElement)member);
            for (TypeElement sup : suptypes) {
                report = ((BaseAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(sup, ReportCreation.class) != null;
                if (!report) continue;
                member = sup;
                break;
            }
        }
        if (report) {
            this.checker.report(Result.failure("creation", node, ElementUtils.getVerboseName(member)), node);
        }
        return super.visitNewClass(node, p);
    }

    @Override
    public Void visitNewArray(NewArrayTree node, Void p) {
        return super.visitNewArray(node, p);
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Void p) {
        return super.visitTypeCast(node, p);
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree node, Void p) {
        return super.visitInstanceOf(node, p);
    }

    @Override
    public Void visitModifiers(ModifiersTree node, Void p) {
        if (node != null && this.modifiers != null) {
            for (Modifier hasmod : node.getFlags()) {
                for (String searchmod : this.modifiers) {
                    if (!hasmod.toString().equals(searchmod)) continue;
                    this.checker.report(Result.failure("Modifier." + (Object)((Object)hasmod), new Object[0]), node);
                }
            }
        }
        return (Void)super.visitModifiers(node, p);
    }

    @Override
    protected BaseTypeValidator createTypeValidator() {
        return new ReportTypeValidator(this.checker, this, this.atypeFactory);
    }

    protected class ReportTypeValidator
    extends BaseTypeValidator {
        public ReportTypeValidator(BaseTypeChecker checker, BaseTypeVisitor<?> visitor, AnnotatedTypeFactory atypeFactory) {
            super(checker, visitor, atypeFactory);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Tree tree) {
            Element member = type.getUnderlyingType().asElement();
            ReportVisitor.this.checkReportUse(tree, member);
            return super.visitDeclared(type, tree);
        }
    }
}

