/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test.diagnostics;

import java.util.List;
import org.checkerframework.framework.test.diagnostics.TestDiagnostic;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticUtils;
import org.checkerframework.framework.util.PluginUtil;

public class TestDiagnosticLine {
    private final long lineNumber;
    private final String originalLine;
    private final List<TestDiagnostic> diagnostics;

    public TestDiagnosticLine(long lineNumber, String originalLine, List<TestDiagnostic> diagnostics) {
        this.lineNumber = lineNumber;
        this.originalLine = originalLine;
        this.diagnostics = diagnostics;
    }

    public boolean hasDiagnostics() {
        return !this.diagnostics.isEmpty();
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public String getOriginalLine() {
        return this.originalLine;
    }

    public String asSourceString() {
        return "//:: " + PluginUtil.join(" :: ", TestDiagnosticUtils.diagnosticsToString(this.diagnostics));
    }

    public List<TestDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }
}

