/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.qualframework.base.CheckerAdapter;
import org.checkerframework.qualframework.base.DefaultQualifiedTypeFactory;
import org.checkerframework.qualframework.base.QualifiedTypeFactoryAdapter;
import org.checkerframework.qualframework.base.QualifiedTypeMirror;
import org.checkerframework.qualframework.base.QualifiedTypeParameterBounds;
import org.checkerframework.qualframework.base.SimpleQualifiedTypeVisitor;
import org.checkerframework.qualframework.qual.QualifierKey;
import org.checkerframework.qualframework.util.WrappedAnnotatedTypeMirror;

public class TypeMirrorConverter<Q> {
    private final CheckerAdapter<Q> checkerAdapter;
    private final ProcessingEnvironment processingEnv;
    private final AnnotationMirror blankKey;
    private QualifiedTypeFactoryAdapter<Q> typeFactory;
    private int nextIndex = 0;
    private final HashMap<Q, Integer> qualToIndex;
    private final HashMap<Integer, Q> indexToQual;
    public LinkedHashMap<Integer, AnnotationMirror> keyToAnnoCache = new LinkedHashMap<Integer, AnnotationMirror>(10, 0.75f, true){
        private static final long serialVersionUID = 1L;
        private static final int MAX_SIZE = 1000;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, AnnotationMirror> eldest) {
            return this.size() > 1000;
        }
    };
    private final SimpleQualifiedTypeVisitor<Q, Void, AnnotatedTypeMirror> APPLY_COMPONENT_QUALIFIERS_VISITOR = new SimpleQualifiedTypeVisitor<Q, Void, AnnotatedTypeMirror>(){
        private final IdentityHashMap<AnnotatedTypeMirror, Void> seenATVs = new IdentityHashMap();

        @Override
        public Void visitArray(QualifiedTypeMirror.QualifiedArrayType<Q> qtm, AnnotatedTypeMirror rawAtm) {
            AnnotatedTypeMirror.AnnotatedArrayType atm = (AnnotatedTypeMirror.AnnotatedArrayType)rawAtm;
            TypeMirrorConverter.this.applyQualifiers(qtm.getComponentType(), atm.getComponentType());
            return null;
        }

        @Override
        public Void visitDeclared(QualifiedTypeMirror.QualifiedDeclaredType<Q> qtm, AnnotatedTypeMirror rawAtm) {
            AnnotatedTypeMirror.AnnotatedDeclaredType atm = (AnnotatedTypeMirror.AnnotatedDeclaredType)rawAtm;
            TypeMirrorConverter.this.applyQualifiersToLists(qtm.getTypeArguments(), atm.getTypeArguments());
            return null;
        }

        @Override
        public Void visitExecutable(QualifiedTypeMirror.QualifiedExecutableType<Q> qtm, AnnotatedTypeMirror rawAtm) {
            AnnotatedTypeMirror.AnnotatedExecutableType atm = (AnnotatedTypeMirror.AnnotatedExecutableType)rawAtm;
            ExecutableElement elt = qtm.getUnderlyingType().asElement();
            if (atm.getElement() != elt) {
                assert (elt != null);
                atm.setElement(elt);
            }
            TypeMirrorConverter.this.applyQualifiersToLists(qtm.getParameterTypes(), atm.getParameterTypes());
            TypeMirrorConverter.this.applyQualifiers(qtm.getReceiverType(), atm.getReceiverType());
            TypeMirrorConverter.this.applyQualifiers(qtm.getReturnType(), atm.getReturnType());
            TypeMirrorConverter.this.applyQualifiersToLists(qtm.getThrownTypes(), atm.getThrownTypes());
            TypeMirrorConverter.this.applyQualifiersToLists(qtm.getTypeParameters(), atm.getTypeVariables());
            return null;
        }

        @Override
        public Void visitIntersection(QualifiedTypeMirror.QualifiedIntersectionType<Q> qtm, AnnotatedTypeMirror rawAtm) {
            AnnotatedTypeMirror.AnnotatedIntersectionType atm = (AnnotatedTypeMirror.AnnotatedIntersectionType)rawAtm;
            TypeMirrorConverter.this.applyQualifiersToLists(qtm.getBounds(), atm.directSuperTypes());
            return null;
        }

        @Override
        public Void visitNoType(QualifiedTypeMirror.QualifiedNoType<Q> qtm, AnnotatedTypeMirror rawAtm) {
            return null;
        }

        @Override
        public Void visitNull(QualifiedTypeMirror.QualifiedNullType<Q> qtm, AnnotatedTypeMirror rawAtm) {
            return null;
        }

        @Override
        public Void visitPrimitive(QualifiedTypeMirror.QualifiedPrimitiveType<Q> qtm, AnnotatedTypeMirror rawAtm) {
            return null;
        }

        @Override
        public Void visitTypeVariable(QualifiedTypeMirror.QualifiedTypeVariable<Q> qtm, AnnotatedTypeMirror rawAtm) {
            AnnotatedTypeMirror.AnnotatedTypeVariable atm = (AnnotatedTypeMirror.AnnotatedTypeVariable)rawAtm;
            this.typeVariableHelper(qtm.getDeclaration(), atm);
            return null;
        }

        @Override
        public Void visitUnion(QualifiedTypeMirror.QualifiedUnionType<Q> qtm, AnnotatedTypeMirror rawAtm) {
            AnnotatedTypeMirror.AnnotatedUnionType atm = (AnnotatedTypeMirror.AnnotatedUnionType)rawAtm;
            TypeMirrorConverter.this.applyQualifiersToLists(qtm.getAlternatives(), atm.getAlternatives());
            return null;
        }

        @Override
        public Void visitWildcard(QualifiedTypeMirror.QualifiedWildcardType<Q> qtm, AnnotatedTypeMirror rawAtm) {
            AnnotatedTypeMirror.AnnotatedWildcardType atm = (AnnotatedTypeMirror.AnnotatedWildcardType)rawAtm;
            TypeMirrorConverter.this.applyQualifiers(qtm.getExtendsBound(), atm.getExtendsBound());
            TypeMirrorConverter.this.applyQualifiers(qtm.getSuperBound(), atm.getSuperBound());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void typeVariableHelper(QualifiedTypeMirror.QualifiedParameterDeclaration<Q> qtm, AnnotatedTypeMirror.AnnotatedTypeVariable atm) {
            if (!this.seenATVs.containsKey(atm)) {
                this.seenATVs.put(atm, null);
                QualifiedTypeParameterBounds bounds = TypeMirrorConverter.this.getTypeFactory().getUnderlying().getQualifiedTypeParameterBounds(qtm.getUnderlyingType());
                try {
                    TypeMirrorConverter.this.applyQualifiers(bounds.getUpperBound(), atm.getUpperBound());
                    TypeMirrorConverter.this.applyQualifiers(bounds.getLowerBound(), atm.getLowerBound());
                }
                finally {
                    this.seenATVs.remove(atm);
                }
            }
        }

        @Override
        public Void visitParameterDeclaration(QualifiedTypeMirror.QualifiedParameterDeclaration<Q> qtm, AnnotatedTypeMirror rawAtm) {
            AnnotatedTypeMirror.AnnotatedTypeVariable atm = (AnnotatedTypeMirror.AnnotatedTypeVariable)rawAtm;
            this.typeVariableHelper(qtm, atm);
            return null;
        }

        @Override
        public Void visitTypeDeclaration(QualifiedTypeMirror.QualifiedTypeDeclaration<Q> qtm, AnnotatedTypeMirror rawAtm) {
            AnnotatedTypeMirror.AnnotatedDeclaredType atm = (AnnotatedTypeMirror.AnnotatedDeclaredType)rawAtm;
            TypeMirrorConverter.this.applyQualifiersToLists(qtm.getTypeParameters(), atm.getTypeArguments());
            return null;
        }
    };

    public TypeMirrorConverter(ProcessingEnvironment processingEnv, CheckerAdapter<Q> checkerAdapter) {
        this.checkerAdapter = checkerAdapter;
        this.processingEnv = processingEnv;
        this.blankKey = AnnotationUtils.fromClass(processingEnv.getElementUtils(), QualifierKey.class);
        this.typeFactory = null;
        this.qualToIndex = new HashMap();
        this.indexToQual = new HashMap();
    }

    private QualifiedTypeFactoryAdapter<Q> getTypeFactory() {
        if (this.typeFactory == null) {
            this.typeFactory = this.checkerAdapter.getTypeFactory();
        }
        return this.typeFactory;
    }

    private AnnotationMirror createKey(int index, Object desc) {
        if (this.keyToAnnoCache.containsKey(index)) {
            return this.keyToAnnoCache.get(index);
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, QualifierKey.class.getCanonicalName());
        builder.setValue((CharSequence)"index", index);
        builder.setValue((CharSequence)"desc", "" + desc);
        AnnotationMirror result = builder.build();
        this.keyToAnnoCache.put(index, result);
        return result;
    }

    private int getIndexForQualifier(Q qual) {
        if (this.qualToIndex.containsKey(qual)) {
            return this.qualToIndex.get(qual);
        }
        int index = this.nextIndex++;
        this.qualToIndex.put(qual, index);
        this.indexToQual.put(index, qual);
        return index;
    }

    private int getIndex(AnnotationMirror anno) {
        Integer value = AnnotationUtils.getElementValue(anno, "index", Integer.class, true);
        if (value == null) {
            ErrorReporter.errorAbort("@QualifierKey annotation contains no index");
            return -1;
        }
        return value;
    }

    public void applyQualifiers(QualifiedTypeMirror<Q> qtm, AnnotatedTypeMirror atm) {
        if (qtm == null && atm == null) {
            return;
        }
        assert (qtm != null && atm != null);
        atm.clearAnnotations();
        if (qtm.getQualifier() != null && (qtm.getKind() != TypeKind.TYPEVAR || ((QualifiedTypeMirror.QualifiedTypeVariable)qtm).isPrimaryQualifierValid())) {
            int index = this.getIndexForQualifier(qtm.getQualifier());
            AnnotationMirror key = this.createKey(index, qtm.getQualifier());
            atm.addAnnotation(key);
        }
        this.APPLY_COMPONENT_QUALIFIERS_VISITOR.visit(qtm, atm);
    }

    public AnnotatedTypeMirror getAnnotatedType(QualifiedTypeMirror<Q> qtm) {
        if (qtm == null) {
            return null;
        }
        AnnotatedTypeMirror atm = qtm.getUnderlyingType() instanceof WrappedAnnotatedTypeMirror ? ((WrappedAnnotatedTypeMirror)qtm.getUnderlyingType()).unwrap().deepCopy() : AnnotatedTypeMirror.createType(qtm.getUnderlyingType().getOriginalType(), this.getTypeFactory(), qtm.getUnderlyingType().isDeclaration());
        this.applyQualifiers(qtm, atm);
        return atm;
    }

    public List<AnnotatedTypeMirror> getAnnotatedTypeList(List<? extends QualifiedTypeMirror<Q>> qtms) {
        if (qtms == null) {
            return null;
        }
        ArrayList<AnnotatedTypeMirror> atms = new ArrayList<AnnotatedTypeMirror>();
        for (QualifiedTypeMirror<Q> qtm : qtms) {
            atms.add(this.getAnnotatedType(qtm));
        }
        return atms;
    }

    private void applyQualifiersToLists(List<? extends QualifiedTypeMirror<Q>> qtms, List<? extends AnnotatedTypeMirror> atms) {
        assert (qtms.size() == atms.size());
        for (int i = 0; i < qtms.size(); ++i) {
            this.applyQualifiers(qtms.get(i), atms.get(i));
        }
    }

    public QualifiedTypeMirror<Q> getQualifiedType(AnnotatedTypeMirror atm) {
        if (atm == null) {
            return null;
        }
        return this.getQualifiedTypeFromWrapped(WrappedAnnotatedTypeMirror.wrap(atm));
    }

    public List<QualifiedTypeMirror<Q>> getQualifiedTypeList(List<? extends AnnotatedTypeMirror> atms) {
        if (atms == null) {
            return null;
        }
        ArrayList<QualifiedTypeMirror<Q>> qtms = new ArrayList<QualifiedTypeMirror<Q>>();
        for (AnnotatedTypeMirror annotatedTypeMirror : atms) {
            qtms.add(this.getQualifiedType(annotatedTypeMirror));
        }
        return qtms;
    }

    private QualifiedTypeMirror<Q> getQualifiedTypeFromWrapped(WrappedAnnotatedTypeMirror watm) {
        if (watm == null) {
            return null;
        }
        DefaultQualifiedTypeFactory defaultFactory = (DefaultQualifiedTypeFactory)this.getTypeFactory().getUnderlying();
        return (QualifiedTypeMirror)watm.accept(defaultFactory.getTypeAnnotator(), null);
    }

    public Q getQualifier(AnnotationMirror anno) {
        if (anno == null) {
            return null;
        }
        int index = this.getIndex(anno);
        return this.indexToQual.get(index);
    }

    public Q getQualifier(AnnotatedTypeMirror atm) {
        return this.getQualifier(atm.getAnnotation(QualifierKey.class));
    }

    public AnnotationMirror getAnnotation(Q qual) {
        return this.createKey(this.getIndexForQualifier(qual), qual);
    }

    public boolean isKey(AnnotationMirror anno) {
        return anno != null && this.blankKey.getAnnotationType().equals(anno.getAnnotationType());
    }

    public AnnotationMirror getBlankKeyAnnotation() {
        return this.blankKey;
    }
}

