/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.optimizer;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.optimizer.MethodOptimizer;
import org.objectweb.asm.optimizer.NameMapping;

public class ClassOptimizer
extends ClassAdapter {
    private NameMapping mapping;
    private String className;
    private String pkgName;

    public ClassOptimizer(ClassVisitor cv, NameMapping mapping) {
        super(cv);
        this.mapping = mapping;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.pkgName = name.substring(0, name.lastIndexOf(47));
        this.cv.visit(version2, access, this.mapping.map(name), null, this.mapping.map(superName), interfaces);
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        String s2 = this.className + "." + name;
        if ((access & 5) == 0) {
            if ((access & 0x10) != 0 && (access & 8) != 0 && desc.equals("I")) {
                return null;
            }
            if (this.pkgName.equals("org/objectweb/asm") && this.mapping.map(s2).equals(name)) {
                System.out.println("INFO: " + s2 + " could be renamed");
            }
            this.cv.visitField(access, this.mapping.map(s2), this.mapping.fix(desc), null, value);
        } else {
            if (!this.mapping.map(s2).equals(name)) {
                throw new RuntimeException("The public or protected field " + s2 + " must not be renamed.");
            }
            this.cv.visitField(access, name, desc, null, value);
        }
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String s2 = this.className + "." + name + desc;
        if ((access & 5) == 0) {
            if (this.pkgName.equals("org/objectweb/asm") && !name.startsWith("<") && this.mapping.map(s2).equals(name)) {
                System.out.println("INFO: " + s2 + " could be renamed");
            }
            return new MethodOptimizer(this.cv.visitMethod(access, this.mapping.map(s2), this.mapping.fix(desc), null, exceptions), this.mapping);
        }
        if (!this.mapping.map(s2).equals(name)) {
            throw new RuntimeException("The public or protected method " + s2 + " must not be renamed.");
        }
        return new MethodOptimizer(this.cv.visitMethod(access, name, desc, null, exceptions), this.mapping);
    }
}

