/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.lowerbound;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.checker.index.IndexMethodIdentifier;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.minlen.MinLenAnnotatedTypeFactory;
import org.checkerframework.checker.index.minlen.MinLenChecker;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.index.qual.IndexFor;
import org.checkerframework.checker.index.qual.IndexOrHigh;
import org.checkerframework.checker.index.qual.IndexOrLow;
import org.checkerframework.checker.index.qual.LengthOf;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.MinLen;
import org.checkerframework.checker.index.qual.NegativeIndexFor;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.PolyIndex;
import org.checkerframework.checker.index.qual.PolyLowerBound;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.index.searchindex.SearchIndexAnnotatedTypeFactory;
import org.checkerframework.checker.index.searchindex.SearchIndexChecker;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class LowerBoundAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror GTEN1;
    public final AnnotationMirror NN;
    public final AnnotationMirror POS;
    public final AnnotationMirror BOTTOM;
    public final AnnotationMirror UNKNOWN;
    public final AnnotationMirror POLY;
    private final IndexMethodIdentifier imf;

    public LowerBoundAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.GTEN1 = AnnotationUtils.fromClass(this.elements, GTENegativeOne.class);
        this.NN = AnnotationUtils.fromClass(this.elements, NonNegative.class);
        this.BOTTOM = this.POS = AnnotationUtils.fromClass(this.elements, Positive.class);
        this.UNKNOWN = AnnotationUtils.fromClass(this.elements, LowerBoundUnknown.class);
        this.POLY = AnnotationUtils.fromClass(this.elements, PolyLowerBound.class);
        this.addAliasedAnnotation(IndexFor.class, this.NN);
        this.addAliasedAnnotation(IndexOrLow.class, this.GTEN1);
        this.addAliasedAnnotation(IndexOrHigh.class, this.NN);
        this.addAliasedAnnotation(LengthOf.class, this.NN);
        this.addAliasedAnnotation(PolyAll.class, this.POLY);
        this.addAliasedAnnotation(PolyIndex.class, this.POLY);
        this.imf = new IndexMethodIdentifier(this.processingEnv);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(Positive.class, NonNegative.class, GTENegativeOne.class, LowerBoundUnknown.class, PolyLowerBound.class));
    }

    private void addLowerBoundTypeFromValueType(AnnotatedTypeMirror valueType, AnnotatedTypeMirror type) {
        AnnotationMirror anm = this.getLowerBoundAnnotationFromValueType(valueType);
        if (!type.isAnnotatedInHierarchy(this.UNKNOWN)) {
            if (!AnnotationUtils.areSameByClass(anm, LowerBoundUnknown.class)) {
                type.addAnnotation(anm);
            }
            return;
        }
        if (this.qualHierarchy.isSubtype(anm, type.getAnnotationInHierarchy(this.UNKNOWN))) {
            type.replaceAnnotation(anm);
        }
    }

    @Override
    public void addComputedTypeAnnotations(Element element, AnnotatedTypeMirror type) {
        super.addComputedTypeAnnotations(element, type);
        if (element != null) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(element);
            this.addLowerBoundTypeFromValueType(valueType, type);
        }
    }

    @Override
    public void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        super.addComputedTypeAnnotations(tree, type, iUseFlow);
        if (iUseFlow && tree != null && TreeUtils.isExpressionTree(tree)) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(tree);
            this.addLowerBoundTypeFromValueType(valueType, type);
        }
    }

    public ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    public MinLenAnnotatedTypeFactory getMinLenAnnotatedTypeFactory() {
        return (MinLenAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(MinLenChecker.class);
    }

    public SearchIndexAnnotatedTypeFactory getSearchIndexAnnotatedTypeFactory() {
        return (SearchIndexAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(SearchIndexChecker.class);
    }

    private AnnotationMirror getLowerBoundAnnotationFromValueType(AnnotatedTypeMirror valueType) {
        List<Long> possibleValues = IndexUtil.getPossibleValues(valueType);
        if (possibleValues == null) {
            if (AnnotationUtils.containsSameByClass(valueType.getAnnotations(), BottomVal.class)) {
                return this.POS;
            }
            return this.UNKNOWN;
        }
        if (possibleValues.size() == 0) {
            return this.BOTTOM;
        }
        long lvalMin = Collections.min(possibleValues);
        int valMin = (int)Math.max(Math.min(Integer.MAX_VALUE, lvalMin), Integer.MIN_VALUE);
        return this.anmFromVal(valMin);
    }

    private AnnotationMirror anmFromVal(int val) {
        if (val >= 1) {
            return this.POS;
        }
        if (val >= 0) {
            return this.NN;
        }
        if (val >= -1) {
            return this.GTEN1;
        }
        return this.UNKNOWN;
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new LowerBoundTreeAnnotator(this), new PropagationTreeAnnotator(this), new ImplicitsTreeAnnotator(this));
    }

    private void addAnnotationForRightShift(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror rightType = this.getAnnotatedType(rightExpr);
        AnnotatedTypeMirror leftType = this.getAnnotatedType(leftExpr);
        if ((leftType.hasAnnotation(this.NN) || leftType.hasAnnotation(this.POS)) && (rightType.hasAnnotation(this.NN) || rightType.hasAnnotation(this.POS))) {
            type.addAnnotation(this.NN);
            return;
        }
        type.addAnnotation(this.UNKNOWN);
    }

    private void addAnnotationForAnd(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror rightType = this.getAnnotatedType(rightExpr);
        if (rightType.hasAnnotation(this.NN) || rightType.hasAnnotation(this.POS)) {
            type.addAnnotation(this.NN);
            return;
        }
        AnnotatedTypeMirror leftType = this.getAnnotatedType(leftExpr);
        if (leftType.hasAnnotation(this.NN) || leftType.hasAnnotation(this.POS)) {
            type.addAnnotation(this.NN);
            return;
        }
        type.addAnnotation(this.UNKNOWN);
    }

    private class LowerBoundTreeAnnotator
    extends TreeAnnotator {
        public LowerBoundTreeAnnotator(AnnotatedTypeFactory annotatedTypeFactory) {
            super(annotatedTypeFactory);
        }

        private void promoteType(AnnotatedTypeMirror typeSrc, AnnotatedTypeMirror typeDst) {
            if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
            } else if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
            } else if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            } else {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
        }

        private void demoteType(AnnotatedTypeMirror typeSrc, AnnotatedTypeMirror typeDst) {
            if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            } else if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1);
            } else {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
        }

        @Override
        public Void visitUnary(UnaryTree tree, AnnotatedTypeMirror typeDst) {
            AnnotatedTypeMirror typeSrc = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression());
            switch (tree.getKind()) {
                case PREFIX_INCREMENT: {
                    this.promoteType(typeSrc, typeDst);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.demoteType(typeSrc, typeDst);
                    break;
                }
                case POSTFIX_INCREMENT: 
                case POSTFIX_DECREMENT: {
                    break;
                }
                case BITWISE_COMPLEMENT: {
                    this.handleBitWiseComplement(LowerBoundAnnotatedTypeFactory.this.getSearchIndexAnnotatedTypeFactory().getAnnotatedType(tree.getExpression()), typeDst);
                    break;
                }
            }
            return (Void)super.visitUnary(tree, typeDst);
        }

        private void handleBitWiseComplement(AnnotatedTypeMirror searchIndexType, AnnotatedTypeMirror typeDst) {
            if (AnnotationUtils.containsSameByClass(searchIndexType.getAnnotations(), NegativeIndexFor.class)) {
                typeDst.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            }
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            if (LowerBoundAnnotatedTypeFactory.this.imf.isMathMax(tree, LowerBoundAnnotatedTypeFactory.this.processingEnv)) {
                ExpressionTree left = tree.getArguments().get(0);
                ExpressionTree right = tree.getArguments().get(1);
                type.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.qualHierarchy.greatestLowerBound(LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(left).getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS), LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(right).getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS)));
            }
            return (Void)super.visitMethodInvocation(tree, type);
        }

        private Integer getMinLenFromMemberSelectTree(MemberSelectTree tree) {
            if (TreeUtils.isArrayLengthAccess(tree)) {
                AnnotatedTypeMirror minLenType = LowerBoundAnnotatedTypeFactory.this.getMinLenAnnotatedTypeFactory().getAnnotatedType(tree.getExpression());
                AnnotationMirror anm = minLenType.getAnnotation(MinLen.class);
                if (anm == null) {
                    return 0;
                }
                return AnnotationUtils.getElementValue(anm, "value", Integer.class, true);
            }
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
            Integer minLen = this.getMinLenFromMemberSelectTree(tree);
            if (minLen != null) {
                type.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.anmFromVal(minLen));
            }
            return (Void)super.visitMemberSelect(tree, type);
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isStringConcatenation(tree)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
                return super.visitBinary(tree, type);
            }
            ExpressionTree left = tree.getLeftOperand();
            ExpressionTree right = tree.getRightOperand();
            switch (tree.getKind()) {
                case PLUS: {
                    this.addAnnotationForPlus(left, right, type);
                    break;
                }
                case MINUS: {
                    this.addAnnotationForMinus(left, right, type);
                    break;
                }
                case MULTIPLY: {
                    this.addAnnotationForMultiply(left, right, type);
                    break;
                }
                case DIVIDE: {
                    this.addAnnotationForDivide(left, right, type);
                    break;
                }
                case REMAINDER: {
                    this.addAnnotationForRemainder(left, right, type);
                    break;
                }
                case AND: {
                    LowerBoundAnnotatedTypeFactory.this.addAnnotationForAnd(left, right, type);
                    break;
                }
                case RIGHT_SHIFT: {
                    LowerBoundAnnotatedTypeFactory.this.addAnnotationForRightShift(left, right, type);
                    break;
                }
            }
            return super.visitBinary(tree, type);
        }

        private void addAnnotationForLiteralPlus(int val, AnnotatedTypeMirror nonLiteralType, AnnotatedTypeMirror type) {
            if (val == -2) {
                if (nonLiteralType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1);
                    return;
                }
            } else {
                if (val == -1) {
                    this.demoteType(nonLiteralType, type);
                    return;
                }
                if (val == 0) {
                    type.addAnnotation(nonLiteralType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                    return;
                }
                if (val == 1) {
                    this.promoteType(nonLiteralType, type);
                    return;
                }
                if (val >= 2 && !nonLiteralType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN)) {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
                    return;
                }
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private void addAnnotationForPlus(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror leftType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
            Long valRight = IndexUtil.getExactValue(rightExpr, LowerBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory());
            if (valRight != null) {
                this.addAnnotationForLiteralPlus(valRight.intValue(), leftType, type);
                return;
            }
            AnnotatedTypeMirror rightType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(rightExpr);
            Long valLeft = IndexUtil.getExactValue(leftExpr, LowerBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory());
            if (valLeft != null) {
                this.addAnnotationForLiteralPlus(valLeft.intValue(), rightType, type);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                type.addAnnotation(rightType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                return;
            }
            if (rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                type.addAnnotation(leftType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1) || leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private void addAnnotationForMinus(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            Long valRight = IndexUtil.getExactValue(rightExpr, LowerBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory());
            if (valRight != null) {
                MemberSelectTree mstree;
                Integer minLen;
                AnnotatedTypeMirror leftType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
                this.addAnnotationForLiteralPlus(-1 * valRight.intValue(), leftType, type);
                if (leftExpr.getKind() == Tree.Kind.MEMBER_SELECT && (minLen = this.getMinLenFromMemberSelectTree(mstree = (MemberSelectTree)leftExpr)) != null) {
                    type.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.anmFromVal(minLen - valRight.intValue()));
                }
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private void addAnnotationForLiteralMultiply(int val, AnnotatedTypeMirror nonLiteralType, AnnotatedTypeMirror type) {
            if (val == 0) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            if (val == 1) {
                type.addAnnotation(nonLiteralType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                return;
            }
            if (val > 1 && (nonLiteralType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) || nonLiteralType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN))) {
                type.addAnnotation(nonLiteralType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private boolean checkForMathRandomSpecialCase(ExpressionTree randTree, ExpressionTree arrLenTree, AnnotatedTypeMirror type) {
            if (randTree.getKind() == Tree.Kind.METHOD_INVOCATION && TreeUtils.isArrayLengthAccess(arrLenTree)) {
                MethodInvocationTree miTree = (MethodInvocationTree)randTree;
                if (LowerBoundAnnotatedTypeFactory.this.imf.isMathRandom(miTree, LowerBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                    return true;
                }
                if (LowerBoundAnnotatedTypeFactory.this.imf.isRandomNextDouble(miTree, LowerBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                    return true;
                }
            }
            return false;
        }

        private void addAnnotationForMultiply(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            if (this.checkForMathRandomSpecialCase(rightExpr, leftExpr, type) || this.checkForMathRandomSpecialCase(leftExpr, rightExpr, type)) {
                return;
            }
            AnnotatedTypeMirror leftType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
            Long valRight = IndexUtil.getExactValue(rightExpr, LowerBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory());
            if (valRight != null) {
                this.addAnnotationForLiteralMultiply(valRight.intValue(), leftType, type);
                return;
            }
            AnnotatedTypeMirror rightType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(rightExpr);
            Long valLeft = IndexUtil.getExactValue(leftExpr, LowerBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory());
            if (valLeft != null) {
                this.addAnnotationForLiteralMultiply(valLeft.intValue(), rightType, type);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN) || leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private void addAnnotationForLiteralDivideLeft(int val, AnnotatedTypeMirror rightType, AnnotatedTypeMirror type) {
            if (val == 0) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            } else if (val == 1) {
                if (rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN) || rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                } else {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1);
                }
            }
        }

        private void addAnnotationForLiteralDivideRight(int val, AnnotatedTypeMirror leftType, AnnotatedTypeMirror type) {
            if (val == 0) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
            } else if (val == 1) {
                type.addAnnotation(leftType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
            } else if (val >= 2 && (leftType.hasAnnotation(NonNegative.class) || leftType.hasAnnotation(Positive.class))) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            }
        }

        private void addAnnotationForDivide(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror leftType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
            Long valRight = IndexUtil.getExactValue(rightExpr, LowerBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory());
            if (valRight != null) {
                this.addAnnotationForLiteralDivideRight(valRight.intValue(), leftType, type);
                return;
            }
            AnnotatedTypeMirror rightType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(rightExpr);
            Long valLeft = IndexUtil.getExactValue(leftExpr, LowerBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory());
            if (valLeft != null) {
                this.addAnnotationForLiteralDivideLeft(valLeft.intValue(), leftType, type);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) && (rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) || rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN))) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            if (rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) || rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                type.addAnnotation(leftType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private void addAnnotationForLiteralRemainder(int val, AnnotatedTypeMirror type) {
            if (val == 1 || val == -1) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            }
        }

        public void addAnnotationForRemainder(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror leftType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
            AnnotatedTypeMirror rightType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(rightExpr);
            Long valRight = IndexUtil.getExactValue(rightExpr, LowerBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory());
            if (valRight != null) {
                this.addAnnotationForLiteralRemainder(valRight.intValue(), type);
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) || leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1);
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }
    }
}

