/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.minlen;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.index.qual.MinLen;
import org.checkerframework.checker.index.qual.MinLenBottom;
import org.checkerframework.checker.index.qual.MinLenFieldInvariant;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.PolyMinLen;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.FieldInvariants;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.defaults.QualifierDefaults;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class MinLenAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    final AnnotationMirror MIN_LEN_0;
    final AnnotationMirror MIN_LEN_BOTTOM;
    final AnnotationMirror POLY;

    public MinLenAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, MinLen.class);
        builder.setValue((CharSequence)"value", 0);
        this.MIN_LEN_0 = builder.build();
        this.MIN_LEN_BOTTOM = AnnotationUtils.fromClass(this.elements, MinLenBottom.class);
        this.POLY = AnnotationUtils.fromClass(this.elements, PolyMinLen.class);
        this.addAliasedAnnotation(PolyAll.class, this.POLY);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(MinLen.class, MinLenBottom.class, PolyMinLen.class));
    }

    @Override
    protected void addCheckedCodeDefaults(QualifierDefaults defaults) {
        defaults.addCheckedCodeDefault(this.MIN_LEN_0, TypeUseLocation.OTHERWISE);
    }

    public ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    public AnnotatedTypeMirror valueTypeFromTree(Tree tree) {
        return this.getValueAnnotatedTypeFactory().getAnnotatedType(tree);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new MinLenQualifierHierarchy(factory);
    }

    private void addMinLenAnnotationFromArrayLen(AnnotatedTypeMirror valueType, AnnotatedTypeMirror type) {
        if (valueType.hasAnnotation(ArrayLen.class)) {
            AnnotationMirror anm = valueType.getAnnotation(ArrayLen.class);
            Integer val = Collections.min(ValueAnnotatedTypeFactory.getArrayLength(anm));
            type.replaceAnnotation(this.qualHierarchy.greatestLowerBound(this.createMinLen(val), type.getAnnotationInHierarchy(this.MIN_LEN_0)));
        }
    }

    private void addMinLenAnnotationFromStringVal(AnnotatedTypeMirror valueType, AnnotatedTypeMirror type) {
        if (valueType.hasAnnotation(StringVal.class)) {
            AnnotationMirror anm = valueType.getAnnotation(StringVal.class);
            List<String> values = AnnotationUtils.getElementValueArray(anm, "value", String.class, true);
            ArrayList<Integer> lengths = new ArrayList<Integer>();
            for (String value : values) {
                lengths.add(value.length());
            }
            int val = (Integer)Collections.min(lengths);
            type.replaceAnnotation(this.createMinLen(val));
        }
    }

    @Override
    public void addComputedTypeAnnotations(Element element, AnnotatedTypeMirror type) {
        super.addComputedTypeAnnotations(element, type);
        if (element != null) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(element);
            this.addMinLenAnnotationFromArrayLen(valueType, type);
            this.addMinLenAnnotationFromStringVal(valueType, type);
        }
    }

    @Override
    public void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        super.addComputedTypeAnnotations(tree, type, iUseFlow);
        if (tree != null && TreeUtils.isExpressionTree(tree)) {
            AnnotatedTypeMirror valueType = this.valueTypeFromTree(tree);
            this.addMinLenAnnotationFromArrayLen(valueType, type);
            this.addMinLenAnnotationFromStringVal(valueType, type);
        }
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new MinLenTreeAnnotator(this), new PropagationTreeAnnotator(this), new ImplicitsTreeAnnotator(this));
    }

    protected static Integer getMinLenValue(AnnotationMirror annotation) {
        if (annotation == null || !AnnotationUtils.areSameByClass(annotation, MinLen.class)) {
            return null;
        }
        return AnnotationUtils.getElementValue(annotation, "value", Integer.class, true);
    }

    public AnnotationMirror createMinLen(@NonNegative int val) {
        if (val == 0) {
            return this.MIN_LEN_0;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, MinLen.class);
        builder.setValue((CharSequence)"value", val);
        return builder.build();
    }

    public int getMinLenFromString(String arrayExpression, Tree tree, TreePath currentPath) {
        AnnotationMirror minLenAnno = null;
        try {
            minLenAnno = this.getAnnotationFromJavaExpressionString(arrayExpression, tree, currentPath, MinLen.class);
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {
            // empty catch block
        }
        if (minLenAnno == null) {
            return 0;
        }
        Integer minLenValue = MinLenAnnotatedTypeFactory.getMinLenValue(minLenAnno);
        return minLenValue == null ? 0 : minLenValue;
    }

    @Override
    public FieldInvariants getFieldInvariants(TypeElement element) {
        AnnotationMirror fieldInvarAnno = this.getDeclAnnotation(element, MinLenFieldInvariant.class);
        if (fieldInvarAnno == null) {
            return null;
        }
        List<String> fields = AnnotationUtils.getElementValueArray(fieldInvarAnno, "field", String.class, true);
        List<Integer> minlens = AnnotationUtils.getElementValueArray(fieldInvarAnno, "minLen", Integer.class, true);
        ArrayList<AnnotationMirror> qualifiers = new ArrayList<AnnotationMirror>();
        for (Integer minlen : minlens) {
            qualifiers.add(this.createMinLen(minlen));
        }
        FieldInvariants superInvariants = super.getFieldInvariants(element);
        return new FieldInvariants(superInvariants, fields, qualifiers);
    }

    @Override
    protected Set<Class<? extends Annotation>> getFieldInvariantDeclarationAnnotations() {
        HashSet<Class<? extends Annotation>> set = new HashSet<Class<? extends Annotation>>(super.getFieldInvariantDeclarationAnnotations());
        set.add(MinLenFieldInvariant.class);
        return set;
    }

    protected class MinLenTreeAnnotator
    extends TreeAnnotator {
        public MinLenTreeAnnotator(MinLenAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitNewArray(NewArrayTree node, AnnotatedTypeMirror type) {
            ExpressionTree dimExp;
            if (node.getDimensions().size() > 0 && TreeUtils.isArrayLengthAccess(dimExp = node.getDimensions().get(0))) {
                ExpressionTree exp = ((MemberSelectTree)dimExp).getExpression();
                AnnotatedTypeMirror arrayType = MinLenAnnotatedTypeFactory.this.getAnnotatedType(exp);
                AnnotationMirror minLenAnno = arrayType.getAnnotation(MinLen.class);
                if (minLenAnno != null) {
                    type.addAnnotation(minLenAnno);
                } else if (arrayType.hasAnnotation(PolyMinLen.class)) {
                    type.addAnnotation(MinLenAnnotatedTypeFactory.this.POLY);
                }
            }
            return null;
        }
    }

    private final class MinLenQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        Set<? extends AnnotationMirror> minLenTops;

        public MinLenQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
            this.minLenTops = null;
        }

        @Override
        public Set<? extends AnnotationMirror> getTopAnnotations() {
            if (this.minLenTops == null) {
                Set<AnnotationMirror> tops = AnnotationUtils.createAnnotationSet();
                tops.add(MinLenAnnotatedTypeFactory.this.MIN_LEN_0);
                this.minLenTops = Collections.unmodifiableSet(tops);
            }
            return this.minLenTops;
        }

        @Override
        public AnnotationMirror getTopAnnotation(AnnotationMirror start) {
            return MinLenAnnotatedTypeFactory.this.MIN_LEN_0;
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSameByClass(a1, MinLenBottom.class) || AnnotationUtils.areSameByClass(a2, MinLenBottom.class)) {
                return MinLenAnnotatedTypeFactory.this.MIN_LEN_BOTTOM;
            }
            if (AnnotationUtils.areSame(a1, MinLenAnnotatedTypeFactory.this.MIN_LEN_0)) {
                return a2;
            }
            if (AnnotationUtils.areSame(a2, MinLenAnnotatedTypeFactory.this.MIN_LEN_0)) {
                return a1;
            }
            if (AnnotationUtils.areSameByClass(a1, PolyMinLen.class) || AnnotationUtils.areSameByClass(a2, PolyMinLen.class)) {
                return MinLenAnnotatedTypeFactory.this.MIN_LEN_BOTTOM;
            }
            Integer a1Val = AnnotationUtils.getElementValue(a1, "value", Integer.class, true);
            Integer a2Val = AnnotationUtils.getElementValue(a2, "value", Integer.class, true);
            if (a1Val >= a2Val) {
                return a1;
            }
            return a2;
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSameByClass(a1, PolyMinLen.class) && AnnotationUtils.areSameByClass(a2, PolyMinLen.class)) {
                return a1;
            }
            if (AnnotationUtils.areSameByClass(a1, MinLenBottom.class)) {
                return a2;
            }
            if (AnnotationUtils.areSameByClass(a2, MinLenBottom.class)) {
                return a1;
            }
            if (AnnotationUtils.areSameByClass(a1, MinLen.class) && AnnotationUtils.areSameByClass(a2, MinLen.class)) {
                Integer a1Val = AnnotationUtils.getElementValue(a1, "value", Integer.class, true);
                Integer a2Val = AnnotationUtils.getElementValue(a2, "value", Integer.class, true);
                if (a1Val <= a2Val) {
                    return a1;
                }
                return a2;
            }
            return MinLenAnnotatedTypeFactory.this.MIN_LEN_0;
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            if (AnnotationUtils.areSameByClass(superAnno, PolyMinLen.class)) {
                return AnnotationUtils.areSameByClass(subAnno, PolyMinLen.class);
            }
            if (AnnotationUtils.areSameByClass(subAnno, PolyMinLen.class)) {
                return AnnotationUtils.areSame(superAnno, MinLenAnnotatedTypeFactory.this.MIN_LEN_0);
            }
            if (AnnotationUtils.areSameByClass(subAnno, MinLenBottom.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(superAnno, MinLenBottom.class)) {
                return false;
            }
            if (AnnotationUtils.areSameIgnoringValues(subAnno, superAnno)) {
                Integer rhsVal = AnnotationUtils.getElementValue(subAnno, "value", Integer.class, true);
                Integer lhsVal = AnnotationUtils.getElementValue(superAnno, "value", Integer.class, true);
                return rhsVal >= lhsVal;
            }
            return false;
        }
    }
}

