/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.typeannotator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.javacutil.CollectionUtils;
import org.checkerframework.javacutil.TypesUtils;

public class IrrelevantTypeAnnotator
extends TypeAnnotator {
    private List<TypeMirror> relevantTypes;
    private Set<TypeMirror> allFoundRelevantTypes;
    private boolean arraysAreRelevant;
    private Set<? extends AnnotationMirror> annotations;

    public IrrelevantTypeAnnotator(AnnotatedTypeFactory typeFactory, Set<? extends AnnotationMirror> annotations, Class<?>[] relevantClasses) {
        super(typeFactory);
        this.annotations = annotations;
        this.arraysAreRelevant = false;
        this.relevantTypes = new ArrayList<TypeMirror>(relevantClasses.length);
        for (Class<?> clazz : relevantClasses) {
            if (clazz.equals(Object[].class)) {
                this.arraysAreRelevant = true;
                continue;
            }
            this.relevantTypes.add(TypesUtils.typeFromClass(typeFactory.getContext().getTypeUtils(), typeFactory.getElementUtils(), clazz));
        }
        this.allFoundRelevantTypes = Collections.newSetFromMap(CollectionUtils.createLRUCache(300));
    }

    @Override
    protected Void scan(AnnotatedTypeMirror type, Void aVoid) {
        if (type == null) {
            return aVoid;
        }
        switch (type.getKind()) {
            case TYPEVAR: 
            case WILDCARD: 
            case EXECUTABLE: 
            case INTERSECTION: 
            case UNION: 
            case NULL: 
            case NONE: 
            case PACKAGE: 
            case VOID: {
                return (Void)super.scan(type, aVoid);
            }
        }
        Types types = this.typeFactory.getContext().getTypeUtils();
        TypeMirror typeMirror = type.getUnderlyingType();
        if (TypesUtils.isPrimitive(typeMirror)) {
            typeMirror = types.boxedClass((PrimitiveType)typeMirror).asType();
        }
        boolean shouldAnnotate = true;
        if (this.allFoundRelevantTypes.contains(typeMirror)) {
            shouldAnnotate = false;
        } else if (typeMirror.getKind() == TypeKind.DECLARED) {
            for (TypeMirror supportedType : this.relevantTypes) {
                if (!types.isSubtype(typeMirror, supportedType)) continue;
                shouldAnnotate = false;
                this.allFoundRelevantTypes.add(typeMirror);
                break;
            }
        } else if (typeMirror.getKind() == TypeKind.ARRAY) {
            shouldAnnotate = this.arraysAreRelevant;
            if (this.arraysAreRelevant) {
                this.allFoundRelevantTypes.add(typeMirror);
            }
        }
        if (shouldAnnotate) {
            type.addMissingAnnotations(this.annotations);
        }
        return (Void)super.scan(type, aVoid);
    }

    @Override
    public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType t, Void p) {
        this.scan(t.getReturnType(), p);
        this.scanAndReduce(t.getReceiverType(), p, null);
        this.scanAndReduce(t.getParameterTypes(), p, null);
        this.scanAndReduce(t.getThrownTypes(), p, null);
        this.scanAndReduce(t.getTypeVariables(), p, null);
        return null;
    }
}

