/*
 * Decompiled with CFR 0.152.
 */
package annotations.el;

import annotations.Annotation;
import annotations.el.AClass;
import annotations.el.ADeclaration;
import annotations.el.AElement;
import annotations.el.AField;
import annotations.el.AMethod;
import annotations.el.AScene;
import annotations.el.ATypeElement;
import annotations.el.ATypeElementWithType;
import annotations.el.AnnotationDef;
import annotations.el.DefException;
import annotations.field.AnnotationAFT;
import annotations.field.AnnotationFieldType;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class DefCollector {
    private final Set<AnnotationDef> defs = new LinkedHashSet<AnnotationDef>();

    public DefCollector(AScene s2) throws DefException {
        this.collect(s2);
    }

    private AnnotationDef getDef(String name) {
        for (AnnotationDef def : this.defs) {
            if (!def.name.equals(name)) continue;
            return def;
        }
        return null;
    }

    private void collect(AScene s2) throws DefException {
        for (AElement p : s2.packages.values()) {
            this.collect(p);
        }
        for (AClass c : s2.classes.values()) {
            this.collect(c);
        }
    }

    private void addToDefs(AnnotationDef d) throws DefException {
        if (this.defs.contains(d)) {
            return;
        }
        AnnotationDef oldD = this.getDef(d.name);
        if (oldD == null) {
            this.defs.add(d);
        } else {
            AnnotationDef ud = AnnotationDef.unify(oldD, d);
            if (ud == null) {
                throw new DefException(d.name);
            }
            this.defs.remove(oldD);
            this.defs.add(ud);
        }
    }

    private void collect(AnnotationDef d) throws DefException {
        if (this.defs.contains(d)) {
            return;
        }
        for (AnnotationFieldType aft : d.fieldTypes.values()) {
            if (!(aft instanceof AnnotationAFT)) continue;
            this.collect(((AnnotationAFT)aft).annotationDef);
        }
        this.addToDefs(d);
    }

    private void collect(AElement e) throws DefException {
        for (Annotation tla : e.tlAnnotationsHere) {
            AnnotationDef tld = tla.def;
            if (this.defs.contains(tld)) continue;
            AnnotationDef d = tld;
            this.collect(d);
            this.addToDefs(d);
        }
        if (e.type != null) {
            this.collect(e.type);
        }
    }

    private void collect(ATypeElement e) throws DefException {
        this.collect((AElement)e);
        for (AElement it : e.innerTypes.values()) {
            this.collect(it);
        }
    }

    private void collect(ADeclaration d) throws DefException {
        this.collect((AElement)d);
        for (ATypeElement ia : d.insertAnnotations.values()) {
            this.collect(ia);
        }
        for (ATypeElementWithType ic : d.insertTypecasts.values()) {
            this.collect(ic);
        }
    }

    private void collect(AField f) throws DefException {
        this.collect((ADeclaration)f);
    }

    private void collect(AMethod m3) throws DefException {
        for (ATypeElement b : m3.bounds.values()) {
            this.collect(b);
        }
        this.collect((ADeclaration)m3);
        this.collect(m3.returnType);
        this.collect(m3.receiver);
        for (AElement p : m3.parameters.values()) {
            this.collect(p);
        }
        for (AField l : m3.body.locals.values()) {
            this.collect(l);
        }
        for (ATypeElement tc : m3.body.typecasts.values()) {
            this.collect(tc);
        }
        for (ATypeElement i : m3.body.instanceofs.values()) {
            this.collect(i);
        }
        for (ATypeElement n : m3.body.news.values()) {
            this.collect(n);
        }
    }

    private void collect(AClass c) throws DefException {
        this.collect((ADeclaration)c);
        for (ATypeElement b : c.bounds.values()) {
            this.collect(b);
        }
        for (ATypeElement ei : c.extendsImplements.values()) {
            this.collect(ei);
        }
        for (AMethod m3 : c.methods.values()) {
            this.collect(m3);
        }
        for (AField f : c.fields.values()) {
            this.collect(f);
        }
    }

    protected abstract void visitAnnotationDef(AnnotationDef var1);

    public final void visit() {
        for (AnnotationDef d : this.defs) {
            this.visitAnnotationDef(d);
        }
    }
}

