/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Convert;

public class Constants {
    public static Object decode(Object value, Type type) {
        if (value instanceof Integer) {
            int i = (Integer)value;
            switch (type.getTag()) {
                case BOOLEAN: {
                    return i != 0;
                }
                case CHAR: {
                    return Character.valueOf((char)i);
                }
                case BYTE: {
                    return (byte)i;
                }
                case SHORT: {
                    return (short)i;
                }
            }
        }
        return value;
    }

    public static String format(Object value, Type type) {
        value = Constants.decode(value, type);
        switch (type.getTag()) {
            case BYTE: {
                return Constants.formatByte((Byte)value);
            }
            case LONG: {
                return Constants.formatLong((Long)value);
            }
            case FLOAT: {
                return Constants.formatFloat(((Float)value).floatValue());
            }
            case DOUBLE: {
                return Constants.formatDouble((Double)value);
            }
            case CHAR: {
                return Constants.formatChar(((Character)value).charValue());
            }
        }
        if (value instanceof String) {
            return Constants.formatString((String)value);
        }
        return value + "";
    }

    public static String format(Object value) {
        if (value instanceof Byte) {
            return Constants.formatByte((Byte)value);
        }
        if (value instanceof Short) {
            return Constants.formatShort((Short)value);
        }
        if (value instanceof Long) {
            return Constants.formatLong((Long)value);
        }
        if (value instanceof Float) {
            return Constants.formatFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Constants.formatDouble((Double)value);
        }
        if (value instanceof Character) {
            return Constants.formatChar(((Character)value).charValue());
        }
        if (value instanceof String) {
            return Constants.formatString((String)value);
        }
        if (value instanceof Integer || value instanceof Boolean) {
            return value.toString();
        }
        throw new IllegalArgumentException("Argument is not a primitive type or a string; it " + (value == null ? "is a null value." : "has class " + value.getClass().getName()) + ".");
    }

    private static String formatByte(byte b) {
        return String.format("(byte)0x%02x", b);
    }

    private static String formatShort(short s2) {
        return String.format("(short)%d", s2);
    }

    private static String formatLong(long lng) {
        return lng + "L";
    }

    private static String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "0.0f/0.0f";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-1.0f/0.0f" : "1.0f/0.0f";
        }
        return f + "f";
    }

    private static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "0.0/0.0";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-1.0/0.0" : "1.0/0.0";
        }
        return d + "";
    }

    private static String formatChar(char c) {
        return '\'' + Convert.quote(c) + '\'';
    }

    private static String formatString(String s2) {
        return '\"' + Convert.quote(s2) + '\"';
    }
}

