/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.checker.index.IndexMethodIdentifier;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.lowerbound.LowerBoundAnnotatedTypeFactory;
import org.checkerframework.checker.index.lowerbound.LowerBoundChecker;
import org.checkerframework.checker.index.qual.IndexFor;
import org.checkerframework.checker.index.qual.IndexOrHigh;
import org.checkerframework.checker.index.qual.IndexOrLow;
import org.checkerframework.checker.index.qual.LTEqLengthOf;
import org.checkerframework.checker.index.qual.LTLengthOf;
import org.checkerframework.checker.index.qual.LTOMLengthOf;
import org.checkerframework.checker.index.qual.LengthOf;
import org.checkerframework.checker.index.qual.NegativeIndexFor;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.PolyIndex;
import org.checkerframework.checker.index.qual.PolyUpperBound;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.qual.SearchIndexFor;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.index.samelen.SameLenAnnotatedTypeFactory;
import org.checkerframework.checker.index.samelen.SameLenChecker;
import org.checkerframework.checker.index.searchindex.SearchIndexAnnotatedTypeFactory;
import org.checkerframework.checker.index.searchindex.SearchIndexChecker;
import org.checkerframework.checker.index.upperbound.OffsetEquation;
import org.checkerframework.checker.index.upperbound.UBQualifier;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.dependenttypes.DependentTypesError;
import org.checkerframework.framework.util.dependenttypes.DependentTypesHelper;
import org.checkerframework.framework.util.dependenttypes.DependentTypesTreeAnnotator;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class UpperBoundAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror UNKNOWN;
    public final AnnotationMirror BOTTOM;
    public final AnnotationMirror POLY;
    private final IndexMethodIdentifier imf;

    public UpperBoundAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWN = AnnotationUtils.fromClass(this.elements, UpperBoundUnknown.class);
        this.BOTTOM = AnnotationUtils.fromClass(this.elements, UpperBoundBottom.class);
        this.POLY = AnnotationUtils.fromClass(this.elements, PolyUpperBound.class);
        this.addAliasedAnnotation(IndexFor.class, this.createLTLengthOfAnnotation(new String[0]));
        this.addAliasedAnnotation(IndexOrLow.class, this.createLTLengthOfAnnotation(new String[0]));
        this.addAliasedAnnotation(IndexOrHigh.class, this.createLTEqLengthOfAnnotation(new String[0]));
        this.addAliasedAnnotation(SearchIndexFor.class, this.createLTLengthOfAnnotation(new String[0]));
        this.addAliasedAnnotation(NegativeIndexFor.class, this.createLTLengthOfAnnotation(new String[0]));
        this.addAliasedAnnotation(LengthOf.class, this.createLTEqLengthOfAnnotation(new String[0]));
        this.addAliasedAnnotation(PolyAll.class, this.POLY);
        this.addAliasedAnnotation(PolyIndex.class, this.POLY);
        this.imf = new IndexMethodIdentifier(this.processingEnv);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(UpperBoundUnknown.class, LTEqLengthOf.class, LTLengthOf.class, LTOMLengthOf.class, UpperBoundBottom.class, PolyUpperBound.class));
    }

    ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    private SearchIndexAnnotatedTypeFactory getSearchIndexAnnotatedTypeFactory() {
        return (SearchIndexAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(SearchIndexChecker.class);
    }

    SameLenAnnotatedTypeFactory getSameLenAnnotatedTypeFactory() {
        return (SameLenAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(SameLenChecker.class);
    }

    private LowerBoundAnnotatedTypeFactory getLowerBoundAnnotatedTypeFactory() {
        return (LowerBoundAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(LowerBoundChecker.class);
    }

    @Override
    public void addComputedTypeAnnotations(Element element, AnnotatedTypeMirror type) {
        super.addComputedTypeAnnotations(element, type);
        if (element != null) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(element);
            this.addUpperBoundTypeFromValueType(valueType, type);
        }
    }

    @Override
    public void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        super.addComputedTypeAnnotations(tree, type, iUseFlow);
        if (iUseFlow && tree != null && TreeUtils.isExpressionTree(tree)) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(tree);
            this.addUpperBoundTypeFromValueType(valueType, type);
        }
    }

    private void addUpperBoundTypeFromValueType(AnnotatedTypeMirror valueType, AnnotatedTypeMirror type) {
        if (AnnotationUtils.containsSameByClass(valueType.getAnnotations(), BottomVal.class)) {
            type.replaceAnnotation(this.BOTTOM);
        }
    }

    @Override
    protected DependentTypesHelper createDependentTypesHelper() {
        return new DependentTypesHelper(this){

            @Override
            protected String standardizeString(String expression, FlowExpressionParseUtil.FlowExpressionContext context, TreePath localScope, boolean useLocalScope) {
                if (DependentTypesError.isExpressionError(expression)) {
                    return expression;
                }
                if (this.indexOf(expression, '-', '+', 0) == -1) {
                    return super.standardizeString(expression, context, localScope, useLocalScope);
                }
                OffsetEquation equation = OffsetEquation.createOffsetFromJavaExpression(expression);
                if (equation.hasError()) {
                    return equation.getError();
                }
                try {
                    equation.standardizeAndViewpointAdaptExpressions(context, localScope, useLocalScope);
                }
                catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                    return new DependentTypesError(expression, e).toString();
                }
                return equation.toString();
            }

            private int indexOf(String expression, char a, char b, int index) {
                int aIndex = expression.indexOf(a, index);
                int bIndex = expression.indexOf(b, index);
                if (aIndex == -1) {
                    return bIndex;
                }
                if (bIndex == -1) {
                    return aIndex;
                }
                return Math.min(aIndex, bIndex);
            }

            @Override
            public TreeAnnotator createDependentTypesTreeAnnotator(AnnotatedTypeFactory factory) {
                return new DependentTypesTreeAnnotator(factory, this){

                    @Override
                    public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
                        if (TreeUtils.isArrayLengthAccess(tree)) {
                            return null;
                        }
                        return super.visitMemberSelect(tree, type);
                    }
                };
            }
        };
    }

    @Override
    public AnnotationMirror aliasedAnnotation(AnnotationMirror a) {
        if (AnnotationUtils.areSameByClass(a, IndexFor.class) || AnnotationUtils.areSameByClass(a, SearchIndexFor.class) || AnnotationUtils.areSameByClass(a, NegativeIndexFor.class)) {
            List<String> stringList = AnnotationUtils.getElementValueArray(a, "value", String.class, true);
            return this.createLTLengthOfAnnotation(stringList.toArray(new String[0]));
        }
        if (AnnotationUtils.areSameByClass(a, IndexOrLow.class)) {
            List<String> stringList = AnnotationUtils.getElementValueArray(a, "value", String.class, true);
            return this.createLTLengthOfAnnotation(stringList.toArray(new String[0]));
        }
        if (AnnotationUtils.areSameByClass(a, IndexOrHigh.class) || AnnotationUtils.areSameByClass(a, LengthOf.class)) {
            List<String> stringList = AnnotationUtils.getElementValueArray(a, "value", String.class, true);
            return this.createLTEqLengthOfAnnotation(stringList.toArray(new String[0]));
        }
        return super.aliasedAnnotation(a);
    }

    public AnnotationMirror sameLenAnnotationFromTree(Tree tree) {
        AnnotatedTypeMirror sameLenType = this.getSameLenAnnotatedTypeFactory().getAnnotatedType(tree);
        return sameLenType.getAnnotation(SameLen.class);
    }

    public boolean isMathMin(Tree methodTree) {
        return this.imf.isMathMin(methodTree, this.processingEnv);
    }

    public boolean isRandomNextInt(Tree methodTree) {
        return this.imf.isRandomNextInt(methodTree, this.processingEnv);
    }

    AnnotationMirror createLTLengthOfAnnotation(String ... names) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), LTLengthOf.class);
        if (names == null) {
            names = new String[]{};
        }
        builder.setValue((CharSequence)"value", names);
        return builder.build();
    }

    AnnotationMirror createLTEqLengthOfAnnotation(String ... names) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), LTEqLengthOf.class);
        if (names == null) {
            names = new String[]{};
        }
        builder.setValue((CharSequence)"value", names);
        return builder.build();
    }

    public boolean hasLowerBoundTypeByClass(Node node, Class<? extends Annotation> classOfType) {
        return AnnotationUtils.areSameByClass(this.getLowerBoundAnnotatedTypeFactory().getAnnotatedType(node.getTree()).getAnnotationInHierarchy(this.getLowerBoundAnnotatedTypeFactory().UNKNOWN), classOfType);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new UpperBoundQualifierHierarchy(factory);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new UpperBoundTreeAnnotator(this), super.createTreeAnnotator());
    }

    public AnnotationMirror convertUBQualifierToAnnotation(UBQualifier qualifier) {
        if (qualifier.isUnknown()) {
            return this.UNKNOWN;
        }
        if (qualifier.isBottom()) {
            return this.BOTTOM;
        }
        if (qualifier.isPoly()) {
            return this.POLY;
        }
        UBQualifier.LessThanLengthOf ltlQualifier = (UBQualifier.LessThanLengthOf)qualifier;
        return ltlQualifier.convertToAnnotationMirror(this.processingEnv);
    }

    protected class UpperBoundTreeAnnotator
    extends TreeAnnotator {
        public UpperBoundTreeAnnotator(UpperBoundAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            if (UpperBoundAnnotatedTypeFactory.this.isMathMin(tree)) {
                AnnotatedTypeMirror leftType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(0));
                AnnotatedTypeMirror rightType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(1));
                type.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.qualHierarchy.greatestLowerBound(leftType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN), rightType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN)));
            }
            if (UpperBoundAnnotatedTypeFactory.this.isRandomNextInt(tree)) {
                AnnotatedTypeMirror argType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(0));
                AnnotationMirror anno = argType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                UBQualifier qualifier = UBQualifier.createUBQualifier(anno);
                qualifier = qualifier.plusOffset(1);
                type.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(qualifier));
            }
            return (Void)super.visitMethodInvocation(tree, type);
        }

        @Override
        public Void visitUnary(UnaryTree node, AnnotatedTypeMirror type) {
            if (node.getKind() == Tree.Kind.BITWISE_COMPLEMENT) {
                this.addAnnotationForBitwiseComplement(UpperBoundAnnotatedTypeFactory.this.getSearchIndexAnnotatedTypeFactory().getAnnotatedType(node.getExpression()), type);
            } else {
                type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
            return (Void)super.visitUnary(node, type);
        }

        private void addAnnotationForBitwiseComplement(AnnotatedTypeMirror searchIndexType, AnnotatedTypeMirror typeDst) {
            if (AnnotationUtils.containsSameByClass(searchIndexType.getAnnotations(), NegativeIndexFor.class)) {
                AnnotationMirror nif = searchIndexType.getAnnotation(NegativeIndexFor.class);
                List<String> arrays = IndexUtil.getValueOfAnnotationWithStringArgument(nif);
                List<String> negativeOnes = Collections.nCopies(arrays.size(), "-1");
                UBQualifier qual = UBQualifier.createUBQualifier(arrays, negativeOnes);
                typeDst.addAnnotation(UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(qual));
            } else {
                typeDst.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            return (Void)super.visitCompoundAssignment(node, type);
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isStringConcatenation(tree)) {
                type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                return super.visitBinary(tree, type);
            }
            ExpressionTree left = tree.getLeftOperand();
            ExpressionTree right = tree.getRightOperand();
            switch (tree.getKind()) {
                case PLUS: 
                case MINUS: {
                    type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                    break;
                }
                case MULTIPLY: {
                    this.addAnnotationForMultiply(left, right, type);
                    break;
                }
                case DIVIDE: {
                    this.addAnnotationForDivide(left, right, type);
                    break;
                }
                case AND: {
                    this.addAnnotationForAnd(left, right, type);
                    break;
                }
            }
            return super.visitBinary(tree, type);
        }

        private void addAnnotationForAnd(ExpressionTree left, ExpressionTree right, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror leftType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(left);
            AnnotatedTypeMirror leftLBType = UpperBoundAnnotatedTypeFactory.this.getLowerBoundAnnotatedTypeFactory().getAnnotatedType(left);
            AnnotationMirror leftResultType = UpperBoundAnnotatedTypeFactory.this.UNKNOWN;
            if (leftLBType.hasAnnotation(NonNegative.class) || leftLBType.hasAnnotation(Positive.class)) {
                leftResultType = leftType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
            AnnotatedTypeMirror rightType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(right);
            AnnotatedTypeMirror rightLBType = UpperBoundAnnotatedTypeFactory.this.getLowerBoundAnnotatedTypeFactory().getAnnotatedType(right);
            AnnotationMirror rightResultType = UpperBoundAnnotatedTypeFactory.this.UNKNOWN;
            if (rightLBType.hasAnnotation(NonNegative.class) || rightLBType.hasAnnotation(Positive.class)) {
                rightResultType = rightType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.qualHierarchy.greatestLowerBound(leftResultType, rightResultType));
        }

        private void addAnnotationForDivide(ExpressionTree numeratorTree, ExpressionTree divisorTree, AnnotatedTypeMirror resultType) {
            Long divisor = IndexUtil.getExactValue(divisorTree, UpperBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory());
            if (divisor == null) {
                resultType.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                return;
            }
            UBQualifier result = UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
            UBQualifier numerator = UBQualifier.createUBQualifier(UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(numeratorTree), UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            if (numerator.isLessThanLengthQualifier()) {
                result = ((UBQualifier.LessThanLengthOf)numerator).divide(divisor.intValue());
            }
            result = result.glb(this.plusTreeDivideByVal(divisor.intValue(), numeratorTree));
            if (TreeUtils.isArrayLengthAccess(numeratorTree) && divisor > 1L) {
                String arrayName = ((MemberSelectTree)numeratorTree).getExpression().toString();
                int minlen = UpperBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory().getMinLenFromString(arrayName, numeratorTree, UpperBoundAnnotatedTypeFactory.this.getPath(numeratorTree));
                if (minlen > 0) {
                    result = result.glb(UBQualifier.createUBQualifier(arrayName, "0"));
                }
            }
            resultType.addAnnotation(UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(result));
        }

        private UBQualifier plusTreeDivideByVal(int divisor, ExpressionTree numeratorTree) {
            numeratorTree = TreeUtils.skipParens(numeratorTree);
            if (divisor < 2 || numeratorTree.getKind() != Tree.Kind.PLUS) {
                return UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
            }
            BinaryTree plusTree = (BinaryTree)numeratorTree;
            UBQualifier left = UBQualifier.createUBQualifier(UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(plusTree.getLeftOperand()), UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            UBQualifier right = UBQualifier.createUBQualifier(UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(plusTree.getRightOperand()), UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            if (left.isLessThanLengthQualifier() && right.isLessThanLengthQualifier()) {
                UBQualifier.LessThanLengthOf leftLTL = (UBQualifier.LessThanLengthOf)left;
                UBQualifier.LessThanLengthOf rightLTL = (UBQualifier.LessThanLengthOf)right;
                ArrayList<String> arrays = new ArrayList<String>();
                for (String string : leftLTL.getArrays()) {
                    if (!rightLTL.isLessThanLengthOf(string) || !leftLTL.isLessThanLengthOf(string)) continue;
                    arrays.add(string);
                }
                if (!arrays.isEmpty()) {
                    return UBQualifier.createUBQualifier(arrays, Collections.emptyList());
                }
            }
            return UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
        }

        private boolean checkForMathRandomSpecialCase(ExpressionTree randTree, ExpressionTree arrLenTree, AnnotatedTypeMirror type) {
            if (randTree.getKind() == Tree.Kind.METHOD_INVOCATION && TreeUtils.isArrayLengthAccess(arrLenTree)) {
                MemberSelectTree mstree = (MemberSelectTree)arrLenTree;
                MethodInvocationTree mitree = (MethodInvocationTree)randTree;
                if (UpperBoundAnnotatedTypeFactory.this.imf.isMathRandom(mitree, UpperBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(mstree.getExpression().toString()));
                    return true;
                }
                if (UpperBoundAnnotatedTypeFactory.this.imf.isRandomNextDouble(mitree, UpperBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(mstree.getExpression().toString()));
                    return true;
                }
            }
            return false;
        }

        private void addAnnotationForMultiply(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            if (this.checkForMathRandomSpecialCase(rightExpr, leftExpr, type) || this.checkForMathRandomSpecialCase(leftExpr, rightExpr, type)) {
                return;
            }
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
        }
    }

    protected final class UpperBoundQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public UpperBoundQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            UBQualifier a1Obj = UBQualifier.createUBQualifier(a1);
            UBQualifier a2Obj = UBQualifier.createUBQualifier(a2);
            UBQualifier glb = a1Obj.glb(a2Obj);
            return UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(glb);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            UBQualifier a1Obj = UBQualifier.createUBQualifier(a1);
            UBQualifier a2Obj = UBQualifier.createUBQualifier(a2);
            UBQualifier lub = a1Obj.lub(a2Obj);
            return UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(lub);
        }

        @Override
        public AnnotationMirror widenUpperBound(AnnotationMirror a, AnnotationMirror b) {
            UBQualifier a1Obj = UBQualifier.createUBQualifier(a);
            UBQualifier a2Obj = UBQualifier.createUBQualifier(b);
            UBQualifier lub = a1Obj.widenUpperBound(a2Obj);
            return UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(lub);
        }

        @Override
        public boolean implementsWidening() {
            return true;
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            UBQualifier subtype = UBQualifier.createUBQualifier(subAnno);
            UBQualifier supertype = UBQualifier.createUBQualifier(superAnno);
            return subtype.isSubtype(supertype);
        }
    }
}

