/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.KeyForPropagationTreeAnnotator;
import org.checkerframework.checker.nullness.KeyForPropagator;
import org.checkerframework.checker.nullness.compatqual.KeyForDecl;
import org.checkerframework.checker.nullness.compatqual.KeyForType;
import org.checkerframework.checker.nullness.qual.Covariant;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.PolyKeyFor;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.DefaultTypeHierarchy;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.visitor.VisitHistory;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.typeinference.TypeArgInferenceUtil;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TypesUtils;

public class KeyForAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror UNKNOWNKEYFOR;
    protected final AnnotationMirror KEYFOR = AnnotationUtils.fromClass(this.elements, KeyFor.class);
    protected final AnnotationMirror KEYFORBOTTOM;
    private final KeyForPropagator keyForPropagator;
    private TypeMirror erasedMapType = null;

    public KeyForAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker, true);
        this.UNKNOWNKEYFOR = AnnotationUtils.fromClass(this.elements, UnknownKeyFor.class);
        this.KEYFORBOTTOM = AnnotationUtils.fromClass(this.elements, KeyForBottom.class);
        this.keyForPropagator = new KeyForPropagator(this.UNKNOWNKEYFOR);
        this.addAliasedAnnotation(KeyForDecl.class, this.KEYFOR);
        this.addAliasedAnnotation(KeyForType.class, this.KEYFOR);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(KeyFor.class, UnknownKeyFor.class, KeyForBottom.class, PolyKeyFor.class, PolyAll.class));
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> constructorFromUse(NewClassTree tree) {
        AnnotatedTypeMirror assignedTo;
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> result = super.constructorFromUse(tree);
        AnnotatedTypeMirror returnType = ((AnnotatedTypeMirror.AnnotatedExecutableType)result.first).getReturnType();
        Pair<Tree, AnnotatedTypeMirror> context = this.getVisitorState().getAssignmentContext();
        if (returnType.getKind() == TypeKind.DECLARED && context != null && context.first != null && (assignedTo = TypeArgInferenceUtil.assignedTo(this, this.getPath(tree))) != null && assignedTo.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType newClassType = (AnnotatedTypeMirror.AnnotatedDeclaredType)returnType;
            this.keyForPropagator.propagate(newClassType, (AnnotatedTypeMirror.AnnotatedDeclaredType)assignedTo, KeyForPropagator.PropagationDirection.TO_SUBTYPE, this);
        }
        return result;
    }

    @Override
    protected TypeHierarchy createTypeHierarchy() {
        return new KeyForTypeHierarchy(this.checker, this.getQualifierHierarchy(), this.checker.getOption("ignoreRawTypeArguments", "true").equals("true"), this.checker.hasOption("invariantArrays"));
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new KeyForPropagationTreeAnnotator(this, this.keyForPropagator));
    }

    public AnnotationMirror createKeyForAnnotationMirrorWithValue(LinkedHashSet<String> values) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), KeyFor.class);
        builder.setValue((CharSequence)"value", values.toArray());
        return builder.build();
    }

    public AnnotationMirror createKeyForAnnotationMirrorWithValue(String value) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        values.add(value);
        return this.createKeyForAnnotationMirrorWithValue(values);
    }

    public boolean isKeyForMap(String mapExpression, ExpressionTree tree) {
        AnnotatedTypeMirror type = this.getAnnotatedType(tree);
        AnnotationMirror keyForAnno = type.getAnnotation(KeyFor.class);
        if (keyForAnno == null) {
            return false;
        }
        List<String> val = AnnotationUtils.getElementValueArray(keyForAnno, "value", String.class, false);
        return val.contains(mapExpression);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new KeyForQualifierHierarchy(factory);
    }

    protected boolean isInvocationOfMapMethod(MethodInvocationNode n, String methodName) {
        String invokedMethod = this.getMethodName(n);
        if (invokedMethod.equals(methodName)) {
            TypeMirror receiverType;
            if (this.erasedMapType == null) {
                TypeMirror mapType = TypesUtils.typeFromClass(this.types, this.elements, Map.class);
                this.erasedMapType = this.types.erasure(mapType);
            }
            if (this.types.isSubtype(receiverType = this.types.erasure(n.getTarget().getReceiver().getType()), this.erasedMapType)) {
                return true;
            }
        }
        return false;
    }

    protected String getMethodName(MethodInvocationNode n) {
        String invokedMethod = n.getTarget().getMethod().toString();
        int index = invokedMethod.indexOf("(");
        assert (index != -1) : this.getClass() + ": expected method name to contain (";
        invokedMethod = invokedMethod.substring(0, index);
        return invokedMethod;
    }

    private final class KeyForQualifierHierarchy
    extends GraphQualifierHierarchy {
        public KeyForQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory, KeyForAnnotatedTypeFactory.this.KEYFORBOTTOM);
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            if (AnnotationUtils.areSameIgnoringValues(superAnno, KeyForAnnotatedTypeFactory.this.KEYFOR) && AnnotationUtils.areSameIgnoringValues(subAnno, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                List<Object> lhsValues = null;
                List<Object> rhsValues = null;
                Map<? extends ExecutableElement, ? extends AnnotationValue> valMap = superAnno.getElementValues();
                lhsValues = valMap.isEmpty() ? new ArrayList() : AnnotationUtils.getElementValueArray(superAnno, "value", String.class, true);
                valMap = subAnno.getElementValues();
                rhsValues = valMap.isEmpty() ? new ArrayList() : AnnotationUtils.getElementValueArray(subAnno, "value", String.class, true);
                return rhsValues.containsAll(lhsValues);
            }
            if (AnnotationUtils.areSameIgnoringValues(superAnno, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                superAnno = KeyForAnnotatedTypeFactory.this.KEYFOR;
            }
            if (AnnotationUtils.areSameIgnoringValues(subAnno, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                subAnno = KeyForAnnotatedTypeFactory.this.KEYFOR;
            }
            return super.isSubtype(subAnno, superAnno);
        }
    }

    protected static class KeyForTypeHierarchy
    extends DefaultTypeHierarchy {
        public KeyForTypeHierarchy(BaseTypeChecker checker, QualifierHierarchy qualifierHierarchy, boolean ignoreRawTypes, boolean invariantArrayComponents) {
            super(checker, qualifierHierarchy, ignoreRawTypes, invariantArrayComponents);
        }

        @Override
        public boolean isSubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
            if (supertype.getKind() == TypeKind.TYPEVAR && subtype.getKind() == TypeKind.TYPEVAR && supertype.getAnnotations().isEmpty()) {
                return true;
            }
            if (subtype.hasAnnotation(KeyForBottom.class)) {
                return true;
            }
            return super.isSubtype(subtype, supertype, visited);
        }

        protected boolean isCovariant(int typeArgIndex, int[] covariantArgIndexes) {
            if (covariantArgIndexes != null) {
                for (int covariantIndex : covariantArgIndexes) {
                    if (typeArgIndex != covariantIndex) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Boolean visitTypeArgs(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited, boolean subtypeIsRaw, boolean supertypeIsRaw) {
            boolean ignoreTypeArgs;
            boolean bl = ignoreTypeArgs = this.ignoreRawTypes && (subtypeIsRaw || supertypeIsRaw);
            if (!ignoreTypeArgs) {
                TypeElement supertypeElem = (TypeElement)supertype.getUnderlyingType().asElement();
                int[] covariantArgIndexes = null;
                if (supertypeElem.getAnnotation(Covariant.class) != null) {
                    covariantArgIndexes = supertypeElem.getAnnotation(Covariant.class).value();
                }
                List<AnnotatedTypeMirror> subtypeTypeArgs = subtype.getTypeArguments();
                List<AnnotatedTypeMirror> supertypeTypeArgs = supertype.getTypeArguments();
                if (subtypeTypeArgs.isEmpty() || supertypeTypeArgs.isEmpty()) {
                    return true;
                }
                if (supertypeTypeArgs.size() > 0) {
                    for (int i = 0; i < supertypeTypeArgs.size(); ++i) {
                        AnnotatedTypeMirror superTypeArg = supertypeTypeArgs.get(i);
                        AnnotatedTypeMirror subTypeArg = subtypeTypeArgs.get(i);
                        if (subtypeIsRaw || supertypeIsRaw) {
                            this.rawnessComparer.isValidInHierarchy(subtype, supertype, this.currentTop, visited);
                            continue;
                        }
                        if (this.isContainedBy(subTypeArg, superTypeArg, visited, this.isCovariant(i, covariantArgIndexes))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

