/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signedness;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.signedness.SignednessAnnotatedTypeFactory;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.TreeUtils;

public class SignednessVisitor
extends BaseTypeVisitor<SignednessAnnotatedTypeFactory> {
    public SignednessVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    private boolean isMask(Tree node) {
        Tree.Kind kind = node.getKind();
        return kind == Tree.Kind.AND || kind == Tree.Kind.OR;
    }

    private PrimitiveTypeTree primitiveTypeCast(Tree node) {
        if (node.getKind() != Tree.Kind.TYPE_CAST) {
            return null;
        }
        TypeCastTree cast = (TypeCastTree)node;
        Tree castType = cast.getType();
        if (castType.getKind() != Tree.Kind.ANNOTATED_TYPE) {
            return null;
        }
        AnnotatedTypeTree annotatedType = (AnnotatedTypeTree)castType;
        ExpressionTree underlyingType = annotatedType.getUnderlyingType();
        if (underlyingType.getKind() != Tree.Kind.PRIMITIVE_TYPE) {
            return null;
        }
        return (PrimitiveTypeTree)((Object)underlyingType);
    }

    private boolean isLiteral(ExpressionTree expr) {
        return expr instanceof LiteralTree;
    }

    private long getLong(Object obj) {
        if (obj instanceof Integer) {
            Integer intObj = (Integer)obj;
            return intObj.longValue();
        }
        return (Long)obj;
    }

    private boolean maskIgnoresMSB(Tree.Kind maskKind, LiteralTree shiftAmountLit, LiteralTree maskLit) {
        long shiftAmount = this.getLong(shiftAmountLit.getValue());
        long mask = this.getLong(maskLit.getValue());
        if (maskLit.getKind() != Tree.Kind.LONG_LITERAL) {
            mask <<= 32;
        }
        mask >>>= (int)(64L - shiftAmount);
        if (maskKind == Tree.Kind.AND) {
            return mask == 0L;
        }
        if (maskKind == Tree.Kind.OR) {
            return mask == (long)((1 << (int)shiftAmount) - 1);
        }
        throw new RuntimeException("Invalid Masking Operation");
    }

    private boolean castIgnoresMSB(TypeKind shiftTypeKind, TypeKind castTypeKind, LiteralTree shiftAmountLit) {
        long castBits;
        long shiftAmount;
        long shiftBits;
        switch (shiftTypeKind) {
            case INT: {
                shiftBits = 32L;
                shiftAmount = 0x1FL & this.getLong(shiftAmountLit.getValue());
                break;
            }
            case LONG: {
                shiftBits = 64L;
                shiftAmount = 0x3FL & this.getLong(shiftAmountLit.getValue());
                break;
            }
            default: {
                throw new RuntimeException("Invalid shift type");
            }
        }
        switch (castTypeKind) {
            case BYTE: {
                castBits = 8L;
                break;
            }
            case CHAR: {
                castBits = 8L;
                break;
            }
            case SHORT: {
                castBits = 16L;
                break;
            }
            case INT: {
                castBits = 32L;
                break;
            }
            case LONG: {
                castBits = 64L;
                break;
            }
            default: {
                throw new RuntimeException("Invalid cast target");
            }
        }
        long bitsDiscarded = shiftBits - castBits;
        return shiftAmount <= bitsDiscarded || shiftAmount == 0L;
    }

    private boolean isMaskedShift(BinaryTree shiftExpr) {
        Tree enclosing;
        TreePath parentPath = this.visitorState.getPath().getParentPath();
        Tree enclosingChild = enclosing = parentPath.getLeaf();
        while (enclosing.getKind() == Tree.Kind.PARENTHESIZED) {
            parentPath = parentPath.getParentPath();
            enclosingChild = enclosing;
            enclosing = parentPath.getLeaf();
        }
        if (!this.isMask(enclosing)) {
            return false;
        }
        BinaryTree maskExpr = (BinaryTree)enclosing;
        ExpressionTree shiftAmountExpr = shiftExpr.getRightOperand();
        ExpressionTree mask = maskExpr.getRightOperand() == enclosingChild ? maskExpr.getLeftOperand() : maskExpr.getRightOperand();
        mask = TreeUtils.skipParens(mask);
        if (!this.isLiteral(shiftAmountExpr) || !this.isLiteral(mask)) {
            return false;
        }
        LiteralTree shiftLit = (LiteralTree)shiftAmountExpr;
        LiteralTree maskLit = (LiteralTree)mask;
        return this.maskIgnoresMSB(maskExpr.getKind(), shiftLit, maskLit);
    }

    private boolean isCastedShift(BinaryTree shiftExpr) {
        TreePath parentPath = this.visitorState.getPath().getParentPath();
        Tree enclosing = parentPath.getLeaf();
        while (enclosing.getKind() == Tree.Kind.PARENTHESIZED) {
            parentPath = parentPath.getParentPath();
            enclosing = parentPath.getLeaf();
        }
        PrimitiveTypeTree castPrimitiveType = this.primitiveTypeCast(enclosing);
        if (castPrimitiveType == null) {
            return false;
        }
        TypeKind castTypeKind = castPrimitiveType.getPrimitiveTypeKind();
        TypeKind shiftTypeKind = ((SignednessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(shiftExpr).getUnderlyingType().getKind();
        ExpressionTree shiftAmountExpr = shiftExpr.getRightOperand();
        if (!this.isLiteral(shiftAmountExpr)) {
            return false;
        }
        LiteralTree shiftLit = (LiteralTree)shiftAmountExpr;
        return this.castIgnoresMSB(shiftTypeKind, castTypeKind, shiftLit);
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        ExpressionTree leftOp = node.getLeftOperand();
        ExpressionTree rightOp = node.getRightOperand();
        AnnotatedTypeMirror leftOpType = ((SignednessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(leftOp);
        AnnotatedTypeMirror rightOpType = ((SignednessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(rightOp);
        Tree.Kind kind = node.getKind();
        switch (kind) {
            case DIVIDE: 
            case REMAINDER: {
                if (leftOpType.hasAnnotation(Unsigned.class)) {
                    this.checker.report(Result.failure("operation.unsignedlhs", new Object[]{kind}), leftOp);
                    break;
                }
                if (!rightOpType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("operation.unsignedrhs", new Object[]{kind}), rightOp);
                break;
            }
            case RIGHT_SHIFT: {
                if (!leftOpType.hasAnnotation(Unsigned.class) || this.isMaskedShift(node) || this.isCastedShift(node)) break;
                this.checker.report(Result.failure("shift.signed", new Object[]{kind}), leftOp);
                break;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                if (!leftOpType.hasAnnotation(Signed.class) || this.isMaskedShift(node) || this.isCastedShift(node)) break;
                this.checker.report(Result.failure("shift.unsigned", new Object[]{kind}), leftOp);
                break;
            }
            case LEFT_SHIFT: {
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: {
                if (leftOpType.hasAnnotation(Unsigned.class)) {
                    this.checker.report(Result.failure("comparison.unsignedlhs", new Object[0]), leftOp);
                    break;
                }
                if (!rightOpType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("comparison.unsignedrhs", new Object[0]), rightOp);
                break;
            }
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                if (leftOpType.hasAnnotation(Unsigned.class) && rightOpType.hasAnnotation(Signed.class)) {
                    this.checker.report(Result.failure("comparison.mixed.unsignedlhs", new Object[0]), node);
                    break;
                }
                if (!leftOpType.hasAnnotation(Signed.class) || !rightOpType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("comparison.mixed.unsignedrhs", new Object[0]), node);
                break;
            }
            default: {
                if (leftOpType.hasAnnotation(Unsigned.class) && rightOpType.hasAnnotation(Signed.class)) {
                    this.checker.report(Result.failure("operation.mixed.unsignedlhs", new Object[]{kind}), node);
                    break;
                }
                if (!leftOpType.hasAnnotation(Signed.class) || !rightOpType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("operation.mixed.unsignedrhs", new Object[]{kind}), node);
            }
        }
        return (Void)super.visitBinary(node, p);
    }

    private String kindWithOutAssignment(Tree.Kind kind) {
        String result = kind.toString();
        if (result.endsWith("_ASSIGNMENT")) {
            return result.substring(0, result.length() - "_ASSIGNMENT".length());
        }
        return result;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        ExpressionTree var = node.getVariable();
        ExpressionTree expr = node.getExpression();
        AnnotatedTypeMirror varType = ((SignednessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(var);
        AnnotatedTypeMirror exprType = ((SignednessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(expr);
        Tree.Kind kind = node.getKind();
        switch (kind) {
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: {
                if (varType.hasAnnotation(Unsigned.class)) {
                    this.checker.report(Result.failure("compound.assignment.unsigned.variable", this.kindWithOutAssignment(kind)), var);
                    break;
                }
                if (!exprType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("compound.assignment.unsigned.expression", this.kindWithOutAssignment(kind)), expr);
                break;
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                if (!varType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("compound.assignment.shift.signed", this.kindWithOutAssignment(kind), "unsigned"), var);
                break;
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                if (!varType.hasAnnotation(Signed.class)) break;
                this.checker.report(Result.failure("compound.assignment.shift.unsigned", this.kindWithOutAssignment(kind), "signed"), var);
                break;
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                break;
            }
            default: {
                if (varType.hasAnnotation(Unsigned.class) && exprType.hasAnnotation(Signed.class)) {
                    this.checker.report(Result.failure("compound.assignment.mixed.unsigned.variable", this.kindWithOutAssignment(kind)), expr);
                    break;
                }
                if (!varType.hasAnnotation(Signed.class) || !exprType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("compound.assignment.mixed.unsigned.expression", this.kindWithOutAssignment(kind)), expr);
            }
        }
        return super.visitCompoundAssignment(node, p);
    }
}

