/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.BoolVal;
import org.checkerframework.common.value.qual.DoubleVal;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.common.value.qual.IntRangeFromPositive;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.SimpleAnnotatedTypeScanner;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.InternalUtils;

public class ValueVisitor
extends BaseTypeVisitor<ValueAnnotatedTypeFactory> {
    public ValueVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    private long getIntLiteralValue(LiteralTree exp) {
        Object orgValue = exp.getValue();
        switch (exp.getKind()) {
            case INT_LITERAL: 
            case LONG_LITERAL: {
                return ((Number)orgValue).longValue();
            }
            case CHAR_LITERAL: {
                return ((Character)orgValue).charValue();
            }
        }
        throw new IllegalArgumentException("exp is not an intergral literal (INT_LITERAL, LONG_LITERAL, CHAR_LITERAL)");
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, ExpressionTree valueExp, @CompilerMessageKey String errorKey) {
        SimpleAnnotatedTypeScanner<Void, Void> replaceIntRangeFromPositive = new SimpleAnnotatedTypeScanner<Void, Void>(){

            @Override
            protected Void defaultAction(AnnotatedTypeMirror type, Void p) {
                if (type.hasAnnotation(IntRangeFromPositive.class)) {
                    type.replaceAnnotation(((ValueAnnotatedTypeFactory)((ValueVisitor)ValueVisitor.this).atypeFactory).UNKNOWNVAL);
                }
                return null;
            }
        };
        replaceIntRangeFromPositive.visit(varType);
        super.commonAssignmentCheck(varType, valueExp, errorKey);
    }

    @Override
    protected ValueAnnotatedTypeFactory createTypeFactory() {
        return new ValueAnnotatedTypeFactory(this.checker);
    }

    @Override
    public Void visitAnnotation(AnnotationTree node, Void p) {
        List<? extends ExpressionTree> args = node.getArguments();
        if (args.isEmpty()) {
            return super.visitAnnotation(node, p);
        }
        AnnotationMirror anno = InternalUtils.annotationFromAnnotationTree(node);
        if (AnnotationUtils.areSameByClass(anno, IntRange.class)) {
            long to;
            long from;
            if (args.size() == 2 && (from = AnnotationUtils.getElementValue(anno, "from", Long.class, true).longValue()) > (to = AnnotationUtils.getElementValue(anno, "to", Long.class, true).longValue())) {
                this.checker.report(Result.failure("from.greater.than.to", new Object[0]), node);
                return null;
            }
        } else if (AnnotationUtils.areSameByClass(anno, ArrayLen.class) || AnnotationUtils.areSameByClass(anno, BoolVal.class) || AnnotationUtils.areSameByClass(anno, DoubleVal.class) || AnnotationUtils.areSameByClass(anno, IntVal.class) || AnnotationUtils.areSameByClass(anno, StringVal.class)) {
            List<Integer> arrayLens;
            List<Object> values = AnnotationUtils.getElementValueArray(anno, "value", Object.class, true);
            if (values.isEmpty()) {
                this.checker.report(Result.warning("no.values.given", new Object[0]), node);
                return null;
            }
            if (values.size() > 10) {
                this.checker.report(Result.warning(AnnotationUtils.areSameByClass(anno, IntVal.class) ? "too.many.values.given.int" : "too.many.values.given", 10), node);
                return null;
            }
            if (AnnotationUtils.areSameByClass(anno, ArrayLen.class) && Collections.min(arrayLens = AnnotationUtils.getElementValueArray(anno, "value", Integer.class, true)) < 0) {
                this.checker.report(Result.warning("negative.arraylen", Collections.min(arrayLens)), node);
                return null;
            }
        } else if (AnnotationUtils.areSameByClass(anno, ArrayLenRange.class)) {
            int to;
            int from = AnnotationUtils.getElementValue(anno, "from", Integer.class, true);
            if (from > (to = AnnotationUtils.getElementValue(anno, "to", Integer.class, true).intValue())) {
                this.checker.report(Result.failure("from.greater.than.to", new Object[0]), node);
                return null;
            }
            if (from < 0) {
                this.checker.report(Result.warning("negative.arraylen", from), node);
                return null;
            }
        }
        return super.visitAnnotation(node, p);
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Void p) {
        if (node.getExpression().getKind() == Tree.Kind.NULL_LITERAL) {
            return null;
        }
        return super.visitTypeCast(node, p);
    }
}

