/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import plume.Partitioner;
import plume.RandomSelector;

public class MultiRandSelector<T> {
    private int num_elts = -1;
    private boolean coin_toss_mode;
    private double keep_probability = -1.0;
    private Random seed;
    private Partitioner<T, T> eq;
    private HashMap<T, RandomSelector<T>> map;

    public MultiRandSelector(int num_elts, Partitioner<T, T> eq) {
        this(num_elts, new Random(), eq);
    }

    public MultiRandSelector(double keep_prob, Partitioner<T, T> eq) {
        this(keep_prob, new Random(), eq);
    }

    public MultiRandSelector(int num_elts, Random r, Partitioner<T, T> eq) {
        this.coin_toss_mode = false;
        this.num_elts = num_elts;
        this.seed = r;
        this.eq = eq;
        this.map = new HashMap();
    }

    public MultiRandSelector(double keep_prob, Random r, Partitioner<T, T> eq) {
        this.keep_probability = keep_prob;
        this.coin_toss_mode = true;
        this.seed = r;
        this.eq = eq;
        this.map = new HashMap();
    }

    public void acceptIter(Iterator<T> iter) {
        while (iter.hasNext()) {
            this.accept(iter.next());
        }
    }

    public void accept(T next) {
        T equivClass = this.eq.assignToBucket(next);
        if (equivClass == null) {
            return;
        }
        RandomSelector<T> delegation = this.map.get(equivClass);
        if (delegation == null) {
            delegation = this.coin_toss_mode ? new RandomSelector(this.keep_probability, this.seed) : new RandomSelector(this.num_elts, this.seed);
            this.map.put(equivClass, delegation);
        }
        delegation.accept(next);
    }

    public Map<T, RandomSelector<T>> values() {
        return this.map;
    }

    public Iterator<T> valuesIter() {
        ArrayList<T> ret = new ArrayList<T>();
        for (RandomSelector<T> rs : this.map.values()) {
            ret.addAll(rs.getValues());
        }
        return ret.iterator();
    }
}

