/*
 * Decompiled with CFR 0.152.
 */
package annotations.el;

import annotations.Annotation;
import annotations.Annotations;
import annotations.el.AElement;
import annotations.field.AnnotationFieldType;
import java.io.File;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class AnnotationDef
extends AElement {
    public final String name;
    public Map<String, AnnotationFieldType> fieldTypes;

    public AnnotationDef(String name) {
        super("annotation: " + name);
        assert (name != null);
        this.name = name;
    }

    @Override
    public AnnotationDef clone() {
        throw new UnsupportedOperationException("can't duplicate AnnotationDefs");
    }

    public static AnnotationDef fromClass(Class<? extends java.lang.annotation.Annotation> annoType, Map<String, AnnotationDef> adefs) {
        java.lang.annotation.Annotation[] jannos;
        String name = annoType.getName();
        assert (name != null);
        if (adefs.containsKey(name)) {
            return adefs.get(name);
        }
        LinkedHashMap<String, AnnotationFieldType> fieldTypes = new LinkedHashMap<String, AnnotationFieldType>();
        for (Method m3 : annoType.getDeclaredMethods()) {
            AnnotationFieldType aft = AnnotationFieldType.fromClass(m3.getReturnType(), adefs);
            fieldTypes.put(m3.getName(), aft);
        }
        AnnotationDef result = new AnnotationDef(name, Annotations.noAnnotations, fieldTypes);
        adefs.put(name, result);
        try {
            jannos = annoType.getDeclaredAnnotations();
        }
        catch (Exception e) {
            AnnotationDef.printClasspath();
            throw new Error("Exception in anno.getDeclaredAnnotations() for anno = " + annoType, e);
        }
        for (java.lang.annotation.Annotation ja : jannos) {
            result.tlAnnotationsHere.add(new Annotation(ja, adefs));
        }
        return result;
    }

    public AnnotationDef(String name, Set<Annotation> tlAnnotationsHere) {
        super("annotation: " + name);
        assert (name != null);
        this.name = name;
        if (tlAnnotationsHere != null) {
            this.tlAnnotationsHere.addAll(tlAnnotationsHere);
        }
    }

    public AnnotationDef(String name, Set<Annotation> tlAnnotationsHere, Map<String, ? extends AnnotationFieldType> fieldTypes) {
        this(name, tlAnnotationsHere);
        this.setFieldTypes(fieldTypes);
    }

    public void setFieldTypes(Map<String, ? extends AnnotationFieldType> fieldTypes) {
        this.fieldTypes = Collections.unmodifiableMap(new LinkedHashMap<String, AnnotationFieldType>(fieldTypes));
    }

    public RetentionPolicy retention() {
        if (this.tlAnnotationsHere.contains(Annotations.aRetentionClass)) {
            return RetentionPolicy.CLASS;
        }
        if (this.tlAnnotationsHere.contains(Annotations.aRetentionRuntime)) {
            return RetentionPolicy.RUNTIME;
        }
        if (this.tlAnnotationsHere.contains(Annotations.aRetentionSource)) {
            return RetentionPolicy.SOURCE;
        }
        return null;
    }

    public boolean isTypeAnnotation() {
        return this.tlAnnotationsHere.contains(Annotations.aTargetTypeUse) || this.tlAnnotationsHere.contains(Annotations.aTypeQualifier);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof AnnotationDef && ((AnnotationDef)o).equals(this);
    }

    public boolean equals(AnnotationDef o) {
        boolean sameName = this.name.equals(o.name);
        boolean sameMetaAnnotations = this.equalsElement(o);
        boolean sameFieldTypes = this.fieldTypes.equals(o.fieldTypes);
        return sameName && sameMetaAnnotations && sameFieldTypes;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() + this.fieldTypes.hashCode();
    }

    public static AnnotationDef unify(AnnotationDef def1, AnnotationDef def2) {
        if (def1.equals(def2)) {
            return def1;
        }
        if (def1.name.equals(def2.name) && def1.equalsElement(def2) && def1.fieldTypes.keySet().equals(def2.fieldTypes.keySet())) {
            LinkedHashMap<String, AnnotationFieldType> newFieldTypes = new LinkedHashMap<String, AnnotationFieldType>();
            for (String fieldName : def1.fieldTypes.keySet()) {
                AnnotationFieldType aft2;
                AnnotationFieldType aft1 = def1.fieldTypes.get(fieldName);
                AnnotationFieldType uaft = AnnotationFieldType.unify(aft1, aft2 = def2.fieldTypes.get(fieldName));
                if (uaft == null) {
                    return null;
                }
                newFieldTypes.put(fieldName, uaft);
            }
            return new AnnotationDef(def1.name, def1.tlAnnotationsHere, newFieldTypes);
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Annotation annotation : this.tlAnnotationsHere) {
            if (!first) {
                sb.append(" ");
            } else {
                first = false;
            }
            sb.append(annotation);
        }
        sb.append("] ");
        sb.append("@");
        sb.append(this.name);
        sb.append("(");
        first = true;
        for (Map.Entry entry : this.fieldTypes.entrySet()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(((AnnotationFieldType)entry.getValue()).toString());
            sb.append(" ");
            sb.append((String)entry.getKey());
        }
        sb.append(")");
        return sb.toString();
    }

    public static void printClasspath() {
        System.out.println();
        System.out.println("Classpath:");
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String cpelt = tokenizer.nextToken();
            boolean exists = new File(cpelt).exists();
            if (!exists) {
                System.out.print(" non-existent:");
            }
            System.out.println("  " + cpelt);
        }
    }
}

