/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

final class EnclosedByCriterion
implements Criterion {
    private final Tree.Kind kind;

    EnclosedByCriterion(Tree.Kind kind) {
        this.kind = kind;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.ENCLOSED_BY;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        assert (path == null || path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        for (Tree tree : path) {
            if (tree.getKind() != this.kind) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "enclosed by '" + (Object)((Object)this.kind) + "'";
    }
}

