/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index;

import com.sun.source.tree.Tree;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.javacutil.TreeUtils;

public class IndexMethodIdentifier {
    private final ExecutableElement fcnRandom;
    private final ExecutableElement fcnNextDouble;
    private final ExecutableElement fcnNextInt;
    private final List<ExecutableElement> mathMinMethods;
    private final List<ExecutableElement> mathMaxMethods;

    public IndexMethodIdentifier(ProcessingEnvironment processingEnv) {
        this.fcnRandom = TreeUtils.getMethod("java.lang.Math", "random", 0, processingEnv);
        this.fcnNextDouble = TreeUtils.getMethod("java.util.Random", "nextDouble", 0, processingEnv);
        this.fcnNextInt = TreeUtils.getMethod("java.util.Random", "nextInt", 1, processingEnv);
        this.mathMinMethods = TreeUtils.getMethodList("java.lang.Math", "min", 2, processingEnv);
        this.mathMaxMethods = TreeUtils.getMethodList("java.lang.Math", "max", 2, processingEnv);
    }

    public boolean isMathMin(Tree methodTree, ProcessingEnvironment processingEnv) {
        return IndexMethodIdentifier.isInvocationOfOne(methodTree, processingEnv, this.mathMinMethods);
    }

    public boolean isMathMax(Tree methodTree, ProcessingEnvironment processingEnv) {
        return IndexMethodIdentifier.isInvocationOfOne(methodTree, processingEnv, this.mathMaxMethods);
    }

    private static boolean isInvocationOfOne(Tree methodTree, ProcessingEnvironment processingEnv, List<ExecutableElement> methods) {
        for (ExecutableElement minMethod : methods) {
            if (!TreeUtils.isMethodInvocation(methodTree, minMethod, processingEnv)) continue;
            return true;
        }
        return false;
    }

    public boolean isMathRandom(Tree tree, ProcessingEnvironment processingEnv) {
        return TreeUtils.isMethodInvocation(tree, this.fcnRandom, processingEnv);
    }

    public boolean isRandomNextDouble(Tree tree, ProcessingEnvironment processingEnv) {
        return TreeUtils.isMethodInvocation(tree, this.fcnNextDouble, processingEnv);
    }

    public boolean isRandomNextInt(Tree tree, ProcessingEnvironment processingEnv) {
        return TreeUtils.isMethodInvocation(tree, this.fcnNextInt, processingEnv);
    }
}

