/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.util.Range;
import org.checkerframework.framework.util.PluginUtil;

class RangeOrListOfValues {
    private Range range;
    private List<Integer> values;
    private boolean isRange;

    public RangeOrListOfValues() {
        this.values = new ArrayList<Integer>();
        this.isRange = false;
    }

    public RangeOrListOfValues(List<Integer> values) {
        this.values = new ArrayList<Integer>();
        this.isRange = false;
        this.addAll(values);
    }

    public RangeOrListOfValues(Range range) {
        this.range = range;
        this.isRange = true;
    }

    public void add(Range otherRange) {
        if (this.isRange) {
            this.range = this.range.union(otherRange);
        } else {
            this.convertToRange();
            this.add(otherRange);
        }
    }

    public void addAll(List<Integer> newValues) {
        if (this.isRange) {
            Range newValueRange = new Range(Collections.min(newValues).intValue(), Collections.max(newValues).intValue());
            this.range = this.range.union(newValueRange);
        } else {
            for (Integer i : newValues) {
                if (this.values.contains(i)) continue;
                this.values.add(i);
            }
            if (this.values.size() > 10) {
                this.convertToRange();
            }
        }
    }

    public AnnotationMirror createAnnotation(ValueAnnotatedTypeFactory atypefactory) {
        if (this.isRange) {
            return atypefactory.createArrayLenRangeAnnotation(this.range);
        }
        return atypefactory.createArrayLenAnnotation(this.values);
    }

    public static List<Integer> convertLongsToInts(List<Long> newValues) {
        ArrayList<Integer> result = new ArrayList<Integer>(newValues.size());
        for (Long l : newValues) {
            if (l > Integer.MAX_VALUE) {
                result.add(Integer.MAX_VALUE);
                continue;
            }
            if (l < Integer.MIN_VALUE) {
                result.add(Integer.MIN_VALUE);
                continue;
            }
            result.add(l.intValue());
        }
        return result;
    }

    public void convertToRange() {
        if (!this.isRange) {
            this.isRange = true;
            this.range = new Range(Collections.min(this.values).intValue(), Collections.max(this.values).intValue());
            this.values = null;
        }
    }

    public String toString() {
        if (this.isRange) {
            return this.range.toString();
        }
        if (this.values.size() == 0) {
            return "[]";
        }
        String res = "[";
        res = res + PluginUtil.join(", ", this.values);
        res = res + "]";
        return res;
    }
}

