/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import plume.EntryReader;
import plume.Option;
import plume.Options;
import plume.Pair;
import plume.TimeLimitProcess;
import plume.UtilMDE;

public class MultiVersionControl {
    @Option(value="User home directory", noDocDefault=true)
    public static String home = System.getProperty("user.home");
    @Option(value="File with list of checkouts.  Set it to /dev/null to suppress reading.")
    public String checkouts = "~/.mvc-checkouts";
    @Option(value="Directory under which to search for checkouts; default=home dir")
    public List<String> dir = new ArrayList<String>();
    @Option(value="Directory under which to NOT search for checkouts")
    public List<String> ignore_dir = new ArrayList<String>();
    private List<File> ignoreDirs = new ArrayList<File>();
    @Option(value="Search for all checkouts, not just those listed in a file")
    public boolean search = false;
    @Option(value="Display commands as they are executed")
    public boolean show = false;
    @Option(value="Print the directory before executing commands")
    public boolean print_directory = false;
    @Option(value="Do not execute commands; just print them.  Implies --show --redo-existing")
    public boolean dry_run = false;
    @Option(value="Redo existing checkouts; relevant only to checkout command")
    public boolean redo_existing = false;
    @Option(value="Timeout for each command, in seconds")
    public int timeout = 600;
    @Option(value="-q Run quietly (e.g., no output about missing directories)")
    public boolean quiet = true;
    @Option(value="Path to the cvs program")
    public String cvs_executable = "cvs";
    @Option(value="Path to the git program")
    public String git_executable = "git";
    @Option(value="Path to the hg program")
    public String hg_executable = "hg";
    @Option(value="Path to the svn program")
    public String svn_executable = "svn";
    @Option(value="Pass --insecure argument to hg (and likewise for other programs)")
    public boolean insecure = false;
    @Option(value="Extra argument to pass to the cvs program")
    public List<String> cvs_arg = new ArrayList<String>();
    @Option(value="Extra argument to pass  to the git program")
    public List<String> git_arg = new ArrayList<String>();
    @Option(value="Extra argument to pass  to the hg program")
    public List<String> hg_arg = new ArrayList<String>();
    @Option(value="Extra argument to pass  to the svn program")
    public List<String> svn_arg = new ArrayList<String>();
    @Option(value="Print debugging output")
    public static boolean debug = false;
    @Option(value="Debug 'replacers' that filter command output")
    public boolean debug_replacers = false;
    @Option(value="Lightweight debugging of 'replacers' that filter command output")
    public boolean debug_process_output = false;
    private static Action CLONE = Action.CLONE;
    private static Action STATUS = Action.STATUS;
    private static Action PULL = Action.PULL;
    private static Action LIST = Action.LIST;
    private Action action;
    static IsDirectoryFilter idf = new IsDirectoryFilter();
    private Pattern defaultPattern = Pattern.compile("^default[ \t]*=[ \t]*(.*)");
    private Pattern invalidCertificatePattern = Pattern.compile("^https://[^.]*[.][^.]*[.]googlecode[.]com/hg$");

    private static String expandTilde(String path) {
        return path.replaceFirst("^~", home);
    }

    public static void main(String[] args) {
        MultiVersionControl.setupSVNKIT();
        MultiVersionControl mvc = new MultiVersionControl(args);
        LinkedHashSet<Checkout> checkouts = new LinkedHashSet<Checkout>();
        try {
            MultiVersionControl.readCheckouts(new File(mvc.checkouts), checkouts);
        }
        catch (IOException e) {
            System.err.println("Problem reading file " + mvc.checkouts + ": " + e.getMessage());
        }
        if (mvc.search) {
            for (String adir : mvc.ignore_dir) {
                File afile = new File(MultiVersionControl.expandTilde(adir));
                if (!afile.exists()) {
                    System.err.printf("Warning: Directory to ignore while searching for checkouts does not exist:%n  %s%n", adir);
                    continue;
                }
                if (!afile.isDirectory()) {
                    System.err.printf("Warning: Directory to ignore while searching for checkouts is not a directory:%n  %s%n", adir);
                    continue;
                }
                mvc.ignoreDirs.add(afile);
            }
            for (String adir : mvc.dir) {
                adir = MultiVersionControl.expandTilde(adir);
                if (debug) {
                    System.out.println("Searching for checkouts under " + adir);
                }
                if (!new File(adir).isDirectory()) {
                    System.err.printf("Directory in which to search for checkouts is not a directory: %s%n", adir);
                    System.exit(2);
                }
                MultiVersionControl.findCheckouts(new File(adir), checkouts, mvc.ignoreDirs);
            }
        }
        if (debug) {
            System.out.println("Processing checkouts read from " + checkouts);
        }
        mvc.process(checkouts);
    }

    private static void setupSVNKIT() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    private MultiVersionControl() {
    }

    public MultiVersionControl(String[] args) {
        this.parseArgs(args);
    }

    public void parseArgs(String[] args) {
        String action_string;
        Options options = new Options("mvc [options] {checkout,status,update,list}", this);
        Object[] remaining_args = options.parse_or_usage(args);
        if (remaining_args.length != 1) {
            options.print_usage("Please supply exactly one argument (found %d)%n%s", remaining_args.length, UtilMDE.join(remaining_args, " "));
            System.exit(1);
        }
        if ("checkout".startsWith(action_string = remaining_args[0])) {
            this.action = CLONE;
        } else if ("clone".startsWith(action_string)) {
            this.action = CLONE;
        } else if ("list".startsWith(action_string)) {
            this.action = LIST;
        } else if ("pull".startsWith(action_string)) {
            this.action = PULL;
        } else if ("status".startsWith(action_string)) {
            this.action = STATUS;
        } else if ("update".startsWith(action_string)) {
            this.action = PULL;
        } else {
            options.print_usage("Unrecognized action \"%s\"", action_string);
            System.exit(1);
        }
        this.checkouts = MultiVersionControl.expandTilde(this.checkouts);
        if (this.dir.isEmpty()) {
            this.dir.add(home);
        }
        if (this.action == CLONE) {
            this.search = false;
            this.show = true;
            this.timeout *= 10;
            boolean explicit_run_dry = false;
            for (String arg : args) {
                if (!arg.startsWith("--dry-run") && !arg.startsWith("--dry_run")) continue;
                explicit_run_dry = true;
            }
            if (!explicit_run_dry) {
                if (!this.quiet) {
                    System.out.println("No --dry-run argument, so using --dry-run=true; override with --dry-run=false");
                }
                this.dry_run = true;
            }
        }
        if (this.dry_run) {
            this.show = true;
            this.redo_existing = true;
        }
        if (debug) {
            this.show = true;
        }
    }

    static void readCheckouts(File file, Set<Checkout> checkouts) throws IOException {
        RepoType currentType = RepoType.BZR;
        String currentRoot = null;
        boolean currentRootIsRepos = false;
        EntryReader er = new EntryReader(file);
        for (String line : er) {
            String dirname;
            String root;
            if (debug) {
                System.out.println("line: " + line);
            }
            if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
            String[] splitTwo = line.split("[ \t]+");
            if (debug) {
                System.out.println("split length: " + splitTwo.length);
            }
            if (splitTwo.length == 2) {
                String word1 = splitTwo[0];
                String word2 = splitTwo[1];
                if (word1.equals("BZRROOT:") || word1.equals("BZRREPOS:")) {
                    currentType = RepoType.BZR;
                    currentRoot = word2;
                    currentRootIsRepos = word1.equals("BZRREPOS:");
                    continue;
                }
                if (word1.equals("CVSROOT:")) {
                    String[] rootWords;
                    String possibleRoot;
                    currentType = RepoType.CVS;
                    currentRoot = word2;
                    currentRootIsRepos = false;
                    if (!currentRoot.startsWith(":ext:") || !new File(possibleRoot = (rootWords = currentRoot.split(":"))[rootWords.length - 1]).isDirectory()) continue;
                    currentRoot = possibleRoot;
                    continue;
                }
                if (word1.equals("HGROOT:") || word1.equals("HGREPOS:")) {
                    currentType = RepoType.HG;
                    currentRoot = word2;
                    currentRootIsRepos = word1.equals("HGREPOS:");
                    continue;
                }
                if (word1.equals("GITROOT:") || word1.equals("GITREPOS:")) {
                    currentType = RepoType.GIT;
                    currentRoot = word2;
                    currentRootIsRepos = word1.equals("GITREPOS:");
                    continue;
                }
                if (word1.equals("SVNROOT:") || word1.equals("SVNREPOS:")) {
                    currentType = RepoType.SVN;
                    currentRoot = word2;
                    currentRootIsRepos = word1.equals("SVNREPOS:");
                    continue;
                }
            }
            if (currentRoot == null) {
                System.err.printf("need root before directory at line %d of file %s%n", er.getLineNumber(), er.getFileName());
                System.exit(1);
            }
            if ((root = currentRoot).endsWith("/")) {
                root = root.substring(0, root.length() - 1);
            }
            String module = null;
            int spacePos = line.lastIndexOf(32);
            if (spacePos == -1) {
                dirname = line;
            } else {
                dirname = line.substring(0, spacePos);
                module = line.substring(spacePos + 1);
            }
            File dir = new File(MultiVersionControl.expandTilde(dirname));
            if (module == null) {
                module = dir.getName();
            }
            if (currentType != RepoType.CVS) {
                if (!currentRootIsRepos) {
                    root = root + "/" + module;
                }
                module = null;
            }
            Checkout checkout = new Checkout(currentType, dir, root, module);
            checkouts.add(checkout);
        }
    }

    private static void findCheckouts(File dir, Set<Checkout> checkouts, List<File> ignoreDirs) {
        File[] childdirs;
        if (!dir.isDirectory()) {
            return;
        }
        if (ignoreDirs.contains(dir)) {
            return;
        }
        String dirName = dir.getName().toString();
        File parent = dir.getParentFile();
        if (parent != null) {
            if (dirName.equals(".bzr")) {
                checkouts.add(new Checkout(RepoType.BZR, parent, null, null));
                return;
            }
            if (dirName.equals("CVS")) {
                MultiVersionControl.addCheckoutCvs(dir, parent, checkouts);
                return;
            }
            if (dirName.equals(".hg")) {
                checkouts.add(MultiVersionControl.dirToCheckoutHg(dir, parent));
                return;
            }
            if (dirName.equals(".svn")) {
                Checkout c = MultiVersionControl.dirToCheckoutSvn(parent);
                if (c != null) {
                    checkouts.add(c);
                }
                return;
            }
        }
        if ((childdirs = dir.listFiles(idf)) == null) {
            System.err.printf("childdirs is null (permission or other I/O problem?) for %s%n", dir.toString());
            return;
        }
        Arrays.sort(childdirs, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File childdir : childdirs) {
            MultiVersionControl.findCheckouts(childdir, checkouts, ignoreDirs);
        }
    }

    static void addCheckoutCvs(File cvsDir, File dir, Set<Checkout> checkouts) {
        assert (cvsDir.getName().toString().equals("CVS")) : cvsDir.getName();
        File repositoryFile = new File(cvsDir, "Repository");
        File rootFile = new File(cvsDir, "Root");
        if (!repositoryFile.exists() || !rootFile.exists()) {
            return;
        }
        String pathInRepo = UtilMDE.readFile(repositoryFile).trim();
        String repoRoot = UtilMDE.readFile(rootFile).trim();
        File repoFileRoot = new File(pathInRepo);
        while (repoFileRoot.getParentFile() != null) {
            File newRepoFileRoot;
            repoFileRoot = newRepoFileRoot = repoFileRoot.getParentFile();
        }
        Pair<File, File> stripped = MultiVersionControl.removeCommonSuffixDirs(dir, new File(pathInRepo), repoFileRoot, "CVS");
        File cDir = (File)stripped.a;
        if (cDir == null) {
            System.out.printf("dir (%s) is parent of path in repo (%s)", dir, pathInRepo);
            System.exit(1);
        }
        String pathInRepoAtCheckout = stripped.b != null ? ((File)stripped.b).toString() : cDir.getName();
        checkouts.add(new Checkout(RepoType.CVS, cDir, repoRoot, pathInRepoAtCheckout));
    }

    static Checkout dirToCheckoutHg(File hgDir, File dir) {
        String repository = null;
        File hgrcFile = new File(hgDir, "hgrc");
        if (hgrcFile.exists()) {
            Ini ini;
            try {
                ini = new Ini((Reader)new FileReader(hgrcFile));
            }
            catch (IOException e) {
                throw new Error("Problem reading file " + hgrcFile);
            }
            Profile.Section pathsSection = (Profile.Section)ini.get((Object)"paths");
            if (pathsSection != null && (repository = (String)pathsSection.get((Object)"default")) != null && repository.endsWith("/")) {
                repository = repository.substring(0, repository.length() - 1);
            }
        }
        return new Checkout(RepoType.HG, dir, repository, null);
    }

    static Checkout dirToCheckoutGit(File gitDir, File dir) {
        String repository = UtilMDE.backticks("git", "config", "remote.origin.url");
        return new Checkout(RepoType.GIT, dir, repository, null);
    }

    static Checkout dirToCheckoutSvn(File dir) {
        SVNInfo info;
        SVNWCClient wcClient = new SVNWCClient((ISVNAuthenticationManager)null, null);
        try {
            info = wcClient.doInfo(new File(dir.toString()), SVNRevision.WORKING);
        }
        catch (SVNException e) {
            System.err.println("Problem in dirToCheckoutSvn(" + dir + "): " + e.getMessage());
            if (e.getMessage() != null && e.getMessage().contains("This client is too old")) {
                System.err.println("plume-lib needs a newer version of SVNKit.");
            }
            return null;
        }
        SVNURL url = info.getURL();
        SVNURL repoRoot = info.getRepositoryRootURL();
        if (repoRoot == null) {
            System.err.println("Problem:  old svn working copy in " + dir.toString());
            System.err.println("Check it out again to get a 'Repository Root' entry in the svn info output.");
            System.err.println("  repoUrl = " + url);
            System.exit(2);
        }
        if (debug) {
            System.out.println();
            System.out.println("repoRoot = " + repoRoot);
            System.out.println(" repoUrl = " + url);
            System.out.println("     dir = " + dir.toString());
        }
        Pair<File, File> stripped = MultiVersionControl.removeCommonSuffixDirs(dir, new File(url.getPath()), new File(repoRoot.getPath()), ".svn");
        File cDir = (File)stripped.a;
        if (cDir == null) {
            System.out.printf("dir (%s) is parent of repository URL (%s)", dir, url.getPath());
            System.exit(1);
        }
        if (stripped.b == null) {
            System.out.printf("dir (%s) is child of repository URL (%s)", dir, url.getPath());
            System.exit(1);
        }
        String pathInRepoAtCheckout = ((File)stripped.b).toString();
        try {
            url = url.setPath(pathInRepoAtCheckout, false);
        }
        catch (SVNException e) {
            throw new Error(e);
        }
        if (debug) {
            System.out.println("stripped: " + stripped);
            System.out.println("repoRoot = " + repoRoot);
            System.out.println(" repoUrl = " + url);
            System.out.println("    cDir = " + cDir.toString());
        }
        assert (url.toString().startsWith(repoRoot.toString())) : "repoRoot=" + repoRoot + ", url=" + url;
        return new Checkout(RepoType.SVN, cDir, url.toString(), null);
    }

    static Pair<File, File> removeCommonSuffixDirs(File p1, File p2, File p2_limit, String p1_contains) {
        File r2;
        if (debug) {
            System.out.printf("removeCommonSuffixDirs(%s, %s, %s, %s)%n", p1, p2, p2_limit, p1_contains);
        }
        File r1 = p1;
        for (r2 = p2; !(r1 == null || r2 == null || p2_limit != null && r2.equals(p2_limit) || !r1.getName().equals(r2.getName()) || p1_contains != null && !new File(r1.getParentFile(), p1_contains).isDirectory()); r1 = r1.getParentFile(), r2 = r2.getParentFile()) {
        }
        if (debug) {
            System.out.printf("removeCommonSuffixDirs => %s %s%n", r1, r2);
        }
        return Pair.of(r1, r2);
    }

    private void addArg(ProcessBuilder pb, String arg) {
        List<String> command = pb.command();
        command.add(arg);
        pb.command(command);
    }

    private void addArgs(ProcessBuilder pb, List<String> args) {
        List<String> command = pb.command();
        command.addAll(args);
        pb.command(command);
    }

    public void process(Set<Checkout> checkouts) {
        ProcessBuilder pb = new ProcessBuilder("");
        ProcessBuilder pb2 = new ProcessBuilder(new ArrayList<String>());
        ProcessBuilder pb3 = new ProcessBuilder(new ArrayList<String>());
        pb.redirectErrorStream(true);
        pb2.redirectErrorStream(true);
        pb3.redirectErrorStream(true);
        block38: for (Checkout c : checkouts) {
            if (debug) {
                System.out.println(c);
            }
            File dir = c.directory;
            ArrayList<Replacer> replacers = new ArrayList<Replacer>();
            ArrayList<Replacer> replacers3 = new ArrayList<Replacer>();
            switch (c.repoType) {
                case BZR: {
                    break;
                }
                case CVS: {
                    replacers.add(new Replacer("(^|\\n)([?]) ", "$1$2 " + dir + "/"));
                    break;
                }
                case GIT: {
                    replacers.add(new Replacer("(^|\\n)fatal:", "$1fatal in " + dir + ":"));
                    replacers.add(new Replacer("(^|\\n)warning:", "$1warning in " + dir + ":"));
                    replacers.add(new Replacer("(^|\\n)(There is no tracking information for the current branch\\.)", "$1" + dir + ": $2"));
                    replacers.add(new Replacer("(^|\\n)(Your configuration specifies to merge)", dir + ": $1$2"));
                    break;
                }
                case HG: {
                    replacers.add(new Replacer("(^|\\n)real URL is .*\\n", "$1"));
                    replacers.add(new Replacer("(^|\\n)(abort: .*)", "$1$2: " + dir));
                    replacers.add(new Replacer("(^|\\n)([MARC!?I]) ", "$1$2 " + dir + "/"));
                    replacers.add(new Replacer("(^|\\n)(\\*\\*\\* failed to import extension .*: No module named demandload\\n)", "$1"));
                    replacers.add(new Replacer("(^|\\n)warning: .* certificate not verified \\(check web.cacerts config setting\\)\\n", "$1"));
                    replacers.add(new Replacer("(^|\\n)warning: .* certificate not verified \\(check web.cacerts config setting\\)\\n", "$1"));
                    replacers.add(new Replacer("(^|\\n)((comparing with default-push\\n)?abort: repository default(-push)? not found!: .*\\n)", "$1"));
                    break;
                }
                case SVN: {
                    replacers.add(new Replacer("(svn: Network connection closed unexpectedly)", "$1 for " + dir));
                    replacers.add(new Replacer("(svn: Repository) (UUID)", "$1 " + dir + " $2"));
                    replacers.add(new Replacer("(svn: E155037: Previous operation has not finished; run 'cleanup' if it was interrupted)", "$1; for " + dir));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            replacers.add(new Replacer("(remote: )?Warning: untrusted X11 forwarding setup failed: xauth key data not generated\r*\n(remote: )?Warning: No xauth data; using fake authentication data for X11 forwarding\\.\r*\n", ""));
            replacers.add(new Replacer("(working copy ')", "$1" + dir));
            pb.command("echo", "command", "not", "set");
            pb.directory(dir);
            pb2.command(new ArrayList<String>());
            pb2.directory(dir);
            pb3.command(new ArrayList<String>());
            pb3.directory(dir);
            boolean show_normal_output = false;
            block7 : switch (this.action) {
                case LIST: {
                    System.out.println(c);
                    continue block38;
                }
                case CLONE: {
                    pb.directory(dir.getParentFile());
                    String dirbase = dir.getName();
                    if (c.repository == null) {
                        System.out.printf("Skipping checkout with unknown repository:%n  %s%n", dir);
                        continue block38;
                    }
                    switch (c.repoType) {
                        case BZR: {
                            System.out.println("bzr handling not yet implemented: skipping " + c.directory);
                            break block7;
                        }
                        case CVS: {
                            assert (c.module != null) : "@AssumeAssertion(nullness): dependent type CVS";
                            pb.command(this.cvs_executable, "-d", c.repository, "checkout", "-P", "-ko", c.module);
                            this.addArgs(pb, this.cvs_arg);
                            break block7;
                        }
                        case GIT: {
                            pb.command(this.git_executable, "clone", c.repository, dirbase);
                            this.addArgs(pb, this.git_arg);
                            break block7;
                        }
                        case HG: {
                            pb.command(this.hg_executable, "clone", c.repository, dirbase);
                            this.addArgs(pb, this.hg_arg);
                            if (!this.insecure) break block7;
                            this.addArg(pb, "--insecure");
                            break block7;
                        }
                        case SVN: {
                            if (c.module != null) {
                                pb.command(this.svn_executable, "checkout", c.repository, c.module);
                            } else {
                                pb.command(this.svn_executable, "checkout", c.repository);
                            }
                            this.addArgs(pb, this.svn_arg);
                            break block7;
                        }
                        default: {
                            assert (false);
                            break block7;
                        }
                    }
                }
                case STATUS: {
                    show_normal_output = true;
                    switch (c.repoType) {
                        case BZR: {
                            System.out.println("bzr handling not yet implemented: skipping " + c.directory);
                            break block7;
                        }
                        case CVS: {
                            assert (c.repository != null);
                            pb.command(this.cvs_executable, "-q", "diff", "-b", "--brief", "-N");
                            this.addArgs(pb, this.cvs_arg);
                            String removeRegexp = "\n=+\nRCS file: .*(\nretrieving revision .*)?\ndiff .*(\nFiles .* and .* differ)?";
                            replacers.add(new Replacer(removeRegexp, ""));
                            replacers.add(new Replacer("(^|\\n)Index: ", "$1" + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)(cvs \\[diff aborted)(\\]:)", "$1$2 in " + dir + "$3"));
                            replacers.add(new Replacer("(^|\\n)(Permission denied)", "$1$2 in " + dir));
                            replacers.add(new Replacer("(^|\\n)(cvs diff: )(cannot find revision control)", "$1$2 in " + dir + ": $3"));
                            replacers.add(new Replacer("(^|\\n)(cvs diff: cannot find )", "$1$2" + dir));
                            replacers.add(new Replacer("(^|\\n)(cvs diff: in directory )", "$1$2" + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)(cvs diff: ignoring )", "$1$2" + dir + "/"));
                            break block7;
                        }
                        case GIT: {
                            pb.command(this.git_executable, "status");
                            this.addArgs(pb, this.git_arg);
                            this.addArg(pb, "--porcelain");
                            replacers.add(new Replacer("(^|\\n)On branch master\\nYour branch is up-to-date with 'origin/master'.\\n\\n?", "$1"));
                            replacers.add(new Replacer("(^|\\n)nothing to commit,? working directory clean\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)no changes added to commit \\(use \"git add\" and/or \"git commit -a\"\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)nothing added to commit but untracked files present \\(use \"git add\" to track\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)nothing to commit \\(use -u to show untracked files\\)\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)#\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)# On branch master\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)nothing to commit \\(working directory clean\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)# Changed but not updated:\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)#   \\(use \"git add <file>...\" to update what will be committed\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)#   \\(use \"git checkout -- <file>...\" to discard changes in working directory\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)# Untracked files:\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)#   \\(use \"git add <file>...\" to include in what will be committed\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)(#\tmodified:   )", "$1" + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)(#\t)", "$1untracked: " + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)# Your branch is ahead of .*\\n", "$1unpushed changesets: " + pb.directory() + "\n"));
                            replacers.add(new Replacer("(^|\\n)([?][?]) ", "$1$2 " + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)([ACDMRU][ ACDMRTU]|[ ACDMRU][ACDMRTU]) ", "$1$2 " + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)# Your branch is behind .*\\n", "$1unpushed changesets: " + pb.directory() + "\n"));
                            pb2.command(this.git_executable, "log", "--branches", "--not", "--remotes");
                            this.addArgs(pb2, this.git_arg);
                            replacers.add(new Replacer("^commit .*(.*\\n)+", "unpushed commits: " + pb2.directory() + "\n"));
                            break block7;
                        }
                        case HG: {
                            pb.command(this.hg_executable, "status");
                            this.addArgs(pb, this.hg_arg);
                            if (debug) {
                                System.out.printf("invalidCertificate(%s) => %s%n", c.directory, this.invalidCertificate(c.directory));
                            }
                            if (this.invalidCertificate(c.directory)) {
                                pb2.command(this.hg_executable, "outgoing", "-l", "1", "--config", "web.cacerts=");
                            } else {
                                pb2.command(this.hg_executable, "outgoing", "-l", "1");
                            }
                            this.addArgs(pb2, this.hg_arg);
                            if (this.insecure) {
                                this.addArg(pb2, "--insecure");
                            }
                            replacers.add(new Replacer("^comparing with .*\\nsearching for changes\\nchangeset[^\u0001]*", "unpushed changesets: " + pb.directory() + "\n"));
                            replacers.add(new Replacer("^\\n?comparing with .*\\nsearching for changes\\nno changes found\n", ""));
                            pb3.command(this.hg_executable, "shelve", "-l");
                            this.addArgs(pb3, this.hg_arg);
                            replacers3.add(new Replacer("^hg: unknown command 'shelve'\\n(.*\\n)+", ""));
                            replacers3.add(new Replacer("^(.*\\n)+", "shelved changes: " + pb.directory() + "\n"));
                            break block7;
                        }
                        case SVN: {
                            replacers.add(new Replacer("(^|\\n)([ACDIMRX?!~ ][CM ][L ][+ ][$ ]) *", "$1$2 " + dir + "/"));
                            pb.command(this.svn_executable, "status");
                            this.addArgs(pb, this.svn_arg);
                            break block7;
                        }
                    }
                    assert (false);
                    break;
                }
                case PULL: {
                    switch (c.repoType) {
                        case BZR: {
                            System.out.println("bzr handling not yet implemented: skipping " + c.directory);
                            break block7;
                        }
                        case CVS: {
                            replacers.add(new Replacer("(^|\\n)(cvs update: ((in|skipping) directory|conflicts found in )) +", "$1$2 " + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)(Merging differences between 1.16 and 1.17 into )", "$1$2 " + dir + "/"));
                            assert (c.repository != null);
                            pb.command(this.cvs_executable, "-Q", "update", "-d");
                            this.addArgs(pb, this.cvs_arg);
                            replacers.add(new Replacer("(cvs update: move away )", "$1" + dir + "/"));
                            replacers.add(new Replacer("(cvs \\[update aborted)(\\])", "$1 in " + dir + "$2"));
                            break block7;
                        }
                        case GIT: {
                            replacers.add(new Replacer("(^|\\n)Already up-to-date\\.\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)error:", "$1error in " + dir + ":"));
                            replacers.add(new Replacer("(^|\\n)Please, commit your changes or stash them before you can merge.\\nAborting\\n", "$1"));
                            replacers.add(new Replacer("((^|\\n)CONFLICT \\(content\\): Merge conflict in )", "$1" + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)([ACDMRU]\t)", "$1$2" + dir + "/"));
                            pb.command(this.git_executable, "pull", "-q");
                            this.addArgs(pb, this.git_arg);
                            pb2.command(this.git_executable, "fetch", "-p");
                            break block7;
                        }
                        case HG: {
                            replacers.add(new Replacer("(^|\\n)([?!AMR] ) +", "$1$2 " + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)abort: ", "$1"));
                            pb.command(this.hg_executable, "-q", "update");
                            this.addArgs(pb, this.hg_arg);
                            if (this.invalidCertificate(c.directory)) {
                                pb2.command(this.hg_executable, "-q", "fetch", "--config", "web.cacerts=");
                            } else {
                                pb2.command(this.hg_executable, "-q", "fetch");
                            }
                            this.addArgs(pb2, this.hg_arg);
                            if (!this.insecure) break block7;
                            this.addArg(pb2, "--insecure");
                            break block7;
                        }
                        case SVN: {
                            replacers.add(new Replacer("(^|\\n)([?!AMR] ) +", "$1$2 " + dir + "/"));
                            replacers.add(new Replacer("(svn: Failed to add file ')(.*')", "$1" + dir + "/$2"));
                            assert (c.repository != null);
                            pb.command(this.svn_executable, "-q", "update");
                            this.addArgs(pb, this.svn_arg);
                            break block7;
                        }
                        default: {
                            assert (false);
                            break block7;
                        }
                    }
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (debug) {
                System.out.println(dir + ":");
            }
            if (dir.exists()) {
                if (this.action == CLONE && !this.redo_existing && !this.quiet) {
                    System.out.println("Skipping checkout (dir already exists): " + dir);
                    continue;
                }
            } else {
                File parent = dir.getParentFile();
                if (parent == null) {
                    System.err.printf("Directory %s does not exist, and it has no parent%n", dir);
                    continue;
                }
                switch (this.action) {
                    case CLONE: {
                        if (parent.exists()) break;
                        if (this.show) {
                            if (!this.dry_run) {
                                System.out.printf("Parent directory %s does not exist%s%n", parent, this.dry_run ? "" : " (creating)");
                            } else {
                                System.out.printf("  mkdir -p %s%n", parent);
                            }
                        }
                        if (this.dry_run || parent.mkdirs()) break;
                        System.err.println("Could not create directory: " + parent);
                        System.exit(1);
                        break;
                    }
                    case STATUS: 
                    case PULL: {
                        if (this.quiet) continue block38;
                        System.out.println("Cannot find directory: " + dir);
                        continue block38;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            if (this.print_directory) {
                System.out.println(dir + " :");
            }
            this.perform_command(pb, replacers, show_normal_output);
            if (pb2.command().size() > 0) {
                this.perform_command(pb2, replacers, show_normal_output);
            }
            if (pb3.command().size() <= 0) continue;
            this.perform_command(pb3, replacers3, show_normal_output);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String defaultPath(File dir) {
        File hgrc = new File(new File(dir, ".hg"), "hgrc");
        try (EntryReader er = new EntryReader(hgrc, "^#.*", null);){
            String line;
            Matcher m3;
            Iterator<String> iterator = er.iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while (!(m3 = this.defaultPattern.matcher(line = iterator.next())).matches());
            String string = m3.group(1);
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean invalidCertificate(File dir) {
        String defaultPath = this.defaultPath(dir);
        if (debug) {
            System.out.printf("defaultPath=%s for %s%n", defaultPath, dir);
        }
        if (defaultPath == null) {
            return false;
        }
        return defaultPath.startsWith("https://hg.codespot.com/") || this.invalidCertificatePattern.matcher(defaultPath).matches();
    }

    void perform_command(ProcessBuilder pb, List<Replacer> replacers, boolean show_normal_output) {
        if (this.show) {
            System.out.println(this.command(pb));
        }
        if (this.dry_run) {
            return;
        }
        try {
            TimeLimitProcess p = new TimeLimitProcess(pb.start(), (long)(this.timeout * 1000), true);
            p.waitFor();
            Thread.sleep(10L);
            if (p.timed_out()) {
                System.out.printf("Timed out (limit: %ss):%n", this.timeout);
                System.out.println(this.command(pb));
            }
            if (show_normal_output || p.exitValue() != 0 || this.debug_replacers || this.debug_process_output) {
                String output = UtilMDE.streamString(p.getInputStream());
                if (this.debug_replacers || this.debug_process_output) {
                    System.out.println("preoutput=<<<" + output + ">>>");
                }
                for (Replacer r : replacers) {
                    if (this.debug_replacers) {
                        System.out.println("midoutput_pre[" + r.regexp + "]=<<<" + output + ">>>");
                    }
                    output = r.replaceAll(output);
                    if (!this.debug_replacers) continue;
                    System.out.println("midoutput_post[" + r.regexp + "]=<<<" + output + ">>>");
                }
                if (this.debug_replacers || this.debug_process_output) {
                    System.out.println("postoutput=<<<" + output + ">>>");
                }
                if (this.debug_replacers) {
                    for (int i = 0; i < Math.min(100, output.length()); ++i) {
                        System.out.println(i + ": " + output.charAt(i) + "\n        \"" + output.charAt(i) + "\"");
                    }
                }
                System.out.print(output);
            }
        }
        catch (IOException e) {
            String msg = e.toString();
            if (msg.startsWith("java.io.IOException: Cannot run program \"") && msg.endsWith(", No such file or directory")) {
                System.err.println(msg.substring(21));
            }
            throw new Error(e);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
    }

    String command(ProcessBuilder pb) {
        return "  cd " + pb.directory() + "\n  " + UtilMDE.join(pb.command(), " ");
    }

    static class StreamOfNewlines
    extends InputStream {
        StreamOfNewlines() {
        }

        @Override
        public int read() {
            return 10;
        }
    }

    private static class Replacer {
        String regexp;
        String replacement;

        public Replacer(String regexp, String replacement) {
            this.regexp = regexp;
            this.replacement = replacement;
        }

        public String replaceAll(String s2) {
            return s2.replaceAll(this.regexp, this.replacement);
        }
    }

    static class IsDirectoryFilter
    implements FileFilter {
        IsDirectoryFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            try {
                return pathname.isDirectory() && pathname.getPath().equals(pathname.getCanonicalPath());
            }
            catch (IOException e) {
                System.err.printf("Exception in IsDirectoryFilter.accept(%s): %s%n", pathname, e);
                throw new Error(e);
            }
        }
    }

    static class Checkout {
        RepoType repoType;
        File directory;
        String repository;
        String module;

        Checkout(RepoType repoType, File directory) {
            this(repoType, directory, null, null);
        }

        Checkout(RepoType repoType, File directory, String repository, String module) {
            assert (!directory.exists() || directory.isDirectory()) : "Not a directory: " + directory;
            this.repoType = repoType;
            this.directory = directory;
            this.repository = repository;
            this.module = module;
            switch (repoType) {
                case BZR: {
                    Checkout.assertSubdirExists(directory, ".bzr");
                    assert (module == null);
                    break;
                }
                case CVS: {
                    Checkout.assertSubdirExists(directory, "CVS");
                    assert (module != null) : "No module for CVS checkout at: " + directory;
                    break;
                }
                case GIT: {
                    Checkout.assertSubdirExists(directory, ".git");
                    assert (module == null);
                    break;
                }
                case HG: {
                    Checkout.assertSubdirExists(directory, ".hg");
                    assert (module == null);
                    break;
                }
                case SVN: {
                    Checkout.assertSubdirExists(directory, ".svn");
                    assert (module == null);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private static void assertSubdirExists(File directory, String subdirName) {
            if (directory.exists() && !new File(directory, subdirName).isDirectory()) {
                System.err.printf("Directory %s exists but %s subdirectory does not exist%n", directory, subdirName);
                System.exit(2);
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof Checkout)) {
                return false;
            }
            Checkout c2 = (Checkout)other;
            return this.repoType == c2.repoType && this.directory.equals(c2.directory) && (this.repository == null ? c2.repository == null : this.repository.equals(c2.repository)) && (this.module == null ? c2.module == null : this.module.equals(c2.module));
        }

        public int hashCode() {
            return this.repoType.hashCode() + this.directory.hashCode() + (this.repository == null ? 0 : this.repository.hashCode()) + (this.module == null ? 0 : this.module.hashCode());
        }

        public String toString() {
            return (Object)((Object)this.repoType) + " " + this.directory + " " + this.repository + " " + this.module;
        }
    }

    static enum RepoType {
        BZR,
        CVS,
        GIT,
        HG,
        SVN;

    }

    static enum Action {
        CLONE,
        STATUS,
        PULL,
        LIST;

    }
}

