/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import plume.ArraysMDE;
import plume.ClassFileVersion;
import plume.CountingPrintWriter;
import plume.Filter;
import plume.FuzzyFloat;
import plume.GraphMDE;
import plume.Intern;
import plume.LimitedSizeSet;
import plume.MathMDE;
import plume.Option;
import plume.OptionGroup;
import plume.Options;
import plume.OrderedPairIterator;
import plume.Pair;
import plume.StringBuilderDelimited;
import plume.TimeLimitProcess;
import plume.Triple;
import plume.Unpublicized;
import plume.UtilMDE;
import plume.WeakIdentityHashMap;

public final class TestPlume {
    static boolean short_run = false;
    private static Runtime runtime = Runtime.getRuntime();
    private static Map<Integer, List<Integer>> preds1;
    private static Map<Integer, List<Integer>> succs1;

    public static void assert_arrays_equals(int[] a1, int[] a2) {
        boolean result = Arrays.equals(a1, a2);
        if (!result) {
            System.out.println("Arrays differ: " + ArraysMDE.toString(a1) + ", " + ArraysMDE.toString(a2));
        }
        assert (result);
    }

    public static void assert_arrays_equals(double[] a1, double[] a2) {
        boolean result = Arrays.equals(a1, a2);
        if (!result) {
            System.out.println("Arrays differ: " + ArraysMDE.toString(a1) + ", " + ArraysMDE.toString(a2));
        }
        assert (result);
    }

    public static Iterator<Integer> int_array_iterator(int[] nums) {
        ArrayList<Integer> asList = new ArrayList<Integer>(nums.length);
        for (int i = 0; i < nums.length; ++i) {
            asList.add(nums[i]);
        }
        return asList.iterator();
    }

    public static int[] int_iterator_array(Iterator<Integer> itor) {
        Vector<Integer> v = new Vector<Integer>();
        while (itor.hasNext()) {
            v.add(itor.next());
        }
        int[] a = new int[v.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (Integer)v.elementAt(i);
        }
        return a;
    }

    public static <T> Vector<T> toVector(Iterator<T> itor) {
        Vector<T> v = new Vector<T>();
        while (itor.hasNext()) {
            v.add(itor.next());
        }
        return v;
    }

    public static <T> Vector<T> toVector(Enumeration<T> e) {
        Vector<T> v = new Vector<T>();
        while (e.hasMoreElements()) {
            v.add(e.nextElement());
        }
        return v;
    }

    @Test
    public void testArraysMDE() {
        assert (ArraysMDE.min(new int[]{1, 2, 3}) == 1);
        assert (ArraysMDE.min(new int[]{2, 33, 1}) == 1);
        assert (ArraysMDE.min(new int[]{3, -2, 1}) == -2);
        assert (ArraysMDE.min(new int[]{3}) == 3);
        assert (ArraysMDE.max(new int[]{1, 2, 3}) == 3);
        assert (ArraysMDE.max(new int[]{2, 33, 1}) == 33);
        assert (ArraysMDE.max(new int[]{3, -2, 1}) == 3);
        assert (ArraysMDE.max(new int[]{3}) == 3);
        TestPlume.assert_arrays_equals(ArraysMDE.min_max(new int[]{1, 2, 3}), new int[]{1, 3});
        TestPlume.assert_arrays_equals(ArraysMDE.min_max(new int[]{2, 33, 1}), new int[]{1, 33});
        TestPlume.assert_arrays_equals(ArraysMDE.min_max(new int[]{3, -2, 1}), new int[]{-2, 3});
        TestPlume.assert_arrays_equals(ArraysMDE.min_max(new int[]{3}), new int[]{3, 3});
        try {
            ArraysMDE.min_max(new int[0]);
            throw new Error("Didn't throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                ArraysMDE.min_max(new long[0]);
                throw new Error("Didn't throw ArrayIndexOutOfBoundsException");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                int i;
                assert (0 == ArraysMDE.sum(new int[0]));
                assert (10 == ArraysMDE.sum(new int[]{10}));
                assert (10 == ArraysMDE.sum(new int[]{1, 2, 3, 4}));
                assert (0 == ArraysMDE.sum(new int[0][0]));
                assert (78 == ArraysMDE.sum(new int[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}}));
                assert (68 == ArraysMDE.sum(new int[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 11, 12}}));
                assert (0.0 == ArraysMDE.sum(new double[0]));
                assert (3.14 == ArraysMDE.sum(new double[]{3.14}));
                assert (8.624 == ArraysMDE.sum(new double[]{3.14, 2.718, -1.234, 4.0}));
                assert (0.0 == ArraysMDE.sum(new double[0][0]));
                assert (79.5 == ArraysMDE.sum(new double[][]{{1.1, 2.2, 3.3, 4.4}, {5.5, 6.0, 7.0, 8.0}, {9.0, 10.0, 11.0, 12.0}}));
                assert (ArraysMDE.element_range(new int[]{1, 2, 3}) == 2);
                assert (ArraysMDE.element_range(new int[]{2, 33, 1}) == 32);
                assert (ArraysMDE.element_range(new int[]{3, -2, 1}) == 5);
                assert (ArraysMDE.element_range(new int[]{3}) == 0);
                Object[] a = new Integer[10];
                for (i = 0; i < a.length; ++i) {
                    a[i] = new Integer(i);
                }
                assert (ArraysMDE.indexOf(a, (Object)new Integer(-1)) == -1);
                assert (ArraysMDE.indexOf(a, (Object)new Integer(0)) == 0);
                assert (ArraysMDE.indexOf(a, (Object)new Integer(7)) == 7);
                assert (ArraysMDE.indexOf(a, (Object)new Integer(9)) == 9);
                assert (ArraysMDE.indexOf(a, (Object)new Integer(10)) == -1);
                assert (ArraysMDE.indexOf(a, (Object)new Integer(20)) == -1);
                assert (ArraysMDE.indexOf(a, null) == -1);
                assert (ArraysMDE.indexOf(a, null, 1, 5) == -1);
                assert (ArraysMDE.indexOfEq(a, (Object)new Integer(-1)) == -1);
                assert (ArraysMDE.indexOfEq(a, (Object)new Integer(0)) == -1);
                assert (ArraysMDE.indexOfEq(a, (Object)new Integer(7)) == -1);
                assert (ArraysMDE.indexOfEq(a, (Object)new Integer(9)) == -1);
                assert (ArraysMDE.indexOfEq(a, (Object)new Integer(10)) == -1);
                assert (ArraysMDE.indexOfEq(a, (Object)new Integer(20)) == -1);
                assert (ArraysMDE.indexOfEq(a, null) == -1);
                assert (ArraysMDE.indexOfEq(a, null, 1, 5) == -1);
                assert (ArraysMDE.indexOfEq(a, a[0]) == 0);
                assert (ArraysMDE.indexOfEq(a, a[7]) == 7);
                assert (ArraysMDE.indexOfEq(a, a[9]) == 9);
                assert (ArraysMDE.indexOf(new ArrayList(), null) == -1);
                assert (ArraysMDE.indexOf(new ArrayList(), null, 0, -1) == -1);
                assert (ArraysMDE.indexOfEq(new ArrayList(), null) == -1);
                assert (ArraysMDE.indexOfEq(new ArrayList(), null, 0, -1) == -1);
                a = new int[10];
                for (i = 0; i < a.length; ++i) {
                    a[i] = i;
                }
                assert (ArraysMDE.indexOf((int[])a, -1) == -1);
                assert (ArraysMDE.indexOf((int[])a, 0) == 0);
                assert (ArraysMDE.indexOf((int[])a, 7) == 7);
                assert (ArraysMDE.indexOf((int[])a, 9) == 9);
                assert (ArraysMDE.indexOf((int[])a, 10) == -1);
                assert (ArraysMDE.indexOf((int[])a, 20) == -1);
                a = new boolean[10];
                for (i = 0; i < a.length; ++i) {
                    a[i] = false;
                }
                assert (ArraysMDE.indexOf((boolean[])a, true) == -1);
                assert (ArraysMDE.indexOf((boolean[])a, false) == 0);
                a[9] = true;
                assert (ArraysMDE.indexOf((boolean[])a, true) == 9);
                assert (ArraysMDE.indexOf((boolean[])a, false) == 0);
                a[7] = true;
                assert (ArraysMDE.indexOf((boolean[])a, true) == 7);
                assert (ArraysMDE.indexOf((boolean[])a, false) == 0);
                a[0] = true;
                assert (ArraysMDE.indexOf((boolean[])a, true) == 0);
                assert (ArraysMDE.indexOf((boolean[])a, false) == 1);
                for (i = 0; i < a.length; ++i) {
                    a[i] = true;
                }
                assert (ArraysMDE.indexOf((boolean[])a, true) == 0);
                assert (ArraysMDE.indexOf((boolean[])a, false) == -1);
                a = new Integer[10];
                for (i = 0; i < a.length; ++i) {
                    a[i] = new Integer(i);
                }
                Object[] b = new Integer[]{};
                Object[] c = new Integer[]{a[0], a[1], a[2]};
                Object[] d = new Integer[]{a[1], a[2]};
                Object[] e = new Integer[]{a[2], a[3], a[4], a[5]};
                Object[] f = new Integer[]{a[7], a[8], a[9]};
                Object[] g2 = new Integer[]{a[7], new Integer(8), a[9]};
                Object[] h2 = new Integer[]{a[7], a[8], a[9], new Integer(10)};
                Object[] i2 = new Integer[]{a[7], a[8], null, a[9], new Integer(10)};
                Object[] j = new Integer[]{a[8], null, a[9]};
                Object[] c2 = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
                Object[] d2 = new Integer[]{new Integer(1), new Integer(2)};
                Object[] e2 = new Integer[]{new Integer(2), new Integer(3), new Integer(4), new Integer(5)};
                Object[] f2 = new Integer[]{new Integer(7), new Integer(8), new Integer(9)};
                assert (ArraysMDE.indexOf(a, b) == 0);
                assert (ArraysMDE.indexOfEq(a, b) == 0);
                assert (ArraysMDE.indexOf(a, c) == 0);
                assert (ArraysMDE.indexOfEq(a, c) == 0);
                assert (ArraysMDE.indexOf(a, c2) == 0);
                assert (ArraysMDE.indexOfEq(a, c2) == -1);
                assert (ArraysMDE.indexOf(a, d) == 1);
                assert (ArraysMDE.indexOfEq(a, d) == 1);
                assert (ArraysMDE.indexOf(a, d2) == 1);
                assert (ArraysMDE.indexOfEq(a, d2) == -1);
                assert (ArraysMDE.indexOf(a, e) == 2);
                assert (ArraysMDE.indexOfEq(a, e) == 2);
                assert (ArraysMDE.indexOf(a, e2) == 2);
                assert (ArraysMDE.indexOfEq(a, e2) == -1);
                assert (ArraysMDE.indexOf(a, f) == 7);
                assert (ArraysMDE.indexOfEq(a, f) == 7);
                assert (ArraysMDE.indexOf(a, f2) == 7);
                assert (ArraysMDE.indexOfEq(a, f2) == -1);
                assert (ArraysMDE.indexOf(a, g2) == 7);
                assert (ArraysMDE.indexOfEq(a, g2) == -1);
                assert (ArraysMDE.indexOf(a, h2) == -1);
                assert (ArraysMDE.indexOfEq(a, h2) == -1);
                assert (ArraysMDE.indexOf(i2, j) == 1);
                assert (ArraysMDE.indexOfEq(i2, j) == 1);
                assert (ArraysMDE.indexOf(a, i2) == -1);
                assert (ArraysMDE.indexOfEq(a, i2) == -1);
                a = new int[10];
                for (int i3 = 0; i3 < a.length; ++i3) {
                    a[i3] = i3;
                }
                int[] b2 = new int[]{};
                c = new int[]{(int)a[0], (int)a[1], (int)a[2]};
                d = new int[]{(int)a[1], (int)a[2]};
                e = new int[]{(int)a[2], (int)a[3], (int)a[4], (int)a[5]};
                f = new int[]{(int)a[7], (int)a[8], (int)a[9]};
                g2 = new int[]{(int)a[7], 22, (int)a[9]};
                h2 = new int[]{(int)a[7], (int)a[8], (int)a[9], 10};
                assert (ArraysMDE.indexOf((int[])a, b2) == 0);
                assert (ArraysMDE.indexOf((int[])a, (int[])c) == 0);
                assert (ArraysMDE.indexOf((int[])a, (int[])d) == 1);
                assert (ArraysMDE.indexOf((int[])a, (int[])e) == 2);
                assert (ArraysMDE.indexOf((int[])a, (int[])f) == 7);
                assert (ArraysMDE.indexOf((int[])a, (int[])g2) == -1);
                assert (ArraysMDE.indexOf((int[])a, (int[])h2) == -1);
                int[] origTheArray = new int[]{1267757, 1267757, 1267757, 1267757, 1267757, 1267757, 1267757, 1267757, 1267757, 1267757, 1267757, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                int[] postTheArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                assert (ArraysMDE.indexOf(postTheArray, origTheArray) == -1);
                assert (ArraysMDE.indexOf(origTheArray, postTheArray) == -1);
                assert (ArraysMDE.toString((Object[])null).equals("null"));
                assert (ArraysMDE.toStringQuoted((Object[])null).equals("null"));
                assert (ArraysMDE.toString((List)null).equals("null"));
                assert (ArraysMDE.toStringQuoted((List)null).equals("null"));
                assert (ArraysMDE.toStringQuoted(Arrays.asList(3.14, null, "hello")).equals("[3.14, null, \"hello\"]"));
                assert (ArraysMDE.toString(new int[0]).equals("[]"));
                assert (ArraysMDE.toString(new int[]{0}).equals("[0]"));
                assert (ArraysMDE.toString(new int[]{0, 1, 2}).equals("[0, 1, 2]"));
                assert (ArraysMDE.sorted(new int[]{0, 1, 2}));
                assert (ArraysMDE.sorted(new int[]{0, 1, 2, 2, 3, 3}));
                assert (ArraysMDE.sorted(new int[0]));
                assert (ArraysMDE.sorted(new int[]{0}));
                assert (ArraysMDE.sorted(new int[]{0, 1}));
                assert (!ArraysMDE.sorted(new int[]{1, 0}));
                assert (!ArraysMDE.sorted(new int[]{0, 1, 2, 1, 2, 3}));
                assert (ArraysMDE.noDuplicates(new int[]{1, 2, 3, 5, 4, 0}));
                assert (ArraysMDE.noDuplicates(new int[]{1, 2, 3, 5, 4, 100}));
                assert (!ArraysMDE.noDuplicates(new int[]{2, 2, 3, 5, 4, 0}));
                assert (!ArraysMDE.noDuplicates(new int[]{1, 2, 3, 5, 4, 1}));
                assert (ArraysMDE.noDuplicates(new int[]{1, 2, -3, -5, 4, 0}));
                assert (!ArraysMDE.noDuplicates(new int[]{1, 2, -2, -2, 4, 100}));
                assert (ArraysMDE.noDuplicates(new int[0]));
                assert (ArraysMDE.noDuplicates(new int[]{42}));
                assert (ArraysMDE.noDuplicates(new long[]{1L, 2L, 3L, 5L, 4L, 0L}));
                assert (ArraysMDE.noDuplicates(new long[]{1L, 2L, 3L, 5L, 4L, 100L}));
                assert (!ArraysMDE.noDuplicates(new long[]{2L, 2L, 3L, 5L, 4L, 0L}));
                assert (!ArraysMDE.noDuplicates(new long[]{1L, 2L, 3L, 5L, 4L, 1L}));
                assert (ArraysMDE.noDuplicates(new long[]{1L, 2L, -3L, -5L, 4L, 0L}));
                assert (!ArraysMDE.noDuplicates(new long[]{1L, 2L, -2L, -2L, 4L, 100L}));
                assert (ArraysMDE.noDuplicates(new long[0]));
                assert (ArraysMDE.noDuplicates(new long[]{42L}));
                assert (ArraysMDE.noDuplicates(new double[]{1.0, 2.0, 3.0, 5.0, 4.0, 0.0}));
                assert (ArraysMDE.noDuplicates(new double[]{1.0, 2.0, 3.0, 5.0, 4.0, 100.0}));
                assert (!ArraysMDE.noDuplicates(new double[]{2.0, 2.0, 3.0, 5.0, 4.0, 0.0}));
                assert (!ArraysMDE.noDuplicates(new double[]{1.0, 2.0, 3.0, 5.0, 4.0, 1.0}));
                assert (ArraysMDE.noDuplicates(new double[]{1.0, 1.001, -3.0, -5.0, 4.0, 0.0}));
                assert (!ArraysMDE.noDuplicates(new double[]{1.0, 2.0, -2.0, -2.0, 4.0, 100.0}));
                assert (ArraysMDE.noDuplicates(new double[0]));
                assert (ArraysMDE.noDuplicates(new double[]{42.0}));
                assert (ArraysMDE.noDuplicates(new String[]{"1", "2", "3", "5", "4", "0"}));
                assert (ArraysMDE.noDuplicates(new String[]{"A", "a", "foo", "Foo", ""}));
                assert (!ArraysMDE.noDuplicates(new String[]{" ", " "}));
                assert (ArraysMDE.noDuplicates(new String[]{"  ", " "}));
                assert (ArraysMDE.fn_is_permutation(new int[]{0, 1, 2, 3}));
                assert (ArraysMDE.fn_is_permutation(new int[]{1, 2, 3, 0}));
                assert (ArraysMDE.fn_is_permutation(new int[]{3, 2, 1, 0}));
                assert (!ArraysMDE.fn_is_permutation(new int[]{0, 1, 2, 2}));
                assert (!ArraysMDE.fn_is_permutation(new int[]{0, -1, 2, 3}));
                assert (!ArraysMDE.fn_is_permutation(new int[]{0, 1, 2, 4}));
                assert (!ArraysMDE.fn_is_permutation(new int[]{0, 0, 0, 0}));
                assert (ArraysMDE.fn_is_total(new int[]{0, 1, 2, 3}));
                assert (ArraysMDE.fn_is_total(new int[]{1, 2, 3, 0}));
                assert (ArraysMDE.fn_is_total(new int[]{3, 2, 1, 0}));
                assert (ArraysMDE.fn_is_total(new int[]{0, 1, 2, 2}));
                assert (!ArraysMDE.fn_is_total(new int[]{-1, 0, 2, 3}));
                assert (!ArraysMDE.fn_is_total(new int[]{0, -1, 2, 3}));
                assert (ArraysMDE.fn_is_total(new int[]{0, -2, 1, 3}));
                assert (!ArraysMDE.fn_is_total(new int[]{0, 2, 3, -1}));
                assert (ArraysMDE.fn_is_total(new int[]{0, 1, 2, 4}));
                assert (ArraysMDE.fn_is_total(new int[]{0, 0, 0, 0}));
                TestPlume.assert_arrays_equals(ArraysMDE.fn_identity(0), new int[0]);
                TestPlume.assert_arrays_equals(ArraysMDE.fn_identity(1), new int[]{0});
                TestPlume.assert_arrays_equals(ArraysMDE.fn_identity(2), new int[]{0, 1});
                TestPlume.assert_arrays_equals(ArraysMDE.fn_identity(3), new int[]{0, 1, 2});
                TestPlume.assert_arrays_equals(ArraysMDE.fn_inverse_permutation(new int[]{0, 1, 2, 3}), new int[]{0, 1, 2, 3});
                TestPlume.assert_arrays_equals(ArraysMDE.fn_inverse_permutation(new int[]{1, 2, 3, 0}), new int[]{3, 0, 1, 2});
                TestPlume.assert_arrays_equals(ArraysMDE.fn_inverse_permutation(new int[]{3, 2, 1, 0}), new int[]{3, 2, 1, 0});
                TestPlume.assert_arrays_equals(ArraysMDE.fn_inverse(new int[]{0, 1, 2, 3}, 4), new int[]{0, 1, 2, 3});
                TestPlume.assert_arrays_equals(ArraysMDE.fn_inverse(new int[]{1, 2, 3, 0}, 4), new int[]{3, 0, 1, 2});
                TestPlume.assert_arrays_equals(ArraysMDE.fn_inverse(new int[]{3, 2, 1, 0}, 4), new int[]{3, 2, 1, 0});
                try {
                    ArraysMDE.fn_inverse(new int[]{1, 0, 3, 0}, 4);
                    throw new Error();
                }
                catch (UnsupportedOperationException e3) {
                    assert (e3.getMessage() != null && e3.getMessage().equals("Not invertible; a[1]=0 and a[3]=0"));
                    TestPlume.assert_arrays_equals(ArraysMDE.fn_inverse(new int[]{5}, 6), new int[]{-1, -1, -1, -1, -1, 0});
                    TestPlume.assert_arrays_equals(ArraysMDE.fn_inverse(new int[]{1, 2, 3, 5}, 6), new int[]{-1, 0, 1, 2, -1, 3});
                    try {
                        TestPlume.assert_arrays_equals(ArraysMDE.fn_inverse(new int[]{100, 101, 102, 103}, 4), new int[]{40, 41, 42, 43});
                        throw new Error();
                    }
                    catch (IllegalArgumentException e4) {
                        assert (e4.getMessage() != null && e4.getMessage().equals("Bad range value: a[0]=100"));
                        TestPlume.assert_arrays_equals(ArraysMDE.fn_compose(new int[]{0, 1, 2, 3}, new int[]{0, 1, 2, 3}), new int[]{0, 1, 2, 3});
                        TestPlume.assert_arrays_equals(ArraysMDE.fn_compose(new int[]{1, 2, 3, 0}, new int[]{1, 2, 3, 0}), new int[]{2, 3, 0, 1});
                        TestPlume.assert_arrays_equals(ArraysMDE.fn_compose(new int[]{3, 2, 1, 0}, new int[]{3, 2, 1, 0}), new int[]{0, 1, 2, 3});
                        TestPlume.assert_arrays_equals(ArraysMDE.fn_compose(new int[]{0, 1, 0, 3}, new int[]{0, 5, 2, 1}), new int[]{0, 5, 0, 1});
                        TestPlume.assert_arrays_equals(ArraysMDE.fn_compose(new int[]{0}, new int[]{5}), new int[]{5});
                        TestPlume.assert_arrays_equals(ArraysMDE.fn_compose(new int[]{1, 2, 3, 5}, new int[]{1, 2, 3, 5, -1, -1}), new int[]{2, 3, 5, -1});
                        double[] f1 = new double[10];
                        double[] f22 = new double[20];
                        for (int j2 = 0; j2 < f22.length; ++j2) {
                            f22[j2] = j2;
                        }
                        for (int i4 = 0; i4 < f22.length - f1.length; ++i4) {
                            for (int j3 = 0; j3 < f1.length; ++j3) {
                                f1[j3] = f22[i4 + j3];
                            }
                            f1[5] = f22[i4];
                            double[] f1_copy = (double[])f1.clone();
                            double[] f2_copy = (double[])f22.clone();
                            assert (ArraysMDE.isSubset(f1, f22));
                            TestPlume.assert_arrays_equals(f1, f1_copy);
                            TestPlume.assert_arrays_equals(f22, f2_copy);
                        }
                        double[] a1 = new double[]{1.0, 5.0, 10.0};
                        double[] a2 = new double[]{};
                        double[] a3 = new double[]{1.0};
                        double[] a4 = new double[]{10.0};
                        double[] a5 = new double[]{1.0, 10.0, 15.0, 20.0};
                        double[] a6 = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 1.0};
                        assert (ArraysMDE.isSubset(a2, a1));
                        assert (!ArraysMDE.isSubset(a1, a2));
                        assert (!ArraysMDE.isSubset(a1, a5));
                        assert (ArraysMDE.isSubset(a3, a1));
                        assert (ArraysMDE.isSubset(a4, a1));
                        assert (ArraysMDE.isSubset(a6, a1));
                        assert (!ArraysMDE.isSubset(a1, a6));
                        ArraysMDE.IntArrayComparatorLexical iacl = new ArraysMDE.IntArrayComparatorLexical();
                        ArraysMDE.IntArrayComparatorLengthFirst iaclf = new ArraysMDE.IntArrayComparatorLengthFirst();
                        Object[] a0 = new int[]{};
                        Object[] a12 = new int[]{};
                        Object[] a22 = new int[]{0, 1, 2, 3};
                        Object[] a32 = new int[]{0, 1, 2, 3, 0};
                        Object[] a42 = new int[]{0, 1, 2, 3, 4};
                        Object[] a52 = new int[]{0, 1, 2, 3, 4};
                        Object[] a62 = new int[]{0, 1, 5, 3, 4};
                        Object[] a7 = new int[]{1, 2, 3, 4};
                        Object[] a8 = new int[]{-5};
                        Object[] a9 = new int[]{Integer.MAX_VALUE};
                        Object[] a10 = new int[]{Integer.MIN_VALUE};
                        assert (iacl.compare(a0, a12) == 0);
                        assert (iaclf.compare(a0, a12) == 0);
                        assert (iacl.compare(a12, a0) == 0);
                        assert (iaclf.compare(a12, a0) == 0);
                        assert (iacl.compare(a12, a22) < 0);
                        assert (iaclf.compare(a12, a22) < 0);
                        assert (iacl.compare(a22, a12) > 0);
                        assert (iaclf.compare(a22, a12) > 0);
                        assert (iacl.compare(a22, a32) < 0);
                        assert (iaclf.compare(a22, a32) < 0);
                        assert (iacl.compare(a32, a22) > 0);
                        assert (iaclf.compare(a32, a22) > 0);
                        assert (iacl.compare(a32, a42) < 0);
                        assert (iaclf.compare(a32, a42) < 0);
                        assert (iacl.compare(a42, a32) > 0);
                        assert (iaclf.compare(a42, a32) > 0);
                        assert (iacl.compare(a42, a52) == 0);
                        assert (iaclf.compare(a42, a52) == 0);
                        assert (iacl.compare(a52, a42) == 0);
                        assert (iaclf.compare(a52, a42) == 0);
                        assert (iacl.compare(a52, a62) < 0);
                        assert (iaclf.compare(a52, a62) < 0);
                        assert (iacl.compare(a62, a52) > 0);
                        assert (iaclf.compare(a62, a52) > 0);
                        assert (iacl.compare(a62, a7) < 0);
                        assert (iaclf.compare(a62, a7) > 0);
                        assert (iacl.compare(a7, a62) > 0);
                        assert (iaclf.compare(a7, a62) < 0);
                        assert (iacl.compare(a12, a42) < 0);
                        assert (iaclf.compare(a12, a42) < 0);
                        assert (iacl.compare(a42, a12) > 0);
                        assert (iaclf.compare(a42, a12) > 0);
                        assert (iacl.compare(a22, a42) < 0);
                        assert (iaclf.compare(a22, a42) < 0);
                        assert (iacl.compare(a42, a22) > 0);
                        assert (iaclf.compare(a42, a22) > 0);
                        assert (iacl.compare(a62, a42) > 0);
                        assert (iaclf.compare(a62, a42) > 0);
                        assert (iacl.compare(a42, a62) < 0);
                        assert (iaclf.compare(a42, a62) < 0);
                        assert (iacl.compare(a7, a42) > 0);
                        assert (iaclf.compare(a7, a42) < 0);
                        assert (iacl.compare(a42, a7) < 0);
                        assert (iaclf.compare(a42, a7) > 0);
                        assert (iacl.compare(a8, a9) < 0);
                        assert (iaclf.compare(a8, a9) < 0);
                        assert (iacl.compare(a10, a7) < 0);
                        ArraysMDE.LongArrayComparatorLexical lacl = new ArraysMDE.LongArrayComparatorLexical();
                        ArraysMDE.LongArrayComparatorLengthFirst laclf = new ArraysMDE.LongArrayComparatorLengthFirst();
                        a0 = new long[0];
                        a12 = new long[0];
                        a22 = new long[]{0L, 1L, 2L, 3L};
                        a32 = new long[]{0L, 1L, 2L, 3L, 0L};
                        a42 = new long[]{0L, 1L, 2L, 3L, 4L};
                        a52 = new long[]{0L, 1L, 2L, 3L, 4L};
                        a62 = new long[]{0L, 1L, 5L, 3L, 4L};
                        a7 = new long[]{1L, 2L, 3L, 4L};
                        a8 = new long[]{-5L};
                        a9 = new long[]{Long.MAX_VALUE};
                        a10 = new long[]{Long.MIN_VALUE};
                        assert (lacl.compare(a0, a12) == 0);
                        assert (laclf.compare(a0, a12) == 0);
                        assert (lacl.compare(a12, a0) == 0);
                        assert (laclf.compare(a12, a0) == 0);
                        assert (lacl.compare(a12, a22) < 0);
                        assert (laclf.compare(a12, a22) < 0);
                        assert (lacl.compare(a22, a12) > 0);
                        assert (laclf.compare(a22, a12) > 0);
                        assert (lacl.compare(a22, a32) < 0);
                        assert (laclf.compare(a22, a32) < 0);
                        assert (lacl.compare(a32, a22) > 0);
                        assert (laclf.compare(a32, a22) > 0);
                        assert (lacl.compare(a32, a42) < 0);
                        assert (laclf.compare(a32, a42) < 0);
                        assert (lacl.compare(a42, a32) > 0);
                        assert (laclf.compare(a42, a32) > 0);
                        assert (lacl.compare(a42, a52) == 0);
                        assert (laclf.compare(a42, a52) == 0);
                        assert (lacl.compare(a52, a42) == 0);
                        assert (laclf.compare(a52, a42) == 0);
                        assert (lacl.compare(a52, a62) < 0);
                        assert (laclf.compare(a52, a62) < 0);
                        assert (lacl.compare(a62, a52) > 0);
                        assert (laclf.compare(a62, a52) > 0);
                        assert (lacl.compare(a62, a7) < 0);
                        assert (laclf.compare(a62, a7) > 0);
                        assert (lacl.compare(a7, a62) > 0);
                        assert (laclf.compare(a7, a62) < 0);
                        assert (lacl.compare(a12, a42) < 0);
                        assert (laclf.compare(a12, a42) < 0);
                        assert (lacl.compare(a42, a12) > 0);
                        assert (laclf.compare(a42, a12) > 0);
                        assert (lacl.compare(a22, a42) < 0);
                        assert (laclf.compare(a22, a42) < 0);
                        assert (lacl.compare(a42, a22) > 0);
                        assert (laclf.compare(a42, a22) > 0);
                        assert (lacl.compare(a62, a42) > 0);
                        assert (laclf.compare(a62, a42) > 0);
                        assert (lacl.compare(a42, a62) < 0);
                        assert (laclf.compare(a42, a62) < 0);
                        assert (lacl.compare(a7, a42) > 0);
                        assert (laclf.compare(a7, a42) < 0);
                        assert (lacl.compare(a42, a7) < 0);
                        assert (laclf.compare(a42, a7) > 0);
                        assert (lacl.compare(a8, a9) < 0);
                        assert (laclf.compare(a8, a9) < 0);
                        assert (lacl.compare(a10, a7) < 0);
                        ArraysMDE.DoubleArrayComparatorLexical dacl = new ArraysMDE.DoubleArrayComparatorLexical();
                        double[] a02 = new double[]{};
                        a1 = new double[]{};
                        a2 = new double[]{0.0, 1.0, 2.0, 3.0};
                        a3 = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
                        a4 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
                        a5 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
                        a6 = new double[]{0.0, 1.0, 5.0, 3.0, 4.0};
                        double[] a72 = new double[]{1.0, 2.0, 3.0, 4.0};
                        double[] a82 = new double[]{0.005};
                        double[] a92 = new double[]{0.004};
                        double[] a102 = new double[]{-0.005};
                        double[] a11 = new double[]{-0.004};
                        double[] a122 = new double[]{2.147483647E10};
                        double[] a13 = new double[]{-2.147483648E10};
                        assert (dacl.compare(a02, a1) == 0);
                        assert (dacl.compare(a1, a02) == 0);
                        assert (dacl.compare(a1, a2) < 0);
                        assert (dacl.compare(a2, a1) > 0);
                        assert (dacl.compare(a2, a3) < 0);
                        assert (dacl.compare(a3, a2) > 0);
                        assert (dacl.compare(a3, a4) < 0);
                        assert (dacl.compare(a4, a3) > 0);
                        assert (dacl.compare(a4, a5) == 0);
                        assert (dacl.compare(a5, a4) == 0);
                        assert (dacl.compare(a5, a6) < 0);
                        assert (dacl.compare(a6, a5) > 0);
                        assert (dacl.compare(a6, a72) < 0);
                        assert (dacl.compare(a72, a6) > 0);
                        assert (dacl.compare(a1, a4) < 0);
                        assert (dacl.compare(a4, a1) > 0);
                        assert (dacl.compare(a2, a4) < 0);
                        assert (dacl.compare(a4, a2) > 0);
                        assert (dacl.compare(a6, a4) > 0);
                        assert (dacl.compare(a4, a6) < 0);
                        assert (dacl.compare(a72, a4) > 0);
                        assert (dacl.compare(a4, a72) < 0);
                        assert (dacl.compare(a82, a92) > 0);
                        assert (dacl.compare(a102, a11) < 0);
                        assert (dacl.compare(a11, a122) < 0);
                        assert (dacl.compare(a122, a13) > 0);
                        assert (dacl.compare(a13, a11) < 0);
                        ArraysMDE.ComparableArrayComparatorLexical<int[]> cacl = new ArraysMDE.ComparableArrayComparatorLexical<int[]>();
                        ArraysMDE.ComparableArrayComparatorLengthFirst<int[]> caclf = new ArraysMDE.ComparableArrayComparatorLengthFirst<int[]>();
                        a0 = new String[0];
                        a12 = new String[0];
                        a22 = new String[]{"0", "1", "2", "3"};
                        a32 = new String[]{"0", "1", "2", "3", "0"};
                        a42 = new String[]{"0", "1", "2", "3", "4"};
                        a52 = new String[]{"0", "1", "2", "3", "4"};
                        a62 = new String[]{"0", "1", "5", "3", "4"};
                        a7 = new String[]{"1", "2", "3", "4"};
                        a8 = new String[]{"0", "1", null, "3", "4"};
                        assert (cacl.compare((int[])a0, (int[])a12) == 0);
                        assert (caclf.compare((int[])a0, (int[])a12) == 0);
                        assert (cacl.compare((int[])a12, (int[])a0) == 0);
                        assert (caclf.compare((int[])a12, (int[])a0) == 0);
                        assert (cacl.compare((int[])a12, (int[])a22) < 0);
                        assert (caclf.compare((int[])a12, (int[])a22) < 0);
                        assert (cacl.compare((int[])a22, (int[])a12) > 0);
                        assert (caclf.compare((int[])a22, (int[])a12) > 0);
                        assert (cacl.compare((int[])a22, (int[])a32) < 0);
                        assert (caclf.compare((int[])a22, (int[])a32) < 0);
                        assert (cacl.compare((int[])a32, (int[])a22) > 0);
                        assert (caclf.compare((int[])a32, (int[])a22) > 0);
                        assert (cacl.compare((int[])a32, (int[])a42) < 0);
                        assert (caclf.compare((int[])a32, (int[])a42) < 0);
                        assert (cacl.compare((int[])a42, (int[])a32) > 0);
                        assert (caclf.compare((int[])a42, (int[])a32) > 0);
                        assert (cacl.compare((int[])a42, (int[])a52) == 0);
                        assert (caclf.compare((int[])a42, (int[])a52) == 0);
                        assert (cacl.compare((int[])a52, (int[])a42) == 0);
                        assert (caclf.compare((int[])a52, (int[])a42) == 0);
                        assert (cacl.compare((int[])a52, (int[])a62) < 0);
                        assert (caclf.compare((int[])a52, (int[])a62) < 0);
                        assert (cacl.compare((int[])a62, (int[])a52) > 0);
                        assert (caclf.compare((int[])a62, (int[])a52) > 0);
                        assert (cacl.compare((int[])a62, (int[])a7) < 0);
                        assert (caclf.compare((int[])a62, (int[])a7) > 0);
                        assert (cacl.compare((int[])a7, (int[])a62) > 0);
                        assert (caclf.compare((int[])a7, (int[])a62) < 0);
                        assert (cacl.compare((int[])a12, (int[])a42) < 0);
                        assert (caclf.compare((int[])a12, (int[])a42) < 0);
                        assert (cacl.compare((int[])a42, (int[])a12) > 0);
                        assert (caclf.compare((int[])a42, (int[])a12) > 0);
                        assert (cacl.compare((int[])a22, (int[])a42) < 0);
                        assert (caclf.compare((int[])a22, (int[])a42) < 0);
                        assert (cacl.compare((int[])a42, (int[])a22) > 0);
                        assert (caclf.compare((int[])a42, (int[])a22) > 0);
                        assert (cacl.compare((int[])a62, (int[])a42) > 0);
                        assert (caclf.compare((int[])a62, (int[])a42) > 0);
                        assert (cacl.compare((int[])a42, (int[])a62) < 0);
                        assert (caclf.compare((int[])a42, (int[])a62) < 0);
                        assert (cacl.compare((int[])a7, (int[])a42) > 0);
                        assert (caclf.compare((int[])a7, (int[])a42) < 0);
                        assert (cacl.compare((int[])a8, (int[])a12) > 0);
                        assert (caclf.compare((int[])a8, (int[])a12) > 0);
                        assert (cacl.compare((int[])a12, (int[])a8) < 0);
                        assert (caclf.compare((int[])a12, (int[])a8) < 0);
                        assert (cacl.compare((int[])a8, (int[])a22) < 0);
                        assert (caclf.compare((int[])a8, (int[])a22) > 0);
                        assert (cacl.compare((int[])a22, (int[])a8) > 0);
                        assert (caclf.compare((int[])a22, (int[])a8) < 0);
                        assert (cacl.compare((int[])a8, (int[])a32) < 0);
                        assert (caclf.compare((int[])a8, (int[])a32) < 0);
                        assert (cacl.compare((int[])a32, (int[])a8) > 0);
                        assert (caclf.compare((int[])a32, (int[])a8) > 0);
                        Object o = new Object();
                        assert (!ArraysMDE.any_null(new Object[0]));
                        assert (ArraysMDE.any_null(new Object[]{null}));
                        assert (ArraysMDE.any_null(new Object[]{null, null}));
                        assert (!ArraysMDE.any_null(new Object[]{o}));
                        assert (!ArraysMDE.any_null(new Object[]{o, o}));
                        assert (ArraysMDE.any_null(new Object[]{o, null, null}));
                        assert (ArraysMDE.any_null(new Object[]{null, o, null}));
                        assert (ArraysMDE.any_null(new Object[]{o, null, o}));
                        assert (ArraysMDE.any_null(new Object[]{null, o, o}));
                        assert (!ArraysMDE.any_null((Object[])new Object[0][]));
                        assert (ArraysMDE.any_null((Object[])new Object[][]{null}));
                        assert (!ArraysMDE.any_null((Object[])new Object[][]{{null}}));
                        assert (ArraysMDE.any_null((Object[])new Object[][]{{null}, null}));
                        assert (!ArraysMDE.any_null((Object[])new Object[][]{{null}, {o}}));
                        o = new Object();
                        assert (ArraysMDE.all_null(new Object[0]));
                        assert (ArraysMDE.all_null(new Object[]{null}));
                        assert (ArraysMDE.all_null(new Object[]{null, null}));
                        assert (!ArraysMDE.all_null(new Object[]{o}));
                        assert (!ArraysMDE.all_null(new Object[]{o, o}));
                        assert (!ArraysMDE.all_null(new Object[]{o, null, null}));
                        assert (!ArraysMDE.all_null(new Object[]{null, o, null}));
                        assert (!ArraysMDE.all_null(new Object[]{o, null, o}));
                        assert (!ArraysMDE.all_null(new Object[]{null, o, o}));
                        assert (ArraysMDE.all_null((Object[])new Object[0][]));
                        assert (ArraysMDE.all_null((Object[])new Object[][]{null}));
                        assert (ArraysMDE.all_null((Object[])new Object[][]{null, null}));
                        assert (!ArraysMDE.all_null((Object[])new Object[][]{{null}}));
                        assert (!ArraysMDE.all_null((Object[])new Object[][]{{null}, null}));
                        assert (!ArraysMDE.all_null((Object[])new Object[][]{{null}, {o}}));
                        return;
                    }
                }
            }
        }
    }

    @Test
    public void testHasher() {
        class InternTest {
            InternTest() {
            }

            void test(boolean random) {
                int i;
                int size1 = random ? 100 : 1;
                int size2 = random ? 10 : 1;
                Random random_gen = new Random();
                int[][] arrays = new int[100][];
                for (i = 0; i < arrays.length; ++i) {
                    int[] a = new int[10];
                    for (int j = 0; j < a.length; ++j) {
                        a[j] = random ? random_gen.nextInt(1000) : j;
                    }
                    arrays[i] = a;
                    a = null;
                }
                System.gc();
                if (Intern.numIntArrays() != 0) {
                    throw new Error(" expected 0 int arrays at start, found " + Intern.numIntArrays());
                }
                for (i = 0; i < arrays.length; ++i) {
                    Intern.intern(arrays[i]);
                }
                if (Intern.numIntArrays() != size1) {
                    throw new Error("Expected " + size1 + ", got " + Intern.numIntArrays() + " int arrays");
                }
                System.gc();
                if (Intern.numIntArrays() != size1) {
                    throw new Error();
                }
                for (i = 10; i < arrays.length; ++i) {
                    Object reset_value = null;
                    arrays[i] = reset_value;
                }
                System.gc();
                if (Intern.numIntArrays() != size2) {
                    if (Intern.numIntArrays() < size2 + 10) {
                        System.out.println("Is JIT disabled?  Size should have been " + size2 + ", actually was " + Intern.numIntArrays());
                    } else {
                        System.out.println("================");
                        for (i = 0; i < arrays.length; ++i) {
                            System.out.println(ArraysMDE.toString(arrays[i]));
                        }
                        System.out.println("================");
                        Iterator<int[]> itor = Intern.intArrays();
                        while (itor.hasNext()) {
                            System.out.println(ArraysMDE.toString(itor.next()));
                        }
                        String message = "Size should have been " + size2 + ", actually was " + Intern.numIntArrays();
                        System.out.println(message);
                        throw new Error(message);
                    }
                }
            }
        }
        InternTest intern = new InternTest();
        intern.test(true);
        intern.test(false);
    }

    @Test
    public void testIntern() {
        Integer i = Intern.internedInteger("1234");
        assert (Intern.isInterned(i));
        assert (i == 1234);
        i = Intern.internedInteger("0x12ab");
        assert (Intern.isInterned(i));
        assert (i == 4779);
        Long l = Intern.internedLong("12345678");
        assert (Intern.isInterned(l));
        assert (l.intValue() == 12345678);
        l = Intern.internedLong("0x1234abcd");
        assert (Intern.isInterned(l));
        assert (l.intValue() == 305441741);
    }

    @Test
    public void testInternObject() {
        Object nIntern = Intern.intern(null);
        assert (nIntern == null);
        String sOrig = new String("foo");
        String sIntern = Intern.intern(sOrig);
        Object sObjIntern = Intern.intern((Object)sOrig);
        assert (sIntern == sObjIntern);
        String sOtherIntern = Intern.intern(new String("foo"));
        assert (sIntern == sOtherIntern);
        String[] saOrig = new String[]{"foo", "bar"};
        String[] saIntern = Intern.intern(saOrig);
        Object saObjIntern = Intern.intern((Object)saOrig);
        assert (saIntern == saObjIntern);
        String[] saOtherIntern = Intern.intern(new String[]{"foo", "bar"});
        assert (saIntern == saOtherIntern);
        Integer iOrig = new Integer(1);
        Integer iIntern = Intern.intern(iOrig);
        Object iObjIntern = Intern.intern((Object)iOrig);
        assert (iIntern == iObjIntern);
        Object iOtherIntern = Intern.intern((Object)new Integer(1));
        assert (iIntern == iOtherIntern);
        Long lOrig = new Long(12345678901234L);
        Long lIntern = Intern.intern(lOrig);
        Object lObjIntern = Intern.intern((Object)lOrig);
        assert (lIntern == lObjIntern);
        Object lOtherIntern = Intern.intern((Object)new Long(12345678901234L));
        assert (lIntern == lOtherIntern);
        int[] iaOrig = new int[]{1, 2, 3};
        int[] iaIntern = Intern.intern(iaOrig);
        Object iaObjIntern = Intern.intern((Object)iaOrig);
        assert (iaIntern == iaObjIntern);
        Object iaOtherIntern = Intern.intern((Object)new int[]{1, 2, 3});
        assert (iaIntern == iaOtherIntern);
        long[] laOrig = new long[]{12345678901234L, 98765432109876L};
        long[] laIntern = Intern.intern(laOrig);
        Object laObjIntern = Intern.intern((Object)laOrig);
        assert (laIntern == laObjIntern);
        Object laOtherIntern = Intern.intern((Object)new long[]{12345678901234L, 98765432109876L});
        assert (laIntern == laOtherIntern);
        Double dOrig = new Double(3.14);
        Double dIntern = Intern.intern(dOrig);
        Object dObjIntern = Intern.intern((Object)dOrig);
        assert (dIntern == dObjIntern);
        Object dOtherIntern = Intern.intern((Object)dOrig);
        assert (dIntern == dOtherIntern);
        Double dnOrig = new Double(Double.NaN);
        Double dnIntern = Intern.intern(dnOrig);
        Object dnObjIntern = Intern.intern((Object)dnOrig);
        assert (dnIntern == dnObjIntern);
        Object dnOtherIntern = Intern.intern((Object)new Double(Double.NaN));
        assert (dnIntern == dnOtherIntern);
        Double diOrig = new Double(Double.POSITIVE_INFINITY);
        Double diIntern = Intern.intern(diOrig);
        Object diObjIntern = Intern.intern((Object)diOrig);
        assert (diIntern == diObjIntern);
        Object diOtherIntern = Intern.intern((Object)new Double(Double.POSITIVE_INFINITY));
        assert (diIntern == diOtherIntern);
        double positive_zero = 0.0;
        double negative_zero = -0.0;
        assert (positive_zero == negative_zero);
        assert (1.0 / positive_zero == Double.POSITIVE_INFINITY);
        assert (1.0 / negative_zero == Double.NEGATIVE_INFINITY);
        Double dzOrig = new Double(positive_zero);
        Double dzIntern = Intern.intern(dzOrig);
        Object dzObjIntern = Intern.intern((Object)dzOrig);
        assert (dzIntern == dzObjIntern);
        Object dzOtherIntern = Intern.intern((Object)new Double(negative_zero));
        assert (dzIntern == dzOtherIntern);
        double[] daOrig = new double[]{3.14, 2.71};
        double[] daIntern = Intern.intern(daOrig);
        Object daObjIntern = Intern.intern((Object)daOrig);
        assert (daIntern == daObjIntern);
        Object daOtherIntern = Intern.intern((Object)new double[]{3.14, 2.71});
        assert (daIntern == daOtherIntern);
        double[] da2Orig = new double[]{0.0, Double.NaN};
        double[] da2Intern = Intern.intern(da2Orig);
        Object da2ObjIntern = Intern.intern((Object)da2Orig);
        assert (da2Intern == da2ObjIntern);
        Object da2OtherIntern = Intern.intern((Object)new double[]{-0.0, Double.NaN});
        assert (da2Intern == da2OtherIntern);
        Object[] oaOrig = new Object[]{new String("foo"), new Integer(1)};
        Object[] oaIntern = Intern.intern(oaOrig);
        Object oaObjIntern = Intern.intern((Object)oaOrig);
        assert (oaIntern == oaObjIntern);
        Object oaOtherIntern = Intern.intern((Object)new Object[]{new String("foo"), new Integer(1)});
        assert (oaIntern == oaOtherIntern);
        Point pOrig = new Point(1, 2);
        try {
            Intern.intern(pOrig);
            throw new Error("Didn't throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private static void lsis_add_elts(int limit, LimitedSizeSet<Integer> s2) {
        Random r = new Random(20140613L);
        for (int i = 0; i < 100; ++i) {
            s2.add(r.nextInt(limit));
        }
    }

    private static void lsis_test(int max_size) {
        LimitedSizeSet<Integer> s2 = new LimitedSizeSet<Integer>(max_size);
        for (int i = 1; i < 2 * max_size; ++i) {
            TestPlume.lsis_add_elts(i, s2);
            int size = s2.size();
            if ($assertionsDisabled || (i > max_size ? size == max_size + 1 : size == i)) continue;
            throw new AssertionError((Object)String.format("(%d<=%d) ? (%d==%d) : (%d==%d+1)   size=%d, i=%d, max_size=%d, s=%s", i, max_size, size, i, size, max_size, size, i, max_size, s2));
        }
    }

    private static void lss_with_null_test() {
        LimitedSizeSet<Integer> s2 = new LimitedSizeSet<Integer>(10);
        s2.add(1);
        s2.add(2);
        s2.add(null);
        assert (s2.size() == 3);
        assert (s2.contains(1));
        assert (s2.contains(null));
        s2.add(3);
        assert (s2.size() == 4);
        assert (s2.contains(1));
        assert (s2.contains(null));
        assert (s2.contains(3));
    }

    @Test
    public void testLimitedSizeSet() {
        for (int i = 1; i < 10; ++i) {
            TestPlume.lsis_test(i);
        }
        TestPlume.lss_with_null_test();
    }

    @Test
    public void testMathMDE() {
        assert (MathMDE.negate(3) == -3);
        assert (MathMDE.negate(-22) == 22);
        assert (MathMDE.negate(0) == 0);
        assert (MathMDE.bitwiseComplement(3) == -4);
        assert (MathMDE.bitwiseComplement(-22) == 21);
        assert (MathMDE.bitwiseComplement(0) == -1);
        assert (MathMDE.sign(3) == 1);
        assert (MathMDE.sign(-22) == -1);
        assert (MathMDE.sign(0) == 0);
        try {
            assert (MathMDE.pow(3, 3) == 27);
            assert (MathMDE.pow(-5, 5) == -3125);
            assert (MathMDE.pow(22, 0) == 1);
            assert (MathMDE.pow(4, 6) == 4096);
            assert (MathMDE.pow(1, 222222) == 1);
            assert (MathMDE.pow(-2, 25) == -33554432);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
        try {
            MathMDE.pow(3, -3);
            throw new Error("Didn't throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            assert (MathMDE.gcd(2, 50) == 2);
            assert (MathMDE.gcd(50, 2) == 2);
            assert (MathMDE.gcd(12, 144) == 12);
            assert (MathMDE.gcd(144, 12) == 12);
            assert (MathMDE.gcd(96, 144) == 48);
            assert (MathMDE.gcd(144, 96) == 48);
            assert (MathMDE.gcd(10, 25) == 5);
            assert (MathMDE.gcd(25, 10) == 5);
            assert (MathMDE.gcd(17, 25) == 1);
            assert (MathMDE.gcd(25, 17) == 1);
            assert (MathMDE.gcd(0, 10) == 10);
            assert (MathMDE.gcd(10, 0) == 10);
            assert (MathMDE.gcd(25, -10) == 5);
            assert (MathMDE.gcd(-25, -10) == 5);
            assert (MathMDE.gcd(-25, 10) == 5);
            assert (MathMDE.gcd(new int[]{2, 50}) == 2);
            assert (MathMDE.gcd(new int[]{12, 144}) == 12);
            assert (MathMDE.gcd(new int[]{96, 144}) == 48);
            assert (MathMDE.gcd(new int[]{10, 25}) == 5);
            assert (MathMDE.gcd(new int[]{100, 10, 25}) == 5);
            assert (MathMDE.gcd(new int[]{768, 324}) == 12);
            assert (MathMDE.gcd(new int[]{2400, 48, 36}) == 12);
            assert (MathMDE.gcd(new int[]{2400, 72, 36}) == 12);
            assert (MathMDE.gcd_differences(new int[]{0, 2, 52}) == 2);
            assert (MathMDE.gcd_differences(new int[]{0, 12, 156}) == 12);
            assert (MathMDE.gcd_differences(new int[]{0, 96, 240}) == 48);
            assert (MathMDE.gcd_differences(new int[]{0, 10, 35}) == 5);
            assert (MathMDE.gcd_differences(new int[]{0, 100, 110, 135}) == 5);
            assert (MathMDE.gcd_differences(new int[]{0, 768, 1092}) == 12);
            assert (MathMDE.gcd_differences(new int[]{0, 2400, 2448, 2484}) == 12);
            assert (MathMDE.gcd_differences(new int[]{0, 2400, 2472, 2508}) == 12);
            assert (MathMDE.gcd_differences(new int[]{5, 5, 5, 5}) == 0);
            assert (MathMDE.mod_positive(33, 5) == 3);
            assert (MathMDE.mod_positive(-33, 5) == 2);
            assert (MathMDE.mod_positive(33, -5) == 3);
            assert (MathMDE.mod_positive(-33, -5) == 2);
            TestPlume.assert_arrays_equals(MathMDE.missing_numbers(new int[]{3, 4, 5, 6, 7, 8}), new int[0]);
            TestPlume.assert_arrays_equals(MathMDE.missing_numbers(new int[]{3, 4, 6, 7, 8}), new int[]{5});
            TestPlume.assert_arrays_equals(MathMDE.missing_numbers(new int[]{3, 4, 8}), new int[]{5, 6, 7});
            TestPlume.assert_arrays_equals(MathMDE.missing_numbers(new int[]{3, 5, 6, 8}), new int[]{4, 7});
            TestPlume.assert_arrays_equals(MathMDE.missing_numbers(new int[]{3, 6, 8}), new int[]{4, 5, 7});
            TestPlume.assert_arrays_equals(MathMDE.missing_numbers(new int[]{3, 4, 5, 5, 6, 7, 8}), new int[0]);
            TestPlume.assert_arrays_equals(MathMDE.missing_numbers(new int[]{3, 4, 4, 6, 6, 7, 8}), new int[]{5});
            TestPlume.assert_arrays_equals(MathMDE.missing_numbers(new int[]{3, 3, 3}), new int[0]);
            class TestMissingNumbersIteratorInt {
                TestMissingNumbersIteratorInt() {
                }

                void test(int[] orig, boolean add_ends, int[] goal_missing) {
                    Iterator<Integer> orig_iterator = TestPlume.int_array_iterator(orig);
                    MathMDE.MissingNumbersIteratorInt missing_iterator = new MathMDE.MissingNumbersIteratorInt(orig_iterator, add_ends);
                    int[] missing = TestPlume.int_iterator_array(missing_iterator);
                    TestPlume.assert_arrays_equals(missing, goal_missing);
                }
            }
            TestMissingNumbersIteratorInt tmni = new TestMissingNumbersIteratorInt();
            tmni.test(new int[]{3, 4, 5, 6, 7, 8}, false, new int[0]);
            tmni.test(new int[]{3, 4, 6, 7, 8}, false, new int[]{5});
            tmni.test(new int[]{3, 4, 8}, false, new int[]{5, 6, 7});
            tmni.test(new int[]{3, 5, 6, 8}, false, new int[]{4, 7});
            tmni.test(new int[]{3, 6, 8}, false, new int[]{4, 5, 7});
            tmni.test(new int[]{3}, false, new int[0]);
            tmni.test(new int[]{3, 4, 5}, false, new int[0]);
            tmni.test(new int[]{3, 4, 5, 6, 7, 8}, true, new int[]{2, 9});
            tmni.test(new int[]{3, 4, 6, 7, 8}, true, new int[]{2, 5, 9});
            tmni.test(new int[]{3, 4, 8}, true, new int[]{2, 5, 6, 7, 9});
            tmni.test(new int[]{3, 5, 6, 8}, true, new int[]{2, 4, 7, 9});
            tmni.test(new int[]{3, 6, 8}, true, new int[]{2, 4, 5, 7, 9});
            tmni.test(new int[]{3, 4, 5}, true, new int[]{2, 6});
            tmni.test(new int[]{-1, 1, 2, 3, 5, 6, 7, 9}, true, new int[]{-2, 0, 4, 8, 10});
            class TestModulus {
                TestModulus() {
                }

                void check(int[] nums, int[] goal_rm) {
                    int[] rm = MathMDE.modulus(nums);
                    if (!Arrays.equals(rm, goal_rm)) {
                        throw new Error("Expected (r,m)=" + ArraysMDE.toString(goal_rm) + ", saw (r,m)=" + ArraysMDE.toString(rm));
                    }
                    if (rm == null) {
                        return;
                    }
                    int goal_r = rm[0];
                    int m3 = rm[1];
                    for (int i = 0; i < nums.length; ++i) {
                        int r = nums[i] % m3;
                        if (r < 0) {
                            r += m3;
                        }
                        if (r == goal_r) continue;
                        throw new Error("Expected " + nums[i] + " % " + m3 + " = " + goal_r + ", got " + r);
                    }
                }

                void check(Iterator<Integer> itor, int[] goal_rm) {
                    TestPlume.assert_arrays_equals(MathMDE.modulus_int(itor), goal_rm);
                }

                void check_iterator(int[] nums, int[] goal_rm) {
                    this.check(TestPlume.int_array_iterator(nums), goal_rm);
                }
            }
            TestModulus testModulus = new TestModulus();
            testModulus.check(new int[]{3, 7, 47, 51}, new int[]{3, 4});
            testModulus.check(new int[]{3, 11, 43, 51}, new int[]{3, 8});
            testModulus.check(new int[]{3, 11, 47, 55}, new int[]{3, 4});
            testModulus.check(new int[]{2383, 4015, -81, 463, -689}, new int[]{15, 32});
            testModulus.check(new int[0], null);
            testModulus.check(new int[]{1}, null);
            testModulus.check(new int[]{3, 7}, null);
            testModulus.check(new int[]{2, 3, 5, 7}, null);
            testModulus.check(new int[]{2, 19, 101}, null);
            testModulus.check(new int[]{5, 5, 5, 5, 5}, null);
            testModulus.check_iterator(new int[0], null);
            testModulus.check_iterator(new int[]{1}, null);
            testModulus.check_iterator(new int[]{3, 7, 47, 51}, new int[]{3, 4});
            testModulus.check_iterator(new int[]{3, 11, 43, 51}, new int[]{3, 8});
            testModulus.check_iterator(new int[]{3, 11, 47, 55}, new int[]{3, 4});
            testModulus.check_iterator(new int[]{2383, 4015, -81, 463, -689}, new int[]{15, 32});
            testModulus.check_iterator(new int[]{5, 5, 5, 5, 5}, null);
            class TestNonModulus {
                TestNonModulus() {
                }

                void check_strict(int[] nums, int[] goal_rm) {
                    this.check(nums, goal_rm, true);
                    Iterator<Integer> itor = TestPlume.int_array_iterator(nums);
                    TestPlume.assert_arrays_equals(MathMDE.nonmodulus_strict_int(itor), goal_rm);
                }

                void check_nonstrict(int[] nums, int[] goal_rm) {
                    this.check(nums, goal_rm, false);
                }

                void check(int[] nums, int[] goal_rm, boolean strict) {
                    int[] rm = strict ? MathMDE.nonmodulus_strict(nums) : MathMDE.nonmodulus_nonstrict(nums);
                    if (!Arrays.equals(rm, goal_rm)) {
                        throw new Error("Expected (r,m)=" + ArraysMDE.toString(goal_rm) + ", saw (r,m)=" + ArraysMDE.toString(rm));
                    }
                    if (rm == null) {
                        return;
                    }
                    int goal_r = rm[0];
                    int m3 = rm[1];
                    for (int i = 0; i < nums.length; ++i) {
                        int r = nums[i] % m3;
                        if (r < 0) {
                            r += m3;
                        }
                        if (r != goal_r) continue;
                        throw new Error("Expected inequality, saw " + nums[i] + " % " + m3 + " = " + r);
                    }
                }
            }
            TestNonModulus testNonModulus = new TestNonModulus();
            testNonModulus.check_strict(new int[]{1, 2, 3, 5, 6, 7, 9}, null);
            testNonModulus.check_strict(new int[]{-1, 1, 2, 3, 5, 6, 7, 9}, new int[]{0, 4});
            testNonModulus.check_strict(new int[]{1, 2, 3, 5, 6, 7, 9, 11}, null);
            testNonModulus.check_strict(new int[]{1, 2, 3, 5, 6, 7, 11}, null);
            testNonModulus.check_strict(new int[]{1, 2, 4, 6, 8, 10}, null);
            testNonModulus.check_nonstrict(new int[]{1, 2, 3, 5, 6, 7, 9}, null);
            testNonModulus.check_nonstrict(new int[]{1, 2, 3, 5, 6, 7, 9, 10}, new int[]{0, 4});
            testNonModulus.check_nonstrict(new int[]{1, 2, 3, 5, 6, 7, 9, 11}, new int[]{0, 4});
            testNonModulus.check_nonstrict(new int[]{1, 2, 3, 5, 6, 7, 9, 11, 12, 13}, null);
            testNonModulus.check_nonstrict(new int[]{1, 2, 3, 5, 6, 7, 9, 11, 12, 13, 14, 15}, new int[]{4, 6});
            testNonModulus.check_nonstrict(new int[]{1, 2, 3, 5, 6, 7, 9, 11, 12, 13, 14, 15, 22}, null);
            return;
        }
    }

    @Test
    public void testOrderedPairIterator() {
        int NULL = -2222;
        Vector<Integer> ones = new Vector<Integer>();
        for (int i = 1; i <= 30; ++i) {
            ones.add(new Integer(i));
        }
        Vector<Integer> twos = new Vector<Integer>();
        for (int i = 2; i <= 30; i += 2) {
            twos.add(new Integer(i));
        }
        Vector<Integer> threes = new Vector<Integer>();
        for (int i = 3; i <= 30; i += 3) {
            threes.add(new Integer(i));
        }
        TestPlume.compareOrderedPairIterator(new OrderedPairIterator<Integer>(ones.iterator(), ones.iterator()), new int[][]{{1, 1}, {2, 2}, {3, 3}, {4, 4}, {5, 5}, {6, 6}, {7, 7}, {8, 8}, {9, 9}, {10, 10}, {11, 11}, {12, 12}, {13, 13}, {14, 14}, {15, 15}, {16, 16}, {17, 17}, {18, 18}, {19, 19}, {20, 20}, {21, 21}, {22, 22}, {23, 23}, {24, 24}, {25, 25}, {26, 26}, {27, 27}, {28, 28}, {29, 29}, {30, 30}});
        TestPlume.compareOrderedPairIterator(new OrderedPairIterator<Integer>(ones.iterator(), twos.iterator()), new int[][]{{1, -2222}, {2, 2}, {3, -2222}, {4, 4}, {5, -2222}, {6, 6}, {7, -2222}, {8, 8}, {9, -2222}, {10, 10}, {11, -2222}, {12, 12}, {13, -2222}, {14, 14}, {15, -2222}, {16, 16}, {17, -2222}, {18, 18}, {19, -2222}, {20, 20}, {21, -2222}, {22, 22}, {23, -2222}, {24, 24}, {25, -2222}, {26, 26}, {27, -2222}, {28, 28}, {29, -2222}, {30, 30}});
        TestPlume.compareOrderedPairIterator(new OrderedPairIterator<Integer>(twos.iterator(), ones.iterator()), new int[][]{{-2222, 1}, {2, 2}, {-2222, 3}, {4, 4}, {-2222, 5}, {6, 6}, {-2222, 7}, {8, 8}, {-2222, 9}, {10, 10}, {-2222, 11}, {12, 12}, {-2222, 13}, {14, 14}, {-2222, 15}, {16, 16}, {-2222, 17}, {18, 18}, {-2222, 19}, {20, 20}, {-2222, 21}, {22, 22}, {-2222, 23}, {24, 24}, {-2222, 25}, {26, 26}, {-2222, 27}, {28, 28}, {-2222, 29}, {30, 30}});
        TestPlume.compareOrderedPairIterator(new OrderedPairIterator<Integer>(ones.iterator(), threes.iterator()), new int[][]{{1, -2222}, {2, -2222}, {3, 3}, {4, -2222}, {5, -2222}, {6, 6}, {7, -2222}, {8, -2222}, {9, 9}, {10, -2222}, {11, -2222}, {12, 12}, {13, -2222}, {14, -2222}, {15, 15}, {16, -2222}, {17, -2222}, {18, 18}, {19, -2222}, {20, -2222}, {21, 21}, {22, -2222}, {23, -2222}, {24, 24}, {25, -2222}, {26, -2222}, {27, 27}, {28, -2222}, {29, -2222}, {30, 30}});
        TestPlume.compareOrderedPairIterator(new OrderedPairIterator<Integer>(twos.iterator(), threes.iterator()), new int[][]{{2, -2222}, {-2222, 3}, {4, -2222}, {6, 6}, {8, -2222}, {-2222, 9}, {10, -2222}, {12, 12}, {14, -2222}, {-2222, 15}, {16, -2222}, {18, 18}, {20, -2222}, {-2222, 21}, {22, -2222}, {24, 24}, {26, -2222}, {-2222, 27}, {28, -2222}, {30, 30}});
    }

    public static void compareOrderedPairIterator(OrderedPairIterator<Integer> opi, int[][] ints) {
        int pairno = 0;
        while (opi.hasNext()) {
            Object pair = opi.next();
            assert (((Pair)pair).a == null || (Integer)((Pair)pair).a == ints[pairno][0]);
            assert (((Pair)pair).b == null || (Integer)((Pair)pair).b == ints[pairno][1]);
            ++pairno;
        }
        assert (pairno == ints.length);
    }

    private static Triple<Integer, String, String> printFive(int timePerNumber, int timeLimit, boolean cache_stdout) {
        int result;
        TimeLimitProcess p;
        String command = "java plume.TestPlume$PrintOneIntPerTimePeriod 5 " + timePerNumber;
        try {
            p = new TimeLimitProcess(runtime.exec(command), (long)timeLimit, cache_stdout);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        try {
            result = p.waitFor();
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
        String out = UtilMDE.streamString(p.getInputStream());
        String err = UtilMDE.streamString(p.getErrorStream());
        return Triple.of(result, out, err);
    }

    private static void checkPrintFive(int timePerNumber, int timeLimit, boolean cache_stdout, String out, String err) {
        Triple<Integer, String, String> results = TestPlume.printFive(timePerNumber, timeLimit, cache_stdout);
        if (!((String)results.b).equals(out)) {
            throw new Error(String.format("Expected %s, got %s", out, results.b));
        }
        if (!((String)results.c).equals(err)) {
            throw new Error(String.format("Expected %s, got %s", err, results.c));
        }
    }

    @Test
    public void testTimeLimitProcess() {
    }

    private static BitSet randomBitSet(int length, Random r) {
        BitSet result = new BitSet(length);
        for (int i = 0; i < length; ++i) {
            result.set(i, r.nextBoolean());
        }
        return result;
    }

    @Test
    public void testStringBuilderDelimited() {
        this.compareJoinAndSBD(new String[]{"foo", "bar", "baz"});
        this.compareJoinAndSBD(new String[]{"foo"});
        this.compareJoinAndSBD(new String[0]);
    }

    public void compareJoinAndSBD(String[] strings) {
        StringBuilderDelimited sbd = new StringBuilderDelimited(",");
        for (String str : strings) {
            sbd.append(str);
        }
        assert (sbd.toString().equals(UtilMDE.join(strings, ",")));
    }

    private static void checkTypeStrings(String fqn, String bn, String cgn, String fd) {
        TestPlume.checkTypeStrings(fqn, bn, cgn, fd, false);
    }

    private static void checkTypeStrings(String fqn, String bn, String cgn, String fd, boolean skipClassForName) {
        if (!skipClassForName) {
            try {
                UtilMDE.classForName(cgn);
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
        }
        assert (fd.equals(UtilMDE.binaryNameToFieldDescriptor(bn)));
        assert (cgn.equals(UtilMDE.binaryNameToClassGetName(bn))) : bn + " => " + UtilMDE.binaryNameToClassGetName(bn) + ", should be " + cgn;
        assert (cgn.equals(UtilMDE.fieldDescriptorToClassGetName(fd))) : fd + " => " + cgn;
        assert (bn.equals(UtilMDE.fieldDescriptorToBinaryName(fd)));
    }

    @Test
    public void testUtilMDE() {
        Random r = new Random(20031008L);
        for (int i = 0; i < 100; ++i) {
            int j;
            BitSet b1 = TestPlume.randomBitSet(r.nextInt(100), r);
            BitSet b2 = TestPlume.randomBitSet(r.nextInt(100), r);
            BitSet b3 = TestPlume.randomBitSet(r.nextInt(100), r);
            BitSet intersection = (BitSet)b1.clone();
            intersection.and(b2);
            int card = intersection.cardinality();
            for (j = 0; j < 100; ++j) {
                assert (UtilMDE.intersectionCardinalityAtLeast(b1, b2, j) == card >= j);
            }
            intersection.and(b3);
            card = intersection.cardinality();
            for (j = 0; j < 100; ++j) {
                assert (UtilMDE.intersectionCardinalityAtLeast(b1, b2, b3, j) == card >= j);
            }
        }
        assert (UtilMDE.isSubtype(Integer.class, Integer.class));
        assert (UtilMDE.isSubtype(Cloneable.class, Cloneable.class));
        assert (UtilMDE.isSubtype(Object.class, Object.class));
        assert (UtilMDE.isSubtype(Integer.class, Number.class));
        assert (!UtilMDE.isSubtype(Number.class, Integer.class));
        assert (UtilMDE.isSubtype(Integer.class, Comparable.class));
        assert (!UtilMDE.isSubtype(Comparable.class, Integer.class));
        assert (UtilMDE.isSubtype(Integer.class, Object.class));
        assert (!UtilMDE.isSubtype(Object.class, Integer.class));
        assert (!UtilMDE.isSubtype(Integer.class, Float.class));
        assert (UtilMDE.isSubtype(Collection.class, Iterable.class));
        assert (!UtilMDE.isSubtype(Iterable.class, Collection.class));
        assert (UtilMDE.isSubtype(ArrayList.class, Iterable.class));
        assert (!UtilMDE.isSubtype(Iterable.class, ArrayList.class));
        assert (UtilMDE.isSubtype(ArrayList.class, Cloneable.class));
        assert (!UtilMDE.isSubtype(Cloneable.class, ArrayList.class));
        assert (UtilMDE.isSubtype(ArrayList.class, List.class));
        assert (!UtilMDE.isSubtype(List.class, ArrayList.class));
        assert (UtilMDE.binaryNameToFieldDescriptor("boolean").equals("Z"));
        assert (UtilMDE.binaryNameToFieldDescriptor("byte").equals("B"));
        assert (UtilMDE.binaryNameToFieldDescriptor("char").equals("C"));
        assert (UtilMDE.binaryNameToFieldDescriptor("double").equals("D"));
        assert (UtilMDE.binaryNameToFieldDescriptor("float").equals("F"));
        assert (UtilMDE.binaryNameToFieldDescriptor("int").equals("I"));
        assert (UtilMDE.binaryNameToFieldDescriptor("long").equals("J"));
        assert (UtilMDE.binaryNameToFieldDescriptor("short").equals("S"));
        assert (UtilMDE.binaryNameToFieldDescriptor("Integer").equals("LInteger;"));
        assert (UtilMDE.binaryNameToFieldDescriptor("Java.lang.Integer").equals("LJava/lang/Integer;"));
        assert (UtilMDE.binaryNameToFieldDescriptor("int[][]").equals("[[I"));
        assert (UtilMDE.binaryNameToFieldDescriptor("Java.lang.Integer[][][]").equals("[[[LJava/lang/Integer;"));
        assert (UtilMDE.binaryNameToClassGetName("boolean").equals("boolean"));
        assert (UtilMDE.binaryNameToClassGetName("byte").equals("byte"));
        assert (UtilMDE.binaryNameToClassGetName("char").equals("char"));
        assert (UtilMDE.binaryNameToClassGetName("double").equals("double"));
        assert (UtilMDE.binaryNameToClassGetName("float").equals("float"));
        assert (UtilMDE.binaryNameToClassGetName("int").equals("int"));
        assert (UtilMDE.binaryNameToClassGetName("long").equals("long"));
        assert (UtilMDE.binaryNameToClassGetName("short").equals("short"));
        assert (UtilMDE.binaryNameToClassGetName("Integer").equals("Integer"));
        assert (UtilMDE.binaryNameToClassGetName("Java.lang.Integer").equals("Java.lang.Integer"));
        assert (UtilMDE.binaryNameToClassGetName("int[][]").equals("[[I"));
        assert (UtilMDE.binaryNameToClassGetName("Java.lang.Integer[][][]").equals("[[[LJava.lang.Integer;"));
        assert (UtilMDE.arglistToJvm("()").equals("()"));
        assert (UtilMDE.arglistToJvm("(int)").equals("(I)"));
        assert (UtilMDE.arglistToJvm("(int, int)").equals("(II)"));
        assert (UtilMDE.arglistToJvm("(int, long, short)").equals("(IJS)"));
        assert (UtilMDE.arglistToJvm("(java.lang.Integer, int, java.lang.Integer)").equals("(Ljava/lang/Integer;ILjava/lang/Integer;)"));
        assert (UtilMDE.arglistToJvm("(int[])").equals("([I)"));
        assert (UtilMDE.arglistToJvm("(int[], int, int)").equals("([III)"));
        assert (UtilMDE.arglistToJvm("(int, int[][], int)").equals("(I[[II)"));
        assert (UtilMDE.arglistToJvm("(java.lang.Integer[], int, java.lang.Integer[][])").equals("([Ljava/lang/Integer;I[[Ljava/lang/Integer;)"));
        assert (UtilMDE.fieldDescriptorToBinaryName("Z").equals("boolean"));
        assert (UtilMDE.fieldDescriptorToBinaryName("B").equals("byte"));
        assert (UtilMDE.fieldDescriptorToBinaryName("C").equals("char"));
        assert (UtilMDE.fieldDescriptorToBinaryName("D").equals("double"));
        assert (UtilMDE.fieldDescriptorToBinaryName("F").equals("float"));
        assert (UtilMDE.fieldDescriptorToBinaryName("I").equals("int"));
        assert (UtilMDE.fieldDescriptorToBinaryName("J").equals("long"));
        assert (UtilMDE.fieldDescriptorToBinaryName("S").equals("short"));
        assert (UtilMDE.fieldDescriptorToBinaryName("LInteger;").equals("Integer"));
        assert (UtilMDE.fieldDescriptorToBinaryName("LJava/lang/Integer;").equals("Java.lang.Integer"));
        assert (UtilMDE.fieldDescriptorToBinaryName("[[I").equals("int[][]"));
        assert (UtilMDE.fieldDescriptorToBinaryName("[[LJava/lang/Integer;").equals("Java.lang.Integer[][]"));
        assert (UtilMDE.fieldDescriptorToClassGetName("Z").equals("boolean"));
        assert (UtilMDE.fieldDescriptorToClassGetName("B").equals("byte"));
        assert (UtilMDE.fieldDescriptorToClassGetName("C").equals("char"));
        assert (UtilMDE.fieldDescriptorToClassGetName("D").equals("double"));
        assert (UtilMDE.fieldDescriptorToClassGetName("F").equals("float"));
        assert (UtilMDE.fieldDescriptorToClassGetName("I").equals("int"));
        assert (UtilMDE.fieldDescriptorToClassGetName("J").equals("long"));
        assert (UtilMDE.fieldDescriptorToClassGetName("S").equals("short"));
        assert (UtilMDE.fieldDescriptorToClassGetName("LInteger;").equals("Integer"));
        assert (UtilMDE.fieldDescriptorToClassGetName("LJava/lang/Integer;").equals("Java.lang.Integer"));
        assert (UtilMDE.fieldDescriptorToClassGetName("[[I").equals("[[I"));
        assert (UtilMDE.fieldDescriptorToClassGetName("[[LJava/lang/Integer;").equals("[[LJava.lang.Integer;"));
        assert (UtilMDE.arglistFromJvm("()").equals("()"));
        assert (UtilMDE.arglistFromJvm("(I)").equals("(int)"));
        assert (UtilMDE.arglistFromJvm("(II)").equals("(int, int)"));
        assert (UtilMDE.arglistFromJvm("(IJS)").equals("(int, long, short)"));
        assert (UtilMDE.arglistFromJvm("(Ljava/lang/Integer;ILjava/lang/Integer;)").equals("(java.lang.Integer, int, java.lang.Integer)"));
        assert (UtilMDE.arglistFromJvm("([I)").equals("(int[])"));
        assert (UtilMDE.arglistFromJvm("([III)").equals("(int[], int, int)"));
        assert (UtilMDE.arglistFromJvm("(I[[II)").equals("(int, int[][], int)"));
        assert (UtilMDE.arglistFromJvm("([Ljava/lang/Integer;I[[Ljava/lang/Integer;)").equals("(java.lang.Integer[], int, java.lang.Integer[][])"));
        TestPlume.checkTypeStrings("int", "int", "int", "I");
        TestPlume.checkTypeStrings("int[][]", "int[][]", "[[I", "[[I");
        TestPlume.checkTypeStrings("MyClass", "MyClass", "MyClass", "LMyClass;", true);
        TestPlume.checkTypeStrings("MyClass[]", "MyClass[]", "[LMyClass;", "[LMyClass;", true);
        TestPlume.checkTypeStrings("java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "Ljava/lang/Integer;");
        TestPlume.checkTypeStrings("java.lang.Integer[]", "java.lang.Integer[]", "[Ljava.lang.Integer;", "[Ljava/lang/Integer;");
        TestPlume.checkTypeStrings("java.lang.Byte.ByteCache", "java.lang.Byte$ByteCache", "java.lang.Byte$ByteCache", "Ljava/lang/Byte$ByteCache;");
        TestPlume.checkTypeStrings("java.lang.Byte.ByteCache[]", "java.lang.Byte$ByteCache[]", "[Ljava.lang.Byte$ByteCache;", "[Ljava/lang/Byte$ByteCache;");
        try {
            assert (UtilMDE.canCreateAndWrite(new File("TestPlume.java")));
            if (!System.getProperty("user.name").equals("root")) {
                File readOnly = new File("temp");
                readOnly.createNewFile();
                readOnly.setReadOnly();
                assert (!UtilMDE.canCreateAndWrite(readOnly));
                readOnly.delete();
            }
            assert (UtilMDE.canCreateAndWrite(new File("temp")));
            assert (!UtilMDE.canCreateAndWrite(new File("temp/temp")));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("failure while testing UtilMDE.canCreateAndWrite(): " + e.toString()));
        }
        Vector iota0 = new Vector();
        Vector<Integer> iota10 = new Vector<Integer>();
        for (int i = 0; i < 10; ++i) {
            iota10.add(new Integer(i));
        }
        Vector<Integer> iota10_twice = new Vector<Integer>();
        iota10_twice.addAll(iota10);
        iota10_twice.addAll(iota10);
        Vector<Integer> iota10_thrice = new Vector<Integer>();
        iota10_thrice.addAll(iota10);
        iota10_thrice.addAll(iota10);
        iota10_thrice.addAll(iota10);
        assert (iota0.equals(TestPlume.toVector(iota0.iterator())));
        assert (iota0.equals(TestPlume.toVector(new UtilMDE.IteratorEnumeration(iota0.iterator()))));
        assert (iota0.equals(TestPlume.toVector(iota0.elements())));
        assert (iota0.equals(TestPlume.toVector(new UtilMDE.EnumerationIterator(iota0.elements()))));
        assert (iota10.equals(TestPlume.toVector(iota10.iterator())));
        assert (iota10.equals(TestPlume.toVector(new UtilMDE.IteratorEnumeration(iota10.iterator()))));
        assert (iota10.equals(TestPlume.toVector(iota10.elements())));
        assert (iota10.equals(TestPlume.toVector(new UtilMDE.EnumerationIterator(iota10.elements()))));
        assert (iota10_twice.equals(TestPlume.toVector(new UtilMDE.MergedIterator2(iota10.iterator(), iota10.iterator()))));
        assert (iota10.equals(TestPlume.toVector(new UtilMDE.MergedIterator2(iota0.iterator(), iota10.iterator()))));
        assert (iota10.equals(TestPlume.toVector(new UtilMDE.MergedIterator2(iota10.iterator(), iota0.iterator()))));
        Vector iota10_iterator_thrice = new Vector();
        iota10_iterator_thrice.add(iota10.iterator());
        iota10_iterator_thrice.add(iota10.iterator());
        iota10_iterator_thrice.add(iota10.iterator());
        assert (iota10_thrice.equals(TestPlume.toVector(new UtilMDE.MergedIterator(iota10_iterator_thrice.iterator()))));
        Vector iota10_iterator_twice_1 = new Vector();
        iota10_iterator_twice_1.add(iota0.iterator());
        iota10_iterator_twice_1.add(iota10.iterator());
        iota10_iterator_twice_1.add(iota10.iterator());
        Vector iota10_iterator_twice_2 = new Vector();
        iota10_iterator_twice_2.add(iota10.iterator());
        iota10_iterator_twice_2.add(iota0.iterator());
        iota10_iterator_twice_2.add(iota10.iterator());
        Vector iota10_iterator_twice_3 = new Vector();
        iota10_iterator_twice_3.add(iota10.iterator());
        iota10_iterator_twice_3.add(iota10.iterator());
        iota10_iterator_twice_3.add(iota0.iterator());
        assert (iota10_twice.equals(TestPlume.toVector(new UtilMDE.MergedIterator(iota10_iterator_twice_1.iterator()))));
        assert (iota10_twice.equals(TestPlume.toVector(new UtilMDE.MergedIterator(iota10_iterator_twice_2.iterator()))));
        assert (iota10_twice.equals(TestPlume.toVector(new UtilMDE.MergedIterator(iota10_iterator_twice_3.iterator()))));
        Vector<Integer> iota10_odd = new Vector<Integer>();
        for (int i = 0; i < iota10.size(); ++i) {
            if (i % 2 == 0) continue;
            iota10_odd.add(new Integer(i));
        }
        class OddFilter
        implements Filter<Integer> {
            @Override
            public boolean accept(Integer i) {
                return i % 2 != 0;
            }
        }
        assert (iota10_odd.equals(TestPlume.toVector(new UtilMDE.FilteredIterator<Integer>(iota10.iterator(), new OddFilter()))));
        Vector<Integer> iota5 = new Vector<Integer>();
        for (int i = 0; i < 5; ++i) {
            iota5.add(new Integer(i));
        }
        Vector<Integer> iota5middle = new Vector<Integer>();
        for (int i = 1; i < 4; ++i) {
            iota5middle.add(new Integer(i));
        }
        UtilMDE.RemoveFirstAndLastIterator rfali = new UtilMDE.RemoveFirstAndLastIterator(iota5.iterator());
        Vector rfali_vector = TestPlume.toVector(rfali);
        assert (iota5middle.equals(rfali_vector));
        assert (((Integer)rfali.getFirst()).equals(new Integer(0)));
        assert (((Integer)rfali.getLast()).equals(new Integer(4)));
        Calendar nextNotification = Calendar.getInstance();
        nextNotification.add(12, 1);
        SimpleDateFormat df = new SimpleDateFormat();
        int itor_size = 10;
        int num_elts_limit = 12;
        int tries = short_run ? 100 : 100000;
        double ratio_limit = 0.02;
        Random r2 = new Random(20020311L);
        for (int i = 1; i < num_elts_limit; i += 3) {
            int k;
            int[] totals = new int[num_elts_limit];
            for (int j = 0; j < tries; ++j) {
                Calendar now;
                if (j % 100 == 0 && (now = Calendar.getInstance()).after(nextNotification)) {
                    System.out.printf("%s: iteration (%d,%d) out of (%d,%d)%n", df.format(nextNotification.getTime()), i, j, num_elts_limit, tries);
                    nextNotification.add(12, 1);
                }
                class IotaIterator
                implements Iterator<Integer> {
                    int i = 0;
                    int limit;

                    public IotaIterator(int limit) {
                        this.limit = limit;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < this.limit;
                    }

                    @Override
                    public Integer next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new Integer(this.i++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                List<Integer> chosen = UtilMDE.randomElements(new IotaIterator(itor_size), i, r2);
                for (int m3 = 0; m3 < chosen.size(); ++m3) {
                    for (int n = m3 + 1; n < chosen.size(); ++n) {
                        if (chosen.get(m3).intValue() != chosen.get(n).intValue()) continue;
                        throw new Error("Duplicate at " + m3 + "," + n);
                    }
                }
                for (k = 0; k < chosen.size(); ++k) {
                    int n = chosen.get(k);
                    totals[n] = totals[n] + 1;
                }
            }
            int i_truncated = Math.min(itor_size, i);
            int grand_total = tries * i_truncated;
            assert (ArraysMDE.sum(totals) == grand_total) : "Totals = " + ArraysMDE.sum(totals);
            for (k = 0; k < num_elts_limit; ++k) {
                int this_total = totals[k];
                int expected = tries * i_truncated / itor_size;
                double ratio = (double)this_total / (double)expected;
                assert (k >= itor_size || ratio > ratio_limit && ratio < 1.0 / ratio_limit);
            }
        }
        try {
            assert (null != UtilMDE.methodForName("plume.UtilMDE.methodForName(java.lang.String, java.lang.String, java.lang.Class[])"));
            assert (null != UtilMDE.methodForName("plume.UtilMDE.methodForName(java.lang.String,java.lang.String,java.lang.Class[])"));
            assert (null != UtilMDE.methodForName("java.lang.Math.min(int,int)"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
        try {
            Method m4 = UtilMDE.methodForName("plume.UtilMDE.methodForName()");
            throw new Error("Didn't throw NoSuchMethodException");
        }
        catch (NoSuchMethodException m4) {
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
        assert (UtilMDE.replaceString("hello dolly well hello dolly", " ", "  ").equals("hello  dolly  well  hello  dolly"));
        assert (UtilMDE.replaceString("  hello  dolly well hello dolly  ", " ", "  ").equals("    hello    dolly  well  hello  dolly    "));
        assert (UtilMDE.replaceString("hello dolly well hello dolly", "ll", "y").equals("heyo doyy wey heyo doyy"));
        assert (UtilMDE.replaceString("hello dolly well hello dolly", "q", "yyy").equals("hello dolly well hello dolly"));
        assert (Arrays.equals(UtilMDE.split("foo,bar,baz", ','), new String[]{"foo", "bar", "baz"}));
        assert (Arrays.equals(UtilMDE.split("foo", ','), new String[]{"foo"}));
        assert (Arrays.equals(UtilMDE.split("", ','), new String[]{""}));
        assert (Arrays.equals(UtilMDE.split(",foo,", ','), new String[]{"", "foo", ""}));
        assert (Arrays.equals(UtilMDE.split("foo,bar,baz", ","), new String[]{"foo", "bar", "baz"}));
        assert (Arrays.equals(UtilMDE.split("foo", ","), new String[]{"foo"}));
        assert (Arrays.equals(UtilMDE.split("", ","), new String[]{""}));
        assert (Arrays.equals(UtilMDE.split(",foo,", ","), new String[]{"", "foo", ""}));
        assert (Arrays.equals(UtilMDE.split("foo, bar, baz", ", "), new String[]{"foo", "bar", "baz"}));
        assert (Arrays.equals(UtilMDE.split("foo", ", "), new String[]{"foo"}));
        assert (Arrays.equals(UtilMDE.split("", ", "), new String[]{""}));
        assert (Arrays.equals(UtilMDE.split(", foo, ", ", "), new String[]{"", "foo", ""}));
        assert (UtilMDE.join(new String[]{"foo", "bar", "baz"}, ", ").equals("foo, bar, baz"));
        assert (UtilMDE.join(new String[]{"foo"}, ", ").equals("foo"));
        assert (UtilMDE.join(new String[0], ", ").equals(""));
        assert (UtilMDE.join(new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4)}, "").equals("01234"));
        Vector<Object> potpourri = new Vector<Object>();
        potpourri.add("day");
        potpourri.add(new Integer(2));
        potpourri.add("day");
        assert (UtilMDE.join(potpourri, " ").equals("day 2 day"));
        assert (UtilMDE.escapeNonJava("foobar").equals("foobar"));
        assert (UtilMDE.escapeNonJava("").equals(""));
        assert (UtilMDE.escapeNonJava("\\").equals("\\\\"));
        assert (UtilMDE.escapeNonJava("\\\n\r\"").equals("\\\\\\n\\r\\\""));
        assert (UtilMDE.escapeNonJava("split\nlines").equals("split\\nlines"));
        assert (UtilMDE.escapeNonJava("\\relax").equals("\\\\relax"));
        assert (UtilMDE.escapeNonJava("\"hello\"").equals("\\\"hello\\\""));
        assert (UtilMDE.escapeNonJava("\"hello\" \"world\"").equals("\\\"hello\\\" \\\"world\\\""));
        assert (UtilMDE.escapeNonASCII("foobar").equals("foobar"));
        assert (UtilMDE.escapeNonASCII("").equals(""));
        assert (UtilMDE.escapeNonASCII("\\").equals("\\\\"));
        assert (UtilMDE.escapeNonASCII("\\\n\r\"").equals("\\\\\\n\\r\\\""));
        assert (UtilMDE.escapeNonASCII("split\nlines").equals("split\\nlines"));
        assert (UtilMDE.escapeNonASCII("\\relax").equals("\\\\relax"));
        assert (UtilMDE.escapeNonASCII("\"hello\"").equals("\\\"hello\\\""));
        assert (UtilMDE.escapeNonASCII("\"hello\" \"world\"").equals("\\\"hello\\\" \\\"world\\\""));
        assert (UtilMDE.escapeNonASCII("\u0000\u0001\u0002\u0007\n8@I\u0092").equals("\\000\\001\\002\\007\\n8@I\\222"));
        assert (UtilMDE.escapeNonASCII("\u0100\u1000\ucafe\uffff").equals("\\u0100\\u1000\\ucafe\\uffff"));
        assert (UtilMDE.unescapeNonJava("foobar").equals("foobar"));
        assert (UtilMDE.unescapeNonJava("").equals(""));
        assert (UtilMDE.unescapeNonJava("\\\\").equals("\\"));
        assert (UtilMDE.unescapeNonJava("\\\"").equals("\""));
        assert (UtilMDE.unescapeNonJava("\\n").equals("\n"));
        assert (UtilMDE.unescapeNonJava("\\r").equals("\r"));
        assert (UtilMDE.unescapeNonJava("split\\nlines").equals("split\nlines"));
        assert (UtilMDE.unescapeNonJava("\\\\\\n").equals("\\\n"));
        assert (UtilMDE.unescapeNonJava("\\n\\r").equals("\n\r"));
        assert (UtilMDE.unescapeNonJava("\\\\\\n\\r\\\"").equals("\\\n\r\""));
        assert (UtilMDE.unescapeNonJava("\\\\relax").equals("\\relax"));
        assert (UtilMDE.unescapeNonJava("\\\"hello\\\"").equals("\"hello\""));
        assert (UtilMDE.unescapeNonJava("\\\"hello\\\" \\\"world\\\"").equals("\"hello\" \"world\""));
        assert (UtilMDE.unescapeNonJava("\\").equals("\\"));
        assert (UtilMDE.unescapeNonJava("foo\\").equals("foo\\"));
        assert (UtilMDE.unescapeNonJava("\\*abc").equals("*abc"));
        assert (UtilMDE.removeWhitespaceBefore("a,b", ",").equals("a,b"));
        assert (UtilMDE.removeWhitespaceBefore("a, b", ",").equals("a, b"));
        assert (UtilMDE.removeWhitespaceBefore("a ,b", ",").equals("a,b"));
        assert (UtilMDE.removeWhitespaceBefore("a , b", ",").equals("a, b"));
        assert (UtilMDE.removeWhitespaceBefore("ab=>cd", "=>").equals("ab=>cd"));
        assert (UtilMDE.removeWhitespaceBefore("ab=> cd", "=>").equals("ab=> cd"));
        assert (UtilMDE.removeWhitespaceBefore("ab =>cd", "=>").equals("ab=>cd"));
        assert (UtilMDE.removeWhitespaceBefore("ab => cd", "=>").equals("ab=> cd"));
        assert (UtilMDE.removeWhitespaceBefore("123cd", "123").equals("123cd"));
        assert (UtilMDE.removeWhitespaceBefore(" 123 cd", "123").equals("123 cd"));
        assert (UtilMDE.removeWhitespaceBefore(" 123cd", "123").equals("123cd"));
        assert (UtilMDE.removeWhitespaceBefore("123 cd", "123").equals("123 cd"));
        assert (UtilMDE.removeWhitespaceBefore("cd123", "123").equals("cd123"));
        assert (UtilMDE.removeWhitespaceBefore("cd 123 ", "123").equals("cd123 "));
        assert (UtilMDE.removeWhitespaceBefore("cd123 ", "123").equals("cd123 "));
        assert (UtilMDE.removeWhitespaceBefore("cd 123", "123").equals("cd123"));
        assert (UtilMDE.removeWhitespaceAfter("a,b", ",").equals("a,b"));
        assert (UtilMDE.removeWhitespaceAfter("a, b", ",").equals("a,b"));
        assert (UtilMDE.removeWhitespaceAfter("a ,b", ",").equals("a ,b"));
        assert (UtilMDE.removeWhitespaceAfter("a , b", ",").equals("a ,b"));
        assert (UtilMDE.removeWhitespaceAfter("ab=>cd", "=>").equals("ab=>cd"));
        assert (UtilMDE.removeWhitespaceAfter("ab=> cd", "=>").equals("ab=>cd"));
        assert (UtilMDE.removeWhitespaceAfter("ab =>cd", "=>").equals("ab =>cd"));
        assert (UtilMDE.removeWhitespaceAfter("ab => cd", "=>").equals("ab =>cd"));
        assert (UtilMDE.removeWhitespaceAfter("123cd", "123").equals("123cd"));
        assert (UtilMDE.removeWhitespaceAfter(" 123 cd", "123").equals(" 123cd"));
        assert (UtilMDE.removeWhitespaceAfter(" 123cd", "123").equals(" 123cd"));
        assert (UtilMDE.removeWhitespaceAfter("123 cd", "123").equals("123cd"));
        assert (UtilMDE.removeWhitespaceAfter("cd123", "123").equals("cd123"));
        assert (UtilMDE.removeWhitespaceAfter("cd 123 ", "123").equals("cd 123"));
        assert (UtilMDE.removeWhitespaceAfter("cd123 ", "123").equals("cd123"));
        assert (UtilMDE.removeWhitespaceAfter("cd 123", "123").equals("cd 123"));
        assert (UtilMDE.removeWhitespaceAround("a,b", ",").equals("a,b"));
        assert (UtilMDE.removeWhitespaceAround("a, b", ",").equals("a,b"));
        assert (UtilMDE.removeWhitespaceAround("a ,b", ",").equals("a,b"));
        assert (UtilMDE.removeWhitespaceAround("a , b", ",").equals("a,b"));
        assert (UtilMDE.removeWhitespaceAround("ab=>cd", "=>").equals("ab=>cd"));
        assert (UtilMDE.removeWhitespaceAround("ab=> cd", "=>").equals("ab=>cd"));
        assert (UtilMDE.removeWhitespaceAround("ab =>cd", "=>").equals("ab=>cd"));
        assert (UtilMDE.removeWhitespaceAround("ab => cd", "=>").equals("ab=>cd"));
        assert (UtilMDE.removeWhitespaceAround("123cd", "123").equals("123cd"));
        assert (UtilMDE.removeWhitespaceAround(" 123 cd", "123").equals("123cd"));
        assert (UtilMDE.removeWhitespaceAround(" 123cd", "123").equals("123cd"));
        assert (UtilMDE.removeWhitespaceAround("123 cd", "123").equals("123cd"));
        assert (UtilMDE.removeWhitespaceAround("cd123", "123").equals("cd123"));
        assert (UtilMDE.removeWhitespaceAround("cd 123 ", "123").equals("cd123"));
        assert (UtilMDE.removeWhitespaceAround("cd123 ", "123").equals("cd123"));
        assert (UtilMDE.removeWhitespaceAround("cd 123", "123").equals("cd123"));
        assert (UtilMDE.nplural(0, "fuss").equals("0 fusses"));
        assert (UtilMDE.nplural(1, "fuss").equals("1 fuss"));
        assert (UtilMDE.nplural(2, "fuss").equals("2 fusses"));
        assert (UtilMDE.nplural(0, "fox").equals("0 foxes"));
        assert (UtilMDE.nplural(1, "fox").equals("1 fox"));
        assert (UtilMDE.nplural(2, "fox").equals("2 foxes"));
        assert (UtilMDE.nplural(0, "fish").equals("0 fishes"));
        assert (UtilMDE.nplural(1, "fish").equals("1 fish"));
        assert (UtilMDE.nplural(2, "fish").equals("2 fishes"));
        assert (UtilMDE.nplural(0, "fletch").equals("0 fletches"));
        assert (UtilMDE.nplural(1, "fletch").equals("1 fletch"));
        assert (UtilMDE.nplural(2, "fletch").equals("2 fletches"));
        assert (UtilMDE.nplural(0, "fund").equals("0 funds"));
        assert (UtilMDE.nplural(1, "fund").equals("1 fund"));
        assert (UtilMDE.nplural(2, "fund").equals("2 funds"));
        assert (UtilMDE.nplural(0, "f-stop").equals("0 f-stops"));
        assert (UtilMDE.nplural(1, "f-stop").equals("1 f-stop"));
        assert (UtilMDE.nplural(2, "f-stop").equals("2 f-stops"));
        assert (UtilMDE.rpad("", 5).equals("     "));
        assert (UtilMDE.rpad("abcd", 5).equals("abcd "));
        assert (UtilMDE.rpad("abcde", 5).equals("abcde"));
        assert (UtilMDE.rpad("abcdef", 5).equals("abcde"));
        assert (UtilMDE.rpad("abcde ghij", 5).equals("abcde"));
        assert (UtilMDE.rpad(10, 5).equals("10   "));
        assert (UtilMDE.rpad(3.14, 5).equals("3.14 "));
        assert (UtilMDE.count("abcde", 97) == 1);
        assert (UtilMDE.count("abcde", 99) == 1);
        assert (UtilMDE.count("abcde", 101) == 1);
        assert (UtilMDE.count("abcde", 122) == 0);
        assert (UtilMDE.count("abacadaea", 97) == 5);
        assert (UtilMDE.count("aaa aea", 97) == 5);
        assert (UtilMDE.count("daeaaa", 97) == 4);
        ArrayList<Integer> l123 = new ArrayList<Integer>();
        l123.add(1);
        l123.add(2);
        l123.add(3);
        ArrayList<Integer> l123123 = new ArrayList<Integer>();
        l123123.add(1);
        l123123.add(2);
        l123123.add(3);
        l123123.add(1);
        l123123.add(2);
        l123123.add(3);
        ArrayList<Integer> l12223 = new ArrayList<Integer>();
        l12223.add(1);
        l12223.add(2);
        l12223.add(2);
        l12223.add(2);
        l12223.add(3);
        ArrayList<Integer> l1123 = new ArrayList<Integer>();
        l1123.add(1);
        l1123.add(1);
        l1123.add(2);
        l1123.add(3);
        ArrayList<Integer> l1233 = new ArrayList<Integer>();
        l1233.add(1);
        l1233.add(1);
        l1233.add(2);
        l1233.add(3);
        assert (UtilMDE.removeDuplicates(l123).equals(l123));
        assert (UtilMDE.removeDuplicates(l123123).equals(l123));
        assert (UtilMDE.removeDuplicates(l12223).equals(l123));
        assert (UtilMDE.removeDuplicates(l1123).equals(l123));
        assert (UtilMDE.removeDuplicates(l1233).equals(l123));
        boolean[] zatft1 = new boolean[]{true, false, true};
        boolean[] zatft2 = new boolean[]{true, false, true};
        boolean[] zatff = new boolean[]{true, false, false};
        assert (!zatft1.equals(zatft2));
        assert (UtilMDE.deepEquals(zatft1, zatft2));
        assert (!zatft1.equals(zatff));
        assert (!UtilMDE.deepEquals(zatft1, zatff));
        ArrayList<Object> l1 = new ArrayList<Object>();
        ArrayList<Object> l2 = new ArrayList<Object>();
        ArrayList<Object> l3 = new ArrayList<Object>();
        l1.add(l1);
        l2.add(l2);
        l3.add(l3);
        l1.add(zatft1);
        l2.add(zatft2);
        l3.add(zatff);
        assert (UtilMDE.deepEquals(l1, l2));
        assert (!UtilMDE.deepEquals(l1, l3));
        assert (!UtilMDE.deepEquals(l2, l3));
        Locale.setDefault(Locale.US);
        assert (UtilMDE.abbreviateNumber(5L).equals("5.00"));
        assert (UtilMDE.abbreviateNumber(5000L).equals("5.00K"));
        assert (UtilMDE.abbreviateNumber(5000000L).equals("5.00M"));
        assert (UtilMDE.abbreviateNumber(1000000000L).equals("1.00G"));
        assert (UtilMDE.abbreviateNumber(1L).equals("1.00"));
        assert (UtilMDE.abbreviateNumber(12L).equals("12.0"));
        assert (UtilMDE.abbreviateNumber(123L).equals("123"));
        assert (UtilMDE.abbreviateNumber(1234L).equals("1.23K"));
        assert (UtilMDE.abbreviateNumber(12345L).equals("12.3K"));
        assert (UtilMDE.abbreviateNumber(123456L).equals("123K"));
        assert (UtilMDE.abbreviateNumber(1234567L).equals("1.23M"));
        assert (UtilMDE.abbreviateNumber(12345678L).equals("12.3M"));
        assert (UtilMDE.abbreviateNumber(123456789L).equals("123M"));
        assert (UtilMDE.abbreviateNumber(1234567890L).equals("1.23G"));
        assert (UtilMDE.abbreviateNumber(9L).equals("9.00"));
        assert (UtilMDE.abbreviateNumber(98L).equals("98.0"));
        assert (UtilMDE.abbreviateNumber(987L).equals("987"));
        assert (UtilMDE.abbreviateNumber(9876L).equals("9.88K"));
        assert (UtilMDE.abbreviateNumber(98765L).equals("98.8K"));
        assert (UtilMDE.abbreviateNumber(987654L).equals("988K"));
        assert (UtilMDE.abbreviateNumber(9876543L).equals("9.88M"));
        assert (UtilMDE.abbreviateNumber(98765432L).equals("98.8M"));
        assert (UtilMDE.abbreviateNumber(987654321L).equals("988M"));
        assert (UtilMDE.abbreviateNumber(9876543210L).equals("9.88G"));
    }

    @Test
    public void testTestUtilMDE() {
        int[] a = new int[]{3, 4, 5};
        TestPlume.assert_arrays_equals(TestPlume.int_iterator_array(TestPlume.int_array_iterator(a)), a);
    }

    @Test
    public void testWeakHasherMap() {
    }

    @Test
    public void testWeakIdentityHashMap() {
        String s1 = "one";
        String s2 = "two";
        String s3 = "three";
        WeakIdentityHashMap<String, Integer> m3 = new WeakIdentityHashMap<String, Integer>();
        m3.put(s1, 1);
        m3.put(s2, 2);
        m3.put(s3, 3);
        String s1a = new String(s1);
        String s2a = new String(s2);
        String s3a = new String(s3);
        m3.put(s1a, 1);
        m3.put(s2a, 2);
        m3.put(s3a, 3);
        assert ((Integer)m3.get(s1) == 1);
        assert ((Integer)m3.get(s2) == 2);
        assert ((Integer)m3.get(s3) == 3);
        assert ((Integer)m3.get(s1a) == 1);
        assert ((Integer)m3.get(s2a) == 2);
        assert ((Integer)m3.get(s3a) == 3);
        m3.remove(s1);
        m3.remove(s2);
        m3.remove(s3);
        assert (m3.get(s1) == null);
        assert (m3.get(s2) == null);
        assert (m3.get(s3) == null);
        assert ((Integer)m3.get(s1a) == 1);
        assert ((Integer)m3.get(s2a) == 2);
        assert ((Integer)m3.get(s3a) == 3);
    }

    @Test
    public void testClassFileVersion() {
        assert (ClassFileVersion.versionNumbers(new ByteArrayInputStream(new byte[0])) == null);
    }

    @Test
    public void testCountingPrintWriter() {
        CountingPrintWriter c1 = new CountingPrintWriter(new CharArrayWriter());
        c1.print("a");
        assert (c1.getNumberOfPrintedBytes() == 1);
        c1.print(1);
        assert (c1.getNumberOfPrintedBytes() == 2);
        c1.print(true);
        assert (c1.getNumberOfPrintedBytes() == 6);
        c1.print(1.0);
        assert (c1.getNumberOfPrintedBytes() == 9);
        c1.write("a");
        c1.write("-");
        assert (c1.getNumberOfPrintedBytes() == 9);
        assert (c1.getNumberOfWrittenBytes() == 22);
        assert (c1.getNumberOfPrintedChars() == 9);
        c1.write("A long string we will print part of", 5, 10);
        assert (c1.getNumberOfPrintedBytes() == 9);
        assert (c1.getNumberOfWrittenBytes() == 32);
        assert (c1.getNumberOfPrintedChars() == 9);
        c1.println("a b");
        String lineSep = System.getProperty("line.separator");
        int ls_len = lineSep.length();
        assert (c1.getNumberOfPrintedBytes() == 12 + ls_len);
        assert (c1.getNumberOfWrittenBytes() == 38);
        assert (c1.getNumberOfPrintedChars() == 12 + ls_len);
        c1.print((String)null);
        c1.print((Object)null);
        c1.println((String)null);
    }

    @Test
    public void testSequenceAndIndices() {
        int[] a1 = Intern.intern(new int[]{1, 2, 3, 4, 5, 6, 7});
        int[] a2 = Intern.intern(new int[]{1, 2, 3, 4, 5, 6, 7});
        int[] a3 = Intern.intern(new int[]{2, 3, 4, 5, 6, 7});
        int i = 2;
        int j = 4;
        int k = 5;
        int[] s1 = Intern.internSubsequence(a1, i, j);
        int[] s2 = Intern.internSubsequence(a2, i, j);
        int[] s3 = Intern.internSubsequence(a1, j, k);
        int[] s4 = Intern.internSubsequence(a1, j, k);
        int[] s5 = Intern.internSubsequence(a3, j - 1, k - 1);
        assert (a1 == a2);
        assert (s1 == s2);
        assert (s3 == s4);
        assert (s3 == s5);
        assert (ArraysMDE.isSubarray(s1, ArraysMDE.subarray(a1, i, j - i), 0));
        assert (ArraysMDE.isSubarray(ArraysMDE.subarray(a1, i, j - i), s1, 0));
        long[] l1 = Intern.intern(new long[]{1L, 2L, 3L, 4L, 5L, 6L});
        assert (l1 == Intern.internSubsequence(l1, 0, l1.length));
    }

    @Test
    public void testFuzzyFloat() {
        double[] f2_copy;
        double[] f1_copy;
        int j;
        double d;
        FuzzyFloat ff = new FuzzyFloat(1.0E-4);
        double offset = 7.0E-5;
        double offhigh = 1.0 + offset;
        double offlow = 1.0 - offset;
        double offhigh2 = 1.0 + 2.0 * offset;
        double offlow2 = 1.0 - 2.0 * offset;
        for (d = -20000.0; d < 20000.0; d += 1000.36) {
            assert (ff.eq(d, d * offhigh));
            assert (ff.eq(d, d * offlow));
            assert (!ff.eq(d, d * offhigh2));
            assert (!ff.eq(d, d * offlow2));
            assert (!ff.ne(d, d * offhigh));
            assert (!ff.ne(d, d * offlow));
            assert (ff.ne(d, d * offhigh2));
            assert (ff.ne(d, d * offlow2));
        }
        assert (ff.eq(0.0, Double.MIN_VALUE));
        assert (ff.eq(0.0, -4.9E-324));
        assert (!ff.ne(0.0, Double.MIN_VALUE));
        assert (!ff.ne(0.0, -4.9E-324));
        assert (ff.eq(0.0, 0.0));
        assert (!ff.ne(0.0, 0.0));
        assert (!ff.eq(Double.NaN, Double.NaN));
        assert (ff.eq(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
        assert (ff.eq(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY));
        d = 2563.789;
        assert (!ff.gt(d, d * offlow));
        assert (!ff.lt(d, d * offhigh));
        assert (ff.gt(d, d * offlow2));
        assert (ff.lt(d, d * offhigh2));
        assert (ff.gte(d, d * offhigh));
        assert (ff.lte(d, d * offlow));
        assert (!ff.gte(d, d * offhigh2));
        assert (!ff.lte(d, d * offlow2));
        double[] a = new double[10];
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
        }
        double[] a_copy = (double[])a.clone();
        assert (ff.indexOf(a, -1.0) == -1);
        assert (ff.indexOf(a, 0.0) == 0);
        assert (ff.indexOf(a, 7.0) == 7);
        assert (ff.indexOf(a, 9.0) == 9);
        assert (ff.indexOf(a, 10.0) == -1);
        assert (ff.indexOf(a, 20.0) == -1);
        assert (ff.indexOf(a, Double.MIN_VALUE) == 0);
        assert (ff.indexOf(a, 7.0 * offhigh) == 7);
        assert (ff.indexOf(a, 9.0 * offlow) == 9);
        assert (ff.indexOf(a, 7.0 * offhigh2) == -1);
        assert (ff.indexOf(a, 9.0 * offlow2) == -1);
        TestPlume.assert_arrays_equals(a, a_copy);
        a = new double[10];
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
        }
        double[] b = new double[]{};
        double[] c = new double[]{a[0], a[1], a[2]};
        double[] d2 = new double[]{a[1], a[2]};
        double[] e = new double[]{a[2], a[3], a[4], a[5]};
        double[] f = new double[]{a[7], a[8], a[9]};
        double[] g2 = new double[]{a[7], 22.0, a[9]};
        double[] h2 = new double[]{a[7], a[8], a[9], 10.0};
        assert (ff.indexOf(a, b) == 0);
        assert (ff.indexOf(a, c) == 0);
        assert (ff.indexOf(a, d2) == 1);
        assert (ff.indexOf(a, e) == 2);
        assert (ff.indexOf(a, f) == 7);
        assert (ff.indexOf(a, g2) == -1);
        assert (ff.indexOf(a, h2) == -1);
        a = new double[10];
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
        }
        b = new double[]{};
        c = new double[]{a[0] * offlow, a[1] * offhigh, a[2] * offlow};
        d2 = new double[]{a[1] * offhigh, a[2] * offlow};
        e = new double[]{a[2], a[3], a[4] * offlow, a[5] * offhigh};
        f = new double[]{a[7], a[8] * offlow, a[9] * offhigh};
        g2 = new double[]{a[7], 22.0, a[9]};
        h2 = new double[]{a[7], a[8], a[9], 10.0};
        double[] a_copy2 = (double[])a.clone();
        double[] b_copy = (double[])b.clone();
        double[] c_copy = (double[])c.clone();
        double[] d_copy = (double[])d2.clone();
        double[] e_copy = (double[])e.clone();
        double[] f_copy = (double[])f.clone();
        double[] g_copy = (double[])g2.clone();
        double[] h_copy = (double[])h2.clone();
        assert (ff.indexOf(a, b) == 0);
        assert (ff.indexOf(a, c) == 0);
        assert (ff.indexOf(a, d2) == 1);
        assert (ff.indexOf(a, e) == 2);
        assert (ff.indexOf(a, f) == 7);
        assert (ff.indexOf(a, g2) == -1);
        assert (ff.indexOf(a, h2) == -1);
        TestPlume.assert_arrays_equals(a, a_copy2);
        TestPlume.assert_arrays_equals(b, b_copy);
        TestPlume.assert_arrays_equals(c, c_copy);
        TestPlume.assert_arrays_equals(d2, d_copy);
        TestPlume.assert_arrays_equals(e, e_copy);
        TestPlume.assert_arrays_equals(f, f_copy);
        TestPlume.assert_arrays_equals(g2, g_copy);
        TestPlume.assert_arrays_equals(h2, h_copy);
        double[] f1 = new double[10];
        double[] f2 = new double[20];
        for (j = 0; j < 10; ++j) {
            this.initialize_f1_and_f2(j, f1, f2);
            f2[7] = f2[7] * (1.0 + offset);
            f2[8] = f2[8] * (1.0 - offset);
            if (j % 2 == 0 ? !$assertionsDisabled && !ff.isElemMatch(f1, f2) : !$assertionsDisabled && !ff.isElemMatch(f2, f1)) {
                throw new AssertionError();
            }
        }
        for (j = 0; j < 200; ++j) {
            this.initialize_f1_and_f2(j, f1, f2);
            f2[7] = f2[7] * (1.0 + 2.0 * offset);
            f2[8] = f2[8] * (1.0 - 2.0 * offset);
            f1_copy = (double[])f1.clone();
            f2_copy = (double[])f2.clone();
            if (j % 2 == 0 ? !$assertionsDisabled && ff.isElemMatch(f1, f2) : !$assertionsDisabled && ff.isElemMatch(f2, f1)) {
                throw new AssertionError();
            }
            TestPlume.assert_arrays_equals(f1, f1_copy);
            TestPlume.assert_arrays_equals(f2, f2_copy);
        }
        a = new double[]{2.0, 1.0, 0.0};
        b = new double[]{};
        c = new double[]{1.0, 1.0, 1.0, 1.0};
        d2 = new double[]{1.0};
        assert (!ff.isElemMatch(a, b));
        assert (!ff.isElemMatch(b, a));
        assert (ff.isElemMatch(c, d2));
        assert (ff.isElemMatch(d2, c));
        assert (ff.isElemMatch(b, b));
        FuzzyFloat.DoubleArrayComparatorLexical comparator = ff.new FuzzyFloat.DoubleArrayComparatorLexical();
        double[] a0 = new double[]{};
        double[] a1 = new double[]{};
        double[] a2 = new double[]{0.0, 1.0, 2.0, 3.0};
        double[] a3 = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        double[] a4 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        double[] a5 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        double[] a6 = new double[]{0.0, 1.0, 5.0, 3.0, 4.0};
        double[] a7 = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] a0_copy = (double[])a0.clone();
        double[] a1_copy = (double[])a1.clone();
        double[] a2_copy = (double[])a2.clone();
        double[] a3_copy = (double[])a3.clone();
        double[] a4_copy = (double[])a4.clone();
        double[] a5_copy = (double[])a5.clone();
        double[] a6_copy = (double[])a6.clone();
        double[] a7_copy = (double[])a7.clone();
        assert (comparator.compare(a0, a1) == 0);
        assert (comparator.compare(a1, a0) == 0);
        assert (comparator.compare(a1, a2) < 0);
        assert (comparator.compare(a2, a1) > 0);
        assert (comparator.compare(a2, a3) < 0);
        assert (comparator.compare(a3, a2) > 0);
        assert (comparator.compare(a3, a4) < 0);
        assert (comparator.compare(a4, a3) > 0);
        assert (comparator.compare(a4, a5) == 0);
        assert (comparator.compare(a5, a4) == 0);
        assert (comparator.compare(a5, a6) < 0);
        assert (comparator.compare(a6, a5) > 0);
        assert (comparator.compare(a6, a7) < 0);
        assert (comparator.compare(a7, a6) > 0);
        assert (comparator.compare(a1, a4) < 0);
        assert (comparator.compare(a4, a1) > 0);
        assert (comparator.compare(a2, a4) < 0);
        assert (comparator.compare(a4, a2) > 0);
        assert (comparator.compare(a6, a4) > 0);
        assert (comparator.compare(a4, a6) < 0);
        assert (comparator.compare(a7, a4) > 0);
        assert (comparator.compare(a4, a7) < 0);
        TestPlume.assert_arrays_equals(a0, a0_copy);
        TestPlume.assert_arrays_equals(a1, a1_copy);
        TestPlume.assert_arrays_equals(a2, a2_copy);
        TestPlume.assert_arrays_equals(a3, a3_copy);
        TestPlume.assert_arrays_equals(a4, a4_copy);
        TestPlume.assert_arrays_equals(a5, a5_copy);
        TestPlume.assert_arrays_equals(a6, a6_copy);
        TestPlume.assert_arrays_equals(a7, a7_copy);
        f1 = new double[10];
        f2 = new double[20];
        for (int j2 = 0; j2 < f2.length; ++j2) {
            f2[j2] = j2;
        }
        for (int i = 0; i < f2.length - f1.length; ++i) {
            for (int j3 = 0; j3 < f1.length; ++j3) {
                f1[j3] = f2[i + j3];
            }
            f1[5] = f2[i] * offhigh;
            f1_copy = (double[])f1.clone();
            f2_copy = (double[])f2.clone();
            assert (ff.isSubset(f1, f2));
            TestPlume.assert_arrays_equals(f1, f1_copy);
            TestPlume.assert_arrays_equals(f2, f2_copy);
        }
        a1 = new double[]{1.0, 5.0, 10.0};
        a2 = new double[]{};
        a3 = new double[]{1.0};
        a4 = new double[]{10.0};
        a5 = new double[]{1.0, 10.0, 15.0, 20.0};
        a6 = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 1.0};
        assert (ff.isSubset(a2, a1));
        assert (!ff.isSubset(a1, a2));
        assert (!ff.isSubset(a1, a5));
        assert (ff.isSubset(a3, a1));
        assert (ff.isSubset(a4, a1));
        assert (ff.isSubset(a6, a1));
        assert (!ff.isSubset(a1, a6));
    }

    void initialize_f1_and_f2(int j, double[] f1, double[] f2) {
        int i;
        for (i = 0; i < f1.length; ++i) {
            f1[i] = j + i * 10;
            f2[i] = j + i * 10;
        }
        for (i = 10; i < f2.length; ++i) {
            f2[i] = j + (i - 10) * 10;
        }
    }

    @Test
    public void test_create_combinations() {
        Object a = new Object();
        Object b = new Object();
        Object c = new Object();
        List<Object> a_list = Arrays.asList(a);
        List<Object> b_list = Arrays.asList(b);
        List<Object> c_list = Arrays.asList(c);
        List<Object> aa = Arrays.asList(a, a);
        List<Object> bb = Arrays.asList(b, b);
        List<Object> cc = Arrays.asList(c, c);
        List<Object> ab = Arrays.asList(a, b);
        List<Object> ac = Arrays.asList(a, c);
        List<Object> bc = Arrays.asList(b, c);
        List<Object> abc = Arrays.asList(a, b, c);
        List<List<Object>> combo1 = UtilMDE.create_combinations(1, 0, abc);
        assert (combo1.size() == 3);
        assert (combo1.contains(a_list));
        assert (combo1.contains(b_list));
        assert (combo1.contains(c_list));
        List<List<Object>> combo2 = UtilMDE.create_combinations(2, 0, abc);
        assert (combo2.size() == 6);
        assert (combo2.contains(aa));
        assert (combo2.contains(ab));
        assert (combo2.contains(ac));
        assert (combo2.contains(bb));
        assert (combo2.contains(bc));
        assert (combo2.contains(cc));
        Integer i0 = new Integer(0);
        Integer i1 = new Integer(1);
        Integer i2 = new Integer(2);
        Integer i10 = new Integer(10);
        Integer i11 = new Integer(11);
        Integer i12 = new Integer(12);
        ArrayList<ArrayList<Integer>> combo3 = UtilMDE.create_combinations(1, 0, 2);
        assert (combo3.size() == 3);
        assert (combo3.contains(Arrays.asList(i0)));
        assert (combo3.contains(Arrays.asList(i1)));
        assert (combo3.contains(Arrays.asList(i2)));
        ArrayList<ArrayList<Integer>> combo4 = UtilMDE.create_combinations(2, 0, 2);
        assert (combo4.size() == 6);
        assert (combo4.contains(Arrays.asList(i0, i0)));
        assert (combo4.contains(Arrays.asList(i0, i1)));
        assert (combo4.contains(Arrays.asList(i0, i2)));
        assert (combo4.contains(Arrays.asList(i1, i1)));
        assert (combo4.contains(Arrays.asList(i1, i2)));
        assert (combo4.contains(Arrays.asList(i2, i2)));
        ArrayList<ArrayList<Integer>> combo5 = UtilMDE.create_combinations(2, 10, 12);
        assert (combo5.size() == 6);
        assert (combo5.contains(Arrays.asList(i10, i10)));
        assert (combo5.contains(Arrays.asList(i10, i11)));
        assert (combo5.contains(Arrays.asList(i10, i12)));
        assert (combo5.contains(Arrays.asList(i11, i11)));
        assert (combo5.contains(Arrays.asList(i11, i12)));
        assert (combo5.contains(Arrays.asList(i12, i12)));
    }

    @Test
    public void test_fullyQualifiedNameToSimpleName() {
        assert (UtilMDE.fullyQualifiedNameToSimpleName("java.lang.String").equals("String"));
        assert (UtilMDE.fullyQualifiedNameToSimpleName("String").equals("String"));
    }

    @Test
    public void testOptions() throws Options.ArgException {
        TestOptions t = new TestOptions();
        Options options = new Options("test", t);
        options.parse(new String[]{"--lp=foo", "--lp", "bar", "-i", "24", "-d=37.8", "-b", "-b=false", "--ld", "34.6", "--ld", "17.8"});
        assert (t.lp.get(0).toString().equals("foo"));
        assert (t.lp.get(1).toString().equals("bar"));
        assert (t.integer_reference != null && t.integer_reference == 24);
        assert (t.temperature == 37.8);
        assert (!t.bool);
        assert (t.ld.get(0) == 34.6);
        assert (t.ld.get(1) == 17.8);
        t.bool = false;
        String[] args = options.parse(new String[]{"one", "two", "three", "-b"});
        assert (args[0].equals("one")) : args[0];
        assert (args[1].equals("two")) : args[1];
        assert (args[2].equals("three")) : args[2];
        assert (t.bool);
        t.bool = false;
        args = options.parse(new String[]{"--", "one", "two", "-b"});
        assert (args[0].equals("one")) : args[0];
        assert (args[1].equals("two")) : args[1];
        assert (args[2].equals("-b")) : args[2];
        assert (!t.bool);
        t.ld.clear();
        Options.split_lists = true;
        args = options.parse(new String[]{"--ld", "42.1 9.3 10.5", "--ld", "2.7"});
        assert (args.length == 0);
        assert (t.ld.size() == 4);
        assert (t.ld.get(0) == 42.1);
        assert (t.ld.get(1) == 9.3);
        assert (t.ld.get(2) == 10.5);
        assert (t.ld.get(3) == 2.7);
        args = options.parse(new String[]{"--ls", "hello", "--ls", "world"});
        assert (args.length == 0);
        assert (t.ls != null) : "@AssumeAssertion(nullness)";
        assert (t.ls.size() == 2);
        assert (t.ls.get(0).equals("hello"));
        assert (t.ls.get(1).equals("world"));
    }

    @Test
    public void testOptionsAliases() throws Options.ArgException {
        TestOptionsAliases t = new TestOptionsAliases();
        Options options = new Options("test", t);
        options.parse(new String[]{"-d", "Monday", "-temp", "-12.3"});
        assert (t.day.equals("Monday"));
        assert (t.temperature == -12.3);
        assert (!t.printVersion);
        options.parse("-d Monday -temp -12.3");
        assert (t.day.equals("Monday"));
        assert (t.temperature == -12.3);
        assert (!t.printVersion);
        options.parse(new String[]{"-t", "21.7", "-version"});
        assert (t.day.equals("Monday"));
        assert (t.temperature == 21.7);
        assert (t.printVersion);
        options.parse("-t 21.7 -version");
        assert (t.day.equals("Monday"));
        assert (t.temperature == 21.7);
        assert (t.printVersion);
        t.printVersion = false;
        options.parse(new String[]{"--version", "-temp=-60.1", "--day", "Tuesday"});
        assert (t.day.equals("Tuesday"));
        assert (t.temperature == -60.1);
        assert (t.printVersion);
        t.printVersion = false;
        options.parse("--version -temp=-60.1 --day Tuesday");
        assert (t.day.equals("Tuesday"));
        assert (t.temperature == -60.1);
        assert (t.printVersion);
    }

    @Test
    public void testOptionGroups() throws Options.ArgException {
        block16: {
            block15: {
                try {
                    Options options = new Options("test", TestOptionGroups1.class);
                }
                catch (Error e) {
                    if ($assertionsDisabled || e.getMessage() != null && e.getMessage().indexOf("missing @OptionGroup annotation on the first @Option-annotated field") > -1) break block15;
                    throw new AssertionError();
                }
            }
            try {
                Options e = new Options("test", TestOptionGroups2.class, TestOptionGroups1.class);
            }
            catch (Error e) {
                if ($assertionsDisabled || e.getMessage() != null && e.getMessage().indexOf("missing @OptionGroup annotation in field") > -1) break block16;
                throw new AssertionError();
            }
        }
        Options options = new Options("test", TestOptionGroups2.class);
        assert (options.usage(new String[0]).indexOf("General options") > -1);
        assert (options.usage(new String[0]).indexOf("Display options") > -1);
        assert (options.usage(new String[0]).indexOf("Internal options") == -1);
        assert (options.usage("Internal options").indexOf("Set mu") > -1);
        assert (options.usage("Internal options").indexOf("Set pi") == -1);
        options.parse(new String[]{"--colour", "--pi", "3.15"});
        assert (TestOptionGroups2.color);
        assert (TestOptionGroups2.pi == 3.15);
        options.parse("--colour --pi 3.15");
        assert (TestOptionGroups2.color);
        assert (TestOptionGroups2.pi == 3.15);
        Options options2 = new Options("test", TestOptionGroups3.class);
        assert (options.usage(new String[0]).indexOf("Internal options") == -1);
        assert (options.usage(true, new String[0]).indexOf("Internal options") > -1);
    }

    @Test
    public void testOptionsEnums() throws Options.ArgException {
        Options options = new Options("test", TestOptionsEnums.class);
        options.parse(new String[]{"--firstPass", "SMART_RLE"});
        assert (TestOptionsEnums.firstPass == TestOptionsEnums.Compressor.SMART_RLE);
        TestOptionsEnums.firstPass = TestOptionsEnums.Compressor.HUFFMAN;
        options.parse(new String[]{"--firstPass", "smart_rle"});
        assert (TestOptionsEnums.firstPass == TestOptionsEnums.Compressor.SMART_RLE);
        TestOptionsEnums.firstPass = TestOptionsEnums.Compressor.HUFFMAN;
        options.parse(new String[]{"--firstPass", "smart-rle"});
        assert (TestOptionsEnums.firstPass == TestOptionsEnums.Compressor.SMART_RLE);
        options.parse(new String[]{"--firstPass", "rle", "--secondPass", "SMART-RLE"});
        assert (TestOptionsEnums.firstPass == TestOptionsEnums.Compressor.RLE);
        assert (TestOptionsEnums.secondPass == TestOptionsEnums.Compressor.SMART_RLE);
        options.parse(new String[]{"--secondPass", "Huffman"});
        assert (TestOptionsEnums.firstPass == TestOptionsEnums.Compressor.RLE);
        assert (TestOptionsEnums.secondPass == TestOptionsEnums.Compressor.HUFFMAN);
    }

    @Test
    public void testOptionsEnumsFail() {
        Options options = new Options("test", TestOptionsEnums.class);
        try {
            options.parse(new String[]{"--firstPass", "smartrle"});
            Assert.fail((String)"Didn't throw ArgException as expected");
        }
        catch (Options.ArgException argException) {
            // empty catch block
        }
    }

    @Test
    public void testSplitLines() {
        String str = "one\ntwo\n\rthree\r\nfour\rfive\n\n\nsix\r\n\r\n\r\n";
        String[] sa = UtilMDE.splitLines(str);
        assert (sa.length == 11);
        assert (sa[0].equals("one"));
        assert (sa[1].equals("two"));
        assert (sa[2].equals("three"));
        assert (sa[3].equals("four"));
        assert (sa[4].equals("five"));
        assert (sa[5].equals(""));
        assert (sa[6].equals(""));
        assert (sa[7].equals("six"));
        assert (sa[8].equals(""));
        assert (sa[9].equals(""));
        assert (sa[10].equals(""));
    }

    private static void initializePreds1AndSucc1() {
        if (preds1 != null) {
            return;
        }
        preds1 = new LinkedHashMap<Integer, List<Integer>>();
        succs1 = new LinkedHashMap<Integer, List<Integer>>();
        for (int i = 0; i <= 7; ++i) {
            preds1.put(new Integer(i), new ArrayList());
            succs1.put(new Integer(i), new ArrayList());
        }
        succs1.get(0).add(1);
        preds1.get(1).add(0);
        succs1.get(1).add(2);
        preds1.get(2).add(1);
        succs1.get(1).add(3);
        preds1.get(3).add(1);
        succs1.get(2).add(7);
        preds1.get(7).add(2);
        succs1.get(3).add(4);
        preds1.get(4).add(3);
        succs1.get(4).add(5);
        preds1.get(5).add(4);
        succs1.get(4).add(6);
        preds1.get(6).add(4);
        succs1.get(5).add(7);
        preds1.get(7).add(5);
        succs1.get(6).add(4);
        preds1.get(4).add(6);
    }

    @Test
    public void testGraphMDE() {
        TestPlume.initializePreds1AndSucc1();
        Map<Integer, List<Integer>> dom1post = GraphMDE.dominators(succs1);
        assert (dom1post.get(0).toString().equals("[7, 1, 0]"));
        assert (dom1post.get(1).toString().equals("[7, 1]"));
        assert (dom1post.get(2).toString().equals("[7, 2]"));
        assert (dom1post.get(3).toString().equals("[7, 5, 4, 3]"));
        assert (dom1post.get(4).toString().equals("[7, 5, 4]"));
        assert (dom1post.get(5).toString().equals("[7, 5]"));
        assert (dom1post.get(6).toString().equals("[7, 5, 4, 6]"));
        assert (dom1post.get(7).toString().equals("[7]"));
        Map<Integer, List<Integer>> dom1pre = GraphMDE.dominators(preds1);
        assert (dom1pre.get(0).toString().equals("[0]"));
        assert (dom1pre.get(1).toString().equals("[0, 1]"));
        assert (dom1pre.get(2).toString().equals("[0, 1, 2]"));
        assert (dom1pre.get(3).toString().equals("[0, 1, 3]"));
        assert (dom1pre.get(4).toString().equals("[0, 1, 3, 4]"));
        assert (dom1pre.get(5).toString().equals("[0, 1, 3, 4, 5]"));
        assert (dom1pre.get(6).toString().equals("[0, 1, 3, 4, 6]"));
        assert (dom1pre.get(7).toString().equals("[0, 1, 7]"));
    }

    public static class TestOptionsEnums {
        @Option(value="Set the first compression pass")
        public static Compressor firstPass;
        @Option(value="Set the second compression pass")
        public static Compressor secondPass;

        static enum Compressor {
            RLE,
            SMART_RLE,
            HUFFMAN;

        }
    }

    public static class TestOptionGroups3 {
        @OptionGroup(value="General options")
        @Option(value="-h Display help message", aliases={"-help"})
        public static boolean help = false;
        @OptionGroup(value="Internal options")
        @Unpublicized
        @Option(value="Set mu")
        public static double mu = 4902.7;
        @Unpublicized
        @Option(value="Set pi")
        public static double pi = 3.14;
        @OptionGroup(value="Display options")
        @Option(value="Use colors", aliases={"--colour"})
        public static boolean color = false;
    }

    public static class TestOptionGroups2 {
        @OptionGroup(value="General options")
        @Option(value="-h Display help message", aliases={"-help"})
        public static boolean help = false;
        @OptionGroup(value="Internal options", unpublicized=true)
        @Option(value="Set mu")
        public static double mu = 4902.7;
        @Unpublicized
        @Option(value="Set pi")
        public static double pi = 3.14;
        @OptionGroup(value="Display options")
        @Option(value="Use colors", aliases={"--colour"})
        public static boolean color = false;
    }

    public static class TestOptionGroups1 {
        @Option(value="-m Set the mass")
        public static int mass;
        @OptionGroup(value="Coordinate options")
        @Option(value="-x Set the X coordinate")
        public static int x;
        @Option(value="-y Set the Y coordinate")
        public static int y;
        @Option(value="-z Set the Z coordinate")
        public static int z;
    }

    public static class TestOptionsAliases {
        @Option(value="-d Set the day")
        public String day = "Friday";
        @Option(value="-t Set the temperature", aliases={"-temp"})
        public double temperature = 42.0;
        @Option(value="Print the program version", aliases={"-v", "-version", "--version"})
        public boolean printVersion = false;
    }

    public static class TestOptions {
        @Option(value="list of patterns")
        public List<Pattern> lp = new ArrayList<Pattern>();
        @Option(value="-a <filename> argument 1")
        public String arg1 = "/tmp/foobar";
        @Option(value="argument 2")
        public String arg2;
        @Option(value="-d double value")
        public double temperature;
        @Option(value="-f the input file")
        public File input_file;
        @Option(value="-b boolean")
        public boolean bool;
        @Option(value="-i Integer")
        public Integer integer_reference;
        @Option(value="list of doubles")
        public List<Double> ld = new ArrayList<Double>();
        @Option(value="list with no default")
        public List<String> ls;
    }

    public static class PrintOneIntPerTimePeriod {
        public static void main(String[] args) {
            if (args.length != 2) {
                System.err.println("Needs 2 arguments, got " + args.length);
                System.exit(1);
            }
            int limit = Integer.parseInt(args[0]);
            int period = Integer.parseInt(args[1]);
            for (int i = 0; i < limit; ++i) {
                System.out.printf("out%d ", i);
                System.err.printf("err%d ", i);
                try {
                    Thread.sleep(period);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

