/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.ValidationException;

public final class ParameterValidator {
    private static final String ASSERT_NONE_MESSAGE = "Parameter [{0}] is not applicable";
    private static final String ASSERT_ONE_OR_LESS_MESSAGE = "Parameter [{0}] must only be specified once";
    private static final String ASSERT_ONE_MESSAGE = "Parameter [{0}] must be specified once";
    private static final String ASSERT_NULL_OR_EQUAL_MESSAGE = "Parameter [{0}] is invalid";
    private static ParameterValidator instance = new ParameterValidator();

    private ParameterValidator() {
    }

    public void assertOneOrLess(String paramName, ParameterList parameters) throws ValidationException {
        if (parameters.getParameters(paramName).size() > 1) {
            throw new ValidationException(ASSERT_ONE_OR_LESS_MESSAGE, new Object[]{paramName});
        }
    }

    public void assertOne(String paramName, ParameterList parameters) throws ValidationException {
        if (parameters.getParameters(paramName).size() != 1) {
            throw new ValidationException(ASSERT_ONE_MESSAGE, new Object[]{paramName});
        }
    }

    public void assertNone(String paramName, ParameterList parameters) throws ValidationException {
        if (parameters.getParameter(paramName) != null) {
            throw new ValidationException(ASSERT_NONE_MESSAGE, new Object[]{paramName});
        }
    }

    public void assertNullOrEqual(Parameter param, ParameterList parameters) throws ValidationException {
        Parameter p = parameters.getParameter(param.getName());
        if (p != null && !param.equals(p)) {
            throw new ValidationException(ASSERT_NULL_OR_EQUAL_MESSAGE, new Object[]{p});
        }
    }

    public static ParameterValidator getInstance() {
        return instance;
    }
}

