/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.classfile;

import java.util.Stack;
import org.apache.commons.bcel6.classfile.AnnotationDefault;
import org.apache.commons.bcel6.classfile.AnnotationEntry;
import org.apache.commons.bcel6.classfile.Annotations;
import org.apache.commons.bcel6.classfile.Attribute;
import org.apache.commons.bcel6.classfile.BootstrapMethods;
import org.apache.commons.bcel6.classfile.Code;
import org.apache.commons.bcel6.classfile.CodeException;
import org.apache.commons.bcel6.classfile.Constant;
import org.apache.commons.bcel6.classfile.ConstantClass;
import org.apache.commons.bcel6.classfile.ConstantDouble;
import org.apache.commons.bcel6.classfile.ConstantFieldref;
import org.apache.commons.bcel6.classfile.ConstantFloat;
import org.apache.commons.bcel6.classfile.ConstantInteger;
import org.apache.commons.bcel6.classfile.ConstantInterfaceMethodref;
import org.apache.commons.bcel6.classfile.ConstantInvokeDynamic;
import org.apache.commons.bcel6.classfile.ConstantLong;
import org.apache.commons.bcel6.classfile.ConstantMethodHandle;
import org.apache.commons.bcel6.classfile.ConstantMethodType;
import org.apache.commons.bcel6.classfile.ConstantMethodref;
import org.apache.commons.bcel6.classfile.ConstantNameAndType;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.ConstantString;
import org.apache.commons.bcel6.classfile.ConstantUtf8;
import org.apache.commons.bcel6.classfile.ConstantValue;
import org.apache.commons.bcel6.classfile.Deprecated;
import org.apache.commons.bcel6.classfile.EnclosingMethod;
import org.apache.commons.bcel6.classfile.ExceptionTable;
import org.apache.commons.bcel6.classfile.Field;
import org.apache.commons.bcel6.classfile.InnerClass;
import org.apache.commons.bcel6.classfile.InnerClasses;
import org.apache.commons.bcel6.classfile.JavaClass;
import org.apache.commons.bcel6.classfile.LineNumber;
import org.apache.commons.bcel6.classfile.LineNumberTable;
import org.apache.commons.bcel6.classfile.LocalVariable;
import org.apache.commons.bcel6.classfile.LocalVariableTable;
import org.apache.commons.bcel6.classfile.LocalVariableTypeTable;
import org.apache.commons.bcel6.classfile.Method;
import org.apache.commons.bcel6.classfile.MethodParameters;
import org.apache.commons.bcel6.classfile.ParameterAnnotationEntry;
import org.apache.commons.bcel6.classfile.ParameterAnnotations;
import org.apache.commons.bcel6.classfile.Signature;
import org.apache.commons.bcel6.classfile.SourceFile;
import org.apache.commons.bcel6.classfile.StackMap;
import org.apache.commons.bcel6.classfile.StackMapEntry;
import org.apache.commons.bcel6.classfile.Synthetic;
import org.apache.commons.bcel6.classfile.Unknown;
import org.apache.commons.bcel6.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class DescendingVisitor
implements Visitor {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor visitor;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Stack<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object> stack = new Stack();

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object predecessor() {
        return this.predecessor(0);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object predecessor(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int level) {
        int size = this.stack.size();
        if (size < 2 || level < 0) {
            return null;
        }
        return this.stack.elementAt(size - (level + 2));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor visitor) {
        this.clazz = clazz;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    @Override
    public void visitJavaClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass _clazz) {
        Attribute[] attributes;
        Method[] methods;
        Field[] fields;
        this.stack.push(_clazz);
        _clazz.accept(this.visitor);
        for (Field field : fields = _clazz.getFields()) {
            field.accept(this);
        }
        for (Method method : methods = _clazz.getMethods()) {
            method.accept(this);
        }
        for (Attribute attribute : attributes = _clazz.getAttributes()) {
            attribute.accept(this);
        }
        _clazz.getConstantPool().accept(this);
        this.stack.pop();
    }

    @Override
    public void visitAnnotation(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Annotations annotation) {
        AnnotationEntry[] entries;
        this.stack.push(annotation);
        annotation.accept(this.visitor);
        for (AnnotationEntry entrie : entries = annotation.getAnnotationEntries()) {
            entrie.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitAnnotationEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry annotationEntry) {
        this.stack.push(annotationEntry);
        annotationEntry.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field field) {
        Attribute[] attributes;
        this.stack.push(field);
        field.accept(this.visitor);
        for (Attribute attribute : attributes = field.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantValue cv) {
        this.stack.push(cv);
        cv.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method method) {
        Attribute[] attributes;
        this.stack.push(method);
        method.accept(this.visitor);
        for (Attribute attribute : attributes = method.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitExceptionTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Code code) {
        Attribute[] attributes;
        CodeException[] table;
        this.stack.push(code);
        code.accept(this.visitor);
        for (CodeException element : table = code.getExceptionTable()) {
            element.accept(this);
        }
        for (Attribute attribute : attributes = code.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitCodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException ce) {
        this.stack.push(ce);
        ce.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLineNumberTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberTable table) {
        LineNumber[] numbers;
        this.stack.push(table);
        table.accept(this.visitor);
        for (LineNumber number : numbers = table.getLineNumberTable()) {
            number.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitLineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumber number) {
        this.stack.push(number);
        number.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTable table) {
        LocalVariable[] vars;
        this.stack.push(table);
        table.accept(this.visitor);
        for (LocalVariable var : vars = table.getLocalVariableTable()) {
            var.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMap table) {
        StackMapEntry[] vars;
        this.stack.push(table);
        table.accept(this.visitor);
        for (StackMapEntry var : vars = table.getStackMap()) {
            var.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMapEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapEntry var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        this.stack.push(cp);
        cp.accept(this.visitor);
        Constant[] constants = cp.getConstantPool();
        for (int i = 1; i < constants.length; ++i) {
            if (constants[i] == null) continue;
            constants[i].accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantClass constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDouble(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantDouble constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFieldref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantFieldref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFloat(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantFloat constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInteger(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantInteger constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInterfaceMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantInterfaceMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInvokeDynamic(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantInvokeDynamic constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantLong(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantLong constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantNameAndType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantNameAndType constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantString constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8 constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitInnerClasses(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClasses ic) {
        InnerClass[] ics;
        this.stack.push(ic);
        ic.accept(this.visitor);
        for (InnerClass ic2 : ics = ic.getInnerClasses()) {
            ic2.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitInnerClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass inner) {
        this.stack.push(inner);
        inner.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitBootstrapMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethods bm) {
        this.stack.push(bm);
        bm.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitDeprecated(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Deprecated attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Signature attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSourceFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SourceFile attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSynthetic(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Synthetic attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitUnknown(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Unknown attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitAnnotationDefault(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationDefault obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitEnclosingMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown EnclosingMethod obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTypeTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTypeTable obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotation(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ParameterAnnotations obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethodParameters(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodParameters obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantMethodType obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodHandle(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantMethodHandle obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotationEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ParameterAnnotationEntry obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }
}

