/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.bcel6.classfile.Attribute;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.StackMapEntry;
import org.apache.commons.bcel6.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class StackMap
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] map;

    public StackMap(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] map, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)11, name_index, length, constant_pool);
        this.map = map;
    }

    StackMap(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (StackMapEntry[])null, constant_pool);
        int map_length = input.readUnsignedShort();
        this.map = new StackMapEntry[map_length];
        for (int i = 0; i < map_length; ++i) {
            this.map[i] = new StackMapEntry(input, constant_pool);
        }
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.map.length);
        for (StackMapEntry entry : this.map) {
            entry.dump(file);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getStackMap() {
        return this.map;
    }

    public final void setStackMap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] map) {
        this.map = map;
        int len = 2;
        for (int i = 0; i < map.length; ++i) {
            len += map[i].getMapEntrySize();
        }
        this.setLength(len);
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder("StackMap(");
        for (int i = 0; i < this.map.length; ++i) {
            buf.append(this.map[i]);
            if (i >= this.map.length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        StackMap c = (StackMap)this.clone();
        c.map = new StackMapEntry[this.map.length];
        for (int i = 0; i < this.map.length; ++i) {
            c.map[i] = this.map[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitStackMap(this);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMapLength() {
        return this.map == null ? 0 : this.map.length;
    }
}

