/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex;

import java.util.regex.Matcher;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.experimental.regex_qual.Regex;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.dataflow.cfg.node.LessThanNode;
import org.checkerframework.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TypesUtils;
import org.checkerframework.qualframework.base.dataflow.QualAnalysis;
import org.checkerframework.qualframework.base.dataflow.QualStore;
import org.checkerframework.qualframework.base.dataflow.QualTransfer;
import org.checkerframework.qualframework.base.dataflow.QualValue;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.QualParams;

public class RegexQualifiedTransfer
extends QualTransfer<QualParams<Regex>> {
    private static final String IS_REGEX_METHOD_NAME = "isRegex";
    private static final String AS_REGEX_METHOD_NAME = "asRegex";
    private static final String GROUP_COUNT_METHOD_NAME = "groupCount";

    public RegexQualifiedTransfer(QualAnalysis<QualParams<Regex>> analysis) {
        super(analysis);
    }

    @Override
    public TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> visitMethodInvocation(MethodInvocationNode n, TransferInput<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> in) {
        ClassNameNode cnn;
        String receiverName;
        TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> result = super.visitMethodInvocation(n, in);
        MethodAccessNode target = n.getTarget();
        ExecutableElement method = target.getMethod();
        Node receiver = target.getReceiver();
        if (receiver instanceof ClassNameNode && this.isRegexUtil(receiverName = (cnn = (ClassNameNode)receiver).getElement().toString())) {
            result = this.handleRegexUtil(n, method, result);
        }
        return result;
    }

    private TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> handleRegexUtil(MethodInvocationNode n, ExecutableElement method, TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> resultIn) {
        if (ElementUtils.matchesElement(method, IS_REGEX_METHOD_NAME, String.class, Integer.TYPE)) {
            QualStore<QualParams<Regex>> thenStore = resultIn.getRegularStore();
            Store elseStore = thenStore.copy();
            ConditionalTransferResult<QualValue<QualParams<Regex>>, Store> newResult = new ConditionalTransferResult<QualValue<QualParams<Regex>>, Store>(resultIn.getResultValue(), thenStore, elseStore);
            FlowExpressions.Receiver firstParam = FlowExpressions.internalReprOf(this.analysis.getContext().getAnnotationProvider(), n.getArgument(0));
            int groupCount = this.determineIntValue(n.getArgument(1));
            Regex.RegexVal regex = new Regex.RegexVal(groupCount);
            thenStore.insertValue(firstParam, new QualParams<Regex.RegexVal>(new PolyQual.GroundQual<Regex.RegexVal>(regex)));
            return newResult;
        }
        if (ElementUtils.matchesElement(method, AS_REGEX_METHOD_NAME, String.class, Integer.TYPE)) {
            int groupCount = this.determineIntValue(n.getArgument(1));
            QualParams<Regex.RegexVal> regex = new QualParams<Regex.RegexVal>(new PolyQual.GroundQual<Regex.RegexVal>(new Regex.RegexVal(groupCount)));
            QualValue<QualParams<Regex.RegexVal>> newResultValue = this.analysis.createSingleAnnotationValue(regex, resultIn.getResultValue().getType().getUnderlyingType().getOriginalType());
            return new RegularTransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>>(newResultValue, resultIn.getRegularStore());
        }
        return resultIn;
    }

    private int determineIntValue(Node num) {
        int groupCount;
        if (num instanceof IntegerLiteralNode) {
            IntegerLiteralNode iln = (IntegerLiteralNode)num;
            groupCount = iln.getValue();
        } else {
            groupCount = 0;
        }
        return groupCount;
    }

    private boolean isRegexUtil(String receiver) {
        return receiver.equals("RegexUtil") || receiver.endsWith(".RegexUtil");
    }

    @Override
    public TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> visitLessThan(LessThanNode n, TransferInput<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> in) {
        TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> res = super.visitLessThan(n, in);
        res = this.handleMatcherGroupCount(n.getRightOperand(), n.getLeftOperand(), false, in, res);
        return res;
    }

    @Override
    public TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> visitLessThanOrEqual(LessThanOrEqualNode n, TransferInput<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> in) {
        TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> res = super.visitLessThanOrEqual(n, in);
        res = this.handleMatcherGroupCount(n.getRightOperand(), n.getLeftOperand(), true, in, res);
        return res;
    }

    @Override
    public TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> visitGreaterThan(GreaterThanNode n, TransferInput<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> in) {
        TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> res = super.visitGreaterThan(n, in);
        res = this.handleMatcherGroupCount(n.getLeftOperand(), n.getRightOperand(), false, in, res);
        return res;
    }

    @Override
    public TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> visitGreaterThanOrEqual(GreaterThanOrEqualNode n, TransferInput<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> in) {
        TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> res = super.visitGreaterThanOrEqual(n, in);
        res = this.handleMatcherGroupCount(n.getLeftOperand(), n.getRightOperand(), true, in, res);
        return res;
    }

    private TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> handleMatcherGroupCount(Node possibleMatcher, Node possibleConstant, boolean isAlsoEqual, TransferInput<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> in, TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> resultIn) {
        if (!(possibleMatcher instanceof MethodInvocationNode)) {
            return resultIn;
        }
        if (!(possibleConstant instanceof IntegerLiteralNode)) {
            return resultIn;
        }
        MethodInvocationNode min2 = (MethodInvocationNode)possibleMatcher;
        MethodAccessNode target = min2.getTarget();
        ExecutableElement method = target.getMethod();
        if (!ElementUtils.matchesElement(method, GROUP_COUNT_METHOD_NAME, new Class[0])) {
            return resultIn;
        }
        Node receiver = target.getReceiver();
        FlowExpressions.Receiver matcherReceiver = receiver instanceof LocalVariableNode ? new FlowExpressions.LocalVariable((LocalVariableNode)receiver) : null;
        TypeMirror matcherType = matcherReceiver.getType();
        if (matcherType.getKind() != TypeKind.DECLARED) {
            return resultIn;
        }
        DeclaredType matcherDT = (DeclaredType)matcherType;
        if (!TypesUtils.getQualifiedName(matcherDT).contentEquals(Matcher.class.getCanonicalName())) {
            return resultIn;
        }
        IntegerLiteralNode iln = (IntegerLiteralNode)possibleConstant;
        int groupCount = isAlsoEqual ? iln.getValue() : iln.getValue() + 1;
        QualStore<QualParams<Regex>> thenStore = resultIn.getRegularStore();
        Store elseStore = thenStore.copy();
        ConditionalTransferResult<QualValue<QualParams<Regex>>, Store> newResult = new ConditionalTransferResult<QualValue<QualParams<Regex>>, Store>(resultIn.getResultValue(), thenStore, elseStore);
        Regex.RegexVal regex = new Regex.RegexVal(groupCount);
        thenStore.insertValue(matcherReceiver, new QualParams<Regex.RegexVal>(new PolyQual.GroundQual<Regex.RegexVal>(regex)));
        return newResult;
    }
}

