/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.base;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.qualframework.base.AnnotationConverter;
import org.checkerframework.qualframework.base.QualifierHierarchy;
import org.checkerframework.qualframework.base.TypeMirrorConverter;

class QualifierHierarchyAdapter<Q> {
    private QualifierHierarchy<Q> underlying;
    private TypeMirrorConverter<Q> converter;
    private AnnotationConverter<Q> annotationConverter;

    public QualifierHierarchyAdapter(AnnotationConverter<Q> annotationConverter, QualifierHierarchy<Q> underlying, TypeMirrorConverter<Q> converter) {
        this.annotationConverter = annotationConverter;
        this.underlying = underlying;
        this.converter = converter;
    }

    public Implementation createImplementation(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
        return new Implementation(f);
    }

    public class Implementation
    extends MultiGraphQualifierHierarchy {
        public Implementation(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f);
        }

        @Override
        public int getWidth() {
            return 1;
        }

        @Override
        protected Set<AnnotationMirror> findBottoms(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
            Set<AnnotationMirror> newBottoms = AnnotationUtils.createAnnotationSet();
            newBottoms.add(this.getBottomAnnotation(null));
            return newBottoms;
        }

        @Override
        protected Set<AnnotationMirror> findTops(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
            Set<AnnotationMirror> newTops = AnnotationUtils.createAnnotationSet();
            newTops.add(this.getTopAnnotation(null));
            return newTops;
        }

        @Override
        public AnnotationMirror getBottomAnnotation(AnnotationMirror start) {
            return QualifierHierarchyAdapter.this.converter.getAnnotation(QualifierHierarchyAdapter.this.underlying.getBottom());
        }

        @Override
        public AnnotationMirror getTopAnnotation(AnnotationMirror start) {
            return QualifierHierarchyAdapter.this.converter.getAnnotation(QualifierHierarchyAdapter.this.underlying.getTop());
        }

        @Override
        public AnnotationMirror findAnnotationInHierarchy(Collection<? extends AnnotationMirror> annos, AnnotationMirror top) {
            for (AnnotationMirror annotationMirror : annos) {
                if (QualifierHierarchyAdapter.this.converter.isKey(annotationMirror)) {
                    return annotationMirror;
                }
                if (!QualifierHierarchyAdapter.this.annotationConverter.isAnnotationSupported(annotationMirror)) continue;
                return QualifierHierarchyAdapter.this.converter.getAnnotation(QualifierHierarchyAdapter.this.annotationConverter.fromAnnotations(annos));
            }
            return null;
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            Object rhsQual = this.getOrCreateQualifier(rhs);
            Object lhsQual = this.getOrCreateQualifier(lhs);
            if (rhs == null || lhs == null) {
                return false;
            }
            return QualifierHierarchyAdapter.this.underlying.isSubtype(rhsQual, lhsQual);
        }

        private Q getOrCreateQualifier(AnnotationMirror mirror) {
            Object rhsQual = !QualifierHierarchyAdapter.this.converter.isKey(mirror) ? QualifierHierarchyAdapter.this.annotationConverter.fromAnnotations(Arrays.asList(mirror)) : QualifierHierarchyAdapter.this.converter.getQualifier(mirror);
            return rhsQual;
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            Object q1 = this.getOrCreateQualifier(a1);
            Object q2 = this.getOrCreateQualifier(a2);
            return QualifierHierarchyAdapter.this.converter.getAnnotation(QualifierHierarchyAdapter.this.underlying.leastUpperBound(q1, q2));
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            Object q1 = this.getOrCreateQualifier(a1);
            Object q2 = this.getOrCreateQualifier(a2);
            return QualifierHierarchyAdapter.this.converter.getAnnotation(QualifierHierarchyAdapter.this.underlying.greatestLowerBound(q1, q2));
        }

        public Set<AnnotationMirror> getTypeQualifiers() {
            HashSet<AnnotationMirror> names = new HashSet<AnnotationMirror>();
            names.add(QualifierHierarchyAdapter.this.converter.getBlankKeyAnnotation());
            return names;
        }
    }
}

