/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.optimizer;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.TypeAnnotationVisitor;
import org.objectweb.asm.optimizer.AnnotationConstantsCollector;
import org.objectweb.asm.optimizer.ConstantPool;
import org.objectweb.asm.optimizer.TypeAnnotationConstantsCollector;

public class FieldConstantsCollector
implements FieldVisitor {
    private FieldVisitor fv;
    private ConstantPool cp;

    public FieldConstantsCollector(FieldVisitor fv, ConstantPool cp) {
        this.fv = fv;
        this.cp = cp;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleAnnotations");
        }
        return new AnnotationConstantsCollector(this.fv.visitAnnotation(desc, visible), this.cp);
    }

    @Override
    public TypeAnnotationVisitor visitTypeAnnotation(String desc, boolean visible, boolean inCode) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleTypeAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleTypeAnnotations");
        }
        return new TypeAnnotationConstantsCollector(this.fv.visitTypeAnnotation(desc, visible, inCode), this.cp);
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.fv.visitAttribute(attr);
    }

    @Override
    public void visitEnd() {
        this.fv.visitEnd();
    }
}

