/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.map;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMap;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.map.ISqlJetMap;
import org.tmatesoft.sqljet.core.map.ISqlJetMapDef;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTransaction;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetVirtualTableDef;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineSynchronized;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineTransaction;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetMapDb
extends SqlJetEngine {
    private static final String MAP_TABLE_DOES_NOT_EXIST = "Map table '%s' does not exist";
    public static final File IN_MEMORY = new File(":memory:");
    public static final String MODULE_NAME = "sqljetmap";
    private static final String MAP_EXISTS = "Map '%s' exists";
    private volatile Map<String, SqlJetMapDef> mapDefs;

    public SqlJetMapDb(File file, boolean writable) {
        super(file, writable);
    }

    public static SqlJetMapDb open(File file, boolean writable) throws SqlJetException {
        SqlJetMapDb mapDb = new SqlJetMapDb(file, writable);
        mapDb.open();
        return mapDb;
    }

    public Object runTransaction(SqlJetTransactionMode mode, final ISqlJetMapTransaction transaction) throws SqlJetException {
        this.checkOpen();
        return this.runEngineTransaction(new ISqlJetEngineTransaction(){

            public Object run(SqlJetEngine engine) throws SqlJetException {
                return transaction.run(SqlJetMapDb.this);
            }
        }, mode);
    }

    public Object runWriteTransaction(ISqlJetMapTransaction transaction) throws SqlJetException {
        return this.runTransaction(SqlJetTransactionMode.WRITE, transaction);
    }

    public Object runReadTransaction(ISqlJetMapTransaction transaction) throws SqlJetException {
        return this.runTransaction(SqlJetTransactionMode.READ_ONLY, transaction);
    }

    public Object runSynchronized(final ISqlJetMapTransaction transaction) throws SqlJetException {
        return this.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                return transaction.run(SqlJetMapDb.this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SqlJetMapDef> getMapDefs() {
        if (this.mapDefs == null) {
            SqlJetMapDb sqlJetMapDb = this;
            synchronized (sqlJetMapDb) {
                if (this.mapDefs == null) {
                    this.mapDefs = new TreeMap<String, SqlJetMapDef>(String.CASE_INSENSITIVE_ORDER);
                }
            }
        }
        return this.mapDefs;
    }

    @Override
    protected void readSchema() throws SqlJetException {
        super.readSchema();
        this.readMapDefs();
    }

    private void readMapDefs() throws SqlJetException {
        SqlJetSchema schema = this.getSchemaInternal();
        Set<String> names = schema.getVirtualTableNames();
        if (names != null && names.size() > 0) {
            this.getMapDefs().clear();
            for (String name : names) {
                ISqlJetVirtualTableDef vtable = schema.getVirtualTable(name);
                if (!MODULE_NAME.equalsIgnoreCase(vtable.getModuleName())) continue;
                ISqlJetIndexDef indexDef = schema.getIndex(this.getMapIndexName(name));
                if (indexDef != null) {
                    SqlJetMapDef mapTableDef = new SqlJetMapDef(name, vtable, indexDef);
                    this.getMapDefs().put(name, mapTableDef);
                    continue;
                }
                throw new SqlJetException(SqlJetErrorCode.CORRUPT, String.format("Map '%s' does not have index", name));
            }
        }
    }

    public Set<String> getMapNames() throws SqlJetException {
        return (Set)this.runSynchronized(new ISqlJetMapTransaction(){

            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                TreeSet s2 = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                s2.addAll(SqlJetMapDb.this.getMapDefs().keySet());
                return s2;
            }
        });
    }

    public ISqlJetMapDef getMapDef(final String mapName) throws SqlJetException {
        return (ISqlJetMapDef)this.runSynchronized(new ISqlJetMapTransaction(){

            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                return SqlJetMapDb.this.getMapDefs().get(mapName);
            }
        });
    }

    public ISqlJetMapDef createMap(final String mapName) throws SqlJetException {
        if (this.getMapDefs().containsKey(mapName)) {
            throw new SqlJetException(String.format(MAP_EXISTS, mapName));
        }
        return (ISqlJetMapDef)this.runWriteTransaction(new ISqlJetMapTransaction(){

            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                int page = SqlJetMapDb.this.btree.createTable(SqlJetSchema.BTREE_CREATE_TABLE_FLAGS);
                SqlJetSchema schema = SqlJetMapDb.this.getSchemaInternal();
                String create = String.format("create virtual table %s using %s", mapName, SqlJetMapDb.MODULE_NAME);
                ISqlJetVirtualTableDef vtable = schema.createVirtualTable(create, page);
                String indexName = SqlJetMapDb.this.getMapIndexName(mapName);
                ISqlJetIndexDef indexDef = schema.createIndexForVirtualTable(mapName, indexName);
                SqlJetMapDef mapDef = new SqlJetMapDef(mapName, vtable, indexDef);
                SqlJetMapDb.this.getMapDefs().put(mapName, mapDef);
                return mapDef;
            }
        });
    }

    private String getMapIndexName(String mapTableName) {
        return String.format("%s_%s_%d", MODULE_NAME, mapTableName, 1);
    }

    public ISqlJetMap getMap(final String mapName) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetMap)this.runSynchronized(new ISqlJetMapTransaction(){

            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                SqlJetMapDb.this.refreshSchema();
                SqlJetMapDef mapDef = (SqlJetMapDef)SqlJetMapDb.this.getMapDefs().get(mapName);
                if (mapDef != null) {
                    return new SqlJetMap(mapDb, SqlJetMapDb.this.btree, mapDef, SqlJetMapDb.this.writable);
                }
                throw new SqlJetException(String.format(SqlJetMapDb.MAP_TABLE_DOES_NOT_EXIST, mapName));
            }
        });
    }
}

