/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.framework.qual.FromByteCode;
import org.checkerframework.qualframework.base.TypeMirrorConverter;
import plume.ArraysMDE;
import plume.UtilMDE;

public final class MathMDE {
    @FromByteCode
    private MathMDE() {
        throw new Error("do not instantiate");
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int negate(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int a) {
        return -a;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long negate(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long a) {
        return -a;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double negate(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double a) {
        return -a;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int bitwiseComplement(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int a) {
        return ~a;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long bitwiseComplement(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long a) {
        return a ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int mul(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x * y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long mul(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x * y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double mul(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double y) {
        return x * y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int div(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x / y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long div(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x / y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double div(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double y) {
        return x / y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int mod(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x % y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long mod(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x % y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int lshift(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x << y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long lshift(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x << (int)y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int rshiftSigned(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x >> y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long rshiftSigned(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x >> (int)y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int rshiftUnsigned(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x >>> y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long rshiftUnsigned(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x >>> (int)y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int bitwiseAnd(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x & y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long bitwiseAnd(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x & y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int logicalAnd(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x != 0 && y != 0 ? 1 : 0;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long logicalAnd(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x != 0L && y != 0L ? 1L : 0L;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int bitwiseXor(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x ^ y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long bitwiseXor(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x ^ y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int logicalXor(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x != 0 ^ y != 0 ? 1 : 0;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long logicalXor(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x != 0L ^ y != 0L ? 1L : 0L;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int bitwiseOr(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x | y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long bitwiseOr(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x | y;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int logicalOr(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        return x != 0 || y != 0 ? 1 : 0;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long logicalOr(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        return x != 0L || y != 0L ? 1L : 0L;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int sign(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int a) {
        if (a == 0) {
            return 0;
        }
        if (a > 0) {
            return 1;
        }
        return -1;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int pow(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int base, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int expt) throws @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown ArithmeticException {
        return MathMDE.pow_fast(base, expt);
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long pow(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long base, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long expt) throws @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown ArithmeticException {
        return MathMDE.pow_fast(base, expt);
    }

    @FromByteCode
    private static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int pow_fast(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int base, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int expt) throws @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown ArithmeticException {
        if (expt < 0) {
            throw new ArithmeticException("Negative exponent passed to pow");
        }
        int this_square_pow = base;
        int result = 1;
        while (expt > 0) {
            if ((expt & 1) != 0) {
                result *= this_square_pow;
            }
            expt >>= 1;
            this_square_pow *= this_square_pow;
        }
        return result;
    }

    @FromByteCode
    private static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long pow_fast(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long base, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long expt) throws @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown ArithmeticException {
        if (expt < 0L) {
            throw new ArithmeticException("Negative exponent passed to pow");
        }
        long this_square_pow = base;
        long result = 1L;
        while (expt > 0L) {
            if ((expt & 1L) != 0L) {
                result *= this_square_pow;
            }
            expt >>= 1;
            this_square_pow *= this_square_pow;
        }
        return result;
    }

    @FromByteCode
    private static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int pow_slow(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int base, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int expt) throws @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown ArithmeticException {
        if (expt < 0) {
            throw new ArithmeticException("Negative exponent passed to pow");
        }
        int result = 1;
        for (int i = 0; i < expt; ++i) {
            result *= base;
        }
        return result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int gcd(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int a, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int b) {
        if (b == 0) {
            return Math.abs(a);
        }
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0) {
            int tmp = b;
            b = a % b;
            a = tmp;
        }
        return a;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int gcd(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] a) {
        if (a.length == 0) {
            return 0;
        }
        int result = a[0];
        for (int i = 1; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i], result)) != 1 && result != 0) continue;
            return result;
        }
        return result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int gcd_differences(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] a) {
        if (a.length < 2) {
            return 0;
        }
        int result = a[1] - a[0];
        for (int i = 2; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i] - a[i - 1], result)) != 1 && result != 0) continue;
            return result;
        }
        return result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long gcd(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long a, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long b) {
        if (b == 0L) {
            return Math.abs(a);
        }
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0L) {
            long tmp = b;
            b = a % b;
            a = tmp;
        }
        return a;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long gcd(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] a) {
        if (a.length == 0) {
            return 0L;
        }
        long result = a[0];
        for (int i = 1; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i], result)) != 1L && result != 0L) continue;
            return result;
        }
        return result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long gcd_differences(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] a) {
        if (a.length < 2) {
            return 0L;
        }
        long result = a[1] - a[0];
        for (int i = 2; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i] - a[i - 1], result)) != 1L && result != 0L) continue;
            return result;
        }
        return result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double gcd(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double a, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double b) {
        if (a == Double.POSITIVE_INFINITY || a == Double.NEGATIVE_INFINITY || Double.isNaN(a) || b == Double.POSITIVE_INFINITY || b == Double.NEGATIVE_INFINITY || Double.isNaN(b)) {
            return Double.NaN;
        }
        if (b == 0.0) {
            return Math.abs(a);
        }
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0.0) {
            double tmp = b;
            b = a % b;
            a = tmp;
        }
        return a;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double gcd(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] a) {
        if (a.length == 0) {
            return 0.0;
        }
        double result = a[0];
        for (int i = 1; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i], result)) != 1.0 && result != 0.0) continue;
            return result;
        }
        return result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double gcd_differences(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown double @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] a) {
        if (a.length < 2) {
            return 0.0;
        }
        double result = a[1] - a[0];
        for (int i = 2; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i] - a[i - 1], result)) != 1.0 && result != 0.0) continue;
            return result;
        }
        return result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int mod_positive(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int y) {
        int result = x % y;
        if (result < 0) {
            result += Math.abs(y);
        }
        return result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] modulus(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums) {
        if (nums.length < 3) {
            return null;
        }
        int modulus = Math.abs(MathMDE.gcd_differences(nums));
        if (modulus == 0 || modulus == 1) {
            return null;
        }
        int remainder = nums[0] % modulus;
        if (remainder < 0) {
            remainder += modulus;
        }
        return new int[]{remainder, modulus};
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] modulus_int(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Integer> itor) {
        if (!itor.hasNext()) {
            return null;
        }
        int avalue = itor.next();
        if (!itor.hasNext()) {
            return null;
        }
        int modulus = Math.abs(avalue - itor.next());
        if (modulus == 1) {
            return null;
        }
        int count = 2;
        while (itor.hasNext()) {
            int i = itor.next();
            if (i == avalue) continue;
            modulus = MathMDE.gcd(modulus, Math.abs(avalue - i));
            ++count;
            if (modulus != 1) continue;
            return null;
        }
        if (count < 3) {
            return null;
        }
        return new int[]{MathMDE.mod_positive(avalue, modulus), modulus};
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] modulus_strict(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean nonstrict_ends) {
        if (nums.length < 3) {
            return null;
        }
        int first_index = 0;
        int last_index = nums.length - 1;
        int first_nonstrict = 0;
        int last_nonstrict = 0;
        if (nonstrict_ends) {
            first_nonstrict = nums[first_index];
            ++first_index;
            last_nonstrict = nums[last_index];
            --last_index;
        }
        if (last_index - first_index < 2) {
            return null;
        }
        int modulus = nums[first_index + 1] - nums[first_index];
        if (modulus == 1) {
            return null;
        }
        for (int i = first_index + 2; i <= last_index; ++i) {
            if (nums[i] - nums[i - 1] == modulus) continue;
            return null;
        }
        int r = MathMDE.mod_positive(nums[first_index], modulus);
        if (nonstrict_ends && (r != MathMDE.mod_positive(first_nonstrict, modulus) || r != MathMDE.mod_positive(last_nonstrict, modulus))) {
            return null;
        }
        return new int[]{r, modulus};
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] modulus_strict_int(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Integer> itor, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean nonstrict_ends) {
        if (!itor.hasNext()) {
            return null;
        }
        int first_nonstrict = 0;
        int last_nonstrict = 0;
        if (nonstrict_ends) {
            first_nonstrict = itor.next();
        }
        int prev = itor.next();
        if (!itor.hasNext()) {
            return null;
        }
        int next = itor.next();
        int modulus = next - prev;
        if (modulus == 1) {
            return null;
        }
        int count = 2;
        while (itor.hasNext()) {
            prev = next;
            next = itor.next();
            if (nonstrict_ends && !itor.hasNext()) {
                last_nonstrict = next;
                break;
            }
            if (next - prev != modulus) {
                return null;
            }
            ++count;
        }
        if (count < 3) {
            return null;
        }
        int r = MathMDE.mod_positive(next, modulus);
        if (nonstrict_ends && (r != MathMDE.mod_positive(first_nonstrict, modulus) || r != MathMDE.mod_positive(last_nonstrict, modulus))) {
            return null;
        }
        return new int[]{r, modulus};
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long mod_positive(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long x, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long y) {
        long result = x % y;
        if (result < 0L) {
            result += Math.abs(y);
        }
        return result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] modulus(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums) {
        if (nums.length < 3) {
            return null;
        }
        long modulus = Math.abs(MathMDE.gcd_differences(nums));
        if (modulus == 0L || modulus == 1L) {
            return null;
        }
        long remainder = nums[0] % modulus;
        if (remainder < 0L) {
            remainder += modulus;
        }
        return new long[]{remainder, modulus};
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] modulus_long(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Long> itor) {
        if (!itor.hasNext()) {
            return null;
        }
        long avalue = itor.next();
        if (!itor.hasNext()) {
            return null;
        }
        long modulus = Math.abs(avalue - itor.next());
        if (modulus == 1L) {
            return null;
        }
        int count = 2;
        while (itor.hasNext()) {
            long i = itor.next();
            if (i == avalue) continue;
            modulus = MathMDE.gcd(modulus, Math.abs(avalue - i));
            ++count;
            if (modulus != 1L) continue;
            return null;
        }
        if (count < 3) {
            return null;
        }
        return new long[]{MathMDE.mod_positive(avalue, modulus), modulus};
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] modulus_strict(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean nonstrict_ends) {
        if (nums.length < 3) {
            return null;
        }
        int first_index = 0;
        int last_index = nums.length - 1;
        long first_nonstrict = 0L;
        long last_nonstrict = 0L;
        if (nonstrict_ends) {
            first_nonstrict = nums[first_index];
            ++first_index;
            last_nonstrict = nums[last_index];
            --last_index;
        }
        if (last_index - first_index < 2) {
            return null;
        }
        long modulus = nums[first_index + 1] - nums[first_index];
        if (modulus == 1L) {
            return null;
        }
        for (int i = first_index + 2; i <= last_index; ++i) {
            if (nums[i] - nums[i - 1] == modulus) continue;
            return null;
        }
        long r = MathMDE.mod_positive(nums[first_index], modulus);
        if (nonstrict_ends && (r != MathMDE.mod_positive(first_nonstrict, modulus) || r != MathMDE.mod_positive(last_nonstrict, modulus))) {
            return null;
        }
        return new long[]{r, modulus};
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] modulus_strict_long(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Long> itor, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean nonstrict_ends) {
        if (!itor.hasNext()) {
            return null;
        }
        long first_nonstrict = 0L;
        long last_nonstrict = 0L;
        if (nonstrict_ends) {
            first_nonstrict = itor.next();
        }
        long prev = itor.next();
        if (!itor.hasNext()) {
            return null;
        }
        long next = itor.next();
        long modulus = next - prev;
        if (modulus == 1L) {
            return null;
        }
        int count = 2;
        while (itor.hasNext()) {
            prev = next;
            next = itor.next();
            if (nonstrict_ends && !itor.hasNext()) {
                last_nonstrict = next;
                break;
            }
            if (next - prev != modulus) {
                return null;
            }
            ++count;
        }
        if (count < 3) {
            return null;
        }
        long r = MathMDE.mod_positive(next, modulus);
        if (nonstrict_ends && (r != MathMDE.mod_positive(first_nonstrict, modulus) || r != MathMDE.mod_positive(last_nonstrict, modulus))) {
            return null;
        }
        return new long[]{r, modulus};
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] missing_numbers(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums) {
        int[] nums_copy = new int[nums.length];
        System.arraycopy(nums, 0, nums_copy, 0, nums.length);
        nums = nums_copy;
        Arrays.sort(nums);
        int min2 = nums[0];
        int max = nums[nums.length - 1];
        int[] result = new int[max - min2 + 1 - nums.length];
        int result_index = 0;
        int val = min2;
        for (int i = 0; i < nums.length; ++i) {
            while (val < nums[i]) {
                result[result_index] = val++;
                ++result_index;
            }
            if (val != nums[i]) continue;
            ++val;
        }
        if (result_index == result.length) {
            return result;
        }
        int[] new_result = new int[result_index];
        System.arraycopy(result, 0, new_result, 0, result_index);
        return new_result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nonmodulus_strict(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums) {
        if (nums.length == 0) {
            return null;
        }
        int range = ArraysMDE.element_range(nums);
        if (range > 65536) {
            return null;
        }
        return MathMDE.nonmodulus_strict_int_internal(new MissingNumbersIteratorInt(nums, true));
    }

    @FromByteCode
    private static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nonmodulus_strict_int_internal(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Integer> missing) {
        UtilMDE.RemoveFirstAndLastIterator<Integer> missing_nums = new UtilMDE.RemoveFirstAndLastIterator<Integer>(missing);
        int[] result = MathMDE.modulus_strict_int(missing_nums, false);
        if (result == null) {
            return result;
        }
        if (!MathMDE.check_first_and_last_nonmodulus(result, missing_nums)) {
            return null;
        }
        return result;
    }

    @FromByteCode
    private static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean check_first_and_last_nonmodulus(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] rm,  @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown UtilMDE.RemoveFirstAndLastIterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Integer> rfali) {
        int r = rm[0];
        int m3 = rm[1];
        int first = rfali.getFirst();
        int last = rfali.getLast();
        return r != MathMDE.mod_positive(first, m3) && r != MathMDE.mod_positive(last, m3);
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nonmodulus_strict_int(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Integer> nums) {
        return MathMDE.nonmodulus_strict_int_internal(new MissingNumbersIteratorInt(nums, true));
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nonmodulus_nonstrict(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums) {
        if (nums.length < 4) {
            return null;
        }
        int max_modulus = Math.min(nums.length / 2, ArraysMDE.element_range(nums) / 2);
        for (int m3 = 2; m3 <= max_modulus; ++m3) {
            boolean[] has_modulus = new boolean[m3];
            int num_nonmodulus = m3;
            for (int i = 0; i < nums.length; ++i) {
                int rem = MathMDE.mod_positive(nums[i], m3);
                if (has_modulus[rem]) continue;
                has_modulus[rem] = true;
                if (--num_nonmodulus == 0) break;
            }
            if (num_nonmodulus != 1) continue;
            return new int[]{ArraysMDE.indexOf(has_modulus, false), m3};
        }
        return null;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] missing_numbers(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums) {
        long[] nums_copy = new long[nums.length];
        System.arraycopy(nums, 0, nums_copy, 0, nums.length);
        nums = nums_copy;
        Arrays.sort(nums);
        long min2 = nums[0];
        long max = nums[nums.length - 1];
        long[] result = new long[(int)(max - min2 + 1L - (long)nums.length)];
        int result_index = 0;
        long val = min2;
        for (int i = 0; i < nums.length; ++i) {
            while (val < nums[i]) {
                result[result_index] = val++;
                ++result_index;
            }
            if (val != nums[i]) continue;
            ++val;
        }
        if (result_index == result.length) {
            return result;
        }
        long[] new_result = new long[result_index];
        System.arraycopy(result, 0, new_result, 0, result_index);
        return new_result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nonmodulus_strict(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums) {
        if (nums.length == 0) {
            return null;
        }
        long range = ArraysMDE.element_range(nums);
        if (range > 65536L) {
            return null;
        }
        return MathMDE.nonmodulus_strict_long_internal(new MissingNumbersIteratorLong(nums, true));
    }

    @FromByteCode
    private static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nonmodulus_strict_long_internal(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Long> missing) {
        UtilMDE.RemoveFirstAndLastIterator<Long> missing_nums = new UtilMDE.RemoveFirstAndLastIterator<Long>(missing);
        long[] result = MathMDE.modulus_strict_long(missing_nums, false);
        if (result == null) {
            return result;
        }
        if (!MathMDE.check_first_and_last_nonmodulus(result, missing_nums)) {
            return null;
        }
        return result;
    }

    @FromByteCode
    private static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean check_first_and_last_nonmodulus(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] rm,  @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown UtilMDE.RemoveFirstAndLastIterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Long> rfali) {
        long r = rm[0];
        long m3 = rm[1];
        long first = rfali.getFirst();
        long last = rfali.getLast();
        return r != MathMDE.mod_positive(first, m3) && r != MathMDE.mod_positive(last, m3);
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nonmodulus_strict_long(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Long> nums) {
        return MathMDE.nonmodulus_strict_long_internal(new MissingNumbersIteratorLong(nums, true));
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nonmodulus_nonstrict(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums) {
        if (nums.length < 4) {
            return null;
        }
        int max_modulus = (int)Math.min((long)(nums.length / 2), ArraysMDE.element_range(nums) / 2L);
        for (int m3 = 2; m3 <= max_modulus; ++m3) {
            boolean[] has_modulus = new boolean[m3];
            int num_nonmodulus = m3;
            for (int i = 0; i < nums.length; ++i) {
                int rem = (int)MathMDE.mod_positive(nums[i], (long)m3);
                if (has_modulus[rem]) continue;
                has_modulus[rem] = true;
                if (--num_nonmodulus == 0) break;
            }
            if (num_nonmodulus != 1) continue;
            return new long[]{ArraysMDE.indexOf(has_modulus, false), m3};
        }
        return null;
    }

    static final class MissingNumbersIteratorLong
    implements Iterator<Long> {
        @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @MonotonicNonNull @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums;
        @MonotonicNonNull @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Long> nums_itor;
        @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long current_nonmissing;
        @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long current_missing;
        @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int current_index;
        @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean add_ends;

        @FromByteCode
        MissingNumbersIteratorLong(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean add_ends) {
            this.add_ends = add_ends;
            long[] nums_copy = new long[nums.length];
            System.arraycopy(nums, 0, nums_copy, 0, nums.length);
            nums = nums_copy;
            Arrays.sort(nums);
            this.current_index = 0;
            this.current_nonmissing = nums[this.current_index];
            this.current_missing = add_ends ? this.current_nonmissing - 1L : this.current_nonmissing;
            this.nums = nums;
        }

        @FromByteCode
        MissingNumbersIteratorLong(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Long> nums_itor, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean add_ends) {
            this.add_ends = add_ends;
            if (!nums_itor.hasNext()) {
                throw new Error("No elements in nums_itor");
            }
            this.current_nonmissing = nums_itor.next();
            this.current_missing = add_ends ? this.current_nonmissing - 1L : this.current_nonmissing;
            this.nums_itor = nums_itor;
            this.current_index = Integer.MIN_VALUE;
        }

        @Override
        @FromByteCode
        public @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean hasNext() {
            if (this.current_missing < this.current_nonmissing) {
                return true;
            }
            if (this.current_missing == this.current_nonmissing) {
                if (this.nums != null) {
                    ++this.current_index;
                    if (this.current_index >= this.nums.length) {
                        if (this.add_ends) {
                            ++this.current_missing;
                            return true;
                        }
                        return false;
                    }
                    this.current_nonmissing = this.nums[this.current_index];
                } else if (this.nums_itor != null) {
                    if (!this.nums_itor.hasNext()) {
                        if (this.add_ends) {
                            ++this.current_missing;
                            return true;
                        }
                        return false;
                    }
                    long prev_nonmissing = this.current_nonmissing;
                    this.current_nonmissing = this.nums_itor.next();
                    if (prev_nonmissing >= this.current_nonmissing) {
                        throw new Error("Non-sorted Iterator supplied to MissingNumbersIteratorLong: prev_nonmissing = " + prev_nonmissing + ", current_nonmissing = " + this.current_nonmissing);
                    }
                } else {
                    throw new Error("Can't happen");
                }
                ++this.current_missing;
                return this.hasNext();
            }
            if (this.add_ends) {
                return this.current_missing == this.current_nonmissing + 1L;
            }
            throw new Error("Can't happen: " + this.current_missing + " " + this.current_nonmissing);
        }

        @Override
        @FromByteCode
        public @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Long result = new Long(this.current_missing);
            ++this.current_missing;
            return result;
        }

        @Override
        @FromByteCode
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class MissingNumbersIteratorInt
    implements Iterator<Integer> {
        @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @MonotonicNonNull @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums;
        @MonotonicNonNull @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Integer> nums_itor;
        @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int current_nonmissing;
        @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int current_missing;
        @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int current_index;
        @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean add_ends;

        @FromByteCode
        MissingNumbersIteratorInt(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown int @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] nums, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean add_ends) {
            this.add_ends = add_ends;
            int[] nums_copy = new int[nums.length];
            System.arraycopy(nums, 0, nums_copy, 0, nums.length);
            nums = nums_copy;
            Arrays.sort(nums);
            this.current_index = 0;
            this.current_nonmissing = nums[this.current_index];
            this.current_missing = add_ends ? this.current_nonmissing - 1 : this.current_nonmissing;
            this.nums = nums;
        }

        @FromByteCode
        MissingNumbersIteratorInt(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Iterator<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Integer> nums_itor, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean add_ends) {
            this.add_ends = add_ends;
            if (!nums_itor.hasNext()) {
                throw new Error("No elements in nums_itor");
            }
            this.current_nonmissing = nums_itor.next();
            this.current_missing = add_ends ? this.current_nonmissing - 1 : this.current_nonmissing;
            this.nums_itor = nums_itor;
            this.current_index = Integer.MIN_VALUE;
        }

        @Override
        @FromByteCode
        public @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean hasNext() {
            if (this.current_missing < this.current_nonmissing) {
                return true;
            }
            if (this.current_missing == this.current_nonmissing) {
                if (this.nums != null) {
                    ++this.current_index;
                    if (this.current_index >= this.nums.length) {
                        if (this.add_ends) {
                            ++this.current_missing;
                            return true;
                        }
                        return false;
                    }
                    this.current_nonmissing = this.nums[this.current_index];
                } else if (this.nums_itor != null) {
                    if (!this.nums_itor.hasNext()) {
                        if (this.add_ends) {
                            ++this.current_missing;
                            return true;
                        }
                        return false;
                    }
                    int prev_nonmissing = this.current_nonmissing;
                    this.current_nonmissing = this.nums_itor.next();
                    if (prev_nonmissing >= this.current_nonmissing) {
                        throw new Error("Non-sorted Iterator supplied to MissingNumbersIteratorInt: prev_nonmissing = " + prev_nonmissing + ", current_nonmissing = " + this.current_nonmissing);
                    }
                } else {
                    throw new Error("Can't happen");
                }
                ++this.current_missing;
                return this.hasNext();
            }
            if (this.add_ends) {
                return this.current_missing == this.current_nonmissing + 1;
            }
            throw new Error("Can't happen: " + this.current_missing + " " + this.current_nonmissing);
        }

        @Override
        @FromByteCode
        public @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Integer result = new Integer(this.current_missing);
            ++this.current_missing;
            return result;
        }

        @Override
        @FromByteCode
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

