/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;

public class LocalClassScanner
extends TreePathScanner<Void, Integer> {
    private int index = 1;
    private boolean found = false;
    private ClassTree localClass;

    public static int indexOfClassTree(TreePath path, ClassTree localClass) {
        int classesFound = 0;
        boolean localClassFound = false;
        while (path.getParentPath() != null && classesFound < 1) {
            if (path.getLeaf() == localClass) {
                localClassFound = true;
            }
            path = path.getParentPath();
            if (!localClassFound || path.getLeaf().getKind() != Tree.Kind.CLASS) continue;
            ++classesFound;
        }
        LocalClassScanner lcs = new LocalClassScanner(localClass);
        lcs.scan(path, Integer.valueOf(0));
        if (lcs.found) {
            return lcs.index;
        }
        return -1;
    }

    private LocalClassScanner(ClassTree localClass) {
        this.localClass = localClass;
    }

    @Override
    public Void visitBlock(BlockTree node, Integer level) {
        if (level < 1) {
            for (StatementTree statementTree : node.getStatements()) {
                if (this.found || statementTree.getKind() != Tree.Kind.CLASS) continue;
                ClassTree c = (ClassTree)statementTree;
                if (this.localClass == statementTree) {
                    this.found = true;
                    continue;
                }
                if (!c.getSimpleName().equals(this.localClass.getSimpleName())) continue;
                ++this.index;
            }
            super.visitBlock(node, level + 1);
        }
        return null;
    }
}

