/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.ElementValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ArrayElementValue
extends ElementValue {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValue @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] evalues;

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < this.evalues.length; ++i) {
            sb.append(this.evalues[i]);
            if (i + 1 >= this.evalues.length) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public ArrayElementValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValue @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] datums, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cpool) {
        super(type, cpool);
        if (type != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor - type specified: " + type);
        }
        this.evalues = datums;
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        dos.writeByte(super.getType());
        dos.writeShort(this.evalues.length);
        for (ElementValue evalue : this.evalues) {
            evalue.dump(dos);
        }
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String stringifyValue() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.evalues.length; ++i) {
            sb.append(this.evalues[i].stringifyValue());
            if (i + 1 >= this.evalues.length) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValue @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getElementValuesArray() {
        return this.evalues;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getElementValuesArraySize() {
        return this.evalues.length;
    }
}

