/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.classfile;

import java.io.DataInput;
import java.io.IOException;
import org.apache.commons.bcel6.classfile.Attribute;
import org.apache.commons.bcel6.classfile.ClassFormatException;
import org.apache.commons.bcel6.classfile.Code;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.ConstantUtf8;
import org.apache.commons.bcel6.classfile.ExceptionTable;
import org.apache.commons.bcel6.classfile.FieldOrMethod;
import org.apache.commons.bcel6.classfile.LineNumberTable;
import org.apache.commons.bcel6.classfile.LocalVariableTable;
import org.apache.commons.bcel6.classfile.ParameterAnnotationEntry;
import org.apache.commons.bcel6.classfile.Utility;
import org.apache.commons.bcel6.classfile.Visitor;
import org.apache.commons.bcel6.generic.Type;
import org.apache.commons.bcel6.util.BCELComparator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class Method
extends FieldOrMethod {
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator _cmp = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o2) {
            Method THIS = (Method)o1;
            Method THAT = (Method)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o) {
            Method THIS = (Method)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ParameterAnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] parameterAnnotationEntries;

    public Method() {
    }

    public Method(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method c) {
        super(c);
    }

    Method(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        super(file, constant_pool);
    }

    public Method(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signature_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attributes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitMethod(this);
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Code getCode() {
        for (Attribute attribute : super.getAttributes()) {
            if (!(attribute instanceof Code)) continue;
            return (Code)attribute;
        }
        return null;
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ExceptionTable getExceptionTable() {
        for (Attribute attribute : super.getAttributes()) {
            if (!(attribute instanceof ExceptionTable)) continue;
            return (ExceptionTable)attribute;
        }
        return null;
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code == null) {
            return null;
        }
        return code.getLocalVariableTable();
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code == null) {
            return null;
        }
        return code.getLineNumberTable();
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        String str;
        String access = Utility.accessToString(super.getAccessFlags());
        ConstantUtf8 c = (ConstantUtf8)super.getConstantPool().getConstant(super.getSignatureIndex(), (byte)1);
        String signature = c.getBytes();
        c = (ConstantUtf8)super.getConstantPool().getConstant(super.getNameIndex(), (byte)1);
        String name = c.getBytes();
        signature = Utility.methodSignatureToString(signature, name, access, true, this.getLocalVariableTable());
        StringBuilder buf = new StringBuilder(signature);
        for (Attribute attribute : super.getAttributes()) {
            if (attribute instanceof Code || attribute instanceof ExceptionTable) continue;
            buf.append(" [").append(attribute).append("]");
        }
        ExceptionTable e = this.getExceptionTable();
        if (e != null && !(str = e.toString()).equals("")) {
            buf.append("\n\t\tthrows ").append(str);
        }
        return buf.toString();
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        return (Method)this.copy_(_constant_pool);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getReturnType() {
        return Type.getReturnType(this.getSignature());
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getArgumentTypes() {
        return Type.getArgumentTypes(this.getSignature());
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator comparator) {
        _cmp = comparator;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object obj) {
        return _cmp.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return _cmp.hashCode(this);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ParameterAnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getParameterAnnotationEntries() {
        if (this.parameterAnnotationEntries == null) {
            this.parameterAnnotationEntries = ParameterAnnotationEntry.createParameterAnnotationEntries(this.getAttributes());
        }
        return this.parameterAnnotationEntries;
    }
}

