/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.verifier.structurals;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.bcel6.generic.CodeExceptionGen;
import org.apache.commons.bcel6.generic.InstructionHandle;
import org.apache.commons.bcel6.generic.MethodGen;
import org.apache.commons.bcel6.verifier.structurals.ExceptionHandler;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class ExceptionHandlers {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Set<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionHandler>> exceptionhandlers = new HashMap<InstructionHandle, Set<ExceptionHandler>>();

    public ExceptionHandlers(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen mg) {
        CodeExceptionGen[] cegs;
        for (CodeExceptionGen ceg : cegs = mg.getExceptionHandlers()) {
            ExceptionHandler eh = new ExceptionHandler(ceg.getCatchType(), ceg.getHandlerPC());
            for (InstructionHandle ih = ceg.getStartPC(); ih != ceg.getEndPC().getNext(); ih = ih.getNext()) {
                Set<ExceptionHandler> hs = this.exceptionhandlers.get(ih);
                if (hs == null) {
                    hs = new HashSet<ExceptionHandler>();
                    this.exceptionhandlers.put(ih, hs);
                }
                hs.add(eh);
            }
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionHandler @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptionHandlers(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih) {
        Set<ExceptionHandler> hsSet = this.exceptionhandlers.get(ih);
        if (hsSet == null) {
            return new ExceptionHandler[0];
        }
        return hsSet.toArray(new ExceptionHandler[hsSet.size()]);
    }
}

